<?php
define('PLUGIN_WITH_CLASSES__FILE__', __FILE__);
class Analytics
{
    public static function create_page_visitor_table()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';

        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        user_id bigint(20) UNSIGNED,
        page_url varchar(255) NOT NULL,
        visit_time datetime NOT NULL,
        ip_address varchar(45) NOT NULL,
        page_type varchar(10) NOT NULL,
        visit_count int(11) NOT NULL,
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }



    // Função para rastrear e armazenar o histórico de páginas visitadas no banco de dados
    public function track_page_visitor()
    {
        global $wpdb;
        $current_url = esc_url(home_url(add_query_arg(array(), $_SERVER['REQUEST_URI'])));
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $current_month = date('Y-m');

        $existing_visit = $wpdb->get_row(
            $wpdb->prepare("SELECT id, visit_count FROM $table_name WHERE user_id = 0 AND page_url = %s AND ip_address = %s AND DATE_FORMAT(visit_time, '%Y-%m') = %s", $current_url, $ip_address, $current_month)
        );

        if ($existing_visit) {
            // Atualiza a contagem de visualizações
            $wpdb->update(
                $table_name,
                array('visit_count' => $existing_visit->visit_count + 1),
                array('id' => $existing_visit->id)
            );
        } else {
            // Insere um novo registro para o mês atual
            $wpdb->insert(
                $table_name,
                array(
                    'user_id' => 0,
                    'page_url' => $current_url,
                    'visit_time' => current_time('mysql'),
                    'ip_address' => $ip_address,
                    'page_type' => $this->get_page_type(),
                    // Função para obter o tipo de página
                    'visit_count' => 1
                )
            );
        }
    }

    // Execute a função para rastrear a página visitada quando o WordPress estiver pronto para processar a página

    // Função para obter o tipo de página (pagina, busca ou tag)
    public function get_page_type()
    {
        if (is_search()) {
            return 'busca';
        } elseif (is_tag()) {
            return 'tag';
        } elseif (is_archive()) {
            if (is_category()) {
                return 'categoria';
            } else {
                return 'arquivo';
            }
        } else {
            return 'página';
        }
    }

    // Função para exibir o histórico de páginas visitadas
    public function display_page_visitor_history()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';

        $history = $wpdb->get_results(
            "SELECT page_url, visit_time, ip_address, page_type, SUM(visit_count) as total_visits FROM $table_name GROUP BY page_url, ip_address, page_type ORDER BY visit_time DESC LIMIT 10"
        );

        echo '<div class="wrap">';
        echo '<h1>Histórico de Páginas Visitadas</h1>';

        if (!empty($history)) {
            echo '<ul>';
            foreach ($history as $item) {
                echo '<li><a href="' . esc_url($item->page_url) . '">' . esc_html($item->page_url) . '</a> - ' . $item->visit_time . ' - IP: ' . esc_html($item->ip_address) . ' - Tipo de Página: ' . esc_html($item->page_type) . ' - Total de Visualizações: ' . esc_html($item->total_visits) . '</li>';
            }
            echo '</ul>';
        } else {
            echo '<p>Não há histórico de páginas visitadas.</p>';
        }

        echo '</div>';
    }

    public function get_page_visitor_history_json()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';

        $history = $wpdb->get_results(
            "SELECT page_url, COUNT(DISTINCT ip_address) as unique_visits, SUM(visit_count) as total_visits
             FROM $table_name WHERE page_type = 'página'
             GROUP BY page_url
             ORDER BY total_visits DESC"
        );
        $json_history = json_encode($history);

        header('Content-Type: application/json');
        echo $json_history;

        exit();
    }

    // Função para retornar o total de visitas e visitas únicas por mês em formato JSON
    public function get_monthly_visit_totals()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';
        $monthly_totals = $wpdb->get_results(
            "SELECT DATE_FORMAT(visit_time, '%Y-%m') as month,
                    SUM(visit_count) as total_visits,
                    COUNT(DISTINCT ip_address) as unique_visits
             FROM $table_name
             GROUP BY month
             ORDER BY month"
        );
        $json_monthly_totals = json_encode($monthly_totals);

        header('Content-Type: application/json');
        echo $json_monthly_totals;

        exit();
    }

    // Função para retornar o total de visitas e visitas únicas por ano em formato JSON
    public function get_yearly_visit_totals()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';

        $yearly_totals = $wpdb->get_results(
            "SELECT YEAR(visit_time) as year, page_type, SUM(visit_count) as total_visits, COUNT(DISTINCT ip_address) as unique_visits FROM $table_name GROUP BY year, page_type ORDER BY year"
        );

        $json_yearly_totals = json_encode($yearly_totals);

        header('Content-Type: application/json');
        echo $json_yearly_totals;

        exit();
    }



    // Função para retornar o histórico de páginas visitadas em formato JSON com base no mês e ano
    public function get_page_visitor_history_by_month_year($request)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';
        $month = $request->get_param('month');
        $year = $request->get_param('year');

        $history = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT page_url, visit_time, ip_address, page_type, SUM(visit_count) as total_visits FROM $table_name WHERE YEAR(visit_time) = %d AND MONTH(visit_time) = %d GROUP BY page_url, ip_address, page_type ORDER BY visit_time",
                $year,
                $month
            )
        );

        $json_history = json_encode($history);

        header('Content-Type: application/json');
        echo $json_history;

        exit();
    }

    // Função para retornar os IPs por ano em formato JSON
    public function get_ips_by_year($data)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';
        $year = $data['year'];

        $ips_by_year = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT ip_address, YEAR(visit_time) as year, page_type, COUNT(DISTINCT visit_time) as unique_visits
                FROM $table_name
                WHERE YEAR(visit_time) = %d
                GROUP BY year, ip_address, page_type
                ORDER BY year, unique_visits DESC",
                $year
            )
        );

        $json_ips_by_year = json_encode($ips_by_year);

        if (json_last_error() !== JSON_ERROR_NONE) {
            status_header(500);
            echo json_encode(array('error' => 'Erro na geração do JSON'));
        } else {
            header('Content-Type: application/json');
            echo $json_ips_by_year;
        }

        exit();
    }
    // Função para retornar o histórico de páginas visitadas em formato JSON
    public function get_page_visitor_history_tags_json()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';

        $history = $wpdb->get_results(
            "SELECT page_url, COUNT(DISTINCT ip_address) as unique_visits, SUM(visit_count) as total_visits
         FROM $table_name WHERE page_type = 'tag'
         GROUP BY page_url
         ORDER BY total_visits DESC"
        );

        $json_history = json_encode($history);

        header('Content-Type: application/json');
        echo $json_history;

        exit();
    }
    // Função para retornar o histórico de páginas visitadas em formato JSON
    public function get_page_visitor_history_top10_json()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';

        $history = $wpdb->get_results(
            "SELECT page_url, COUNT(DISTINCT ip_address) as unique_visits, SUM(visit_count) as total_visits
         FROM $table_name WHERE page_type = 'busca  '
         GROUP BY page_url
         ORDER BY total_visits DESC"
        );

        $json_history = json_encode($history);

        header('Content-Type: application/json');
        echo $json_history;

        exit();
    }
    // Função para retornar os IPs por mês em formato JSON
    public function get_ips_by_month($data)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'kingpost_page_visitor';
        $month = $data['month'];
        $year = $data['year'];

        $ips_by_month = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT ip_address, DATE_FORMAT(visit_time, '%Y-%m') as month, page_type, SUM(visit_count) as total_visits
            FROM $table_name
            WHERE DATE_FORMAT(visit_time, '%m') = %s AND DATE_FORMAT(visit_time, '%Y') = %s
            GROUP BY month, ip_address, page_type
            ORDER BY month, total_visits DESC",
                str_pad($month, 2, '0', STR_PAD_LEFT),
                $year
            )
        );

        $json_ips_by_month = json_encode($ips_by_month);

        if (json_last_error() !== JSON_ERROR_NONE) {
            status_header(500);
            echo json_encode(array('error' => 'Erro na geração do JSON'));
        } else {
            header('Content-Type: application/json');
            echo $json_ips_by_month;
        }

        exit();
    }

    public function set_endpoints()
    {
        // Registra a rota do endpoint JSON
        register_rest_route(
            'kingpost-analytics/v1',
            'history',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_page_visitor_history_json')
            )
        );
        // Registra a rota do endpoint JSON para os totais mensais
        register_rest_route(
            'kingpost-analytics/v1',
            'monthly-totals',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_monthly_visit_totals')
            )
        );
        // Registra a rota do endpoint JSON para os totais anuais
        register_rest_route(
            'kingpost-analytics/v1',
            'yearly-totals',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_yearly_visit_totals')
            )
        );
        // Registra a rota do endpoint JSON para o histórico com base no mês e ano
        register_rest_route(
            'kingpost-analytics/v1',
            'history/(?P<month>\d+)/(?P<year>\d+)',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_page_visitor_history_by_month_year')
            )
        );
        // Registra a rota do endpoint JSON para os IPs por ano com o ano na URL
        register_rest_route(
            'kingpost-analytics/v1',
            'ips-by-year/(?P<year>\d+)',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_ips_by_year')
            )
        );
        register_rest_route(
            'kingpost-analytics/v1',
            'ips-by-monthly/(?P<month>\d+)/(?P<year>\d+)',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_ips_by_month'),
            )
        );
        // Registra a rota TAG do endpoint JSON
        register_rest_route(
            'kingpost-analytics/v1',
            'tags',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_page_visitor_history_tags_json'),
            )
        );
        // Registra a rota TAG do endpoint JSON
        register_rest_route(
            'kingpost-analytics/v1',
            'top10',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'get_page_visitor_history_top10_json'),
            )
        );
    }
    public function __construct()
    {
        // Execute a função para criar a tabela no ativação do plugin
        //register_activation_hook(PLUGIN_WITH_CLASSES__FILE__, [$this, 'create_page_visitor_table']);
        $this->create_page_visitor_table();
        add_action('rest_api_init', [$this, 'set_endpoints']);
        // add_action('wp', [$this, 'track_page_visitor']);
    }
}
