jQuery(document).ready(function($) {
  function medias_opt(button_selector) {    
    $('body').on('click', button_selector, function() {
      var _custom_media = true,
      _orig_send_attachment = wp.media.editor.send.attachment;
      var button_id = $(this).attr('id');
      wp.media.editor.send.attachment = function(props, attachment) {
        if (_custom_media) {
          $('.' + button_id + '_img').attr('src', attachment.sizes.thumbnail.url);
          $('.' + button_id + '_url').val(attachment.id);
        } else {
          return _orig_send_attachment.apply($('#' + button_id), [props, attachment]);
        }
      }
      wp.media.editor.open($('#' + button_id));
      return false;
    });
  }
  medias_opt('.vt_custom_upload_media');

  function sign_opt(sign_selector) {    
    $('body').on('click', sign_selector, function() {
      var sign_media = true,
      sign_attachment = wp.media.editor.send.attachment;
      var sign_id = $(this).attr('id');
      wp.media.editor.send.attachment = function(props, attachment) {
        if (sign_media) {
          $('.' + sign_id + '_signimg').attr('src', attachment.sizes.thumbnail.url);
          $('.' + sign_id + '_signurl').val(attachment.id);
        } else {
          return sign_attachment.apply($('#' + sign_id), [props, attachment]);
        }
      }
      wp.media.editor.open($('#' + sign_id));
      return false;
    });
  }
  sign_opt('.vt_sign_media');

  $('.colorpicker').wpColorPicker();

  var $vtmedia_upload_button = jQuery('.vtmedia-gallery-upload-btn');
  var $vtmedia_clear_button = jQuery('.vtmedia-gallery-clear-btn');
  if ($vtmedia_upload_button.length > 0) {
  wp.media.customlibEditGallery1 = {
    frame: function() {
      if (this._frame)
        return this._frame;
      var selection = this.select();
      this._frame = wp.media({
        id: 'vtmedia_portfolio-image-gallery',
        frame: 'post',
        state: 'gallery-edit',
        title: wp.media.view.l10n.editGalleryTitle,
        editing: true,
        multiple: true,
        selection: selection
      });
      this._frame.on('update', function() {
        var controller = wp.media.customlibEditGallery1._frame.states.get('gallery-edit');
        var library = controller.get('library');
        var ids = library.pluck('id');
        $input_gallery_items.val(ids);
        jQuery.ajax({
          type: "post",
          url: ajaxurl,
          data: "action=typecase_vtmedia_gallery_upload_get_images&ids=" + ids,
          success: function(data) {
            $thumbs_wrap.empty().html(data);
          }
        });
      });
      return this._frame;
    },
    init: function() {
      $vtmedia_upload_button.on("click", function(event) {
        $thumbs_wrap = $(this).parent().prev().prev();
        $input_gallery_items = $thumbs_wrap.next();
        event.preventDefault();
        wp.media.customlibEditGallery1.frame().open();
      });
      $vtmedia_clear_button.on("click", function(event) {
        $thumbs_wrap = $vtmedia_upload_button.parent().prev().prev();
        $input_gallery_items = $thumbs_wrap.next();
        event.preventDefault();
        $thumbs_wrap.empty();
        $input_gallery_items.val("");
      });
    },

    select: function() {
      var shortcode = wp.shortcode.next('gallery', '[gallery ids="' + $input_gallery_items.val() + '"]'),
        defaultPostId = wp.media.gallery.defaults.id,
        attachments, selection;
      if (!shortcode)
        return;
      shortcode = shortcode.shortcode;
      if (_.isUndefined(shortcode.get('id')) && !_.isUndefined(defaultPostId))
        shortcode.set('id', defaultPostId);
      attachments = wp.media.gallery.attachments(shortcode);
      selection = new wp.media.model.Selection(attachments.models, {
        props: attachments.props.toJSON(),
        multiple: true
      });
      selection.gallery = attachments.gallery;
      selection.more().done(function() {
        selection.props.set({
          query: false
        });
        selection.unmirror();
        selection.props.unset('orderby');
      });
      return selection;
    }
  };
  $(wp.media.customlibEditGallery1.init);
  }
  if ($('.vt_nab_tab').length > 0) {
    custom_meta_tab();
  }

  function custom_meta_tab() {
    var $group = $('.group'),
      $navtabs = $('.vt_nab_tab a'),
      active_tab = '';
    $group.hide();
    if (typeof(localStorage) != 'undefined') {
      active_tab = localStorage.getItem('active_tab');
    }
    if (active_tab != '' && $(active_tab).length) {
      $(active_tab).show();
      $(active_tab + '-tab').addClass('nav-tab-active');
    } else {
      $('.group:first').show();
      $('.vt_nab_tab a:first').addClass('nav-tab-active');
    }

    $navtabs.click(function(e) {
      e.preventDefault();
      $navtabs.removeClass('nav-tab-active');
      $(this).addClass('nav-tab-active').blur();
      if (typeof(localStorage) != 'undefined') {
        localStorage.setItem('active_tab', $(this).attr('href'));
      }
      var selected = $(this).attr('href');
      $group.hide();
      $(selected).show();
    });
  }

  JlCustomFonts = {
    init: function() {
      this._fileUploads();
    },
    _fileUploads: function() {
      var file_frame;
      window.inputWrapper = '';
      $(document.body).on('click', '.vt-custom-fonts-upload', function(event) {
        event.preventDefault();
        var button = $(this),
          button_type = button.data('upload-type');
        window.inputWrapper = $(this).closest('.vt-custom-fonts-file-wrap');
        if (file_frame) {
          file_frame.open();
          return;
        }
        file_frame = wp.media.frames.file_frame = wp.media({
          multiple: false
        });
        file_frame.on('select', function() {
          var attachment = file_frame.state().get('selection').first().toJSON();
          window.inputWrapper.find('.vt-custom-fonts-link').val(attachment.url);
        });
        file_frame.open();
      });
      var file_frame;
      window.inputWrapper = '';
    },
  }
  $(document).ajaxComplete(function(event, request, settings) {
    // if (settings.data && "action=add-tag" === settings.data.split("&")[0]) {
    //   location.reload();
    // }
  });
  $(function() {
    JlCustomFonts.init();
  });

  $( ".vt_meta_media" ).each(function(index) {
    var vision_header_file_frame;
    $(this).on("click", function(event) {
      var vtmedia_id = $(this).attr('id');
      event.preventDefault();
      if (vision_header_file_frame) {
        vision_header_file_frame.open();
        return;
      }
      vision_header_file_frame = wp.media.frames.downloadable_file = wp.media({
        title: 'Choose an image',
        button: {
          text: 'Use image',
        },
        multiple: false
      });
      vision_header_file_frame.on('select', function() {
        attachment = vision_header_file_frame.state().get('selection').first().toJSON();
        $('.vision_cat_header_image_id.' + vtmedia_id).val(attachment.id);
        $('.vision_cat_header.' + vtmedia_id).show();
        var media_url = attachment.url;
        if(media_url.includes(".mp4")){
            $('.vision_cat_header.' + vtmedia_id + ' img').attr('src', vtParamsOpt.vidimg);
            $('.vision_cat_header.' + vtmedia_id + ' .media_url').text(media_url);
        }else if(media_url.includes(".mp3")){
            $('.vision_cat_header.' + vtmedia_id + ' img').attr('src', vtParamsOpt.mp3img);
            $('.vision_cat_header.' + vtmedia_id + ' .media_url').text(media_url);
        }else{
            $('.vision_cat_header.' + vtmedia_id + ' img').attr('src', attachment.sizes.thumbnail.url);
            $('.vision_cat_header.' + vtmedia_id + ' .media_url').text('');
        }
      });
      vision_header_file_frame.open();
    });
  });

  $( ".vt_remove_media" ).each(function(index) {
    $(this).on("click", function(event) {
      var vtmedia_del = $(this).attr('id');
      $('.vision_cat_header_image_id.' + vtmedia_del).val('');
      $('.vision_cat_header.' + vtmedia_del).hide();
      $('.vision_cat_header.' + vtmedia_del + ' .media_url').text(' ');
      return false;
    });
  });

  if (jQuery('#vision_cat_header_image_id').val() == 0)
         jQuery('.vision_remove_header').hide();
        var vision_header_file_frame;
        jQuery(document).on( 'click', '.vision_upload_header', function( event ){
          event.preventDefault();
          if ( vision_header_file_frame ) {
            vision_header_file_frame.open();
            return;
          }
          vision_header_file_frame = wp.media.frames.downloadable_file = wp.media({
            title: 'Choose an image',
            button: {
              text: 'Use image',
            },
            multiple: false
          });
          vision_header_file_frame.on( 'select', function() {
            attachment = vision_header_file_frame.state().get('selection').first().toJSON();
            jQuery('#vision_cat_header_image_id').val( attachment.id );
            jQuery('#vision_cat_header img').attr('src', attachment.url );
            jQuery('.vision_remove_header').show();
          });
          vision_header_file_frame.open();
        });
        jQuery(document).on( 'click', '.vision_remove_header', function( event ){
          jQuery('#vision_cat_header img').attr('src', '');
          jQuery('#vision_cat_header_image_id').val('');
          jQuery('.vision_remove_header').hide();
          return false;
        });

});
