<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class typecase_section_cart extends Widget_Base {

    public function get_name() {
        return 'typecase-cart';
    }

    public function get_title() {
        return esc_html__( 'Vision Cart', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-basket-medium vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'mini_cart_content_section',
            [
                'label' => __( 'Mini Cart', 'typecase' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        
        $this->add_control(
            'vt_btn_icons',
            [
                'label' =>esc_html__( 'Icon', 'typecase' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'vt_btn_icon',
                'label_block' => true,
                'default' => [
                    'value' => '',
                ]
            ]
        );            

        $this->end_controls_section();

        $this->start_controls_section(
            'mini_cart_button_section',
            [
                'label' => __( 'Mini Cart Style', 'typecase' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'icon_menu_height',
            [
                'label' => __( 'Height', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'size' => '90',
                    'unit' => 'px'
                ],
                'selectors' => [                    
                    '{{WRAPPER}} .vt_h_cart' => 'height: {{SIZE}}px',
                ]                
            ]
        );   

        $this->add_responsive_control(
            'icons_margin',
            [
                'label'      => __( 'Margin', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vt_h_cart' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icons_padding',
            [
                'label'      => __( 'Padding', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vt_h_cart' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Icons Font Size', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .vt_i_cart i' => 'font-size: {{SIZE}}px',
                    '{{WRAPPER}} .vt_i_cart svg' => 'width: {{SIZE}}px; height:auto;',                    
                ]                
            ]
        );    

        $this->add_responsive_control(
            'icon_space',
            [
                'label' => __( 'Icons Space', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .vt_i_cart i' => 'margin-right: {{SIZE}}px',
                    '{{WRAPPER}} .vt_i_cart svg' => 'margin-right: {{SIZE}}px',
                ]                
            ]
        );      

        $this->add_responsive_control(
            'product_list_space',
            [
                'label' => __( 'Product list position', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .vt-hshow' => 'right: {{SIZE}}px !important',
                ]                
            ]
        );      

        $this->add_control(
            'vt_btn_mobile_color',
            [
                'label' =>esc_html__( 'Color', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .vt_i_cart i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .vt_i_cart svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->add_control(
            'vt_btn_mobile_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt_i_cart i' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .vt_i_cart svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->add_control(
            'vt_mobile_color_hover',
            [
                'label' =>esc_html__( 'Color Hover', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .vt_i_cart:hover i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .vt_i_cart:hover svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'vt_mobile_color_hover_dark',
            [
                'label' =>esc_html__( 'Color hover dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt_i_cart:hover i' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .vt_i_cart:hover svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'vt_bgnum',
            [
                'label' =>esc_html__( 'Background number', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .vt_i_cart .vt_count_cart' => 'background: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'vt_bgnum_dark',
            [
                'label' =>esc_html__( 'Background number dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt_i_cart .vt_count_cart' => 'background: {{VALUE}} !important;',                    
                ],
            ]
        );

        $this->add_control(
            'vt_colornum',
            [
                'label' =>esc_html__( 'Color number', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .vt_i_cart .vt_count_cart' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'vt_colornum_dark',
            [
                'label' =>esc_html__( 'Color number dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt_i_cart .vt_count_cart' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );

        $this->add_control(
            'sub_menu_div_color',
            [
                'label'     => esc_html__( 'Divider line Color', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_div_color_dark',
            [
                'label'     => esc_html__( 'Divider line Color dark mode', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .woocommerce-mini-cart__total' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_bg_color',
            [
                'label'     => esc_html__( 'Product background color', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vt-hshow' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_bg_color_dark',
            [
                'label'     => esc_html__( 'Product background color dark mode', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt-hshow' => 'background: {{VALUE}};',
                ],
            ]
        );

                
        $this->add_control(
            'sub_menu_normal_color',
            [
                'label'     => esc_html__( 'Product color', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} li.woocommerce-mini-cart-item a:not(.remove)' => 'color: {{VALUE}} !important;;',
                    '{{WRAPPER}} .woocommerce ul.product_list_widget .woocommerce-mini-cart-item .quantity' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .vt-hshow' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .woocommerce a.remove:before' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .woocommerce-mini-cart__total' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_normal_color_dark',
            [
                'label'     => esc_html__( 'Product color dark mode', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '.options_dark_skin {{WRAPPER}} li.woocommerce-mini-cart-item a:not(.remove)' => 'color: {{VALUE}} !important;;',
                    '.options_dark_skin {{WRAPPER}} .woocommerce ul.product_list_widget .woocommerce-mini-cart-item .quantity' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .vt-hshow' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .woocommerce a.remove:before' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .woocommerce-mini-cart__total' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'vt_show_border_menu',
            [
                'label' => esc_html__( 'cart border', 'typecase' ),
                'type' => Controls_Manager::SWITCHER,                                
            ]
            );
            
        $this->add_responsive_control(
            'sub_menu_border',
            [
                'label' => esc_html__( 'cart border size', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ]                        
                ],
                'default' => [
                'unit' => 'px',
                'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .vt-hshow' => 'border: {{SIZE}}{{UNIT}} solid; box-shadow: unset;',
                ],
                'condition' => [
                    'vt_show_border_menu' => 'yes'
                ]
            ]
        );        

        $this->add_control(
            'sub_menu_border_color',
            [
                'label'     => esc_html__( 'Border color', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '{{WRAPPER}} .vt-hshow, {{WRAPPER}} .vt-hshow .mini_cart_item img' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'vt_show_border_menu' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sub_menu_border_color_dark',
            [
                'label'     => esc_html__( 'Border color dark mode', 'typecase' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '.options_dark_skin {{WRAPPER}} .vt-hshowm, .options_dark_skin {{WRAPPER}} .vt-hshow .mini_cart_item img' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'vt_show_border_menu' => 'yes'
                ]
            ]
        );


        $this->end_controls_section();
        

    }
    protected function render(){

        if ( ! function_exists( 'WC' ) ) {
            $this->show_wc_missing_alert();
            return;
        }
        if ( ! class_exists( 'Woocommerce' ) || ! function_exists( 'wc_get_cart_url' ) || ! function_exists( 'is_cart' ) || is_cart() ) {
            return false;
        }
        $settings = $this->get_settings();        
        ?>

        <div class="vt_h_cart nav-cart is-hover">
        <a class="vt_l_cart cart-link" href="<?php echo esc_url( wc_get_cart_url() ) ?>" title="<?php echo esc_attr( 'view cart', 'typecase' ); ?>">
            <span class="vt_i_cart">
                <?php if (empty($settings['vt_btn_icons']['value'])) {?>
                <i class="vti-bag"></i>
                <?php }else{
                            $migrated = isset( $settings['__fa4_migrated']['vt_btn_icons'] );
                            $is_new = empty( $settings['vt_btn_icon'] );
                            if ( $is_new || $migrated ) {
                                Icons_Manager::render_icon( $settings['vt_btn_icons'], [ 'aria-hidden' => 'true' ] );
                            }else{
                                ?>
                                <i class="<?php echo esc_attr($settings['vt_btn_icon']); ?>" aria-hidden="true"></i>
                                <?php
                            }
                        }
                    ?>
                <em class="cart-counter vt_count_cart">
                    <?php
                    if ( !empty(WC()->cart->cart_contents_count) ){
                        echo esc_attr( WC()->cart->cart_contents_count );
                    }else{
                        echo 0;
                    }
                    ?>
                </em>
            </span>
        </a>
        <?php if ( function_exists( 'woocommerce_mini_cart' ) ): ?>
            <div class="vt-nav-cart vt-hshow">
                <div class="vt-cart-wrap woocommerce">
                    <div class="widget_shopping_cart_content">
                        <?php (( WC()->cart != '' ) ? woocommerce_mini_cart() : '' ); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
</div>

    
    <?php
    }
    public function show_wc_missing_alert() {
        if ( current_user_can( 'activate_plugins' ) ) {
            printf(
                '<div %s>%s</div>',
                'style="margin: 1rem;padding: 1rem 1.25rem;border-left: 5px solid #f5c848;color: #856404;background-color: #fff3cd;"',
                __( 'WooCommerce is missing! Please install and activate WooCommerce.', 'typecase' )
                );
        }
    }
}