<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_category_list extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-category-list';
    }

    public function get_title() {
        return esc_html__( 'Categories List', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'typecase'),
            ]
        );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'typecase'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
            ]
        ); 
        $this->add_control(
      'number_cat',
      array(
        'label'       => esc_html__( 'Number of categories', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
                 

      $this->end_controls_section();      
      //Title Style Section
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     
 
      $this->add_control(
      'vt_cat_layout',
      array(
        'label'       => esc_html__( 'Categories layout', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [                        
                        'style1'        => esc_html__( 'Overlay middle text', 'typecase' ),
                        'style2'        => esc_html__( 'Overlay bottom text', 'typecase' ),
                        'style3'        => esc_html__( 'Image on top', 'typecase' ),
                        'style4'        => esc_html__( 'Image text with background', 'typecase' ),
                    ],
        'default'     => 'style1',
      )
    );   

      $this->add_control(
      'section_btn_text', [
        'label'       => esc_html__( 'Text count', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'default'   => ' Articles',
        'condition' => [
                    'vt_cat_layout'    => ['style3']
        ]
      ]
      );

      $this->add_responsive_control(
        'vt_item_cols',
        [
            'label' => __( 'Number of columns', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 4,
            ],
            'tablet_default' => [
              'size' => 4,
            ],
            'mobile_default' => [
              'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cat_lopt' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr)) !important;',            
            ],
        ]
      );

        $this->add_responsive_control(
        'vt_item_cols_space',
        [
            'label' => __( 'Columns space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cat_lopt' => 'grid-column-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

        $this->add_responsive_control(
        'vt_item_row_space',
        [
            'label' => __( 'Row space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cat_lopt' => 'grid-row-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'sl_cat_size',
        [
            'label' => __( 'Categories height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cat_lopt' => '--vt-cat-hs: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'slfont_size',
        [
            'label' => __( 'Title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 17,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cat_lopt .vt_cat_lbw .vt_cm_name' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'g_sm_img',
        [
            'label' => __( 'Categories broder radius', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_cat_lopt .vt_radus_e, {{WRAPPER}} .vt_cat_opt3.vt_cat_lopt .vt_cimg' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
    );   
    
    $this->add_responsive_control(
      'cat_txt_space',
      [
          'label' => __( 'Categories space', 'typecase' ),
          'type' => Controls_Manager::SLIDER,            
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 200,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .vt_cat_opt4 .vt_cat_lbw' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
          ],
          'condition' => [
              'vt_cat_layout'    => 'style4'
          ]
      ]
  );   

    $this->add_control(
      'title_color',
      [
        'label' => __( 'Title color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .vt_cat_opt3 .vt_cat_lbw .vt_cm_name' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'vt_cat_layout'    => ['style3']
        ]
      ]
    );

    $this->add_control(
      'title_color_dark',
      [
        'label' => __( 'Title color dark mode', 'typecase' ),
        'default' => '#fff',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vt_cat_opt3 .vt_cat_lbw .vt_cm_name' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'vt_cat_layout'    => ['style3']
        ]
      ]
    );

    $this->add_control(
      'desc_color',
      [
        'label' => __( 'Number label color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#707070',
        'selectors' => [
            '{{WRAPPER}} .vt_cat_opt3 .vt_cm_count' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'vt_cat_layout'    => ['style3']
        ]
      ]
    );

    $this->add_control(
      'desc_color_dark',
      [
        'label' => __( 'Number label color dark mode', 'typecase' ),
        'default' => '#ababab',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vt_cat_opt3 .vt_cm_count' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'vt_cat_layout'    => ['style3']
        ]
      ]
    );
    
      $this->end_controls_section();

    }

    protected function render( ) { 
        $settings = $this->get_settings_for_display();
        $categories = $settings['categories'];
        $number_cat = $settings['number_cat'];
        $vt_cat_layout = $settings['vt_cat_layout'];
        $section_btn_text = $settings['section_btn_text'];
    
        
        if($settings['categories']){
            $cat_id = implode(',', $settings['categories']);      
        }else{
          $cat_id = "";
        }
            $args = array(
            'orderby'       => 'include', 
            'order'         => 'ASC',
            'hide_empty'    => false,
            'fields'        => 'all',
            'pad_counts'    => false, 
            'include'       => $cat_id,
            'number'        => $number_cat,
            );
            $categories = get_terms('category', $args);
            if ($categories) {
                switch ( $vt_cat_layout ) {
                    case 'style1':
                        echo '<div class="vt_cat_lopt vt_cat_opt1">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $vision_header_id = absint( get_term_meta( $tag->term_id, 'vision_header_id', true ) );
                            echo '<div class="vt_cat_opt_w vt_radus_e vt_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="vt_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($vision_header_id){
                                echo '<div class="vt_cimg">';
                                echo wp_get_attachment_image( $vision_header_id, 'typecase_layouts', "", array( "class" => "vt_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="vt_cat_lbw"><span class="vt_cm_name">'.esc_attr($tag->name).'</span><span class="vt_cm_count">'.esc_attr($tag->count).'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                    case 'style2':
                        echo '<div class="vt_cat_lopt vt_cat_opt2">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $vision_header_id = absint( get_term_meta( $tag->term_id, 'vision_header_id', true ) );
                            echo '<div class="vt_cat_opt_w vt_radus_e vt_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="vt_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($vision_header_id){
                                echo '<div class="vt_cimg">';
                                echo wp_get_attachment_image( $vision_header_id, 'typecase_layouts', "", array( "class" => "vt_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="vt_cat_lbw"><span class="vt_cm_name">'.esc_attr($tag->name).'</span><span class="vt_cm_count">'.esc_attr($tag->count).'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                    case 'style3':
                        echo '<div class="vt_cat_lopt vt_cat_opt3">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $vision_header_id = absint( get_term_meta( $tag->term_id, 'vision_header_id', true ) );
                            echo '<div class="vt_cat_opt_w vt_radus_e vt_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="vt_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($vision_header_id){
                                echo '<div class="vt_cimg">';
                                echo wp_get_attachment_image( $vision_header_id, 'typecase_layouts', "", array( "class" => "vt_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="vt_cat_lbw"><span class="vt_cm_name">'.esc_attr($tag->name).'</span><span class="vt_cm_count">'.esc_attr($tag->count).$section_btn_text.'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                    case 'style4':
                        echo '<div class="vt_cat_lopt vt_cat_opt4">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $vision_header_id = absint( get_term_meta( $tag->term_id, 'vision_header_id', true ) );
                            echo '<div class="vt_cat_opt_w vt_radus_e vt_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="vt_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($vision_header_id){
                                echo '<div class="vt_cimg">';
                                echo wp_get_attachment_image( $vision_header_id, 'typecase_layouts', "", array( "class" => "vt_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="vt_cat_lbw"><span class="vt_cm_name">'.esc_attr($tag->name).'</span><span class="vt_cm_count">'.esc_attr($tag->count).'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                }            
            }

    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }
   
}