<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_contact_form extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-contact-form';
    }

    public function get_title() {
        return esc_html__( 'Contact form 7', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Choose your form', 'typecase'),
            ]
        );
                
        $this->add_control(
            'form_items',
            [
                'label' => __( 'Choose your form', 'typecase' ),
                'type' => Controls_Manager::SELECT,
                'options'     => $this->typecase_all_form()                
            ]
        );        
                 

      $this->end_controls_section();      
      //Title Style Section
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Form Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );         

        $this->add_control(
          'vt_input_inline',
          [
              'label' => esc_html__( 'Show input/button inline', 'typecase' ),
              'description' => esc_html__( 'This options is good for subcribe box', 'typecase' ),
              'type' => Controls_Manager::SWITCHER,
              'selectors' => [
                "{{WRAPPER}} form.wpcf7-form" => 'flex-direction: row !important;;',            
              ]
          ]
      );  

      $this->add_responsive_control(
        'vt_input_align',
        array(
            'label'     => __( 'Postion input', 'typecase' ),
            'type'      => Controls_Manager::CHOOSE,
            'options'   => array(
                'left'   => array(
                    'title' => __( 'Left', 'typecase' ),
                    'icon'  => 'eicon-text-align-left',
                ),
                'center' => array(
                    'title' => __( 'Center', 'typecase' ),
                    'icon'  => 'eicon-text-align-center',
                ),
                'flex-end'  => array(
                    'title' => __( 'Right', 'typecase' ),
                    'icon'  => 'eicon-text-align-right',
                ),
            ),
            'toggle'    => false,
            'selectors' => array(
                '{{WRAPPER}} form.wpcf7-form' => 'justify-content: {{VALUE}} !important;',
                '{{WRAPPER}} .wpcf7-form-control-wrap[data-name="your-consent"]' => 'justify-content: {{VALUE}} !important;',
            ),
            'condition' => [
              'vt_input_inline!'    => ''
            ]
        )
    );

        $this->add_responsive_control(
          'input_spacing',
          [
              'label' => __( 'Input/button spacing', 'typecase' ),
              'type' => Controls_Manager::SLIDER,
              'default' => [
                'unit' => 'px',
                'size' => 20,
                ],
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 300,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                "{{WRAPPER}} .wpcf7-form" => 'display: flex; flex-wrap: wrap; flex-direction: column; gap: {{SIZE}}{{UNIT}} !important;',
                "{{WRAPPER}} .wpcf7-form-control-wrap" => 'margin: 0px !important;',                
                '{{WRAPPER}} .wpcf7-submit' => 'justify-content: center !important;',
                '{{WRAPPER}} .wpcf7-list-item' => 'margin: 0px; display: flex;',
                '{{WRAPPER}} .wpcf7-list-item label' => 'margin: 0px; align-items: center; display: flex; gap: 10px;',                
              ],
          ]
        );

        $this->add_responsive_control(
          'input_radius',
          [
              'label'      => __( 'Input border rounded', 'typecase' ),
              'type'       => Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px', '%'],                
              'selectors'  => [
                "{{WRAPPER}} textarea, {{WRAPPER}} input[type='text'], {{WRAPPER}} input[type='tel'], {{WRAPPER}} input[type='password'], {{WRAPPER}} input[type='email'], {{WRAPPER}} input[type='url'], {{WRAPPER}} input[type='search'], {{WRAPPER}} input[type='number']" => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ]
          ]
      );

      $this->add_responsive_control(
        'button_radius',
        [
            'label'      => __( 'Button border rounded', 'typecase' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%'],                
            'selectors'  => [
              "{{WRAPPER}} .wpcf7-submit" => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ]
        ]
    );

        $this->add_responsive_control(
          'input_width',
          [
              'label' => __( 'Input width', 'typecase' ),
              'type' => Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 100,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                "{{WRAPPER}} .wpcf7-form-control-wrap" => 'width: {{SIZE}}%;',
              ],
          ]
        );
        $this->add_responsive_control(
          'input_height',
          [
              'label' => __( 'Input height', 'typecase' ),
              'type' => Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 300,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                "{{WRAPPER}} input[type='text'], {{WRAPPER}} input[type='tel'], {{WRAPPER}} input[type='password'], {{WRAPPER}} input[type='email'], {{WRAPPER}} input[type='url'], {{WRAPPER}} input[type='search'], {{WRAPPER}} input[type='number']" => 'height: {{SIZE}}{{UNIT}} !important;',
              ],
          ]
        ); 

        $this->add_responsive_control(
          'input_padding',
          [
              'label' => __( 'Input padding', 'typecase' ),
              'type' => Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 300,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                "{{WRAPPER}} textarea, {{WRAPPER}} input[type='text'], {{WRAPPER}} input[type='tel'], {{WRAPPER}} input[type='password'], {{WRAPPER}} input[type='email'], {{WRAPPER}} input[type='url'], {{WRAPPER}} input[type='search'], {{WRAPPER}} input[type='number']" => 'padding: 0px {{SIZE}}{{UNIT}} !important;',
              ],
          ]
        );
        
        $this->add_responsive_control(
          'button_width',
          [
              'label' => __( 'Button width', 'typecase' ),
              'separator' => 'before',
              'type' => Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 100,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                "{{WRAPPER}} .wpcf7-submit" => 'width: {{SIZE}}% !important;',
              ],
          ]
        ); 

        $this->add_responsive_control(
          'button_height',
          [
              'label' => __( 'Button height', 'typecase' ),
              'type' => Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 300,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                "{{WRAPPER}} .wpcf7-submit" => 'height: {{SIZE}}{{UNIT}} !important;',
              ],
          ]
        ); 

        $this->add_responsive_control(
          'button_padding',
          [
              'label' => __( 'Button padding', 'typecase' ),
              'separator' => 'after',
              'type' => Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 300,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                "{{WRAPPER}} .wpcf7-submit" => 'padding: 0px {{SIZE}}{{UNIT}} !important;',
              ],
          ]
        );

        $this->add_responsive_control(
          'term_opts',
          [
              'label' => __( 'Term conditions spacing', 'typecase' ),
              'type' => Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => 1,
                      'max' => 300,
                      'step' => 1,
                  ]
              ],
              'selectors' => [
                '{{WRAPPER}} .wpcf7-form-control-wrap[data-name="your-consent"]' => 'display: flex;margin-top: {{SIZE}}{{UNIT}} !important; flex: 1 0 100% !important;',                
              ],
          ]
        );
        
        $this->add_group_control(
          Group_Control_Typography::get_type(),
          [
              'name'     => 'input_typography',
              'label'    => esc_html__( 'Input typography', 'typecase' ),
              'selector' => "{{WRAPPER}} textarea, {{WRAPPER}} input[type='text'], {{WRAPPER}} input[type='tel'], {{WRAPPER}} input[type='password'], {{WRAPPER}} input[type='email'], {{WRAPPER}} input[type='url'], {{WRAPPER}} input[type='search'], {{WRAPPER}} input[type='number']",
          ]
      );
        $this->add_group_control(
          Group_Control_Border::get_type(), [
              'name'     => 'input_border',
              'label'    => esc_html__( 'Input border', 'typecase' ),
              'selector' => "{{WRAPPER}} textarea, {{WRAPPER}} input[type='text'], {{WRAPPER}} input[type='tel'], {{WRAPPER}} input[type='password'], {{WRAPPER}} input[type='email'], {{WRAPPER}} input[type='url'], {{WRAPPER}} input[type='search'], {{WRAPPER}} input[type='number']",
          ]
      );

      $this->add_control(
        'input_border_dark',
        [
            'label'     => esc_html__( 'Border color dark mode', 'typecase' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
              ".options_dark_skin {{WRAPPER}} textarea, .options_dark_skin {{WRAPPER}} input[type='text'], .options_dark_skin {{WRAPPER}} input[type='tel'], .options_dark_skin {{WRAPPER}} input[type='password'], .options_dark_skin {{WRAPPER}} input[type='email'], .options_dark_skin {{WRAPPER}} input[type='url'], .options_dark_skin {{WRAPPER}} input[type='search'], .options_dark_skin {{WRAPPER}} input[type='number']" => 'border-color: {{VALUE}} !important;',
            ]                        
        ]
    );
      
      $this->add_control(
        'input_background',
        [
            'label'     => esc_html__( 'Background input', 'typecase' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
              "{{WRAPPER}} textarea, {{WRAPPER}} input[type='text'], {{WRAPPER}} input[type='tel'], {{WRAPPER}} input[type='password'], {{WRAPPER}} input[type='email'], {{WRAPPER}} input[type='url'], {{WRAPPER}} input[type='search'], {{WRAPPER}} input[type='number']" => 'background: {{VALUE}};',
            ]            
        ]
    );

    $this->add_control(
      'input_background_dark',
      [
          'label'     => esc_html__( 'Background input dark mode', 'typecase' ),
          'type'      => Controls_Manager::COLOR,
          'selectors' => [
            ".options_dark_skin {{WRAPPER}} textarea, .options_dark_skin {{WRAPPER}} input[type='text'], .options_dark_skin {{WRAPPER}} input[type='tel'], .options_dark_skin {{WRAPPER}} input[type='password'], .options_dark_skin {{WRAPPER}} input[type='email'], .options_dark_skin {{WRAPPER}} input[type='url'], .options_dark_skin {{WRAPPER}} input[type='search'], .options_dark_skin {{WRAPPER}} input[type='number']" => 'background: {{VALUE}};',
          ]            
      ]
  );  

  $this->add_control(
    'vt_input_color',
    [
        'label'     => esc_html__( 'Color input', 'typecase' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          "{{WRAPPER}} textarea, {{WRAPPER}} input[type='text'], {{WRAPPER}} input[type='tel'], {{WRAPPER}} input[type='password'], {{WRAPPER}} input[type='email'], {{WRAPPER}} input[type='url'], {{WRAPPER}} input[type='search'], {{WRAPPER}} input[type='number']" => 'color: {{VALUE}};',
          "{{WRAPPER}} textarea::-webkit-input-placeholder, {{WRAPPER}} input[type='text']::-webkit-input-placeholder, {{WRAPPER}} input[type='tel']::-webkit-input-placeholder, {{WRAPPER}} input[type='password']::-webkit-input-placeholder, {{WRAPPER}} input[type='email']::-webkit-input-placeholder, {{WRAPPER}} input[type='url']::-webkit-input-placeholder, {{WRAPPER}} input[type='search']::-webkit-input-placeholder, {{WRAPPER}} input[type='number']::-webkit-input-placeholder" => 'color: {{VALUE}};',
        ]            
    ]
);

$this->add_control(
  'vt_input_color_dark',
  [
      'label'     => esc_html__( 'Color input dark mode', 'typecase' ),
      'type'      => Controls_Manager::COLOR,
      'separator' => 'after',
      'selectors' => [
        ".options_dark_skin {{WRAPPER}} textarea, .options_dark_skin {{WRAPPER}} input[type='text'], .options_dark_skin {{WRAPPER}} input[type='tel'], .options_dark_skin {{WRAPPER}} input[type='password'], .options_dark_skin {{WRAPPER}} input[type='email'], .options_dark_skin {{WRAPPER}} input[type='url'], .options_dark_skin {{WRAPPER}} input[type='search'], .options_dark_skin {{WRAPPER}} input[type='number']" => 'color: {{VALUE}};',
        ".options_dark_skin {{WRAPPER}} textarea::-webkit-input-placeholder, .options_dark_skin {{WRAPPER}} input[type='text']::-webkit-input-placeholder, .options_dark_skin {{WRAPPER}} input[type='tel']::-webkit-input-placeholder, .options_dark_skin {{WRAPPER}} input[type='password']::-webkit-input-placeholder, .options_dark_skin {{WRAPPER}} input[type='email']::-webkit-input-placeholder, .options_dark_skin {{WRAPPER}} input[type='url']::-webkit-input-placeholder, .options_dark_skin {{WRAPPER}} input[type='search']::-webkit-input-placeholder, .options_dark_skin {{WRAPPER}} input[type='number']::-webkit-input-placeholder" => 'color: {{VALUE}};',
      ]            
  ]
);

$this->add_group_control(
  Group_Control_Typography::get_type(),
  [
      'name'     => 'button_typography',
      'label'    => esc_html__( 'Button typography', 'typecase' ),      
      'selector' => '{{WRAPPER}} .wpcf7-submit',
  ]
);

$this->add_control(
  'button_background',
  [
      'label'     => esc_html__( 'Background button', 'typecase' ),
      'type'      => Controls_Manager::COLOR,
      'selectors' => [
        "{{WRAPPER}} .wpcf7-submit" => 'background: {{VALUE}} !important;',
      ]            
  ]
);

$this->add_control(
'button_background_dark',
[
    'label'     => esc_html__( 'Background button dark mode', 'typecase' ),
    'type'      => Controls_Manager::COLOR,
    'selectors' => [
      ".options_dark_skin {{WRAPPER}} .wpcf7-submit" => 'background: {{VALUE}} !important;',
    ]            
]
);  

$this->add_control(
'vt_button_color',
[
  'label'     => esc_html__( 'Color button', 'typecase' ),
  'type'      => Controls_Manager::COLOR,
  'selectors' => [
    "{{WRAPPER}} .wpcf7-submit" => 'color: {{VALUE}} !important;',
  ]            
]
);

$this->add_control(
'vt_button_color_dark',
[
'label'     => esc_html__( 'Color button dark mode', 'typecase' ),
'type'      => Controls_Manager::COLOR,
'separator' => 'after',
'selectors' => [
  ".options_dark_skin {{WRAPPER}} .wpcf7-submit" => 'color: {{VALUE}} !important;',
]            
]
);

$this->add_control(
  'button_backgroundhover',
  [
      'label'     => esc_html__( 'Background button hover', 'typecase' ),
      'type'      => Controls_Manager::COLOR,
      'selectors' => [
        "{{WRAPPER}} .wpcf7-submit:hover" => 'background: {{VALUE}} !important;',
      ]            
  ]
);

$this->add_control(
'button_background_darkhover',
[
    'label'     => esc_html__( 'Background button hover dark mode', 'typecase' ),
    'type'      => Controls_Manager::COLOR,
    'selectors' => [
      ".options_dark_skin {{WRAPPER}} .wpcf7-submit:hover" => 'background: {{VALUE}} !important;',
    ]            
]
);  

$this->add_control(
'vt_button_colorhover',
[
  'label'     => esc_html__( 'Color button hover', 'typecase' ),
  'type'      => Controls_Manager::COLOR,
  'selectors' => [
    "{{WRAPPER}} .wpcf7-submit:hover" => 'color: {{VALUE}} !important;',
  ]            
]
);

$this->add_control(
'vt_button_color_darkhover',
[
'label'     => esc_html__( 'Color button hover dark mode', 'typecase' ),
'type'      => Controls_Manager::COLOR,
'separator' => 'after',
'selectors' => [
  ".options_dark_skin {{WRAPPER}} .wpcf7-submit:hover" => 'color: {{VALUE}} !important;',
]            
]
);

$this->add_group_control(
  Group_Control_Typography::get_type(),
  [
      'name'     => 'form_typography',
      'label'    => esc_html__( 'Form typography', 'typecase' ),      
      'selector' => '{{WRAPPER}} .wpcf7-form',
  ]
);

$this->add_control(
  'form_color',
  [
    'label'     => esc_html__( 'Form color', 'typecase' ),
    'type'      => Controls_Manager::COLOR,
    'selectors' => [
      "{{WRAPPER}} .wpcf7-form" => 'color: {{VALUE}} !important;',
    ]            
  ]
  );
  
  $this->add_control(
  'form_color_dark',
  [
  'label'     => esc_html__( 'Form color dark mode', 'typecase' ),
  'type'      => Controls_Manager::COLOR,
  'separator' => 'after',
  'selectors' => [
    ".options_dark_skin {{WRAPPER}} .wpcf7-form" => 'color: {{VALUE}} !important;',
  ]            
  ]
  );

    
      $this->end_controls_section();

    }

    protected function render( ) { 
        $settings = $this->get_settings_for_display();        
        $form_items = $settings['form_items'];        
        ?>
        <div class="vt-contact-form-7">
        <?php if ( ! empty( $form_items ) ) {
            echo do_shortcode( '[contact-form-7 id="' . esc_attr($form_items) . '"]' );
        } ?>
        </div>
    <?php       

    }    

    public function typecase_all_form() {
        $options       = array();
        $contact_forms = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );
        if ( ! empty( $contact_forms ) ) {
                $options[''] = esc_html__( 'Default', 'typecase' );
            foreach ( $contact_forms as $contact_form ) {
                $options[ $contact_form->ID ] = esc_html( $contact_form->post_title );
            }
        }
        return $options;
}
}