<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class typecase_section_current_date extends Widget_Base {

    public function get_name() {
        return 'typecase-current-date';
    }

    public function get_title() {
        return esc_html__( 'Vision Current Date', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-calendar vt-icons';
    }

    public function get_categories() {
        return [ 'typecase-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'text_elements',
            [
                'label' => __( 'Date Settings', 'typecase' ),
            ]
        );
        
        $this->add_control(
            'current_date', [
              'label'       => esc_html__( 'Date format', 'typecase' ),
              'type'        => Controls_Manager::TEXT,
              'label_block' => true,
              'default'     => 'l ,  j  F Y'
            ]
            );   
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography', 
                    'label' =>esc_html__( 'Date typography', 'typecase' ),               
                    'selector' => '{{WRAPPER}} .vt_cur_date',                    
                ]
            );
        $this->add_control(
            'vt_date_color',
            [
                'label' =>esc_html__( 'Color', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .vt_cur_date' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->add_control(
            'vt_date_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt_cur_date' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();   
       $current_date = $settings['current_date'];     
       ?>
       <div class="vt_cur_date">
        <?php echo date_i18n( $current_date, current_time( 'timestamp' ) ); ?>
       </div>      
    <?php
    }
}