<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class typecase_section_dark_mode extends Widget_Base {

    public function get_name() {
        return 'typecase-dark-mode-switch';
    }

    public function get_title() {
        return esc_html__( 'Dark mode switcher', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-circle vt-icons';
    }

    public function get_categories() {
        return [ 'typecase-elements-head' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_style_marker',
            [
                'label' => __( 'Dark Mode Style', 'typecase' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );          
        $this->add_control(
            'vt_btn_switch_color',
            [
                'label' =>esc_html__( 'Color', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .typecase_day_night .vt-night-toggle-icon' => 'background: {{VALUE}} !important;',
                ],
            ]
        );  

        $this->add_control(
            'vt_btn_switch_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .typecase_day_night .vt-night-toggle-icon' => 'background: {{VALUE}} !important;',
                ],
            ]
        );        

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();
        ?>
        <div class="typecase_day_night <?php $vt_dn_option = isset( $_COOKIE['vtmode_dn'] ) ? $_COOKIE['vtmode_dn'] : '';if ( 'true' === $vt_dn_option ) {echo 'vt_night_en';}else{echo 'vt_day_en';}?>">
            <span class="vt-night-toggle-icon">
                <span class="vt_moon">
                    <i class="vti-moon"></i>
                </span>
                <span class="vt_sun">
                    <i class="vti-sun"></i>
                </span>
            </span>
        </div>
        <?php
    }
}