<?php
namespace typecaseElementor;
use Elementor\Widget_Base;
defined('ABSPATH') || die();
define("TYPECASE_API", 'https://visionwp.com/wp/wp-json/purchase/v1/purchase-check');
define("TYPECASE_ID", 25223481);
define("TYPECASE_THEMENAME", 'Welcome to Typecase');
if (!did_action('elementor/loaded')) {
	return;
}

class typecase_Shortcode{
    
    private static $_instance = null;
    public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
	public function __construct(){
        add_action('elementor/elements/categories_registered', array($this, 'typecase_header_ele_init'));
        add_action('elementor/elements/categories_registered', array($this, 'typecase_elementor_init'), 10, 1);        
        add_action( 'elementor/widgets/register', array( $this, 'typecase_shortcode_elements' ), 1 );        
        add_action( 'elementor/element/section/section_background/after_section_end', [ $this, 'typecase_bg_dark' ], 10, 2 );
        add_action( 'elementor/element/section/section_border/after_section_end', [ $this, 'typecase_border_dark' ], 10, 2 );
        add_action( 'elementor/element/column/section_advanced/after_section_end', [ $this, 'typecase_order' ], 10, 2 );
        add_action( 'elementor/element/common/_section_style/after_section_end', array( $this, 'typecase_order' ), 10, 2 );                
        add_action( 'elementor/element/divider/section_divider_style/after_section_end', array( $this, 'typecase_dark_input' ), 10, 2 );        
        add_action( 'elementor/element/heading/section_title_style/after_section_end', array( $this, 'typecase_heading_dark' ), 10, 2 );
        add_action( 'elementor/element/image-box/section_style_content/after_section_end', array( $this, 'typecase_image_box_dark' ), 10, 2 );
        add_action( 'elementor/element/counter/section_title/after_section_end', array( $this, 'typecase_counter_dark' ), 10, 2 );
        add_action( 'elementor/element/icon-box/section_style_content/after_section_end', array( $this, 'typecase_icon_box_dark' ), 10, 2 );        
        add_action( 'elementor/element/text-editor/section_style/after_section_end', array( $this, 'typecase_editor_dark' ), 10, 2 );        
        add_action( 'elementor/element/social-icons/section_social_hover/after_section_end', array( $this, 'typecase_social_icons_dark' ), 10, 2 );        
        add_action( 'elementor/element/icon/section_style_icon/after_section_end', array( $this, 'typecase_icons_dark' ), 10, 2 );        
        add_action( 'elementor/element/icon-list/section_text_style/after_section_end', array( $this, 'typecase_icons_list_dark' ), 10, 2 );        
        add_action( 'elementor/element/button/section_style/after_section_end', array( $this, 'typecase_button_dark' ), 10, 2 );                        
        add_action( 'elementor/frontend/after_register_scripts', array( $this, 'typecase_after_register_scripts' ) );
        add_action( 'elementor/frontend/after_enqueue_styles', array( $this, 'typecase_after_register_styles' ) );
	}
    public function typecase_after_register_scripts(){
        wp_register_script('opt-mod', TYPECASE_ADDONS_ASSETS . 'js/opt-mod.js', array( 'jquery' ),false,true);
    }
    public function typecase_after_register_styles() {
          wp_register_style('vt-infobox', TYPECASE_ADDONS_ASSETS .'css/infobox.css', false, false, 'all' );
          wp_register_style('vt-accordion', TYPECASE_ADDONS_ASSETS .'css/accordion.css', false, false, 'all' );      
    }
    public function typecase_header_ele_init($elements_manager){
        $categories = [];
        $categories['typecase-elements-head'] = [
            'title' => esc_html__( 'Typecase header elements', 'typecase' ),
            'icon' => 'fa fa-server',
        ];
        $old_categories = $elements_manager->get_categories();
        $categories = array_merge($categories, $old_categories);
        $set_categories = function ( $categories ) {
            $this->categories = $categories;
        };
        $set_categories->call( $elements_manager, $categories );
    }

    public function typecase_elementor_init($elements_manager){
        $categories = [];
        $categories['typecase-elements'] = [
            'title' => esc_html__( 'Typecase blog layouts', 'typecase' ),
            'icon' => 'fa fa-server',
        ];
        $old_categories = $elements_manager->get_categories();
        $categories = array_merge($categories, $old_categories);
        $set_categories = function ( $categories ) {
            $this->categories = $categories;
        };
        $set_categories->call( $elements_manager, $categories );
    }    
    public function typecase_shortcode_elements(){
        $typecase_is_registered = false;
        $typecase_is_registered = typecase_is_registered();
        if(empty($typecase_is_registered)){
            return;
        }
        require_once 'section-title.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_title());
        require_once 'feature-box.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_box());
        require_once 'featured-layout-1.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout1());
        require_once 'featured-layout-2.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout2());
        require_once 'featured-layout-19.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout19());
        require_once 'featured-layout-20.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout20());
        require_once 'featured-layout-3.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout3());
        require_once 'featured-layout-4.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout4());
        require_once 'featured-layout-5.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout5());
        require_once 'featured-layout-6.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout6());
        require_once 'featured-layout-7.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout7());
        require_once 'featured-layout-8.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout8());
        require_once 'featured-layout-9.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout9());
        require_once 'featured-layout-10.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout10());
        require_once 'featured-layout-11.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout11());
        require_once 'featured-layout-12.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout12());
        require_once 'featured-layout-13.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout13());
        require_once 'featured-layout-14.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout14());
        require_once 'featured-layout-18.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout18());
        require_once 'small-main-right-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout15());
        require_once 'small-main-below-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout16());
        require_once 'small-main-below-2list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout_ligrid());
        require_once 'small-2main-below-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_layout17());
        require_once 'small-overlay-main-below-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_main_ov_sm_li());
        require_once 'feature-slider.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_slider());
        require_once 'feature-slider-tab.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_slider_tab());
        require_once 'feature-hover.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_hover());
        require_once 'feature-carousel.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_carousel());
        require_once 'feature-center-slider.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_center_slider());
        require_once 'large-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_large_post());
        require_once 'grid-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_grid_post());
        require_once 'grid-number.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_grid_number());
        require_once 'grid-overlay.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_grid_overlay());
        require_once 'list-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_list_post());
        require_once 'list-mix-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_list_mix_post());
        require_once 'list-number.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_list_number());
        require_once 'small-list-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_small_list());
        require_once 'xsmall-list-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_xsmall_list());
        require_once 'contact-form.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_contact_form());
        require_once 'gallery.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_gallery());
        require_once 'category-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_category_list());
        require_once 'social.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_social_list());
        require_once 'feature-video.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_feature_video());
        require_once 'marquee-text.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_marquee_text());
        require_once 'newsticker.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_newsticker_text());      

        if ( class_exists( 'woocommerce' ) ) {
            require_once 'feature-product.php';
            \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_product_list());
            require_once 'cart.php';
            \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_cart());
        }

        require_once 'logo.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_logo());
        require_once 'simple-menu.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_simple_menu());
        require_once 'search-button.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_search_button());
        require_once 'mobile-menu.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_mobile_menu());      
        require_once 'dark-mode-switcher.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_dark_mode());
        require_once 'main-menu.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_main_menu());
        require_once 'current-date.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_current_date());
        require_once 'layouts.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_layouts());

        require_once 'accordion.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_accordion());
        require_once 'infobox.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\typecase_section_infobox());
      
    }
    public function typecase_bg_dark( $element, $args ) {
        $element->start_controls_section(
                'typecase_bg_dark_section',
                [
                    'label' => esc_html__( 'Dark Mode Background Options', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );
        $element->add_group_control(
            \Elementor\Group_Control_Background::get_type(), array(
                'label'    => esc_html__( 'Dark Mode Background', 'typecase' ),
                'name'     => 'typecase_bg_dark',
                'types'    => array( 'classic', 'gradient' ),
                'selector' => '.options_dark_skin {{WRAPPER}}.elementor-section',
            )
        );
        $element->end_controls_section();
    }
    public function typecase_border_dark( $element, $args ) {
        $element->start_controls_section(
                'vt_border_section',
                [
                    'label' => esc_html__( 'Dark Mode Border Options', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                ]
        );
        $element->add_control(
                'vt_border_dk_color',
                [
                    'label' => esc_html__( 'Dark Mode Border Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}' => 'border-color: {{VALUE}}',
                    )
                ]
        );
        $element->add_control(
                'vt_border_dk_hover',
                [
                    'label' => esc_html__( 'Dark Mode Border Hover Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}:hover' => 'border-color: {{VALUE}}',
                    )
                ]
        );
        $element->end_controls_section();
    }
    public function typecase_order( $element, $args ) {
            $element->start_controls_section(
                'typecase_vt_order_section',
                [
                    'label' => esc_html__( 'Custom Order', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
                ]
            );
            $element->add_responsive_control(
                'typecase_vt_order',
                [
                    'label'     => __( 'Order', 'typecase' ),
                    'type'      => \Elementor\Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}}' => 'order: {{VALUE}};',
                    ]
                ]
            );
            $element->end_controls_section();
    }
    public static function typecase_dark_input( $element, $args ) {
        $element->start_controls_section(
            'vt_svg_dark', array(
                'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $element->add_control(
            'vt_svg_color_dark', array(
                'label'       => esc_html__( 'Color', 'typecase' ),
                'type'        => \Elementor\Controls_Manager::COLOR,
                'selectors'   => array( '.options_dark_skin {{WRAPPER}}' => '--divider-color: {{VALUE}}', ),
                'default'     => ''
            )
        );
        $element->end_controls_section();
    }

    public static function typecase_heading_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_title_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_title_color', array(
                    'label'       => esc_html__( 'Dark Mode Text Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-heading-title' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->end_controls_section();
    }    

    public static function typecase_image_box_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_img_box_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_title_color', array(
                    'label'       => esc_html__( 'Title Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-image-box-title' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
    
            $element->add_control(
                'vt_dark_desc_color', array(
                    'label'       => esc_html__( 'Description Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-image-box-description' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#eeeeee'
                )
            );
            $element->end_controls_section();
        }

    public static function typecase_counter_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_counter_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_number_color',
                array(
                    'label'     => esc_html__( 'Number Color', 'typecase' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-counter-number-wrapper' => 'color: {{VALUE}};',
                    )
                )
            );
            $element->add_control(
                'vt_dark_title_color',
                array(
                    'label'     => esc_html__( 'Text Color', 'typecase' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-counter-title' => 'color: {{VALUE}};',
                    )
                )
            );
    
            $element->end_controls_section();
    }
        
    public static function typecase_icon_box_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_icon_box_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_icon_color', array(
                    'label'       => esc_html__( 'Icon Primary Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon'                                                                        => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}}; border-color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'vt_dark_icons_color', array(
                    'label'       => esc_html__( 'Icon Secondary Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon'  => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}};'
                    ),
                    'default'     => ''
                )
            );
    
            $element->add_control(
                'vt_dark_hicon_color', array(
                    'label'       => esc_html__( 'Hover Icon Primary Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon:hover'                                                                              => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon:hover, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon:hover' => 'fill: {{VALUE}}; color: {{VALUE}}; border-color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'vt_dark_hicons_color', array(
                    'label'       => esc_html__( 'Hover Icon Secondary Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon:hover'  => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon:hover' => 'fill: {{VALUE}}; color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'vt_dark_title_color', array(
                    'label'       => esc_html__( 'Title Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-box-title' => 'color: {{VALUE}};'
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'vt_dark_desc_color', array(
                    'label'       => esc_html__( 'Description Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-box-description' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#eeeeee'
                )
            );
            $element->end_controls_section();
        }

        
        public static function typecase_editor_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_editor_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_editor_color', array(
                    'label'       => esc_html__( 'Text Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} *' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->end_controls_section();
        }      

        
        public static function typecase_social_icons_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_social_i_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_icon_primary_color',
                array(
                    'label'     => esc_html__( 'Primary Color', 'typecase' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon' => 'background-color: {{VALUE}};',
                    ),
                )
            );
            $element->add_control(
                'vt_dark_icon_secondary_color',
                array(
                    'label'     => esc_html__( 'Secondary Color', 'typecase' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon svg' => 'fill: {{VALUE}};',
                    ),
                )
            );
    
            $element->add_control(
                'vt_dark_hicon_primary_color',
                array(
                    'label'     => esc_html__( 'Hover Primary Color', 'typecase' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon:hover' => 'background-color: {{VALUE}};',
                    ),
                )
            );
            $element->add_control(
                'vt_dark_hicon_secondary_color',
                array(
                    'label'     => esc_html__( 'Hover Secondary Color', 'typecase' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon:hover i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon:hover svg' => 'fill: {{VALUE}};',
                    ),
                )
            );
            $element->end_controls_section();
        }
        
        public static function typecase_icons_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_icon_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_icon_color', array(
                    'label'       => esc_html__( 'Primary Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'vt_dark_icons_color', array(
                    'label'       => esc_html__( 'Secondary Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon' => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => '',
                    'condition'   => array( 'view!' => 'default', ),
                )
            );
            $element->end_controls_section();
        }

        public static function typecase_icons_list_dark( $element, $args ) {
            $element->start_controls_section(
                'vt_icons_list_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'vt_dark_icon_color', array(
                    'label'       => esc_html__( 'Icon Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-icon i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'vt_dark_hicon_color', array(
                    'label'       => esc_html__( 'Hover Icon Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-icon i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'vt_dark_text_color', array(
                    'label'       => esc_html__( 'Text Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-text' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'vt_dark_htext_color', array(
                    'label'       => esc_html__( 'Hover Text Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-text' => 'color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'vt_dark_divider_color', array(
                    'label'       => esc_html__( 'Divider Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'condition'   => array( 'divider' => 'yes' ),
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:not(:last-child):after' => 'border-color: {{VALUE}}',
                    ),
                    'default'     => '#cccccc'
                )
            );
            $element->end_controls_section();
        }
        
        public static function typecase_button_dark( $section, $args ) {
            $section->start_controls_section(
                'vt_button_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'typecase' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $section->add_control(
                'vt_dark_button_text_color', array(
                    'label'       => esc_html__( 'Text Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button' => 'fill: {{VALUE}}; color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'vt_dark_button_bg_color', array(
                    'label'       => esc_html__( 'Background Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button' => 'background: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'vt_dark_button_line_color', array(
                    'label'       => esc_html__( 'Border Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button' => 'border-color: {{VALUE}}',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'vt_dark_button_text_colorh', array(
                    'label'       => esc_html__( 'Hover Text Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => [
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover, .options_dark_skin {{WRAPPER}} .elementor-button:focus'         => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover svg, .options_dark_skin {{WRAPPER}} .elementor-button:focus svg' => 'fill: {{VALUE}};',
                    ],
                    'default'     => ''
                )
            );
            $section->add_control(
                'vt_dark_button_bg_colorh', array(
                    'label'       => esc_html__( 'Hover Background Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover, .options_dark_skin {{WRAPPER}} .elementor-button:focus' => 'background: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'vt_dark_button_line_colorh', array(
                    'label'       => esc_html__( 'Hover Border Color', 'typecase' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover, .options_dark_skin {{WRAPPER}} .elementor-button:focus' => 'border-color: {{VALUE}}',
                    ),
                    'default'     => ''
                )
            );
    
            $section->end_controls_section();
        }
        
    
}
typecase_Shortcode::instance();