<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_feature_center_slider extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-feature-center-slider';
    }

    public function get_title() {
        return esc_html__( 'Feature Center Slider', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

    $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'typecase'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'typecase'),
              'description' => esc_html__( 'Choose post type to display posts', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'typecase'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'typecase' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'typecase' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'typecase'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'typecase' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'typecase'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'typecase'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
               

        $this->add_control(
      'posts_per_page',
      array(
        'label'       => esc_html__( 'Posts per Page', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '4'
      )
    );

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'typecase' ),
                        'gallery'        => esc_html__( 'Gallery', 'typecase' ),
                        'video'        => esc_html__( 'Video', 'typecase' ),
                        'audio'        => esc_html__( 'Audio', 'typecase' ),
                        'quote'        => esc_html__( 'Quote', 'typecase' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );   

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'typecase' ),                        
                  'rand'      =>esc_html__( 'Random', 'typecase' ),
                  'update'      =>esc_html__( 'Latest updated', 'typecase' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'typecase' ),
                  'author'      =>esc_html__( 'Author', 'typecase' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'typecase' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'typecase' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'typecase' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'typecase' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'typecase' ),
              ],
            ]
        );                   

    $this->end_controls_section();        
     
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );      

       $this->add_control(
            'car_type',
            [
                'label'     =>esc_html__( 'Carousel style', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'vt_center_car1',
                'options'   => [
                        'vt_center_car1'      =>esc_html__( 'Overlay Style', 'typecase' ),
                        'vt_center_car2'      =>esc_html__( 'Overlay + Background', 'typecase' ),
                        'vt_center_car3'      =>esc_html__( 'Classic Style', 'typecase' ),
                    ],
            ]
        ); 

        $this->add_control(
          'vt_cus_img',
          [
              'label'     =>esc_html__( 'Image size', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => '',
              'options'   => [
                      ''      =>esc_html__( 'Default image size', 'typecase' ),      
                      'typecase_large'      =>esc_html__( '1600 x 0', 'typecase' ),
                      'typecase_medium'      =>esc_html__( '1100 x 0', 'typecase' ),
                      'typecase_small'      =>esc_html__( '150 x 150', 'typecase' ),
                      'typecase_layouts'      =>esc_html__( '680 x 580', 'typecase' ),
                      'typecase_list'      =>esc_html__( '600 x 0', 'typecase' ),
                  ],
          ]
      ); 

        $this->add_responsive_control(
        'sl_height_main',
        [
            'label' => __( 'Slider height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 70,
            ],
            'tablet_default' => [
              'size' => 70,
            ],
            'mobile_default' => [
              'size' => 70,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 1500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt-eb-sl' => '--vt-slider-h: {{SIZE}}% !important;',            
            ],
        ]
      ); 

      $this->add_responsive_control(
        'slfont_size',
        [
            'label' => __( 'Title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 35,
            ],
            'tablet_default' => [
              'size' => 25,
            ],
            'mobile_default' => [
              'size' => 23,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt-eb-sl' => '--vt-title-size: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );        

      $this->add_responsive_control(
        'sl_radius',
        [
            'label' => __( 'Carousel border radius', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vtc-car-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
      );    

      $this->add_responsive_control(
        'sl_nav_width',
        [
            'label' => __( 'Arrow width', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-w: {{SIZE}}{{UNIT}};',
            ],
        ]
      );
      $this->add_responsive_control(
        'sl_nav_height',
        [
            'label' => __( 'Arrow height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-h: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_responsive_control(
        'sl_nav_size',
        [
            'label' => __( 'Arrow font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 150,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl .vt-spn-inner' => 'font-size: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
      );

      $this->add_control(
        'titlebg',
        [
          'label' => __( 'Title bg color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#FFF',
          'selectors' => [
              '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text .vt_fe_inner' => 'background: {{VALUE}}',
          ],
          'condition' => [
            'car_type' => [ 'vt_center_car3']
          ]
        ]
      );
  
      $this->add_control(
        'titlebg_dark',
        [
          'label' => __( 'Title bg color dark mode', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#101010',
          'selectors' => [
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_text .vt_fe_inner' => 'background: {{VALUE}}',            
          ],
          'condition' => [
            'car_type' => [ 'vt_center_car3']
          ]
        ]
      );
  
      $this->add_control(
        'sl_1cap_color',
        [
          'label' => __( 'Caption color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '{{WRAPPER}} .vt_cgrid_layout .vt_fe_title' => 'color: {{VALUE}} !important',
              '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text a' => 'color: {{VALUE}} !important',
              '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text .vt_fe_title:hover a' => 'color: {{VALUE}} !important',
              '{{WRAPPER}} .vt_cgrid_layout .vt_post_meta span' => 'color: {{VALUE}} !important',
              '{{WRAPPER}} .vt_cgrid_layout .vt_post_meta a' => 'color: {{VALUE}} !important',
              '{{WRAPPER}} .vt_cgrid_layout .vt_post_meta a:hover' => 'color: {{VALUE}} !important',
              '{{WRAPPER}} .vt_cgrid_layout .vt_fe_des' => 'color: {{VALUE}} !important'
          ],
          'condition' => [
            'car_type' => [ 'vt_center_car3']
          ]
        ]
      );
  
        $this->add_control(
        'sl_1cap_color_dark',
        [
          'label' => __( 'Caption dark mode color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_title' => 'color: {{VALUE}} !important',
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_text a' => 'color: {{VALUE}} !important',
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_text .vt_fe_title:hover a' => 'color: {{VALUE}} !important',
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_post_meta span' => 'color: {{VALUE}} !important',
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_post_meta a' => 'color: {{VALUE}} !important',
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_post_meta a:hover' => 'color: {{VALUE}} !important',
              '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_des' => 'color: {{VALUE}} !important'
          ],
          'condition' => [
            'car_type' => [ 'vt_center_car3']
          ]
        ]
      );

      $this->add_responsive_control(
        'sl_nav_radius',
        [
            'label' => __( 'Arrow border radius', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-r: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_responsive_control(
        'sl_nav_space',
        [
            'label' => __( 'Arrow space left/right', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-space: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_control(
      'sl_nav_bg',
      [
        'label' => __( 'Arrow background', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-bg: {{VALUE}}',
        ],
      ]
    );
      $this->add_control(
      'sl_nav_hbg',
      [
        'label' => __( 'Arrow background hover', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-hbg: {{VALUE}}',
        ],
      ]
    );
      $this->add_control(
      'sl_nav_color',
      [
        'label' => __( 'Arrow color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-color: {{VALUE}}',
        ],
      ]
    );
      $this->add_control(
      'sl_nav_hcolor',
      [
        'label' => __( 'Arrow color hover', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-arrow-hcolor: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'sl_dot_color',
      [
        'label' => __( 'Pagination color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .vt-eb-sl .swiper-pagination-bullet' => 'color: {{VALUE}} !important',
        ],
      ]
    );

    $this->add_control(
      'sl_dot_color_dark',
      [
        'label' => __( 'Pagination color dark mode', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vt-eb-sl .swiper-pagination-bullet' => 'color: {{VALUE}} !important',
        ],
      ]
    ); 

      $this->add_responsive_control(
        'sl_caption_width',
        [
            'label' => __( 'Caption width', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 1200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-caption-w: {{SIZE}}{{UNIT}};',
            ],
        ]
      );      

      $this->add_responsive_control(
        'sl_caption_padding',
        [
            'label' => __( 'Caption padding', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-eb-sl' => '--vt-caption-space: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_control(
        'vt_gradient_ov',
        [
            'label' => esc_html__( 'Enable gradient background', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => '',
            'selectors' => [
              '{{WRAPPER}} .vt_ov_el .vt_imgl' => 'background: transparent !important; background-image: repeating-linear-gradient(0deg, #000, transparent) !important;',
            ],
            'condition' => [
              'car_type' => [ 'vt_center_car1']
            ]
        ]
    );     

      $this->add_control(
        'sl_ov_bg',
        [
          'label' => __( 'Overlay background', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '{{WRAPPER}} .vt_ov_el .vt_imgl' => 'background: {{VALUE}}',
          ],                
          'condition' => [
                    'vt_gradient_ov!' => ''
          ]
        ]
      );

      $this->add_responsive_control(
        'vt_bg_opacity',
        [
            'label' => __( 'Opacity Overlay', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1,
                    'step' => 0.1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_ov_el .vt_imgl' => 'opacity: {{SIZE}}',            
            ],
            'condition' => [
              'car_type' => [ 'vt_center_car1']
            ]
        ]
    ); 
    
            $this->add_control(
                'slider_speed',
                [
                    'label' => esc_html__('Speed', 'typecase'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 600,
                ]
            );         

            $this->add_control(
                'slider_spacebetween',
                [
                    'label' => esc_html__('Space Between Items', 'typecase'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 30,
                ]
            );   

            $this->add_control(
                'slider_loop',
                [
                    'label' => esc_html__( 'Repeatable Loop', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'slider_autoplay',
                [
                    'label' => esc_html__( 'Autoplay', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'slider_autoplay_delay',
                [
                    'label' => esc_html__('Autoplay Delay', 'typecase'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3500,
                    'condition'=>[
                        'slider_autoplay'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'slider_arrow',
                [
                    'label' => esc_html__( 'Slider Navigation', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );            

            $this->add_control(
                'slider_dots',
                [
                    'label' => esc_html__( 'Slider Pagination', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );       

            $this->add_control(
                'vt_hide_cat',
                [
                    'label' => esc_html__( 'Hide category', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_author',
                [
                    'label' => esc_html__( 'Hide author', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_date',
                [
                    'label' => esc_html__( 'Hide date', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

            $this->add_control(
                'vt_hide_meta',
                [
                    'label' => esc_html__( 'Hide author & date', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );            

            $this->add_control(
                'vt_hide_review',
                [
                    'label' => esc_html__( 'Hide review', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );        
       
         
        $this->end_controls_section();
    }

protected function render( ) { 
      $settings = $this->get_settings();

      if ( function_exists( 'typecase_cslider' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();
      $id = $settings['blockid'];
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }
      echo '<style>#'.esc_attr($settings['blockid']).' .vt-eb-sl:not(.swiper-container-initialized) .swiper-wrapper{width: 150%; margin-left: -25%; grid-template-columns: repeat(3,minmax(0,1fr));grid-column-gap: '.esc_attr($settings['slider_spacebetween']).'px;display: grid;}#'.esc_attr($settings['blockid']).' .vt-eb-sl:not(.swiper-container-initialized) .swiper-wrapper .swiper-slide{display: none;}#'.esc_attr($settings['blockid']).' .vt-eb-sl:not(.swiper-container-initialized) .swiper-wrapper .swiper-slide:nth-child(-n+3){display: block;}</style>';
      echo \typecase_cslider( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'typecase' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }

   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }
}