<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_feature_hover extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-feature-hover';
    }

    public function get_title() {
        return esc_html__( 'Feature Hover', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

    $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'typecase'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'typecase'),
              'description' => esc_html__( 'Choose post type to display posts', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'typecase'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'typecase' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'typecase' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'typecase'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'typecase' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'typecase'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'typecase'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
               

        $this->add_control(
      'posts_per_page',
      array(
        'label'       => esc_html__( 'Posts per Page', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6'
      )
    );

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'typecase' ),
                        'gallery'        => esc_html__( 'Gallery', 'typecase' ),
                        'video'        => esc_html__( 'Video', 'typecase' ),
                        'audio'        => esc_html__( 'Audio', 'typecase' ),
                        'quote'        => esc_html__( 'Quote', 'typecase' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );     

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );  
      
      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'typecase' ),                        
                  'rand'      =>esc_html__( 'Random', 'typecase' ),
                  'update'      =>esc_html__( 'Latest updated', 'typecase' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'typecase' ),
                  'author'      =>esc_html__( 'Author', 'typecase' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'typecase' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'typecase' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'typecase' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'typecase' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'typecase' ),
              ],
            ]
        );                   

    $this->end_controls_section();        
     
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );      
        
        $this->add_control(
          'vt_cus_img',
          [
              'label'     =>esc_html__( 'Image size', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => '',
              'options'   => [
                      ''      =>esc_html__( 'Default image size', 'typecase' ),      
                      'typecase_large'      =>esc_html__( '1600 x 0', 'typecase' ),
                      'typecase_medium'      =>esc_html__( '1100 x 0', 'typecase' ),
                      'typecase_small'      =>esc_html__( '150 x 150', 'typecase' ),
                      'typecase_layouts'      =>esc_html__( '680 x 580', 'typecase' ),
                      'typecase_list'      =>esc_html__( '600 x 0', 'typecase' ),
                  ],
          ]
      ); 

        $this->add_responsive_control(
        'sl_height',
        [
            'label' => __( 'Feature height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
            'size' => 500,
            ],
            'tablet_default' => [
              'size' => 400,
            ],
            'mobile_default' => [
              'size' => 400,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 1500,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-showcase-container' => '--vtc-sh-height: {{SIZE}}{{UNIT}};',
            ]            
        ]
      );

      $this->add_responsive_control(
        'vt_item_cols',
        [
            'label' => __( 'Number of columns', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 4,
            ],
            'tablet_default' => [
              'size' => 4,
            ],
            'mobile_default' => [
              'size' => 2,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt-showcase-wrapper' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr)) !important;',            
            ],
        ]
      );
      
      $this->add_responsive_control(
        'slfont_size',
        [
            'label' => __( 'Title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt-showcase-container' => '--vtc-font-size: {{SIZE}}{{UNIT}};',            
            ],
        ]
      );          

      $this->add_responsive_control(
        'vt_num_text_line',
        [
            'label' => __( 'Number line of text', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-showcase-content .vt_fe_title' => 'display: -webkit-box !important; -webkit-line-clamp: {{SIZE}}; -webkit-box-orient: vertical; overflow: hidden; color: #fff;',            
            ],
        ]
    ); 

      $this->add_responsive_control(
        'captions_padding',
        [
            'label' => __( 'Captions padding', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-showcase-item-inner' => 'padding: {{SIZE}}{{UNIT}};',
            ],
        ]
      );
      
      $this->add_responsive_control(
        'sl_nav_radius',
        [
            'label' => __( 'Feature border radius', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt-showcase-container' => '--vtc-car-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_control(
        'vt_gradient_ov',
        [
            'label' => esc_html__( 'Enable gradient background', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => '',
            'selectors' => [
              '{{WRAPPER}} .vt-img-wrap:after' => 'background: transparent !important; background-image: repeating-linear-gradient(0deg, #000, transparent) !important;',
            ],
        ]
    );     

      $this->add_control(
        'sl_ov_bg',
        [
          'label' => __( 'Overlay background', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '{{WRAPPER}} .vt-img-wrap:after' => 'background: {{VALUE}}',
          ],                
          'condition' => [
                    'vt_gradient_ov' => ''
          ]
        ]
      );    
      
      $this->add_responsive_control(
        'vt_bg_opacity',
        [
            'label' => __( 'Opacity Overlay', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1,
                    'step' => 0.1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_ov_el .vt_imgl' => 'opacity: {{SIZE}}',            
            ],
        ]
    ); 
         
        $this->end_controls_section();
    }

protected function render( ) { 
      $settings = $this->get_settings();

      if ( function_exists( 'typecase_hover_case' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();
      $id = $settings['blockid'];
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }      
      echo \typecase_hover_case( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'typecase' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }

   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }
}