<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_product_list extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-product-list';
    }

    public function get_title() {
        return esc_html__( 'Product List', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

    $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Product Query And Setting', 'typecase'),
            ]
        );

        $this->add_control(
			'post_status',
			[
				'label' => esc_html__( 'Post Status', 'typecase' ),
				'placeholder' => esc_html__( 'Choose Post Status', 'typecase' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'default' => 'publish',
				'multiple' => true,
				'options' => $this->typecase_get_post_status(),
			]
		);

		$this->add_control(
			'product_types',
			[
				'label' => esc_html__( 'Product Types', 'typecase' ),
				'placeholder' => esc_html__( 'Choose Products to Include', 'typecase' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'default' => '',
				'options' => $this->typecase_get_product_types(),
			]
		);

        $this->add_control(
            'product_cats',
            [
                'label' =>esc_html__('Select Categories', 'typecase'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->typecase_get_product_cats(),
                'label_block' => true,
                'multiple'  => true,
            ]
        );

        $this->add_control(
      'product_tags', [
        'label'       => esc_html__( 'Tag Slug', 'typecase' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );

        $this->add_control(
      'posts_per_page',
      array(
        'label'       => esc_html__( 'Posts per Page', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '4'
      )
    );

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date',
                'options'   => [
                        'date'      =>esc_html__( 'Latest Post', 'typecase' ),
                        'rand'      =>esc_html__( 'Random', 'typecase' ),
                        'modified'      =>esc_html__( 'Modified', 'typecase' )
                    ],
            ]
        );

        $this->add_group_control(
    			\Elementor\Group_Control_Image_Size::get_type(),
    			[
    				'name' => 'thumbnail_size',
    				'default' => 'medium_large',
    			]
    		);

    $this->end_controls_section();

    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Product Custom Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );

      $this->add_responsive_control(
        'grid_col',
        [
            'label' => __( 'Product columns', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
            'size' => 4,
            ],
            'tablet_default' => [
              'size' => 4,
            ],
            'mobile_default' => [
              'size' => 2,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_wcli_in' => '--vt-wc-col: {{SIZE}} !important;',
            ],
        ]
      );

      $this->add_responsive_control(
        'grid_col_gap',
        [
            'label' => __( 'Grid space columns', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
            'size' => 30,
            ],
            'tablet_default' => [
              'size' => 30,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_wcli_in' => '--vt-wc-col-gap: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
      );

      $this->add_responsive_control(
        'grid_row_gap',
        [
            'label' => __( 'Grid space row', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
            'size' => 30,
            ],
            'tablet_default' => [
              'size' => 30,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_wcli_in' => '--vt-wc-row-gap: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
      );

      $this->add_responsive_control(
        'pro_img_height',
        [
            'label' => __( 'Product image height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_wcli_in' => '--vt-img-h: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_responsive_control(
        'pro_title',
        [
            'label' => __( 'Product title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_wcli_in' => '--vt-pro-title: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_responsive_control(
        'pro_price',
        [
            'label' => __( 'Product price font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_wcli_in' => '--vt-pro-price: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_control(
      'pro_color',
      [
        'label' => __( 'Product text color', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .vt_wcli_w .vt_wc_title a, {{WRAPPER}} .vt_wcli_w .vt_wc_price' => 'color: {{VALUE}} !important'
        ]
      ]
    );

      $this->add_control(
      'pro_color_dark',
      [
        'label' => __( 'Product text color dark mode', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vt_wcli_w .vt_wc_title a, .options_dark_skin {{WRAPPER}} .vt_wcli_w .vt_wc_price' => 'color: {{VALUE}} !important'
        ]
      ]
    );

        $this->end_controls_section();
    }

      public function typecase_get_product_types() {
        $product_types_lists = wc_get_product_types();
        return $product_types_lists;
      }

      public function typecase_get_post_status() {
          $post_statuses = array();
          $post_statuses['any'] = esc_html__('Any', 'typecase');
          $post_statuses = get_post_statuses();
          return $post_statuses;
      }      

      public function typecase_get_product_cats( $category='product_cat' ) {
            $product_categories_list = array();
            $args = array(
                'taxonomy'   => $category,
            );
            $args = apply_filters( 'typecase_get_product_cat_args', $args );
            $product_categories = get_terms($args);
        
            if( !empty($product_categories) ){
              foreach ($product_categories as $cat) {
                $product_categories_list[$cat->slug] = $cat->name;
              }
            }
            return $product_categories_list;
      }

      public function typecase_get_attachment_alt( $attachment_id ) {
          if ( ! $attachment_id ) {
            return '';
          }
          $attachment = get_post( $attachment_id );
          if ( ! $attachment ) {
            return '';
          }
          $alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
          if ( ! $alt ) {
            $alt = $attachment->post_excerpt;
            if ( ! $alt ) {
              $alt = $attachment->post_title;
            }
          }
          return trim( strip_tags( $alt ) );
        }      
      
    
protected function render( ) {
      $settings = $this->get_settings_for_display();

      $args['status'] = 'publish';
  		if( isset($settings['post_status']) && is_array($settings['post_status']) && !empty($settings['post_status']) ){
  			$args['status'] = $settings['post_status'];
  		}

  		if( isset($settings['product_types']) && is_array($settings['product_types']) && !empty($settings['product_types']) ){
  			$args['type'] = $settings['product_types'];
  		}

      if( isset($settings['product_cats']) && is_array($settings['product_cats']) && !empty($settings['product_cats']) ){
  			$args['category'] = $settings['product_cats'];
  		}

      if( isset($settings['product_tags']) && !empty($settings['product_tags']) ){
  			$args['tag'] = explode (",", $settings['product_tags']);
  		}

      if( isset($settings['post_not_in']) && !empty($settings['post_not_in']) ){
  			$args['exclude'] = explode (",", $settings['post_not_in']);
  		}

      if( isset($settings['post_in']) && !empty($settings['post_in']) ){
  			$args['include'] = explode (",", $settings['post_in']);
  		}

  		if( isset($settings['posts_per_page']) && intval($settings['posts_per_page']) > 0 ){
  			$args['limit'] = $settings['posts_per_page'];
  		}

  		if( isset($settings['offset']) && !empty($settings['offset']) ){
  			$args['offset'] = $settings['offset'];
  		}

      if( isset($settings['order']) && !empty($settings['order']) ){
  			$args['orderby'] = $settings['order'];
  		}
      $products = wc_get_products($args);
      ?>
      <div class="vt_wcli_w">
        <div class="vt_wcli_in">
        <?php
        if ( sizeof($products) > 0 ) :
        foreach ( $products as $product ) :

        $thumbnail_id = $product->get_image_id();
        require( TYPECASE_ADDONS_DIR_PATH . 'block/tpl-product.php' );

        endforeach;
        endif;
        ?>
        </div>
      </div>
      <?php
    }
}