<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_feature_layout19 extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-feature-layout19';
    }

    public function get_title() {
        return esc_html__( 'Overlay + Right 3 Grid', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

    $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'typecase'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'typecase'),
              'description' => esc_html__( 'Choose post type to display posts', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'typecase'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'typecase' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'typecase' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'typecase'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'typecase' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'typecase'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'typecase'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
              

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'typecase' ),
                        'gallery'        => esc_html__( 'Gallery', 'typecase' ),
                        'video'        => esc_html__( 'Video', 'typecase' ),
                        'audio'        => esc_html__( 'Audio', 'typecase' ),
                        'quote'        => esc_html__( 'Quote', 'typecase' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );      

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'typecase' ),                        
                  'rand'      =>esc_html__( 'Random', 'typecase' ),
                  'update'      =>esc_html__( 'Latest updated', 'typecase' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'typecase' ),
                  'author'      =>esc_html__( 'Author', 'typecase' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'typecase' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'typecase' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'typecase' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'typecase' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'typecase' ),
              ],
            ]
        );

    $this->end_controls_section();
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     

        $this->add_control(
          'vt_cus_img',
          [
              'label'     =>esc_html__( 'Image size', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => '',
              'options'   => [
                      ''      =>esc_html__( 'Default image size', 'typecase' ),      
                      'typecase_large'      =>esc_html__( '1600 x 0', 'typecase' ),
                      'typecase_medium'      =>esc_html__( '1100 x 0', 'typecase' ),
                      'typecase_small'      =>esc_html__( '150 x 150', 'typecase' ),
                      'typecase_layouts'      =>esc_html__( '680 x 580', 'typecase' ),
                      'typecase_list'      =>esc_html__( '600 x 0', 'typecase' ),
                  ],
          ]
      ); 
 
     $this->add_responsive_control(
        'mf_font_size',
        [
            'label' => __( 'Main title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 28,
            ],
            'tablet_default' => [
              'size' => 28,
            ],
            'mobile_default' => [
              'size' => 22,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-font-main: {{SIZE}}{{UNIT}};',            
            ],
        ]
      ); 

      $this->add_responsive_control(
        'mdf_font_size',
        [
            'label' => __( 'Medium title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 16,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-font-medium: {{SIZE}}{{UNIT}};',            
            ],
        ]
      );     

      $this->add_responsive_control(
        'sf_font_size',
        [
            'label' => __( 'Small title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 17,
            ],
            'tablet_default' => [
              'size' => 17,
            ],
            'mobile_default' => [
              'size' => 16,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-font-small: {{SIZE}}{{UNIT}};',            
            ],
        ]
      );     

        $this->add_responsive_control(
        'imgm_height',
        [
            'label' => __( 'Image main height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 80,
            ],
            'tablet_default' => [
              'size' => 40,
            ],
            'mobile_default' => [
              'size' => 70,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-main-h: {{SIZE}}%;',
            ]
        ]
      );

        $this->add_responsive_control(
        'imgs_height',
        [
            'label' => __( 'Image small height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 40,
            ],
            'tablet_default' => [
              'size' => 50,
            ],
            'mobile_default' => [
              'size' => 100,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-small-h: {{SIZE}}%;',
            ]
        ]
      );

        $this->add_responsive_control(
        'grid_spacing',
        [
            'label' => __( 'Grid Spacing', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 3,
            ],
            'tablet_default' => [
              'size' => 3,
            ],
            'mobile_default' => [
              'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-grid-gap: {{SIZE}}{{UNIT}};',
            ]
        ]
      );

        $this->add_responsive_control(
        'capm_padding',
        [
            'label' => __( 'Caption main padding', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 30,
            ],
            'tablet_default' => [
              'size' => 30,
            ],
            'mobile_default' => [
              'size' => 15,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-padding-main: {{SIZE}}{{UNIT}};',
            ]
        ]
      );

        $this->add_responsive_control(
        'caps_padding',
        [
            'label' => __( 'Caption small padding', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 15,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_fr19_inner' => '--vt-padding-small: {{SIZE}}{{UNIT}};',
            ]
        ]
      );

        $this->add_responsive_control(
        'sl_radius',
        [
            'label' => __( 'Post border radius', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_fr19_inner' => '--vtc-car-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
      );  

      $this->add_responsive_control(
        'vt_num_text_line',
        [
            'label' => __( 'Number line of text', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_ov_el .vt_fe_text .vt_fe_title' => '-webkit-line-clamp: {{SIZE}};',            
            ],
        ]
    ); 

      $this->add_control(
        'vt_gradient_ov',
        [
            'label' => esc_html__( 'Enable gradient background', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => '',
            'selectors' => [
              '{{WRAPPER}} .vt_ov_el .vt_imgl' => 'background: transparent !important; background-image: repeating-linear-gradient(0deg, #000, transparent) !important;',
            ],
        ]
    ); 
    
      $this->add_control(
        'sl_ov_bg',
        [
          'label' => __( 'Overlay background', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '{{WRAPPER}} .vt_ov_el .vt_imgl' => 'background: {{VALUE}}',
          ],                
          'condition' => [
                    'vt_gradient_ov' => ''
          ]
        ]
      );

      $this->add_responsive_control(
        'vt_bg_opacity',
        [
            'label' => __( 'Opacity Overlay', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1,
                    'step' => 0.1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_ov_el .vt_imgl' => 'opacity: {{SIZE}}',            
            ],
        ]
    ); 

        $this->add_control(
      'cap_h_align',
      [
        'label' => __( 'Horizontal Alignment', 'typecase' ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'left' => [
            'title' => __( 'Left', 'typecase' ),
            'icon' => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => __( 'Center', 'typecase' ),
            'icon' => 'eicon-text-align-center',
          ],
          'right' => [
            'title' => __( 'Right', 'typecase' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
        'selectors' => [
                '{{WRAPPER}} .vt_fr19_inner' => '--vt-h-align: {{VALUE}}',                
            ]        
      ]
    );    

    $this->add_control(
      'cap_v_align',
      [
        'label' => __( 'Vertical Alignment', 'typecase' ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'start' => [
            'title' => __( 'Top', 'typecase' ),
            'icon' => 'eicon-v-align-top',
          ],
          'center' => [
            'title' => __( 'Middle', 'typecase' ),
            'icon' => 'eicon-v-align-middle',
          ],
          'end' => [
            'title' => __( 'Bottom', 'typecase' ),
            'icon' => 'eicon-v-align-bottom',
          ],
        ],
        'toggle' => true,
        'selectors' => [
                '{{WRAPPER}} .vt_fr19_inner' => '--vt-v-align: {{VALUE}}',                
            ]        
      ]
    );      

      $this->add_control(
                'vt_hide_cat',
                [
                    'label' => esc_html__( 'Hide category', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_author',
                [
                    'label' => esc_html__( 'Hide author', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_date',
                [
                    'label' => esc_html__( 'Hide date', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

            $this->add_control(
                'vt_hide_meta',
                [
                    'label' => esc_html__( 'Hide author & date', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );            

            $this->add_control(
                'vt_hide_review',
                [
                    'label' => esc_html__( 'Hide review', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_light_mode',
                [
                    'label' => esc_html__( 'Enable light text mode', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

          $this->add_control(
                'vt_hide_line',
                [
                    'label' => esc_html__( 'Hide row line', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 
            $this->add_control(
                'vt_hide_col_line',
                [
                    'label' => esc_html__( 'Hide columns line', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
        ); 
            
          $this->add_control(
          'liline_color',
          [
            'label' => __( 'Line color', 'typecase' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .vt_lisep:after, {{WRAPPER}} .vt_risep:before' => 'border-color: {{VALUE}} !important'        
            ]
          ]
        );

          $this->add_control(
          'liline_color_dark',
          [
            'label' => __( 'Line color dark mode', 'typecase' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '.options_dark_skin {{WRAPPER}} .vt_lisep:after, .options_dark_skin {{WRAPPER}} .vt_risep:before' => 'border-color: {{VALUE}} !important'        
            ]
          ]
        );

        $this->end_controls_section();
    }

protected function render( ) { 
  $settings = $this->get_settings();

      if ( function_exists( 'typecase_feature_layout_2' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();      
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }
      echo \typecase_feature_layout_19( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'typecase' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }
   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }
}