<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class typecase_section_gallery extends Widget_Base {

    public function get_name() {
        return 'typecase-gallery';
    }

    public function get_title() {
        return esc_html__( 'Gallery', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-elementor-circle vt-icons';
    }    

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            '_section_gallery',
            [
                'label' => esc_html__( 'Gallery', 'typecase' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );        

        $this->add_control(
            'gallery',
            [
                'type' => Controls_Manager::GALLERY,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        $this->add_control(
            'vt_btn_url',
            [
                'label' =>esc_html__( 'Custom URL', 'typecase' ),
                'type' => Controls_Manager::URL,                
            ]
        );
        $this->add_control(
      'overlay_txt', [
        'label'       => esc_html__( 'Title Overlay', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => 'Instagram',        
      ]
      );
        $this->add_control(
                    'info_image',
                    [
                        'type' => Controls_Manager::RAW_HTML,
                        'separator'    => 'before',
                        'raw' => '<b>Thumbnail Image Size</b>',
                    ]
                );
        
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',                
                'exclude' => [
                    'custom'
                ]
            ]
        );    

        $this->add_responsive_control(
                'item_space',
                [
                    'label' => esc_html__( 'Columns', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'separator'    => 'before',
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 12,
                            'step' => 1,
                        ]                        
                    ],                    
                    'default' => [
                        'size' => 6,
                        'unit' => 'px',
                    ],
                    'tablet_default' => [
                        'size' => 6,
                        'unit' => 'px',
                    ],
                    'mobile_default' => [
                        'size' => 2,
                        'unit' => 'px',
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .vt_gal_wrapper' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr))',
                    ],
                ]
            );

            $this->add_responsive_control(
                'item_column_gap',
                [
                    'label' => esc_html__( 'Column Gap', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 200,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 5,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .vt_gal_wrapper' => 'grid-column-gap: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'item_row_gap',
                [
                    'label' => esc_html__( 'Row Gap', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 200,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 5,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .vt_gal_wrapper' => 'grid-row-gap: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'vt_border_radius',
                [
                    'label' => esc_html__( 'Image Border Radius', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 200,
                            'step' => 1,
                        ]                        
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .vt_gal_wrapper .vt_gal_item a' => 'border-radius: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );    
            $this->add_control(
                'vt_hide_txt',
                [
                    'label' => esc_html__( 'Hide text overlay', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,                                        
                    'selectors' => [
                        '{{WRAPPER}} .vt_gal_link_wrap .vtc_gal_txt' => 'display:none;',
                    ],
                ]
    );        

        $this->end_controls_section();        
    }
    protected function render( ) {
        $settings = $this->get_settings_for_display();

        if ( empty( $settings['gallery'] ) ) {
            return;
        }
        if ( ! empty( $settings['vt_btn_url']['url'] ) ) {
            $this->add_link_attributes( 'button', $settings['vt_btn_url'] );
        }
        echo '<div class="vt_gal_link_wrap">';
        if ( ! empty( $settings['vt_btn_url']['url'] ) ) {?>
            <a <?php echo $this->get_render_attribute_string( 'button' ); ?> class="vtc_gal_txt">
            <i class="vti-instagram"></i>
            <?php echo $settings['overlay_txt'];?>
            </a>
        <?php }
        echo '<div class="vt_gal_wrapper">';        
        foreach ( $settings['gallery'] as $image ) {            
            ?>            
            <div class="vt_gal_item">
                <a <?php echo $this->get_render_attribute_string( 'button' ); ?> class="vt_gal_img">
                <?php echo wp_get_attachment_image( $image['id'], $settings['thumbnail_size'], false, [ 'class' => 'vt_img_gal' ] ); ?>
                </a>            
            </div>
            <?php
        }        
        echo '</div>';        
        echo '</div>';
    }
}