<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_grid_post extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-grid-post';
    }

    public function get_title() {
        return esc_html__( 'Grid Post', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'typecase'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'typecase'),
              'description' => esc_html__( 'Choose post type to display posts', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'typecase'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'typecase' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'typecase' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'typecase'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'typecase' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'typecase'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'typecase'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
               

        $this->add_control(
      'posts_per_page',
      array(
        'label'       => esc_html__( 'Posts per Page', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6'
      )
    );

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'typecase' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'typecase' ),
                        'gallery'        => esc_html__( 'Gallery', 'typecase' ),
                        'video'        => esc_html__( 'Video', 'typecase' ),
                        'audio'        => esc_html__( 'Audio', 'typecase' ),
                        'quote'        => esc_html__( 'Quote', 'typecase' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );      

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );
      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'typecase' ),                        
                  'rand'      =>esc_html__( 'Random', 'typecase' ),
                  'update'      =>esc_html__( 'Latest updated', 'typecase' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'typecase' ),
                  'author'      =>esc_html__( 'Author', 'typecase' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'typecase' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'typecase' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'typecase' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'typecase' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'typecase' ),
              ],
            ]
        );          
      $this->add_control(
      'tabs_link',
      array(
        'label'       => esc_html__( 'Tab Link', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'default'   => 'none',
        'options'   => [
                        'none'     => esc_html__( 'None', 'typecase' ),
                        'category' => esc_html__( 'Categories', 'typecase' ),
                        'tag'      => esc_html__( 'Tags', 'typecase' ),                        
        ],
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );
    $this->add_control(
      'tabs_link_ids',
      array(
        'label'       => esc_html__( 'Filter ID', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__( 'Add ID of category or tag (Example: 1,2,3)', 'typecase' ),
        'default'     => '',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );
    $this->add_control(
      'tabs_link_label',
      array(
        'label'       => esc_html__( 'Tab Label', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__( 'All', 'typecase' ),
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );      
      $this->add_control(
      'pagination',
      array(
        'label'       => esc_html__( 'Pagination', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'None', 'typecase' ),
                        'next_prev'       => esc_html__( 'Arrow', 'typecase' ),
                        'loadmore'        => esc_html__( 'Load More', 'typecase' ),
                        'autoload'        => esc_html__( 'Auto Load', 'typecase' ),
                    ],
        'default'     => '0',
      )
    );      
        $this->end_controls_section();     

    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );  

        $this->add_control(
          'vt_cus_img',
          [
              'label'     =>esc_html__( 'Image size', 'typecase' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => '',
              'options'   => [
                      ''      =>esc_html__( 'Default image size', 'typecase' ),      
                      'typecase_large'      =>esc_html__( '1600 x 0', 'typecase' ),
                      'typecase_medium'      =>esc_html__( '1100 x 0', 'typecase' ),
                      'typecase_small'      =>esc_html__( '150 x 150', 'typecase' ),
                      'typecase_layouts'      =>esc_html__( '680 x 580', 'typecase' ),
                      'typecase_list'      =>esc_html__( '600 x 0', 'typecase' ),
                  ],
          ]
      ); 
      
        $this->add_responsive_control(
        'vt_item_img_height',
        [
            'label' => __( 'Image height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 160,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cgrid_wrap .vt_imgw' => 'padding-bottom: {{SIZE}}% !important;',
            ],
        ]
      );
      $this->add_responsive_control(
        'vt_item_img_margin',
        [
            'label' => __( 'Image margin', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 160,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cgrid_layout .vt_imgw' => 'margin-bottom: {{SIZE}}% !important;',
            ],
        ]
      );
    $this->add_responsive_control(
        'vt_item_cols',
        [
            'label' => __( 'Number of columns', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 2,
            ],
            'tablet_default' => [
              'size' => 2,
            ],
            'mobile_default' => [
              'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cgrid_wrap' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr)) !important;',            
            ],
        ]
      );

        $this->add_responsive_control(
        'vt_item_cols_space',
        [
            'label' => __( 'Columns space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 30,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cgrid_wrap' => '--vtcols-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

        $this->add_responsive_control(
        'vt_item_row_space',
        [
            'label' => __( 'Row space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 30,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cgrid_wrap' => '--vtrow-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'slfont_size',
        [
            'label' => __( 'Title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cgrid_layout .vt_fe_title' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );      

      $this->add_responsive_control(
        'vt_item_img_radius',
        [
            'label' => __( 'Image broder radius', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_cgrid_wrap .vt_img_holder .vt_imgw.vt_radus_e' => 'border-radius: {{SIZE}}px !important;',
            ],
        ]
      );

      $this->add_responsive_control(
        'vt_vid_msize',
        [
            'label' => __( 'Video size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .overlay-media iframe' => 'width: {{SIZE}}% !important;',
            ],
        ]
      );

      $this->add_control(
        'vt_en_bg',
        [
            'label' => esc_html__( 'Enable background text style', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,  
            'selectors' => [
              '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text' => 'position: relative; margin-left: auto; margin-right: auto;',
          ],          
        ]
    );
    
    $this->add_responsive_control(
      'captions_padding_space',
      [
          'label'      => __( 'Padding caption', 'typecase' ),
          'type'       => Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px', '%'],
          'default'    => [
              'top'      => '25',
              'right'    => '20',
              'bottom'   => '0',
              'left'     => '20',
              'unit'     => 'px',
              'isLinked' => false
          ],
          'selectors'  => [
              '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
          ],
          'condition' => [
              'vt_en_bg!'    => ''
          ]
      ]
    );

    $this->add_responsive_control(
      'caption_offset_top',
      [
          'label' => __( 'Caption offset top space', 'typecase' ),
          'type' => Controls_Manager::SLIDER,
          'default' => [
            'size' => -60,
        ],
          'range' => [
              'px' => [
                  'min' => -300,
                  'max' => 500,
                  'step' => 1,
              ]
          ],
          'selectors' => [            
          '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text' => 'margin-top: {{SIZE}}px !important;',
          ],
          'condition' => [
              'vt_en_bg!'    => ''
          ]
      ]
    );

    $this->add_responsive_control(
      'caption_offset_h',
      [
          'label' => __( 'Caption offset left/right', 'typecase' ),
          'type' => Controls_Manager::SLIDER,                        
          'default' => [
            'size' => 40,
        ],
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 500,
                  'step' => 1,
              ]
          ],
          'selectors' => [            
          '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text' => 'max-width: calc(100% - {{SIZE}}px) !important;',
          ],
          'condition' => [
              'vt_en_bg!'    => ''
          ]
      ]
    );

    $this->add_control(
      'titlebg',
      [
        'label' => __( 'Title bg color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
            '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'vt_en_bg!'    => ''
        ]
      ]
    );

    $this->add_control(
      'titlebg_dark',
      [
        'label' => __( 'Title bg color dark mode', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#101010',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_text' => 'background: {{VALUE}}',            
        ],
        'condition' => [
          'vt_en_bg!'    => ''
        ]
      ]
    );

    $this->add_control(
      'sl_cap_color',
      [
        'label' => __( 'Caption color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .vt_cgrid_layout .vt_fe_title' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text a' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text .vt_fe_title:hover a' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .vt_cgrid_layout .vt_post_meta span' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .vt_cgrid_layout .vt_post_meta a' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .vt_cgrid_layout .vt_post_meta a:hover' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .vt_cgrid_layout .vt_fe_des' => 'color: {{VALUE}} !important'
        ]
      ]
    );

      $this->add_control(
      'sl_cap_color_dark',
      [
        'label' => __( 'Caption dark mode color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_title' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_text a' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_text .vt_fe_title:hover a' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_post_meta span' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_post_meta a' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_post_meta a:hover' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .vt_cgrid_layout .vt_fe_des' => 'color: {{VALUE}} !important'
        ]
      ]
    );
    
    $this->add_responsive_control(
        'g_pagination',
        [
            'label' => __( 'Pagination spacing', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => -150,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_el_nav_w' => 'margin-top: {{SIZE}}{{UNIT}};',            
            ],
        ]
    ); 

    $this->add_responsive_control(
        'g_pagination_radius',
        [
            'label' => __( 'Pagination broder radius', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_lmore_c' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
    );    

    $this->add_responsive_control(
            'vtc_align_text',
            array(
                'label'     => __( 'Text alignment', 'typecase' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => array(
                    'left'   => array(
                        'title' => __( 'Left', 'typecase' ),
                        'icon'  => 'eicon-text-align-left',
                    ),
                    'center' => array(
                        'title' => __( 'Center', 'typecase' ),
                        'icon'  => 'eicon-text-align-center',
                    ),
                    'right'  => array(
                        'title' => __( 'Right', 'typecase' ),
                        'icon'  => 'eicon-text-align-right',
                    ),
                ),
                'toggle'    => false,
                'selectors' => array(
                    '{{WRAPPER}} .vt_cgrid_layout .vt_fe_text' => '--vt-h-align: {{VALUE}} !important;',
                )                
            )
        );

    $this->add_responsive_control(
            'vtc_align',
            array(
                'label'     => __( 'Pagination alignment', 'typecase' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => array(
                    'left'   => array(
                        'title' => __( 'Left', 'typecase' ),
                        'icon'  => 'eicon-text-align-left',
                    ),
                    'center' => array(
                        'title' => __( 'Center', 'typecase' ),
                        'icon'  => 'eicon-text-align-center',
                    ),
                    'flex-end'  => array(
                        'title' => __( 'Right', 'typecase' ),
                        'icon'  => 'eicon-text-align-right',
                    ),
                ),
                'toggle'    => false,
                'selectors' => array(
                    '{{WRAPPER}} .vt_el_nav_w' => 'justify-content: {{VALUE}};',
                )                
            )
        );

    $this->add_control(
                'vt_hide_cat',
                [
                    'label' => esc_html__( 'Hide category', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_author',
                [
                    'label' => esc_html__( 'Hide author', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_date',
                [
                    'label' => esc_html__( 'Hide date', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

            $this->add_control(
                'vt_hide_meta',
                [
                    'label' => esc_html__( 'Hide author & date', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'vt_hide_desc',
                [
                    'label' => esc_html__( 'Hide description', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_review',
                [
                    'label' => esc_html__( 'Hide review', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'vt_hide_line',
                [
                    'label' => esc_html__( 'Hide row line', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            ); 
            $this->add_control(
                'vt_hide_col_line',
                [
                    'label' => esc_html__( 'Hide columns line', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
        ); 

          $this->add_control(
          'liline_color',
          [
            'label' => __( 'Line color', 'typecase' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .vt_cgrid_wrap' => '--vt-post-line-color: {{VALUE}} !important'        
            ]
          ]
        );

          $this->add_control(
          'liline_color_dark',
          [
            'label' => __( 'Line color dark mode', 'typecase' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '.options_dark_skin {{WRAPPER}} .vt_cgrid_wrap' => '--vt-post-line-color: {{VALUE}} !important'        
            ]
          ]
        );    

        $this->add_control(
          'category_tag_title',
          [
              'type' => Controls_Manager::RAW_HTML,
              'separator'    => 'before',
              'raw' => '<b>Tab filter</b>',
          ]
      );

      $this->add_responsive_control(
        'tab_filter_size',
        [
            'label' => __( 'Tab filter font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .vt_ajax_c' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
        ]
    );    

    $this->add_responsive_control(
      'tab_filter_space',
      [
          'label' => __( 'Tab filter space', 'typecase' ),
          'type' => Controls_Manager::SLIDER,            
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 200,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .vt_ajax_c' => 'gap: {{SIZE}}{{UNIT}};',
          ],
      ]
  );   
  
  $this->add_control(
    'tab_link_color',
    [
      'label' => __( 'Tab link color', 'typecase' ),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
          '{{WRAPPER}} .vt_ajax_c .ajax_nav_item a' => 'color: {{VALUE}} !important'        
      ]
    ]
  );

    $this->add_control(
    'tab_link_color_dark',
    [
      'label' => __( 'Tab link color dark mode', 'typecase' ),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
          '.options_dark_skin {{WRAPPER}} .vt_ajax_c .ajax_nav_item a' => 'color: {{VALUE}} !important'        
      ]
    ]
  );    

  $this->add_control(
    'tab_link_h_color',
    [
      'label' => __( 'Tab link hover color', 'typecase' ),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
          '{{WRAPPER}} .vt_ajax_c .ajax_nav_item a:hover' => 'color: {{VALUE}} !important'        
      ]
    ]
  );

    $this->add_control(
    'tab_link_h_color_dark',
    [
      'label' => __( 'Tab link hover color dark mode', 'typecase' ),
      'type' => Controls_Manager::COLOR,
      'selectors' => [
          '.options_dark_skin {{WRAPPER}} .vt_ajax_c .ajax_nav_item a:hover' => 'color: {{VALUE}} !important'        
      ]
    ]
  );    
    
    $this->add_control(
      'tab_top_right',
      [
          'label' => esc_html__( 'Tab filter top right', 'typecase' ),
          'type' => Controls_Manager::SWITCHER,
          'return_value' => 'yes',
          'default' => 'no',          
      ]
    );

    $this->add_responsive_control(
      'tab_filter_top',
      [
          'label' => __( 'Top position', 'typecase' ),
          'type' => Controls_Manager::SLIDER,            
          'default' => [
            'size' => -60,
            ],
          'range' => [
              'px' => [
                  'min' => -200,
                  'max' => 200,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .vt_ajax_w' => 'top: {{SIZE}}{{UNIT}}; position: absolute;',
          ],
          'condition' => [
            'tab_top_right'    => 'yes'
          ]
      ]
  );

    $this->add_responsive_control(
      'tab_filter_right',
      [
          'label' => __( 'Right position', 'typecase' ),
          'type' => Controls_Manager::SLIDER,            
          'default' => [
            'size' => 0,
            ],
          'range' => [
              'px' => [
                  'min' => -200,
                  'max' => 200,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .vt_ajax_w' => 'right: {{SIZE}}{{UNIT}};',
          ],
          'condition' => [
            'tab_top_right'    => 'yes'
          ]
      ]
  );
         
        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();
      if ( function_exists( 'typecase_mgrid' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();      
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }
      
      // if(isset($settings['author']) && is_array($settings['author']) ? $settings['author'] : []){
      //   $author = isset($settings['author']) && is_array($settings['author']) ? $settings['author'] : [];
      //   $settings['author'] = implode(',', $author);      
      // }else{
      //   $settings['author'] = $settings['author'];
      // }

      echo \typecase_mgrid( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'typecase' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }

   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'typecase' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }

}