<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class typecase_section_infobox extends Widget_Base {

    public function get_name() {
        return 'typecase-infobox';
    }

    public function get_title() {
        return esc_html__( 'Vision Info Box', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-icon-box vt-icons';
    }    

    public function get_style_depends() {
       return [ 'vt-infobox' ];
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {
    
    $vt_primary_color = get_option( 'vt_primary_color_option', '#000' );
        
        /*
        * Infobox Image
        */
        $this->start_controls_section(
            'vt_section_infobox_content',
            [
                'label' => esc_html__( 'Content', 'typecase' )
            ]
        );

        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'vt_infobox_img_or_icon',
            [
                'label'         => esc_html__( 'Image or Icon', 'typecase' ),
                'type'          => Controls_Manager::CHOOSE,
                'toggle'        => false,
                'label_block'   => true,
                'default'       => 'icon',
                'options'       => [
                    'none'      => [
                        'title' => esc_html__( 'None', 'typecase' ),
                        'icon'  => 'eicon-ban'
                    ],
                    'icon'      => [
                        'title' => esc_html__( 'Icon', 'typecase' ),
                        'icon'  => 'eicon-info-circle'
                    ],
                    'img'       => [
                        'title' => esc_html__( 'Image', 'typecase' ),
                        'icon'  => 'eicon-image-bold'
                    ]
                ]
            ]
        );
        
        $repeater->add_control(
            'vt_infobox_image',
            [
                'label'     => esc_html__( 'Image', 'typecase' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => Utils::get_placeholder_image_src()
                ],                
                'condition' => [
                    'vt_infobox_img_or_icon' => 'img'
                ]
            ]
        );
        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail',
                'default'   => 'medium_large',
                'condition' => [
                    'vt_infobox_img_or_icon' => 'img'
                ]
            ]
        );

        $repeater->add_control(
            'vt_infobox_icon',
            [
                'label'       => esc_html__( 'Icon', 'typecase' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-tag',
                    'library' => 'fa-solid'
                ],
                'condition'   => [
                    'vt_infobox_img_or_icon' => 'icon'
                ]
            ]
        );

        
        $repeater->add_control(
            'vt_infobox_title',
            [
                'label'       => esc_html__( 'Title', 'typecase' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Infobox Title', 'typecase' )                
            ]
        );

        $repeater->add_control(
            'vt_infobox_title_link',
            [
                'label'       => __( 'Link URL', 'typecase' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'typecase' ),
                'label_block' => true
            ]
        );

        $repeater->add_control(
            'vtc_info_button',
            array(
                'label'       => __( 'Button Text', 'typecase' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,                
            )
        );
        
        $repeater->add_control(
            'vt_infobox_description',
            [
                'label'   => esc_html__( 'Description', 'typecase' ),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'We work intimately with customers from around the world with quality', 'typecase' )                
            ]
        );

        $this->add_control(
                'infobox_items',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        ['vt_infobox_title' => 'Data Analytics'],
                        ['vt_infobox_title' => 'Perfect Fund'],
                        ['vt_infobox_title' => 'Quality Design'],
                        ['vt_infobox_title' => 'Training Course']                        
                    ],
                    'title_field' => '{{{ vt_infobox_title }}}',
                ]
            );     

        $this->end_controls_section();

        $this->start_controls_section( 'icon_svg_animate_section', [
            'label'     => esc_html__( 'Icon SVG Animate Stroke', 'typecase' ),
            'condition'   => [
                    'vt_infobox_anim' => 'true'
                ]
        ] );

        $this->add_control( 'icon_svg_animate', [
            'label' => esc_html__( 'SVG Animate', 'typecase' ),
            'type'  => Controls_Manager::SWITCHER,
        ] );

        $this->add_control( 'icon_svg_animate_play_on_hover', [
            'label' => esc_html__( 'Play on hover', 'typecase' ),
            'type'  => Controls_Manager::SWITCHER,
        ] );

        $this->add_control( 'icon_svg_animate_type', [
            'label'   => esc_html__( 'Type', 'typecase' ),
            'type'    => Controls_Manager::SELECT,
            'options' => [
                'delayed'  => esc_html__( 'Delayed', 'typecase' ),
                'sync'     => esc_html__( 'Sync', 'typecase' ),
                'oneByOne' => esc_html__( 'One By One', 'typecase' ),
            ],
            'default' => 'delayed',
        ] );

        $this->add_control( 'icon_svg_animate_duration', [
            'label'   => esc_html__( 'Transition Duration', 'typecase' ),
            'type'    => Controls_Manager::NUMBER,
            'default' => 120,
        ] );

        $this->end_controls_section();
        

        /*
        * Infobox Styling Section
        */
        $this->start_controls_section(
            'vt_section_infobox_styles_preset',
            [
                'label' => esc_html__( 'Container', 'typecase' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        
        $this->add_responsive_control(
                'item_num_col',
                [
                    'label' => esc_html__( 'Columns', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 12,
                            'step' => 1,
                        ]                        
                    ],                    
                    'default' => [
                        'size' => 4,
                        'unit' => 'px',
                    ],
                    'tablet_default' => [
                        'size' => 2,
                        'unit' => 'px',
                    ],
                    'mobile_default' => [
                        'size' => 1,
                        'unit' => 'px',
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .vt-infobox-wrapp' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr))',
                    ],
                ]
            );

            $this->add_responsive_control(
                'item_column_gap',
                [
                    'label' => esc_html__( 'Column Gap', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 200,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .vt-infobox-wrapp' => 'grid-column-gap: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'item_row_gap',
                [
                    'label' => esc_html__( 'Row Gap', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 200,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .vt-infobox-wrapp' => 'grid-row-gap: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
            'vt_infobox_container_min_height',
            [
                'label'       => esc_html__( 'Min Height', 'typecase' ),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px'      => [
                        'max' => 100
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],                    
                'selectors'   => [
                    '{{WRAPPER}} .vt-infobox .vt-infobox-item' => 'min-height: {{SIZE}}%;',
                ],
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_alignment',
            [
                'label'   => __( 'Alignment', 'typecase' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [
                    'vt-infobox-align-left'   => [
                        'title' => __( 'Left', 'typecase' ),
                        'icon'  => 'eicon-text-align-left'
                    ],
                    'vt-infobox-align-center' => [
                        'title' => __( 'Center', 'typecase' ),
                        'icon'  => 'eicon-text-align-center'
                    ],
                    'vt-infobox-align-right'  => [
                        'title' => __( 'Right', 'typecase' ),
                        'icon'  => 'eicon-text-align-right'
                    ]
                ],
                'default' => 'vt-infobox-align-center'
            ]
        );
        
        $this->add_responsive_control(
            'vt_infobox_padding',
            [
                'label'      => esc_html__( 'Padding', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],                
                'selectors'  => [
                    '{{WRAPPER}} .vt-infobox-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],                
                'selectors'  => [
                    '{{WRAPPER}} .vt-infobox-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'vt_infobox_container_tabs' );

            $this->start_controls_tab( 'vt_infobox_container_normal', [ 'label' => esc_html__( 'Normal', 'typecase' ) ] );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'vt_infobox_background_normal',
                        'types'     => [ 'classic', 'gradient' ],
                        'selector'  => '{{WRAPPER}} .vt-infobox .vt-infobox-item',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'vt_infobox_border_normal',
                        'selector' => '{{WRAPPER}} .vt-infobox-item'
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'     => 'vt_infobox_box_shadow_normal',
                        'selector' => '{{WRAPPER}} .vt-infobox-item'
                    ]
                );

            $this->end_controls_tab();
            $this->start_controls_tab( 'vt_infobox_container_hover', [ 'label' => esc_html__( 'Hover', 'typecase' ) ] );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'vt_infobox_background_hover',
                        'types'     => [ 'classic', 'gradient' ],
                        'separator' => 'before',
                        'selector'  => '{{WRAPPER}} .vt-infobox .vt-infobox-item:before',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'vt_infobox_border_hover',
                        'selector' => '{{WRAPPER}} .vt-infobox-item:hover'
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'     => 'vt_infobox_box_shadow_hover',
                        'selector' => '{{WRAPPER}} .vt-infobox-item:hover'
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        
        $this->end_controls_section();

        // transition style

        $this->start_controls_section(
            'section_infobox_transition_style',
            [
                'label' => __('Transition', 'typecase'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'vt_infobox_transition_top',
            [
                'label'        => __( 'Transition Top', 'typecase' ),
                'type'         =>  Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'typecase' ),
                'label_off'    => __( 'Hide', 'typecase' ),
                'return_value' => 'yes',
                'default'      => 'yes'
            ]
        );        

        $this->end_controls_section();

        //icon style
        $this->start_controls_section(
            'section_infobox_icon',
            [
                'label' => __('Icon/Image', 'typecase'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'vt_infobox_icon_position',
            [
                'label'   => __( 'Position', 'typecase' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [
                    'vt-infobox-icon-position-left'   => [
                        'title' => __( 'Left', 'typecase' ),
                        'icon'  => 'eicon-arrow-left'
                    ],
                    'vt-infobox-icon-position-center' => [
                        'title' => __( 'Top', 'typecase' ),
                        'icon'  => 'eicon-arrow-up'
                    ],
                    'vt-infobox-icon-position-right'  => [
                        'title' => __( 'Right', 'typecase' ),
                        'icon'  => 'eicon-arrow-right'
                    ]
                ],
                'default' => 'vt-infobox-icon-position-center'
            ]
        );

        $this->add_control(
            'vertical_align',
            array(
              'label'       => esc_html__( 'Vertical align', 'typecase' ),
              'type'        => Controls_Manager::SELECT,
              'options'   => [
                              'flex-start'               => esc_html__( 'Top', 'typecase' ),
                              'center'        => esc_html__( 'Middle', 'typecase' ),
                              'flex-end'        => esc_html__( 'Bottom', 'typecase' )                              
                          ],
              'default'     => 'flex-start',
              'condition' => [
                'vt_infobox_icon_position'    => ['vt-infobox-icon-position-left','vt-infobox-icon-position-right']
              ],
              'selectors'   => [
                '{{WRAPPER}} .vt-infobox-icon-position-left, {{WRAPPER}} .vt-infobox-icon-position-right' => 'align-items: {{VALUE}}'
            ]
            )
          );    

          $this->add_responsive_control(
            'vt_infobox_align_list',
            [
                'label'   => __( 'List box position', 'typecase' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [                    
                    'column' => [
                        'title' => __( 'Block', 'typecase' ),
                        'icon'  => 'eicon-arrow-up'
                    ],
                    'row'  => [
                        'title' => __( 'Inline', 'typecase' ),
                        'icon'  => 'eicon-arrow-right'
                    ]
                ],
                'condition' => [
                    'vt_infobox_icon_position'    => ['vt-infobox-icon-position-left','vt-infobox-icon-position-right']
                ],
                'selectors'   => [
                    '{{WRAPPER}} .vt-infobox-icon-position-left, {{WRAPPER}} .vt-infobox-icon-position-right' => 'flex-direction: {{VALUE}}',                    
                ]
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_list_alignment',
            [
                'label'   => __( 'Alignment', 'typecase' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [
                    'left'   => [
                        'title' => __( 'Left', 'typecase' ),
                        'icon'  => 'eicon-text-align-left'
                    ],
                    'center' => [
                        'title' => __( 'Center', 'typecase' ),
                        'icon'  => 'eicon-text-align-center'
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'typecase' ),
                        'icon'  => 'eicon-text-align-right'
                    ]
                ],
                'default' => 'center',
                'selectors'   => [
                    '{{WRAPPER}} .vt-infobox .vt-infobox-item .vt-infobox-content' => 'text-align: {{VALUE}};'
                ],
                'condition' => [
                    'vt_infobox_align_list'    => ['column']
                ]
            ]
        );

        $this->add_control(
            'vt_infobox_enable_box',
            [
                'label'        => __( 'Enable Box', 'typecase' ),
                'type'         =>  Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'typecase' ),
                'label_off'    => __( 'Hide', 'typecase' ),
                'return_value' => 'yes',
                'default'      => 'yes'
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_icon_height',
            [
                'label'       => esc_html__( 'Height', 'typecase' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 80
                ],
                'range'       => [
                    'px'      => [
                        'max' => 250
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon' => 'height: {{SIZE}}px;'
                ],
                'condition' => [
                    'vt_infobox_enable_box' => 'yes' 
                ]
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_icon_width',
            [
                'label'       => esc_html__( 'Width', 'typecase' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 80
                ],
                'range'       => [
                    'px'      => [
                        'max' => 250
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon' => 'width: {{SIZE}}px;',
                    '{{WRAPPER}} .vt-infobox-icon-position-left .vt-infobox-content' => 'flex-basis: calc( 100% - {{SIZE}}px );',
                    '{{WRAPPER}} .vt-infobox-icon-position-right .vt-infobox-content' => 'flex-basis: calc( 100% - {{SIZE}}px );'
                ],
                'condition' => [
                    'vt_infobox_enable_box' => 'yes' 
                ]
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_icon_font_size',
            [
                'label'       => esc_html__( 'Icon Size', 'typecase' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 35
                ],
                'range'       => [
                    'px'      => [
                        'max' => 250
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon i'   => 'font-size: {{SIZE}}px;',
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon svg' => 'height: {{SIZE}}px; width: auto;'
                ]                
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_icon_image_size',
            [
                'label'       => esc_html__( 'Image Size', 'typecase' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 40
                ],
                'range'       => [
                    'px'      => [
                        'max' => 400
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon img' => 'height: {{SIZE}}px; width: auto !important;'
                ],                
            ]
        );

        $this->add_responsive_control(
            'vt_infobox_icon_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],                
                'selectors'  => [
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'vt_infobox_icon_box_shadow',
                'selector' => '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon'
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'vt_infobox_image_css_filter',
                'selector' => '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon img',                
            ]
        );        

        $this->add_responsive_control(
            'vt_infobox_icons_margin',
            [
                'label'      => __( 'Spacing icons', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],
                'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '10',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'vt_infobox_icon_tabs' );
            // Normal State Tab
            $this->start_controls_tab( 'vt_infobox_icon_normal', [ 'label' => esc_html__( 'Normal', 'typecase' ) ] );

                $this->add_control(
                    'vt_infobox_icon_background_color_normal',
                    [
                        'label'     => esc_html__( 'Background', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#000',
                        'default'   => $vt_primary_color,
                        'selectors' => [
                            '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon' => 'background: {{VALUE}}'
                        ]
                    ]
                );

                $this->add_control(
                    'vt_infobox_icon_color_normal',
                    [
                        'label'     => esc_html__( 'Icon Color', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon i' => 'color: {{VALUE}}',                            
                        ],                        
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'vt_infobox_icon_border_normal',
                        'selector' => '{{WRAPPER}} .vt-infobox-item .vt-infobox-icon'
                    ]
                );

            $this->end_controls_tab();

            // Hover State Tab
            $this->start_controls_tab( 'vt_infobox_icon_hover', [ 'label' => esc_html__( 'Hover', 'typecase' ) ] );

                $this->add_control(
                    'vt_infobox_icon_background_color_hover',
                    [
                        'label'     => esc_html__( 'Background', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .vt-infobox-item:hover .vt-infobox-icon' => 'background: {{VALUE}}'
                        ]
                    ]
                );

                $this->add_control(
                    'vt_infobox_icon_color_hover',
                    [
                        'label'     => esc_html__( 'Icon Color', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => $vt_primary_color,
                        'selectors' => [
                            '{{WRAPPER}} .vt-infobox-item:hover .vt-infobox-icon i' => 'color: {{VALUE}}',                            
                        ],                        
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'vt_infobox_icon_border_hover',
                        'selector' => '{{WRAPPER}} .vt-infobox-item:hover .vt-infobox-icon'
                    ]
                );
                
            $this->end_controls_tab();
        $this->end_controls_tabs();
        
        $this->end_controls_section();

        // Title , Description Font Color and Typography

        $this->start_controls_section(
            'section_infobox_title',
            [
                'label' => __('Title', 'typecase'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'infobox_title_typography',
                'selector' => '{{WRAPPER}} .vt-infobox-content-title',
                'fields_options'   => [
                    'font_size'    => [
                        'default'  => [
                            'unit' => 'px',
                            'size' => 30
                        ]
                    ],
                    'font_weight'  => [
                        'default'  => '600'
                    ]
                ]
            ]
        );
        
        $this->add_responsive_control(
            'vt_infobox_title_margin',
            [
                'label'      => __( 'Margin', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],
                'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '10',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .vt-infobox-content-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'vt_infobox_title_tabs' );

            $this->start_controls_tab( 'vt_infobox_title_normal', [ 'label' => esc_html__( 'Normal', 'typecase' ) ] );

                $this->add_control(
                    'vt_title_color_normal',
                    [
                        'label'     => __('Color', 'typecase'),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#000000',
                        'selectors' => [
                            '{{WRAPPER}} .vt-infobox-content-title' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
            $this->start_controls_tab( 'vt_infobox_title_hover', [ 'label' => esc_html__( 'Hover', 'typecase' ) ] );

                $this->add_control(
                    'vt_title_color_hover',
                    [
                        'label'     => esc_html__( 'Title Color', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                              '{{WRAPPER}} .vt-infobox-item:hover .vt-infobox-content-title' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        $this->end_controls_section();

        $this->start_controls_section(
            'section_infobox_description',
            [
                'label' => __('Description', 'typecase'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs( 'vt_infobox_desc_tabs' );

            $this->start_controls_tab( 'vt_infobox_desc_normal', [ 'label' => esc_html__( 'Normal', 'typecase' ) ] );

                $this->add_control(
                    'vt_desc_color_normal',
                    [
                        'label'     => __('Description Color', 'typecase'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .vt-infobox-content-description' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
            $this->start_controls_tab( 'vt_infobox_desc_hover', [ 'label' => esc_html__( 'Hover', 'typecase' ) ] );

                $this->add_control(
                    'vt_desc_color_hover',
                    [
                        'label'     => esc_html__( 'Description Color', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                              '{{WRAPPER}} .vt-infobox-item:hover .vt-infobox-content-description' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'vt_description_typography',
                'selector' => '{{WRAPPER}} .vt-infobox-content-description'
            ]
        );
        
        $this->add_responsive_control(
            'vt_infobox_description_margin',
            [
                'label'      => __( 'Margin', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vt-infobox-content-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();
        
        /*
        * Infobox Animating Mask
        */
        
        $this->start_controls_section(
            'vt_section_infobox_button',
            [
                'label'     => esc_html__( 'Button text', 'typecase' ),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
       $this->start_controls_tabs( 'vt_infobox_button_tabs' );

            $this->start_controls_tab( 'vt_infobox_button_normal', [ 'label' => esc_html__( 'Normal', 'typecase' ) ] );

                $this->add_control(
                    'vt_button_color_normal',
                    [
                        'label'     => __('Button Color', 'typecase'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .vt-infobox-btn' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
            $this->start_controls_tab( 'vt_infobox_button_hover', [ 'label' => esc_html__( 'Hover', 'typecase' ) ] );

                $this->add_control(
                    'vt_button_color_hover',
                    [
                        'label'     => esc_html__( 'Button Color', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                              '{{WRAPPER}} .vt-infobox-item:hover .vt-infobox-btn' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'vtbutton__typography',
                'selector' => '{{WRAPPER}} .vt-infobox-btn'
            ]
        );
        
        $this->add_responsive_control(
            'vt_infoboxbutton__margin',
            [
                'label'      => __( 'Margin', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vt-infobox-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();

    }
    protected function render( ) {
       
       $settings                  = $this->get_settings_for_display();      
       $infobox_items    = $this->get_settings_for_display('infobox_items');

        if ( ! empty( $settings['icon_svg_animate'] ) && 'yes' === $settings['icon_svg_animate'] ) {
            $vivus_settings = [
                'enable'        => $settings['icon_svg_animate'],
                'type'          => $settings['icon_svg_animate_type'],
                'duration'      => $settings['icon_svg_animate_duration'],
                'play_on_hover' => $settings['icon_svg_animate_play_on_hover'],
            ];
            $this->add_render_attribute( 'animation_wrap', 'data-vivus', wp_json_encode( $vivus_settings ) );
        }

        $this->add_render_attribute( 'vt_infobox_transition',[
            'class' => [
                'vt-infobox-item', 
                esc_attr( $settings['vt_infobox_alignment'] ), 
                esc_attr( $settings['vt_infobox_icon_position'] ),
                'vt-infobox-enable-box-'.esc_attr( $settings['vt_infobox_enable_box'] )
            ]
        ]);

        if( 'yes' === $settings['vt_infobox_transition_top'] ){
            $this->add_render_attribute( 'vt_infobox_transition', 'class', 'simple-transition' );
        }                
        ?>
        <div class="vt-infobox-wrapp">
        <?php
        foreach ( $infobox_items as $index => $list ):
        $icons_svg = isset( $list['vt_infobox_icon']['library'] ) && 'svg' === $list['vt_infobox_icon']['library'] ? true : false;    
        $title = $list['vt_infobox_title'];
        $details = $list['vt_infobox_description'];
        $vtc_info_button = $list['vtc_info_button'];        
        ?>        
        <div class="vt-infobox">
            <div <?php echo $this->get_render_attribute_string( 'vt_infobox_transition' );?> <?php echo $this->get_render_attribute_string( 'animation_wrap' );?>>
                <?php if( 'none' !== $list['vt_infobox_img_or_icon'] ) { ?>
                    <div class="vt-infobox-icon<?php if($icons_svg){echo ' vt-svg-icon';} ?>">
                        <?php if( 'icon' === $list['vt_infobox_img_or_icon'] && $list['vt_infobox_icon']['value'] ) : ?>
                            <?php Icons_Manager::render_icon( $list['vt_infobox_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php endif; ?>

                        <?php if( 'img' === $list['vt_infobox_img_or_icon'] ) :
                            echo Group_Control_Image_Size::get_attachment_image_html( $list, 'thumbnail', 'vt_infobox_image' );
                        endif; ?>   
                    </div>
                <?php } ?>
                <div class="vt-infobox-content">                    
                    <?php $title ? printf( '<h3 class="vt-infobox-content-title">%s</h3>', $title ) : ''; ?>
                    <?php $details ? printf( '<div class="vt-infobox-content-description">%s</div>', wp_kses_post( $details ) ) : ''; ?>
                    <?php $vtc_info_button ? printf( '<div class="vt-infobox-btn"><span>%s</span></div>', $vtc_info_button ) : ''; ?>
                </div>
                <?php 
                $link_key = 'link_' . $index;
                $vt_infobox_title_link = $list['vt_infobox_title_link']['url'];
                if( $vt_infobox_title_link ) {
                        $this->add_render_attribute( $link_key, 'href', esc_url( $vt_infobox_title_link ) );
                        if( $list['vt_infobox_title_link']['is_external'] ) {
                        $this->add_render_attribute( $link_key, 'target', '_blank' );
                        }
                        if( $list['vt_infobox_title_link']['nofollow'] ) {
                        $this->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                ?>
                <a class="vt_info_link" <?php echo $this->get_render_attribute_string( $link_key ) ;?>></a>
                <?php } ?>
            </div>            
        </div>
        <?php endforeach; ?>        
        </div>
        <?php        
    }
}