<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class typecase_marquee_text extends Widget_Base {

    public function get_name() {
        return 'typecase-marquee-text';
    }

    public function get_title() {
        return esc_html__( 'Marquee Text', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }    

    protected function register_controls() {
     
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'typecase'),
            ]
        );        

        $this->add_control(
            'vt_label_title', [
              'label'       => esc_html__( 'Label title', 'typecase' ),
              'default'   => 'Top News',
              'type'        => Controls_Manager::TEXT,
              'label_block'   => true
            ]
            );  
            
            $this->add_control(
                'post_type',
                [
                    'label' =>esc_html__('Post types', 'typecase'),
                    'description' => esc_html__( 'Choose post type to display posts', 'typecase' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'post',            
                     'options'   => $this->post_get_type(),             
                ]
            ); 
      
            $this->add_control(
              'post_type_tax',
              [
                  'label' =>esc_html__('Post taxonomy', 'typecase'),
                  'description' => esc_html__( 'Choose post type (category or tag)', 'typecase' ),
                  'type'      => Controls_Manager::SELECT,
                  'default'   => 'none',          
                   'options'   => $this->post_get_taxs(),
                   'condition' => [
                     'post_type!'    => ['post']
                   ]  
                              
              ]
          ); 
      
          $this->add_control(
            'term_slugs', [
              'label'       => esc_html__( 'Term Slug', 'typecase' ),
              'description' => esc_html__( 'Example: slug1,slug2,slug3', 'typecase' ),
              'type'        => Controls_Manager::TEXT,
              'label_block'   => true,
              'condition' => [
                'post_type!'    => ['post']
              ]  
            ]
            );
              
              $this->add_control(
                  'categories',
                  [
                      'label' =>esc_html__('Select Categories', 'typecase'),
                      'type'      => Controls_Manager::SELECT2,
                       'options'   => $this->post_categories(),
                      'label_block' => true,
                      'multiple'  => true,
                      'condition' => [
                        'post_type'    => ['post']
                      ]  
                  ]
              ); 
               
      
              $this->add_control(
            'tags', [
              'label'       => esc_html__( 'Tag Slug', 'typecase' ),
              'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'typecase' ),
              'type'        => Controls_Manager::TEXT,
              'label_block'   => true,
              'condition' => [
                'post_type'    => ['post']
              ]  
            ]
            );  
      
              $this->add_control(
                  'author',
                  [
                      'label' =>esc_html__('Author Filter', 'typecase'),
                      'type'      => Controls_Manager::SELECT,
                      'default'   => 'none',
                       'options'   => $this->post_author(),
                       'condition' => [
                         'post_type'    => ['post']
                       ]  
                  ]
              ); 
              
            //   $this->add_control(
            //     'author',
            //     [
            //         'label' =>esc_html__('Select Author', 'typecase'),
            //         'type'      => Controls_Manager::SELECT2,
            //          'options'   => $this->post_author(),
            //         'label_block' => true,
            //         'multiple'  => true,
            //     ]
            // ); 
                     
      
              $this->add_control(
            'posts_per_page',
            array(
              'label'       => esc_html__( 'Posts per Page', 'typecase' ),
              'type'        => Controls_Manager::NUMBER,
              'default'     => '6'
            )
          );
      
              $this->add_control(
            'offset',
            array(
              'label'       => esc_html__( 'Post Offset', 'typecase' ),
              'type'        => Controls_Manager::NUMBER,
              'default'     => '',
            )
          );
          
      
          $this->add_control(
            'format',
            array(
              'label'       => esc_html__( 'Post Format', 'typecase' ),
              'type'        => Controls_Manager::SELECT,
              'options'   => [
                              '0'               => esc_html__( 'All', 'typecase' ),
                              'gallery'        => esc_html__( 'Gallery', 'typecase' ),
                              'video'        => esc_html__( 'Video', 'typecase' ),
                              'audio'        => esc_html__( 'Audio', 'typecase' ),
                              'quote'        => esc_html__( 'Quote', 'typecase' ),
                          ],
              'default'     => '0',
              'condition' => [
                'post_type'    => ['post']
              ]  
            )
          );     

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'typecase' ),
          'description' => esc_html__( 'Example: 1,2,3', 'typecase' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                    'date_post'      =>esc_html__( 'Latest post', 'typecase' ),                        
                    'rand'      =>esc_html__( 'Random', 'typecase' ),
                    'update'      =>esc_html__( 'Latest updated', 'typecase' ),
                    'comment_count'      =>esc_html__( 'Popular comment', 'typecase' ),
                    'author'      =>esc_html__( 'Author', 'typecase' ),
                    'popular_most'      =>esc_html__( 'Popular views', 'typecase' ),
                    'popular_by_month'      =>esc_html__( 'Popular views by month', 'typecase' ),
                    'popular_by_week'      =>esc_html__( 'Popular views by week', 'typecase' ),
                    'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'typecase' ),
                    'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'typecase' ),
                ],
            ]
        );          

      $this->add_control(
      'pagination',
      array(
        'label'       => esc_html__( 'Pagination', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'None', 'typecase' ),
                        'next_prev'       => esc_html__( 'Next Prev', 'typecase' ),
                        'loadmore'        => esc_html__( 'Load More', 'typecase' ),
                        'autoload'        => esc_html__( 'Auto Load', 'typecase' ),
                    ],
        'default'     => '0',
      )
    );      
    
    $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_style', [
              'label'  => esc_html__( 'Title Style', 'typecase' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
              ); 

        $this->add_control(
            'vt_section_list_layout',
            [
                'label' => __( 'Text Scroll', 'typecase' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout_left',
                'options' => [
                    'layout_left' => __( 'Scroll To Left', 'typecase' ),
                    'layout_right' => __( 'Scroll To Right', 'typecase' )                    
                ],
            ]
        );   

        $this->add_control(
            'vt_push_hover',
            [
                'label' => esc_html__('Push On Hover', 'typecase'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'push_on' =>esc_html__( 'Yes', 'typecase' ),
                'push_off' =>esc_html__( 'No', 'typecase' ),
            ]
        ); 

        $this->add_responsive_control(
                'vt_item_speed',
                [
                    'label' => esc_html__( 'Marquee Speed', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'default' => [
                        'size' => 60,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}}' => '--vtc-marquee-speed: {{SIZE}}s;',
                    ],
                ]
            );     

        $this->add_responsive_control(
                'vt_item_space',
                [
                    'label' => esc_html__( 'Space between items', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'default' => [
                        'size' => 20,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 300,
                            'step' => 1,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .vt-marquee-text li' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );         

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'vt_list_text_typography',
                'label' => __( 'Title Typography', 'typecase' ),
                'selector' => '{{WRAPPER}} .vt-marquee-li .vt_fe_title',
            ]
        );

        $this->add_control(
            'vt_list_text_color',
            [
                'label' => __( 'Title Color', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vt-marquee-li .vt_fe_title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'vt_list_text_color_dark',
            [
                'label' => __( 'Title Color Dark Mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt-marquee-li .vt_fe_title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'vt_overlay_bg',
            [
                'label' => __( 'Overlay Background', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}}' => '--mar-ov-bg: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'vt_overlay_bg_dark',
            [
                'label' => __( 'Overlay Background Dark Mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#111',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}}' => '--mar-ov-bg: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        
        $this->start_controls_section(
            'section_label_style', [
              'label'  => esc_html__( 'Label Style', 'typecase' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
              ); 

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'vt_label_typography',
                'label' => __( 'Label Typography', 'typecase' ),
                'selector' => '{{WRAPPER}} .vt_mar_lbl',
            ]
        );

        $this->add_control(
            'vt_label_color',
            [
                'label' => __( 'Label Color', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vt_mar_lbl' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'vt_label_color_dark',
            [
                'label' => __( 'Label Color Dark Mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt_mar_lbl' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'vt_label_background',
            [
                'label' => __( 'Label Background', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vt_mar_lbl' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'vt_label_background_dark',
            [
                'label' => __( 'Label Background Dark Mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .vt_mar_lbl' => 'background: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'vt_label_spacing',
            [
                'label' => esc_html__( 'Label spacing', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vt_mar_wp' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vt_label_rounded',
            [
                'label' => esc_html__( 'Label border rounded', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vt_mar_lbl' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vt_label_padding',
            [
                'label'      => __( 'Label padding', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vt_mar_lbl' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]                
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();
        if ( function_exists( 'typecase_m_list' ) ) {
        $settings['blockid'] = 'blockid_' . $this->get_id();      
        if(!empty($settings['categories'])){
        $settings['categories'] = implode(',', $settings['categories']);      
        }
        echo \typecase_marquee( $settings );
        }
    }
    public function post_categories() {
        $terms = get_terms( array(
              'taxonomy'    => 'category',
              'hide_empty'  => false,
              'posts_per_page' => -1, 
              'suppress_filters' => false,
        ) );
  
        $cat_list = [];
        foreach($terms as $post) {
        $cat_list[$post->term_id]  = [$post->name];
        }
        return $cat_list;
     }
  
     public function post_author() {
  
      $blogusers = get_users( array(
      'role__not_in' => array( 'subscriber' ),
      'fields'       => array( 'ID', 'display_name' )
      ) );
  
        $user_list = [];
        $user_list['none']= esc_html__( 'None', 'typecase' );
        foreach($blogusers as $user) {
        $user_list[$user->ID]  = [$user->display_name];
        }
        return $user_list;
     }
     public function post_get_type() {

        $post_types = get_post_types( '', 'names' ); 
    
          $type_list = [];
          $type_list['none']= esc_html__( 'None', 'typecase' );
          if ( ! empty( $post_types ) ){
            foreach($post_types as $p_type) {
            $type_list[$p_type]  = [$p_type];
            }
          }
          return $type_list;
       }
    
       public function post_get_taxs() {
    
        $taxonomies = get_taxonomies();
    
          $type_taxs = [];
          $type_taxs['none']= esc_html__( 'None', 'typecase' );
          if ( ! empty( $taxonomies ) ){
            foreach($taxonomies as $p_taxs) {
            $type_taxs[$p_taxs]  = [$p_taxs];
            }
        }
          return $type_taxs;
       }
}