<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class typecase_section_mobile_menu extends Widget_Base {

    public function get_name() {
        return 'typecase-mobile-menu';
    }

    public function get_title() {
        return esc_html__( 'Vision Mobile Menu', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-menu-bar vt-icons';
    }

    public function get_categories() {
        return [ 'typecase-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'text_elements',
            [
                'label' => __( 'Menu Icon', 'typecase' ),
            ]
        );
        
        $this->add_control(
            'vt_btn_icons',
            [
                'label' =>esc_html__( 'Icon', 'typecase' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'vt_btn_icon',
                'label_block' => true,
                'default' => [
                    'value' => '',
                ]
            ]
        );        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_marker',
            [
                'label' => __( 'Mobile Menu Style', 'typecase' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );    

        $this->add_responsive_control(
            'icon_menu_height',
            [
                'label' => __( 'Height', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'size' => '90',
                    'unit' => 'px'
                ],
                'selectors' => [                    
                    '{{WRAPPER}} .menu_mobile_icons' => 'height: {{SIZE}}px',
                ]                
            ]
        );   

        $this->add_responsive_control(
            'icons_margin',
            [
                'label'      => __( 'Margin', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .menu_mobile_icons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icons_padding',
            [
                'label'      => __( 'Padding', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .menu_mobile_icons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        $this->add_responsive_control(
            'icon_line_space',
            [
                'label' => __( 'Hamburger menu height', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],                
                'selectors' => [                    
                    '{{WRAPPER}} .vtm_w' => 'min-height: {{SIZE}}px !important',
                ],
                'condition' => [
                    'vt_btn_icons[value]' => ''
                ]
            ]
        );  
        
        $this->add_responsive_control(
            'icon_line_height',
            [
                'label' => __( 'Hamburger line height', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 0.5,
                    ],
                ],                
                'selectors' => [                    
                    '{{WRAPPER}} .vtm_w span' => 'height: {{SIZE}}px !important',
                ],
                'condition' => [
                    'vt_btn_icons[value]' => ''
                ]                
            ]
        );  

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Icons Font Size', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .menu_mobile_icons i' => 'font-size: {{SIZE}}px !important',
                    '{{WRAPPER}} .menu_mobile_icons svg' => 'width: {{SIZE}}px !important; height:auto !important;',
                    '{{WRAPPER}} .vtm_w' => 'width: {{SIZE}}px !important',
                ]                
            ]
        );     
        $this->add_control(
            'vt_btn_mobile_color',
            [
                'label' =>esc_html__( 'Color', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .menu_mobile_icons i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .menu_mobile_icons svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',
                    '{{WRAPPER}} .menu_mobile_icons .vtm_w span' => 'background: {{VALUE}} !important;',
                ],
            ]
        );  

        $this->add_control(
            'vt_btn_mobile_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .menu_mobile_icons i' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .menu_mobile_icons svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .menu_mobile_icons .vtm_w span' => 'background: {{VALUE}} !important;',
                ],
            ]
        );  

        $this->add_control(
            'vt_mobile_color_hover',
            [
                'label' =>esc_html__( 'Color Hover', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .menu_mobile_icons i:hover' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .menu_mobile_icons svg:hover path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',
                    '{{WRAPPER}} .menu_mobile_icons:hover .vtm_w span' => 'background: {{VALUE}} !important;',
                ],
            ]
        );  
        
        $this->add_control(
            'vt_mobile_color_hover_dark',
            [
                'label' =>esc_html__( 'Color hover dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .menu_mobile_icons i:hover' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .menu_mobile_icons svg:hover path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .menu_mobile_icons:hover .vtm_w span' => 'background: {{VALUE}} !important;',
                ],
            ]
        );  

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();        
       ?>
       <div class="menu_mobile_icons_wrap">
       <div class="menu_mobile_icons">
        <?php
        if (empty($settings['vt_btn_icons']['value'])) {?>
            <div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div>
            <?php }else{
            $migrated = isset( $settings['__fa4_migrated']['vt_btn_icons'] );
            $is_new = empty( $settings['vt_btn_icon'] );
            if ( $is_new || $migrated ) {
                Icons_Manager::render_icon( $settings['vt_btn_icons'], [ 'aria-hidden' => 'true' ] );
            }else{
            ?>
            <i class="<?php echo esc_attr($settings['vt_btn_icon']); ?>" aria-hidden="true"></i>
            <?php
            }
        }?>
      </div>
      </div>
    <?php
    }
}