<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class typecase_section_search_button extends Widget_Base {

    public function get_name() {
        return 'typecase-search-button';
    }

    public function get_title() {
        return esc_html__( 'Vision Search Button', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-search vt-icons';
    }

    public function get_categories() {
        return [ 'typecase-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'text_elements',
            [
                'label' => __( 'Search Icon', 'typecase' ),
            ]
        );
        
        $this->add_control(
            'vt_btn_icons',
            [
                'label' =>esc_html__( 'Icon', 'typecase' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'vt_btn_icon',
                'label_block' => true,
                'default' => [
                    'value' => '',
                ]
            ]
        );        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_marker',
            [
                'label' => __( 'Search Style', 'typecase' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );               

        $this->add_responsive_control(
            'icons_height',
            [
                'label' => __( 'Height Icon', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'size' => '90',
                    'unit' => 'px'
                ],
                'selectors' => [
                    '{{WRAPPER}} .search_header_wrapper.search_form_menu_personal_click' => 'height: {{SIZE}}px',
                    '{{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click' => 'margin-left: 0px;',
                ],
            ]
        );     

        $this->add_responsive_control(
            'icons_margin',
            [
                'label'      => __( 'Margin', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icons_padding',
            [
                'label'      => __( 'Padding', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icons_size',
            [
                'label' => __( 'Font size', 'typecase' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'size' => '20',
                    'unit' => 'px'
                ],
                'selectors' => [
                    '{{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click i' => 'font-size: {{SIZE}}px',
                ],
            ]
        );     
        $this->add_control(
            'vt_btn_search_color',
            [
                'label' =>esc_html__( 'Color', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click i' => 'color: {{VALUE}} !important;',
                ],
            ]
        );  

        $this->add_control(
            'vt_btn_search_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click i' => 'color: {{VALUE}} !important;',
                ],
            ]
        );  

        $this->add_control(
            'vt_btn_search_color_hover',
            [
                'label' =>esc_html__( 'Color Hover', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click:hover i' => 'color: {{VALUE}} !important;'
                ],
            ]
        );   

        $this->add_control(
            'vt_btn_search_color_hover_dark',
            [
                'label' =>esc_html__( 'Color hover dark mode', 'typecase' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .search_header_wrapper.vtce-seach.search_form_menu_personal_click:hover i' => 'color: {{VALUE}} !important;'                    
                ],
            ]
        );   

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();
        ?>
        <div class="search_header_wrapper vtce-seach search_form_menu_personal_click">        
            <?php if (empty($settings['vt_btn_icons']['value'])) {?>
                            <i class="vti-search"></i>
                        <?php }else{
                            $migrated = isset( $settings['__fa4_migrated']['vt_btn_icons'] );
                            $is_new = empty( $settings['vt_btn_icon'] );
                            if ( $is_new || $migrated ) {
                                Icons_Manager::render_icon( $settings['vt_btn_icons'], [ 'aria-hidden' => 'true' ] );
                            }else{
                                ?>
                                <i class="<?php echo esc_attr($settings['vt_btn_icon']); ?>" aria-hidden="true"></i>
                                <?php
                            }
                        }
                    ?>
        </div>
        <?php
    }
}