<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_section_title extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-section-title';
    }

    public function get_title() {
        return esc_html__( 'Section Title', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Section Title Setting', 'typecase'),
            ]
        );

      $this->add_control(
      'section_title', [
        'label'       => esc_html__( 'Section Title', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => 'Section title',
        'placeholder' => esc_html__( 'Section text', 'typecase' )        
      ]
      );
      $this->add_control(
      'section_desc', [
        'label'       => esc_html__( 'Section description', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
      ]
      );
      $this->add_control(
      'section_btn_text', [
        'label'       => esc_html__( 'Section button text', 'typecase' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
      ]
      );
      $this->add_control(
            'vt_text_url',
            [
                'label' =>esc_html__( 'Section title URL', 'typecase' ),
                'type' => Controls_Manager::URL,                
            ]
     );

     $this->add_control(
            'vt_btn_url',
            [
                'label' =>esc_html__( 'Section button URL', 'typecase' ),
                'type' => Controls_Manager::URL,                
            ]
        );
    $this->add_control(
            'tag',
            [
                'label' => __( 'Title Tag', 'typecase' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h2',
            ]
        );
      $this->end_controls_section();
      $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Section Title Options', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     
      $this->add_control(
            'section_style',
            [
                'label'     =>esc_html__( 'Section Title Styles', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'vt_sec_style1',
                'options'   => [
                        'vt_sec_style1'      =>esc_html__( 'Line bottom', 'typecase' ),
                        'vt_sec_style2'    =>esc_html__( 'Line top', 'typecase' ),
                        'vt_sec_style3'    =>esc_html__( 'Line center', 'typecase' ),
                        'vt_sec_style4'    =>esc_html__( 'Double line bottom', 'typecase' ),
                        'vt_sec_style5'    =>esc_html__( 'Double line top', 'typecase' ),
                        'vt_sec_style6'    =>esc_html__( 'Double line center', 'typecase' ),
                        'vt_sec_style7'    =>esc_html__( 'Title shadow', 'typecase' ),
                        'vt_sec_style8'    =>esc_html__( 'Text only', 'typecase' ),
                        'vt_sec_style9'    =>esc_html__( 'Title with background', 'typecase' ),
                        'vt_sec_style10'    =>esc_html__( 'Title with background line top', 'typecase' ),
                        'vt_sec_style11'    =>esc_html__( 'Title line left', 'typecase' ),
                        'vt_sec_style12'    =>esc_html__( 'Title with doted circle', 'typecase' ),
                        'vt_sec_style13'    =>esc_html__( 'Title with squre', 'typecase' ),
                        'vt_sec_style14'    =>esc_html__( 'Title with parallelogram', 'typecase' ),
                        'vt_sec_style15'    =>esc_html__( 'Title line with line color', 'typecase' ),
                        'vt_sec_style16'    =>esc_html__( 'Title with background full', 'typecase' ),
                        'vt_sec_style17'    =>esc_html__( 'Title with background full with arrow', 'typecase' ),
                    ],
            ]
        );

      $this->add_responsive_control(
            'vtc_align',
            array(
                'label'     => __( 'Alignment', 'typecase' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => array(
                    'left'   => array(
                        'title' => __( 'Left', 'typecase' ),
                        'icon'  => 'eicon-text-align-left',
                    ),
                    'center' => array(
                        'title' => __( 'Center', 'typecase' ),
                        'icon'  => 'eicon-text-align-center',
                    ),
                    'right'  => array(
                        'title' => __( 'Right', 'typecase' ),
                        'icon'  => 'eicon-text-align-right',
                    ),
                ),
                'toggle'    => false,
                'default'   => 'left',
                'selectors' => array(
                    '{{WRAPPER}} .vtcus_sec_title' => '--sect-t-algin: {{VALUE}};',
                    '{{WRAPPER}} .vtcus_sec_title .vt_sct_bt' => 'top: 0px;',
                )                
            )
        );

        $this->add_responsive_control(
            'sec_line_top',
            [
                'label' => __( 'Section line top', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'default' => [
                    'size' => 5,
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title .vtcus_sect_inner' => 'border-top: {{SIZE}}{{UNIT}} solid;',
                ],
                'condition' => [
                    'section_style'    => ['vt_sec_style12','vt_sec_style13','vt_sec_style14']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_line_bottom',
            [
                'label' => __( 'Section line bottom', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title .vtcus_sect_inner' => 'border-bottom: {{SIZE}}{{UNIT}} solid;',
                ],
                'condition' => [
                    'section_style'    => ['vt_sec_style12','vt_sec_style13','vt_sec_style14']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_line_padding',
            [
                'label'      => __( 'Section line space', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vtcus_sec_title .vtcus_sect_inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                    'section_style'    => ['vt_sec_style12','vt_sec_style13','vt_sec_style14']
                ]
            ]
        );

        $this->add_control(
            'sec_line_color',
            [
              'label' => __( 'Section line color', 'typecase' ),
              'type' => Controls_Manager::COLOR,        
              'default' => '#000',
              'selectors' => [
                  '{{WRAPPER}}  .vtcus_sec_title .vtcus_sect_inner' => 'border-color: {{VALUE}}',
              ],
              'condition' => [
                  'section_style'    => ['vt_sec_style12','vt_sec_style13','vt_sec_style14']
              ]
            ]
          );
      
          $this->add_control(
            'sec_line_color_dark',
            [
              'label' => __( 'Section line color dark mode', 'typecase' ),
              'default' => '#3c3c3c',
              'type' => Controls_Manager::COLOR,        
              'selectors' => [
                  '.options_dark_skin {{WRAPPER}}  .vtcus_sec_title .vtcus_sect_inner' => 'border-color: {{VALUE}}',
              ],
              'condition' => [
                  'section_style'    => ['vt_sec_style12','vt_sec_style13','vt_sec_style14']
              ]
            ]
          );
          
        $this->add_responsive_control(
            'sec_line_height',
            [
                'label' => __( 'Line width', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title' => '--sect-line-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style'    => ['vt_sec_style1','vt_sec_style2','vt_sec_style3','vt_sec_style9','vt_sec_style10','vt_sec_style11','vt_sec_style15']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_ac_line_height',
            [
                'label' => __( 'Active line width', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'default' => [
                    'size' => 5,
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title' => '--sect-ac-line-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style'    => ['vt_sec_style15']
                ]
            ]
        );

          $this->add_responsive_control(
            'sec_line_width',
            [
                'label' => __( 'Line width', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title' => '--sect-line-w: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style'    => ['vt_sec_style3','vt_sec_style6','vt_sec_style7']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_line_space',
            [
                'label' => __( 'Title space', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title' => '--sect-line-space: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style!'    => ['vt_sec_style16','vt_sec_style17']
                ]
            ]
        );

        $this->add_control(
            'section_title_font',
            [
                'label'     =>esc_html__( 'Section Title font', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'vt_secf_title',
                'options'   => [
                        'vt_secf_title'      =>esc_html__( 'Title font', 'typecase' ),
                        'vt_secf_menu'    =>esc_html__( 'Menu font', 'typecase' ),
                        'vt_secf_body'    =>esc_html__( 'Body font', 'typecase' ),
                        'vt_secf_cus'    =>esc_html__( 'Custom font', 'typecase' ),
                    ],
            ]
        );

        $this->add_responsive_control(
        'sec_font_size',
        [
            'label' => __( 'Title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 23,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-t-size: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'section_title_font'    => ['vt_secf_title','vt_secf_menu','vt_secf_body']
            ]
        ]
    );
    
    $this->add_responsive_control(
        'sec_letter_spaceing',
        [
            'label' => __( 'Title letter spacing', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
                'size' => -0.03,
            ],
            'range' => [
                'px' => [
                    'min' => -0.7,
                    'max' => 0.7,
                    'step' => 0.01,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-t-space: {{SIZE}}em !important;',
            ],
            'condition' => [
                'section_title_font'    => ['vt_secf_title','vt_secf_menu','vt_secf_body']
            ]
        ]
    );

    $this->add_control(
        'vt_title_up',
        [
            'label' => esc_html__( 'Title Uppercase', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title .vt-heading-text' => 'text-transform: uppercase !important;',
            ],
            'condition' => [
                'section_title_font'    => ['vt_secf_title','vt_secf_menu','vt_secf_body']
            ]            
        ]
        );

      $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography', 
                'label' =>esc_html__( 'Title typography', 'typecase' ),               
                'selector' => '{{WRAPPER}} .vtcus_sec_title.vt_secf_cus .vt-heading-text',
                'condition' => [
                    'section_title_font'    => 'vt_secf_cus'
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_desc_size',
            [
                'label' => __( 'Description font size', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title .vt_sct_sub' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
                'condition'=>[
                    'section_desc!'=>'',
                ],
            ]
        );   
        
        $this->add_responsive_control(
            'sec_desc_space',
            [
                'label' => __( 'Description space', 'typecase' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .vtcus_sec_title .vt_sct_sub' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
                ],
                'condition'=>[
                    'section_desc!'=>'',
                ],
            ]
        );   

      $this->add_control(
            'section_btn_font',
            [
                'label'     =>esc_html__( 'Section button font', 'typecase' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'vt_secb_menu',
                'options'   => [
                        'vt_secb_title'      =>esc_html__( 'Title font', 'typecase' ),
                        'vt_secb_menu'    =>esc_html__( 'Menu font', 'typecase' ),
                        'vt_secb_body'    =>esc_html__( 'Body font', 'typecase' ),
                        'vt_secb_cus'    =>esc_html__( 'Custom font', 'typecase' ),
                ],
                'condition'=>[
                        'section_btn_text!'=>'',
                ],
            ]
        );  

      $this->add_responsive_control(
        'sec_btn_font_size',
        [
            'label' => __( 'Button font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 14,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-btn-size: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'section_btn_font'    => ['vt_secb_title','vt_secb_menu','vt_secb_body'],                
                'section_btn_text!'=>'',                
            ]
        ]
    );
    $this->add_responsive_control(
        'sec_btn_letter_spaceing',
        [
            'label' => __( 'Button letter spacing', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => -0.7,
                    'max' => 0.7,
                    'step' => 0.01,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-btn-space: {{SIZE}}em !important;',
            ],
            'condition' => [
                'section_btn_font'    => ['vt_secb_title','vt_secb_menu','vt_secb_body'],
                'section_btn_text!'=>'',                

            ]
        ]
    );

      $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography', 
                'label' =>esc_html__( 'Button typography', 'typecase' ),               
                'selector' => '{{WRAPPER}} .vtcus_sec_title.vt_secb_cus .vt_sct_bt',
                'condition' => [
                    'section_btn_font'    => 'vt_secb_cus',
                    'section_btn_text!'=>'',                
                ]
            ]
        );

    $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography', 
                'label' =>esc_html__( 'Description typography', 'typecase' ),               
                'selector' => '{{WRAPPER}} .vtcus_sec_title .vt_sct_sub',                
                'condition'=>[
                        'section_desc!'=>'',
                ],
            ]
        );

    $this->add_control(
      'title_color',
      [
        'label' => __( 'Title color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .vtcus_sec_title' => '--sect-t-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'title_color_dark',
      [
        'label' => __( 'Title color dark mode', 'typecase' ),
        'default' => '#fff',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--sect-t-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
        'ac_line_color',
        [
          'label' => __( 'Active line color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#000',
          'selectors' => [
              '{{WRAPPER}} .vtcus_sec_title' => '--ac-line-color: {{VALUE}}',
          ],
        ]
      );
  
      $this->add_control(
        'ac_line_color_dark',
        [
          'label' => __( 'Active line color dark mode', 'typecase' ),
          'default' => '#fff',
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--ac-line-color: {{VALUE}}',
          ],
        ]
      );

    $this->add_control(
        'titlebg_color',
        [
          'label' => __( 'Title bg color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#e9e9e9',
          'selectors' => [
              '{{WRAPPER}} .vtcus_sect_inner' => 'background: {{VALUE}}',
              '{{WRAPPER}} .vt_sec_style17 .vtcus_sect_inner:before' => '    border-top-color: {{VALUE}}',
          ],
          'condition' => [
            'section_style'    => ['vt_sec_style16','vt_sec_style17']
          ]
        ]
      );
  
      $this->add_control(
        'titlebg_color_dark',
        [
          'label' => __( 'Title bg color dark mode', 'typecase' ),
          'default' => '#3c3c3c',
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}} .vtcus_sect_inner' => 'background: {{VALUE}}',
              '.options_dark_skin {{WRAPPER}} .vt_sec_style17 .vtcus_sect_inner:before' => '    border-top-color: {{VALUE}}',
          ],
          'condition' => [
            'section_style'    => ['vt_sec_style16','vt_sec_style17']
          ]
        ]
      );

      $this->add_responsive_control(
        'sec_title_bg_h',
        [
            'label' => __( 'Title bg height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 40,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sect_inner' => 'height: {{SIZE}}{{UNIT}}; align-items: center;padding: 0px 15px;',
            ],
            'condition' => [
                'section_style'    => ['vt_sec_style16','vt_sec_style17']
            ]
        ]
    );

    $this->add_control(
      'title_desc_color',
      [
        'label' => __( 'Description color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#666',
        'selectors' => [
            '{{WRAPPER}} .vtcus_sec_title' => '--sect-dsc-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_desc!'=>'',
        ],
      ]
    );
    

    $this->add_control(
      'title_desc_color_dark',
      [
        'label' => __( 'Description color dark mode', 'typecase' ),
        'default' => '#ddd',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--sect-dsc-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_desc!'=>'',
        ],
      ]
    );

    $this->add_control(
      'button_color',
      [
        'label' => __( 'Button color', 'typecase' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .vtcus_sec_title' => '--sect-btn-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_btn_text!'=>'',
        ],
      ]
    );
    $this->add_control(
      'button_color_dark',
      [
        'label' => __( 'Button Dark mode color', 'typecase' ),
        'default' => '#fff',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--sect-btn-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_btn_text!'=>'',
        ],
      ]
    );
    $this->add_control(
      'line_color',
      [
        'label' => __( 'Line / dot color / background', 'typecase' ),
        'default' => '#e9ecef',
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .vtcus_sec_title' => '--sect-line-color: {{VALUE}}'
        ],
            'condition' => [
                'section_style'    => ['vt_sec_style1','vt_sec_style2','vt_sec_style3','vt_sec_style4','vt_sec_style5','vt_sec_style6', 'vt_sec_style7','vt_sec_style9','vt_sec_style10','vt_sec_style11','vt_sec_style12','vt_sec_style13','vt_sec_style14','vt_sec_style15']
        ]
      ]
    );
    

    $this->add_control(
      'line_color_dark',
      [
        'label' => __( 'Line / dot / background dark mode color', 'typecase' ),
        'default' => '#49494b',
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--sect-line-color: {{VALUE}}'        
        ],
            'condition' => [
                'section_style'    => ['vt_sec_style1','vt_sec_style2','vt_sec_style3','vt_sec_style4','vt_sec_style5','vt_sec_style6', 'vt_sec_style7', 'vt_sec_style9','vt_sec_style10','vt_sec_style11','vt_sec_style12','vt_sec_style13','vt_sec_style14','vt_sec_style15']
        ]
      ]
    );

    $this->add_control(
                'vt_show_icons',
                [
                    'label' => esc_html__( 'Show button arrow', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'=>[
                        'section_btn_text!'=>'',
                    ],  
                ]
    );

    $this->add_responsive_control(
        'sec_title_stroke',
        [
            'label' => __( 'Title stroke width', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 20,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-stroke-size: {{SIZE}}px !important;',
            ],
            'condition' => [
                'section_style'    => 'vt_sec_style7'
            ]            
        ]
    );

    $this->add_responsive_control(
        'sec_title_shadow',
        [
            'label' => __( 'Title shadow position', 'typecase' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 0.6,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3,
                    'step' => 0.01,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-stroke-pos: {{SIZE}}rem !important;',
            ],
            'condition' => [
                'section_style'    => 'vt_sec_style7'
            ]            
        ]
    );
    $this->add_control(
      'line_stroke_color',
      [
        'label' => __( 'Stroke and shadow color', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .vtcus_sec_title' => '--sect-shadow-color: {{VALUE}};'        
        ],
        'condition' => [
            'section_style'    => 'vt_sec_style7'
        ]
      ]
    );

    $this->add_control(
      'line_stroke_color_dark',
      [
        'label' => __( 'Stroke and shadow dark mode color', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#000',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--sect-shadow-color: {{VALUE}};'        
        ],
        'condition' => [
            'section_style'    => 'vt_sec_style7'
        ]
      ]
    );

    $this->add_control(
                'vt_bg_title',
                [
                    'label' => esc_html__( 'Enable title background & padding', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                    'section_style!'    => ['vt_sec_style16','vt_sec_style17']
                    ]
                ]
    );

    $this->add_control(
      'vt_title_bg',
      [
        'label' => __( 'Title background', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#ff1d46',
        'selectors' => [
            '{{WRAPPER}} .vtcus_sec_title' => '--sect-title-bg: {{VALUE}};'        
        ],
        'condition' => [
            'vt_bg_title'    => 'yes',
            'section_style!'    => ['vt_sec_style9','vt_sec_style10']
        ]
      ]
    );

    $this->add_control(
      'vt_title_bg_dark',
      [
        'label' => __( 'Title dark mode background', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#ff1d46',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--sect-title-bg: {{VALUE}};'        
        ],
        'condition' => [
            'vt_bg_title'    => 'yes',
            'section_style!'    => ['vt_sec_style9','vt_sec_style10']
        ]
      ]
    );
    $this->add_responsive_control(
        'vt_title_radius',
        [
            'label' => __( 'Title rounded coner', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-rounded: {{SIZE}}{{UNIT}} !important;',
                '{{WRAPPER}} .vtcus_sec_title.vt_sec_style10 .vt-heading-text span' => 'margin-top: 0px !important;',
            ],
            'condition' => [
                'vt_bg_title'    => 'yes',
                'section_style!'    => ['vt_sec_style9']
            ]            
        ]
    );

    $this->add_responsive_control(
            'vt_title_padding',
            [
                'label'      => __( 'Title padding', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vtcus_sec_title.vt_sec_title_bg .vt-heading-text span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                    'vt_bg_title'    => 'yes'
                ]
            ]
        );
    $this->add_control(
                'vt_bg_btn',
                [
                    'label' => esc_html__( 'Enable button background', 'typecase' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'=>[
                        'section_btn_text!'=>'',
                    ],
                ]
    );

    $this->add_control(
      'vt_btn_bg',
      [
        'label' => __( 'Button background', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#fff',
        'selectors' => [
            '{{WRAPPER}} .vtcus_sec_title' => '--sect-btn-bg: {{VALUE}};'        
        ],
        'condition' => [
            'vt_bg_btn'    => 'yes',
            'section_btn_text!'=>'',
        ]
      ]
    );

    $this->add_control(
      'vt_btn_bg_dark',
      [
        'label' => __( 'Button dark mode background', 'typecase' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#ff1d46',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .vtcus_sec_title' => '--sect-btn-bg: {{VALUE}};'        
        ],
        'condition' => [
            'vt_bg_btn'    => 'yes',
            'section_btn_text!'=>'',
        ]
      ]
    );
    $this->add_responsive_control(
        'vt_btn_radius',
        [
            'label' => __( 'Button rounded coner', 'typecase' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .vtcus_sec_title' => '--sect-btn-rounded: {{SIZE}}{{UNIT}} !important;',
            ],
            'condition' => [
                'vt_bg_btn'    => 'yes',
                'section_btn_text!'=>'',
            ]            
        ]
    );

    $this->add_responsive_control(
            'vt_btn_padding',
            [
                'label'      => __( 'Button Padding', 'typecase' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .vtcus_sec_title.vt_sec_btn_bg .vt_sct_bt span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                    'vt_bg_btn'    => 'yes',
                    'section_btn_text!'=>'',
                ]
            ]
        );
        $this->end_controls_section();
    }
    protected function render( ) { 
        $settings = $this->get_settings_for_display();
        $tag = $settings['tag'];
        $section_style = $settings['section_style'];
        $section_title = $settings['section_title'];
        $section_desc = $settings['section_desc'];
        $section_btn_text = $settings['section_btn_text'];        
        $vt_show_icons = $settings['vt_show_icons'];
        $section_title_font = $settings['section_title_font'];
        $section_btn_font = $settings['section_btn_font'];
        $vt_bg_title = $settings['vt_bg_title'];
        $vt_bg_btn = $settings['vt_bg_btn'];
        if ($vt_bg_title === 'yes') {
            $vt_bg_title = 'vt_sec_title_bg';
        }
        if ($vt_bg_btn === 'yes') {
            $vt_bg_btn = 'vt_sec_btn_bg';
        }        
        $this->add_render_attribute(
            'section_head',
            array(                
                'class' => array('vtcus_sec_title', $section_style, $section_title_font, $section_btn_font, $vt_bg_title, $vt_bg_btn),
            )
        );
        if ( ! empty( $settings['vt_text_url']['url'] ) ) {
            $this->add_link_attributes( 'vt_text_url', $settings['vt_text_url'] );
        }
        if ( ! empty( $settings['vt_btn_url']['url'] ) ) {
            $this->add_link_attributes( 'vt_btn_url', $settings['vt_btn_url'] );
        }                                
        ?>
          <div <?php echo $this->get_render_attribute_string( 'section_head' ); ?>>
            <div class="vtcus_sect_inner">
                  <?php if(!empty($section_title)){?>
                  <<?php echo esc_html($tag); ?> class="vt-heading-text">            
                        <span>
                            <?php if ( ! empty( $settings['vt_text_url']['url'] ) ) {?>
                            <a <?php echo $this->get_render_attribute_string( 'vt_text_url' ); ?> class="vtopt-text-link">
                            <?php }?>
                                <?php echo esc_html($section_title); ?>
                            <?php if ( ! empty( $settings['vt_text_url']['url'] ) ) {?>
                            </a>
                            <?php }?>
                        </span>            
                  </<?php echo esc_html($tag); ?>>
                  <?php }?>                  
                  <?php if(!empty($section_btn_text)){?>
                  <p class="vt_sct_bt">
                        <?php if ( ! empty( $settings['vt_btn_url']['url'] ) ) {?>
                        <a <?php echo $this->get_render_attribute_string( 'vt_btn_url' ); ?> class="vtopt-text-link">
                        <?php }?>
                        <span class="vt_bt_inner">
                        <span><?php echo esc_html($section_btn_text);?></span>
                        <?php if ($vt_show_icons === 'yes') {?>
                            <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 64 64" viewBox="8.1 8.1 47.8 47.8"><g transform="translate(28 328)"><path fill="currentColor" d="M4-272.1c-13.2 0-23.9-10.7-23.9-23.9S-9.2-319.9 4-319.9s23.9 10.7 23.9 23.9S17.2-272.1 4-272.1zm0-45.2c-11.7 0-21.3 9.6-21.3 21.3s9.6 21.3 21.3 21.3 21.3-9.6 21.3-21.3-9.6-21.3-21.3-21.3z"></path><path fill="currentColor" d="m3.5-282.3-1.8-1.9L13.4-296 1.7-307.8l1.8-1.9L17.2-296 3.5-282.3"></path><path fill="currentColor" d="M15.3-294.6h-24v-2.8h24z"></path></g></svg>
                        <?php }?>
                        </span>
                        <?php if ( ! empty( $settings['vt_btn_url']['url'] ) ) {?>
                        </a>
                        <?php }?>
                  </p>
                  <?php }?>
            </div>                    
            <?php if (!empty($section_desc)) {?><p class="vt_sct_sub"><?php echo $section_desc;?></p><?php }?>
          </div>                    
    <?php  
    }    
}