<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class typecase_section_simple_menu extends Widget_Base {

    public function get_name() {
        return 'typecase-simple-menu';
    }

    public function get_title() {
        return esc_html__( 'Vision Simple Menu', 'typecase' );
    }

    public function get_icon() {
        return 'eicon-editor-list-ol vt-icons';
    }

    public function get_categories() {
        return [ 'typecase-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Inline Menu', 'typecase' ),
            ]
        );
            
            $this->add_control(
                    'menu_style',
                    [
                        'label' => esc_html__( 'Menu Layout', 'typecase' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'vt_menu_list',
                        'options' => [                            
                            'vt_menu_list'  => esc_html__( 'Menu List', 'typecase' ),
                            'vt_menu_inline'  => esc_html__( 'Menu Inline', 'typecase' ),
                        ],
                    ]
                );                

            if ( ! empty( typecase_get_menus() ) ) {
                $this->add_control(
                    'inline_menu_slug',
                    [
                        'label'   => esc_html__( 'Menu', 'typecase' ),
                        'type'    => Controls_Manager::SELECT,
                        'options' => typecase_get_menus(),
                        'default' => array_keys( typecase_get_menus() )[0],
                        'save_default' => true,
                        'separator' => 'after',
                        'description' => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus Option</a> to manage your menus.', 'typecase' ), admin_url( 'nav-menus.php' ) ),                        
                    ]
                );
            } else {
                $this->add_control(
                    'inline_menu_notice',
                    [
                        'type' => Controls_Manager::RAW_HTML,
                        'raw' => sprintf( __( '<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus Option</a> to create one.', 'typecase' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
                        'separator' => 'after',                        
                    ]
                );                
            }

            $this->add_responsive_control(
                'menu_position',
                [
                    'label'   => esc_html__( 'Menu position', 'typecase' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start'    => [
                            'title' => esc_html__( 'Left', 'typecase' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'typecase' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Right', 'typecase' ),
                            'icon' => 'eicon-text-align-right',
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul'   => 'justify-content: {{VALUE}};',                        
                    ],
                    'condition' => [
                        'menu_style'    => ['vt_menu_inline']
                    ]
                ]
            );
            
            $this->add_responsive_control(
                'area_alignment',
                [
                    'label'   => esc_html__( 'Text alignment', 'typecase' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'typecase' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'typecase' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'typecase' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul li'   => 'text-align: {{VALUE}};',                        
                    ],
                    'condition' => [
                        'menu_style'    => ['vt_menu_list']
                    ]
                ]
            );
            
            $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name' => 'menu_item_typography',
                    'label' => esc_html__( 'Typography', 'typecase' ),
                    'selector' => '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul li a, {{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul li a',
                ]
            );            

            $this->add_responsive_control(
                'menu_item_space',
                [
                    'label' => esc_html__( 'Space menu', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 20,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 300,
                            'step' => 1,
                        ]                        
                    ],
                    'selectors' => [                        
                        '{{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul' => 'gap: 7px {{SIZE}}px !important; display: flex !important; padding: 0px; flex-direction: row !important; flex-wrap: wrap;margin-top: 0px !important;',
                        '{{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul li' => 'list-style: none;',
                    ],
                    'condition' => [
                        'menu_style'    => ['vt_menu_inline']
                    ]
                ]
            );

            $this->add_responsive_control(
                'menu_item_col',
                [
                    'label' => esc_html__( 'Number col', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 2,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 12,
                            'step' => 1,
                        ]                        
                    ],
                    'selectors' => [                        
                        '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr)) !important; display: grid !important; padding: 0px;',
                        '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul li' => 'list-style: none;',
                    ],
                    'condition' => [
                        'menu_style'    => ['vt_menu_list']
                    ]
                ]
            );

            $this->add_responsive_control(
                'menu_item_space_col',
                [
                    'label' => esc_html__( 'Space col', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 7,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 300,
                            'step' => 1,
                        ]                        
                    ],
                    'selectors' => [                        
                        '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul' => 'grid-column-gap: {{SIZE}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'menu_style'    => ['vt_menu_list']
                    ]
                ]
            );

            $this->add_responsive_control(
                'menu_item_space_row',
                [
                    'label' => esc_html__( 'Space row', 'typecase' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 7,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 300,
                            'step' => 1,
                        ]
                    ],
                    'selectors' => [                        
                        '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul' => 'grid-row-gap: {{SIZE}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'menu_style'    => ['vt_menu_list']
                    ]
                ]
            );

            $this->add_control(
                'menu_normal_color',
                [
                    'label'     => esc_html__( 'Color', 'typecase' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul li a, {{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul li a' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'menu_normal_color_dark',
                [
                    'label'     => esc_html__( 'Color dark mode', 'typecase' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '.options_dark_skin {{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul li a, .options_dark_skin {{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul li a' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'menu_hover_color',
                    [
                        'label'     => esc_html__( 'Color hover', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul li a:hover, {{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul li a:hover' => 'color: {{VALUE}};',
                        ],
                    ]
            );

            $this->add_control(
                'menu_hover_color_dark',
                    [
                        'label'     => esc_html__( 'Color hover dark mode', 'typecase' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '.options_dark_skin {{WRAPPER}} .vtcm-main-vt_menu_list.widget_nav_menu ul li a:hover, .options_dark_skin {{WRAPPER}} .vtcm-main-vt_menu_inline.widget_nav_menu ul li a:hover' => 'color: {{VALUE}};',
                        ],
                    ]
            );
           
        $this->end_controls_section();        
    }
    protected function render( ) {
    $settings = $this->get_settings_for_display();
    $id       = $this->get_id();    
    $this->add_render_attribute( 'area_attr', 'class', 'vtcm--simple-menu widget_nav_menu vtcm-main-'.$settings['menu_style'] );
        $args = [
            'echo' => false,
            'menu' => $settings['inline_menu_slug'],
            'menu_class' => 'menu',
            'menu_id' => 'menu-'. $id,
            'fallback_cb' => '__return_empty_string',
            'container' => ''
        ];        
        $menu_html = wp_nav_menu( $args );
        ?>                
        <div <?php echo $this->get_render_attribute_string( 'area_attr' ); ?> >            
            <?php if( !empty( $menu_html ) ){
                    echo $menu_html;
                }            
            ?>
        </div>
        <?php
    }
}