<?php
namespace typecaseElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class typecase_social_list extends Widget_Base {

  public $base;

    public function get_name() {
        return 'typecase-social-list';
    }

    public function get_title() {
        return esc_html__( 'Social List', 'typecase' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle vt-icons';
    }

    public function get_categories() {
       return [ 'typecase-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'typecase'),
            ]
        );
        
        $this->add_control(
            'facebook_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Facebook</b>',
            ]
        );
        $this->add_control(
            'facebook_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,                    
                ]
            ]
        );
        $this->add_control(
            'facebook_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'facebook_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Likes',
          ]
        );

        $this->add_control(
            'twitter_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Twitter</b>',
            ]
        );
        $this->add_control(
            'twitter_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,                    
                ]                                
            ]
        );
        $this->add_control(
            'twitter_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '93k',
          ]
        );
        $this->add_control(
            'twitter_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Follows',
          ]
        );

        $this->add_control(
            'instagram_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Instagram</b>',
            ]
        );
        $this->add_control(
            'instagram_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,                    
                ]                                
            ]
        );
        $this->add_control(
            'instagram_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '32k',
          ]
        );
        $this->add_control(
            'instagram_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Follows',
          ]
        );

        $this->add_control(
            'pinterest_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Pinterest</b>',
            ]
        );
        $this->add_control(
            'pinterest_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,                    
                ]                                
            ]
        );
        $this->add_control(
            'pinterest_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '42k',
          ]
        );
        $this->add_control(
            'pinterest_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Pin',
          ]
        );

        $this->add_control(
            'youtube_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Youtube</b>',
            ]
        );
        $this->add_control(
            'youtube_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,                    
                ]                                
            ]
        );
        $this->add_control(
            'youtube_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '100k',
          ]
        );
        $this->add_control(
            'youtube_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Subscribers',
          ]
        );

        $this->add_control(
            'vimeo_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Vimeo</b>',
            ]
        );
        $this->add_control(
            'vimeo_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,                    
                ]                                
            ]
        );
        $this->add_control(
            'vimeo_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '89k',
          ]
        );
        $this->add_control(
            'vimeo_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'sound_cloud_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Sound cloud</b>',
            ]
        );
        $this->add_control(
            'sound_cloud_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,                    
                ]                                
            ]
        );
        $this->add_control(
            'sound_cloud_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '76k',
          ]
        );
        $this->add_control(
            'sound_cloud_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'spotify_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Spotify</b>',
            ]
        );
        $this->add_control(
            'spotify_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'spotify_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '65k',
          ]
        );
        $this->add_control(
            'spotify_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'linkedin_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Linkedin</b>',
            ]
        );
        $this->add_control(
            'linkedin_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'linkedin_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '21k',
          ]
        );
        $this->add_control(
            'linkedin_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'behance_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Behance</b>',
            ]
        );
        $this->add_control(
            'behance_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'behance_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '42k',
          ]
        );
        $this->add_control(
            'behance_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'telegram_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Telegram</b>',
            ]
        );
        $this->add_control(
            'telegram_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'telegram_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '88k',
          ]
        );
        $this->add_control(
            'telegram_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'tumblr_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Tumblr</b>',
            ]
        );
        $this->add_control(
            'tumblr_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'tumblr_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '77k',
          ]
        );
        $this->add_control(
            'tumblr_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'deviantart_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Deviantart</b>',
            ]
        );
        $this->add_control(
            'deviantart_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'deviantart_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '90k',
          ]
        );
        $this->add_control(
            'deviantart_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'dribble_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Dribble</b>',
            ]
        );
        $this->add_control(
            'dribble_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'dribble_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'dribble_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'dropbox_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Dropbox</b>',
            ]
        );
        $this->add_control(
            'dropbox_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'dropbox_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'dropbox_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'rss_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>RSS</b>',
            ]
        );
        $this->add_control(
            'rss_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'rss_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'rss_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'skype_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Skype</b>',
            ]
        );
        $this->add_control(
            'skype_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'skype_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'skype_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'stumbleupon_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Stumbleupon</b>',
            ]
        );
        $this->add_control(
            'stumbleupon_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'stumbleupon_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'stumbleupon_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'wordpress_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>WordPress</b>',
            ]
        );
        $this->add_control(
            'wordpress_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'wordpress_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'wordpress_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'yahoo_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Yahoo</b>',
            ]
        );
        $this->add_control(
            'yahoo_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'yahoo_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'yahoo_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'flickr_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Facebook</b>',
            ]
        );
        $this->add_control(
            'flickr_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'flickr_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'flickr_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'wechat_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>Wechat</b>',
            ]
        );
        $this->add_control(
            'wechat_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'wechat_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'wechat_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );

        $this->add_control(
            'tiktok_info',
            [
                'type' => Controls_Manager::RAW_HTML,
                'separator'    => 'before',
                'raw' => '<b>TikTok</b>',
            ]
        );
        $this->add_control(
            'tiktok_url',
            [
                'label' =>esc_html__( 'Social URL', 'typecase' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );
        $this->add_control(
            'tiktok_count', [
            'label'       => esc_html__( 'Number follow', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => '23k',
          ]
        );
        $this->add_control(
            'tiktok_label', [
            'label'       => esc_html__( 'Label social', 'typecase' ),
            'type'        => Controls_Manager::TEXT,            
            'default'     => 'Followers',
          ]
        );
        
                 

      $this->end_controls_section();      
      //Title Style Section
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'typecase' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     
 
      $this->add_control(
      'vt_sh_layout',
      array(
        'label'       => esc_html__( 'Social layout', 'typecase' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [                        
                        'style1'        => esc_html__( 'Layout with background', 'typecase' ),
                        'style2'        => esc_html__( 'Layout icon background', 'typecase' ),
                        'style3'        => esc_html__( 'Layout border background', 'typecase' ),
                        'style4'        => esc_html__( 'Layout block icon background', 'typecase' ),
                        'style5'        => esc_html__( 'Layout block with background', 'typecase' ),
                        'style6'        => esc_html__( 'Layout only icons', 'typecase' ),
                        'style7'        => esc_html__( 'Layout only icons with background color', 'typecase' ),
                        'style8'        => esc_html__( 'Layout only icons with border', 'typecase' ),
                        'style9'        => esc_html__( 'Layout only icons color', 'typecase' ),
                    ],
        'default'     => 'style1',
      )
    );      
    
    $this->add_control(
        'vt_hscale',
        [
            'label' => esc_html__( 'Hover scale', 'typecase' ),
            'type' => Controls_Manager::SWITCHER,
            'selectors' => [
                '{{WRAPPER}} .vt_sh_ctericons li:hover, {{WRAPPER}} .vt_sh_ctericons_bg li:hover'   => 'transform: scale(1.2) !important;',
                '{{WRAPPER}} .vt_sh_ctericons li, {{WRAPPER}} .vt_sh_ctericons_bg li'   => 'transition: all 0.3s ease 0s !important;',
            ],
            'condition' => [
                'vt_sh_layout'    => ['style6', 'style7', 'style8', 'style9']
            ]
        ]        
    );       

    $this->add_responsive_control(
        'area_alignment',
        [
            'label'   => esc_html__( 'Alignment', 'typecase' ),
            'type'    => Controls_Manager::CHOOSE,
            'options' => [
                'left'    => [
                    'title' => esc_html__( 'Left', 'typecase' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'typecase' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'flex-end' => [
                    'title' => esc_html__( 'Right', 'typecase' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .vt_sh_ctericons'   => 'justify-content: {{VALUE}};',
            ],
            'condition' => [
                'vt_sh_layout'    => ['style6', 'style8', 'style9']
            ]
        ]
    );

    $this->add_responsive_control(
        'slcitems8_size',
        [
            'label' => __( 'Icons width + height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
                'size' => 38,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_ctericons li a .vt_sh_i' => 'width: {{SIZE}}{{UNIT}} !important; height: {{SIZE}}{{UNIT}} !important; display: flex; align-items: center; justify-content: center; border-radius: 100%;',
            ],
            'condition' => [
                'vt_sh_layout'    => ['style8']
            ]
        ]
      );
      
    $this->add_responsive_control(
        'slcicons_size',
        [
            'label' => __( 'Icons font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
                'size' => 16,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_ctericons a' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            '{{WRAPPER}} .vt_sh_t, {{WRAPPER}} .vt_sh_w' => 'display: none !important;',
            '{{WRAPPER}} .vt_sh_ctericons' => 'margin: 0px !important; padding: 0px !important;',
            '{{WRAPPER}} .vt_sh_ctericons li' => 'list-style: none !important;',
            ],
            'condition' => [
                'vt_sh_layout'    => ['style6', 'style8', 'style9']
            ]
        ]
      );

      $this->add_responsive_control(
        'slcicons_sizespace',
        [
            'label' => __( 'Icons space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
                'size' => 13,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_ctericons' => 'gap: {{SIZE}}{{UNIT}} !important; display: flex; flex-wrap: wrap;',            
            ],
            'condition' => [
                'vt_sh_layout'    => ['style6', 'style8', 'style9']
            ]
        ]
      );

      $this->add_control(
        'iconss_color',
        [
          'label' => __( 'Icons color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#000',
          'selectors' => [
              '{{WRAPPER}} .vt_sh_ctericons li a' => 'color: {{VALUE}}',
          ],
          'condition' => [
              'vt_sh_layout'    => ['style6', 'style8']
          ]
        ]
      );
  
      $this->add_control(
        'iconss_color_dark',
        [
          'label' => __( 'Icons color dark mode', 'typecase' ),
          'default' => '#FFF',
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}}  .vt_sh_ctericons li a' => 'color: {{VALUE}}',
          ],
          'condition' => [
              'vt_sh_layout'    => ['style6', 'style8']
          ]
        ]
      );

      $this->add_control(
        'iconss_colorh',
        [
          'label' => __( 'Icons hover color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '',
          'selectors' => [
              '{{WRAPPER}} .vt_sh_ctericons li a:hover' => 'color: {{VALUE}}',
          ],
          'condition' => [
              'vt_sh_layout'    => ['style6', 'style8']
          ]
        ]
      );
  
      $this->add_control(
        'iconss_colorh_dark',
        [
          'label' => __( 'Icons hover color dark mode', 'typecase' ),
          'default' => '',
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}}  .vt_sh_ctericons li a:hover' => 'color: {{VALUE}}',
          ],
          'condition' => [
              'vt_sh_layout'    => ['style6', 'style8']
          ]
        ]
      );

      $this->add_control(
        'border_iconss_color',
        [
          'label' => __( 'Border color', 'typecase' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#f1e9e9',
          'selectors' => [
              '{{WRAPPER}} .vt_sh_ctericons li a .vt_sh_i' => 'border: 1px solid {{VALUE}}',
          ],
          'condition' => [
              'vt_sh_layout'    => ['style8']
          ]
        ]
      );
  
      $this->add_control(
        'border_iconss_color_dark',
        [
          'label' => __( 'Border color dark mode', 'typecase' ),
          'default' => '#5e5e5e',
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}}  .vt_sh_ctericons li a .vt_sh_i' => 'border: 1px solid {{VALUE}}',
          ],
          'condition' => [
              'vt_sh_layout'    => ['style8']
          ]
        ]
      );

      $this->add_responsive_control(
        'area7_alignment',
        [
            'label'   => esc_html__( 'Alignment', 'typecase' ),
            'type'    => Controls_Manager::CHOOSE,
            'options' => [
                'left'    => [
                    'title' => esc_html__( 'Left', 'typecase' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'typecase' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'typecase' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .vt_sh_ctericons_bg'   => 'justify-content: {{VALUE}};',
            ],
            'condition' => [
                'vt_sh_layout'    => ['style7']
            ]
        ]
    );
    
    $this->add_responsive_control(
        'slcitems7_size',
        [
            'label' => __( 'Icons width + height', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
                'size' => 38,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_ctericons_bg li a .vt_sh_i' => 'width: {{SIZE}}{{UNIT}} !important; height: {{SIZE}}{{UNIT}} !important; color: #fff !important; display: flex; align-items: center; justify-content: center; border-radius: 100%;',
            ],
            'condition' => [
                'vt_sh_layout'    => ['style7']
            ]
        ]
      );
    
    $this->add_responsive_control(
        'slcicons7_size',
        [
            'label' => __( 'Icons font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
                'size' => 15,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_ctericons_bg a' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            '{{WRAPPER}} .vt_sh_t, {{WRAPPER}} .vt_sh_w' => 'display: none !important;',
            '{{WRAPPER}} .vt_sh_ctericons_bg' => 'margin: 0px !important; padding: 0px !important;',
            '{{WRAPPER}} .vt_sh_ctericons_bg li' => 'list-style: none !important;',
            ],
            'condition' => [
                'vt_sh_layout'    => ['style7']
            ]
        ]
      );
    
      $this->add_responsive_control(
        'slcicons7_sizespace',
        [
            'label' => __( 'Icons space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
                'size' => 10,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_ctericons_bg' => 'gap: {{SIZE}}{{UNIT}} !important; display: flex; flex-wrap: wrap;',            
            ],
            'condition' => [
                'vt_sh_layout'    => ['style7']
            ]
        ]
      );

      $this->add_responsive_control(
        'vt_item_cols',
        [
            'label' => __( 'Number of columns', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 4,
            ],
            'tablet_default' => [
              'size' => 4,
            ],
            'mobile_default' => [
              'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_cter' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr)) !important;',            
            ],
            'condition' => [
                'vt_sh_layout!'    => ['style6', 'style7', 'style8', 'style9']
            ]
        ]
      );

        $this->add_responsive_control(
        'vt_item_cols_space',
        [
            'label' => __( 'Columns space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_cter' => 'grid-column-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
            'condition' => [
                'vt_sh_layout!'    => ['style6', 'style7', 'style8', 'style9']
            ]
        ]
      );

        $this->add_responsive_control(
        'vt_item_row_space',
        [
            'label' => __( 'Row space', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_cter' => 'grid-row-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
            'condition' => [
                'vt_sh_layout!'    => ['style6', 'style7', 'style8', 'style9']
            ]
        ]
      );      

      $this->add_responsive_control(
        'sltfont_size',
        [
            'label' => __( 'Title font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_cter li a .vt_sh_t' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            ],
            'condition' => [
                'vt_sh_layout!'    => ['style6', 'style7', 'style8', 'style9']
            ]
        ]
      );

      $this->add_responsive_control(
        'slcfont_size',
        [
            'label' => __( 'Counter font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_cter li a .vt_sh_w .vt_sh_c' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            ],
            'condition' => [
                'vt_sh_layout!'    => ['style6', 'style7', 'style8', 'style9']
            ]
        ]
      );

      $this->add_responsive_control(
        'sllfont_size',
        [
            'label' => __( 'Label font size', 'typecase' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .vt_sh_cter li a .vt_sh_w .vt_sh_l' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            ],
            'condition' => [
                'vt_sh_layout!'    => ['style6', 'style7', 'style8', 'style9']
            ]
        ]
      );

    
      $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings_for_display();        
        $vt_sh_layout = $settings['vt_sh_layout'];
        switch ( $vt_sh_layout ) {
            case 'style1':
                $vt_sh_class = 'vt_sh_cter vt_sh1';
            break;
            case 'style2':
                $vt_sh_class = 'vt_sh_cter vt_sh2';
            break;
            case 'style3':
                $vt_sh_class = 'vt_sh_cter vt_sh2 vt2line';
            break;
            case 'style4':
                $vt_sh_class = 'vt_sh_cter vt_sh2 vt2cols';
            break;
            case 'style5':
                $vt_sh_class = 'vt_sh_cter vt_sh1 vt2cols';
            break;
            case 'style6':
                $vt_sh_class = 'vt_sh_ctericons';
            break;
            case 'style7':
                $vt_sh_class = 'vt_sh_ctericons_bg';
            break;
            case 'style8':
                $vt_sh_class = 'vt_sh_ctericons vt_shline';
            break;
            case 'style9':
                $vt_sh_class = 'vt_sh_ctericons vtshcolor';
            break;
        }
        ?>        
        <ul class="<?php echo esc_attr($vt_sh_class);?>">
            <?php if ( ! empty( $settings['facebook_url']['url'] ) ) {
            $this->add_link_attributes( 'facebook_url', $settings['facebook_url'] );
            ?>
            <li class="vt_facebook_url">
                <a aria-label="<?php esc_html_e('facebook', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'facebook_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-facebook"></i></span>
                    <span class="vt_sh_t">Facebook</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['facebook_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['facebook_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['twitter_url']['url'] ) ) {
            $this->add_link_attributes( 'twitter_url', $settings['twitter_url'] );
            ?>
            <li class="vt_twitter_url">
                <a aria-label="<?php esc_html_e('twitter', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'twitter_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-twitter"></i></span>
                    <span class="vt_sh_t">Twitter</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['twitter_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['twitter_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['instagram_url']['url'] ) ) {
            $this->add_link_attributes( 'instagram_url', $settings['instagram_url'] );
            ?>
            <li class="vt_instagram_url">
                <a aria-label="<?php esc_html_e('instagram', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'instagram_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-instagram"></i></span>
                    <span class="vt_sh_t">Instagram</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['instagram_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['instagram_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['pinterest_url']['url'] ) ) {
            $this->add_link_attributes( 'pinterest_url', $settings['pinterest_url'] );
            ?>
            <li class="vt_pinterest_url">
                <a aria-label="<?php esc_html_e('pinterest', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'pinterest_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-pinterest"></i></span>
                    <span class="vt_sh_t">Pinterest</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['pinterest_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['pinterest_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['youtube_url']['url'] ) ) {
            $this->add_link_attributes( 'youtube_url', $settings['youtube_url'] );
            ?>
            <li class="vt_youtube_url">
                <a aria-label="<?php esc_html_e('youtube', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'youtube_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-youtube"></i></span>
                    <span class="vt_sh_t">Youtube</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['youtube_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['youtube_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['vimeo_url']['url'] ) ) {
            $this->add_link_attributes( 'vimeo_url', $settings['vimeo_url'] );
            ?>
            <li class="vt_vimeo_url">
                <a aria-label="<?php esc_html_e('vimeo', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'vimeo_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-vimeo"></i></span>
                    <span class="vt_sh_t">Vimeo</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['vimeo_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['vimeo_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['sound_cloud_url']['url'] ) ) {
            $this->add_link_attributes( 'sound_cloud_url', $settings['sound_cloud_url'] );
            ?>
            <li class="vt_sound_cloud_url">
                <a aria-label="<?php esc_html_e('soundcloud', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'sound_cloud_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-soundcloud"></i></span>
                    <span class="vt_sh_t">SoundCloud</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['sound_cloud_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['sound_cloud_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['spotify_url']['url'] ) ) {
            $this->add_link_attributes( 'spotify_url', $settings['spotify_url'] );
            ?>
            <li class="vt_spotify_url">
                <a aria-label="<?php esc_html_e('spotify', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'spotify_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-spotify"></i></span>
                    <span class="vt_sh_t">Spotify</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['spotify_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['spotify_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['linkedin_url']['url'] ) ) {
            $this->add_link_attributes( 'linkedin_url', $settings['linkedin_url'] );
            ?>
            <li class="vt_linkedin_url">
                <a aria-label="<?php esc_html_e('linkedin', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'linkedin_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-linkedin"></i></span>
                    <span class="vt_sh_t">Linkedin</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['linkedin_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['linkedin_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['behance_url']['url'] ) ) {
            $this->add_link_attributes( 'behance_url', $settings['behance_url'] );
            ?>
            <li class="vt_behance_url">
                <a aria-label="<?php esc_html_e('behance', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'behance_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-behance"></i></span>
                    <span class="vt_sh_t">Behance</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['behance_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['behance_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['telegram_url']['url'] ) ) {
            $this->add_link_attributes( 'telegram_url', $settings['telegram_url'] );
            ?>
            <li class="vt_telegram_url">
                <a aria-label="<?php esc_html_e('telegram', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'telegram_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-telegram"></i></span>
                    <span class="vt_sh_t">Telegram</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['telegram_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['telegram_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['tumblr_url']['url'] ) ) {
            $this->add_link_attributes( 'tumblr_url', $settings['tumblr_url'] );
            ?>
            <li class="vt_tumblr_url">
                <a aria-label="<?php esc_html_e('tumblr', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'tumblr_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-tumblr"></i></span>
                    <span class="vt_sh_t">Tumblr</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['tumblr_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['tumblr_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['deviantart_url']['url'] ) ) {
            $this->add_link_attributes( 'deviantart_url', $settings['deviantart_url'] );
            ?>
            <li class="vt_deviantart_url">
                <a aria-label="<?php esc_html_e('deviantart', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'deviantart_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-deviantart"></i></span>
                    <span class="vt_sh_t">Deviantart</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['deviantart_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['deviantart_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['dribble_url']['url'] ) ) {
            $this->add_link_attributes( 'dribble_url', $settings['dribble_url'] );
            ?>
            <li class="vt_dribble_url">
                <a aria-label="<?php esc_html_e('dribble', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'dribble_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-dribble"></i></span>
                    <span class="vt_sh_t">Dribble</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['dribble_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['dribble_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['dropbox_url']['url'] ) ) {
            $this->add_link_attributes( 'dropbox_url', $settings['dropbox_url'] );
            ?>
            <li class="vt_dropbox_url">
                <a aria-label="<?php esc_html_e('dropbox', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'dropbox_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-dropbox"></i></span>
                    <span class="vt_sh_t">Dropbox</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['dropbox_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['dropbox_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['rss_url']['url'] ) ) {
            $this->add_link_attributes( 'rss_url', $settings['rss_url'] );
            ?>
            <li class="vt_rss_url">
                <a aria-label="<?php esc_html_e('rss', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'rss_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-rss"></i></span>
                    <span class="vt_sh_t">RSS</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['rss_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['rss_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['skype_url']['url'] ) ) {
            $this->add_link_attributes( 'skype_url', $settings['skype_url'] );
            ?>
            <li class="vt_skype_url">
                <a aria-label="<?php esc_html_e('skype', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'skype_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-skype"></i></span>
                    <span class="vt_sh_t">Skype</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['skype_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['skype_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['stumbleupon_url']['url'] ) ) {
            $this->add_link_attributes( 'stumbleupon_url', $settings['stumbleupon_url'] );
            ?>
            <li class="vt_stumbleupon_url">
                <a aria-label="<?php esc_html_e('stumbleupon', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'stumbleupon_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-stumbleupon"></i></span>
                    <span class="vt_sh_t">StumbleUpon</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['stumbleupon_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['stumbleupon_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['wordpress_url']['url'] ) ) {
            $this->add_link_attributes( 'wordpress_url', $settings['wordpress_url'] );
            ?>
            <li class="vt_wordpress_url">
                <a aria-label="<?php esc_html_e('wordpress', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'wordpress_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-wordpress"></i></span>
                    <span class="vt_sh_t">WordPress</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['wordpress_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['wordpress_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['yahoo_url']['url'] ) ) {
            $this->add_link_attributes( 'yahoo_url', $settings['yahoo_url'] );
            ?>
            <li class="vt_yahoo_url">
                <a aria-label="<?php esc_html_e('yahoo', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'yahoo_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-yahoo"></i></span>
                    <span class="vt_sh_t">Yahoo</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['yahoo_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['yahoo_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['flickr_url']['url'] ) ) {
            $this->add_link_attributes( 'flickr_url', $settings['flickr_url'] );
            ?>
            <li class="vt_flickr_url">
                <a aria-label="<?php esc_html_e('flickr', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'flickr_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-flickr"></i></span>
                    <span class="vt_sh_t">Flickr</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['flickr_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['flickr_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>            
            <?php if ( ! empty( $settings['wechat_url']['url'] ) ) {
            $this->add_link_attributes( 'wechat_url', $settings['wechat_url'] );
            ?>
            <li class="vt_wechat_url">
                <a aria-label="<?php esc_html_e('wechat', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'wechat_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-wechat"></i></span>
                    <span class="vt_sh_t">WeChat</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['wechat_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['wechat_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
            <?php if ( ! empty( $settings['tiktok_url']['url'] ) ) {
            $this->add_link_attributes( 'tiktok_url', $settings['tiktok_url'] );
            ?>
            <li class="vt_tiktok_url">
                <a aria-label="<?php esc_html_e('tiktok', 'typecase');?>" <?php echo $this->get_render_attribute_string( 'tiktok_url' ); ?>>
                    <span class="vt_sh_i"><i class="vti-tiktok"></i></span>
                    <span class="vt_sh_t">WeChat</span>
                    <span class="vt_sh_w">
                    <span class="vt_sh_c"><?php echo esc_attr($settings['tiktok_count']);?></span>
                    <span class="vt_sh_l"><?php echo esc_attr($settings['tiktok_label']);?></span>
                    </span>
                </a>
            </li>
            <?php }?>
        </ul>
        <?php
    }   
}