<?php
if ( $product->is_type( 'grouped' ) ) {
	$typecase_badge = '<span class="onsale typecase-badge">' . esc_html__( 'Sale', 'typecase' ) . '</span>';
}elseif( $product->is_type('variable') ) {

		$regularPriceMin = $product->get_variation_regular_price();
		$salePriceMin    = $product->get_variation_sale_price();
		$priceMin        = $product->get_variation_price();

		$regularPriceMax = $product->get_variation_regular_price('max');
		$salePriceMax    = $product->get_variation_sale_price('max');
		$priceMax        = $product->get_variation_price('max');

		$variationsPrices = $product->get_variation_prices();

		$regularPrice = $salePrice = $price = '';
		$variationPrice = [
				'min' => $product->get_variation_price(),
				'max' => $product->get_variation_price('max')
		];

		$typecase_badge = array();
		foreach ( $variationsPrices['price'] as $key => $price ) {
			if ( $variationsPrices['regular_price'][ $key ] !== $price ) {
				$typecase_badge[] = 100 - ( $variationsPrices['sale_price'][ $key ] / $variationsPrices['regular_price'][ $key ] * 100 );
			}
		}
		if( !empty( $typecase_badge ) ){
			$typecase_badge = max( $typecase_badge );
			$typecase_badge = '<span class="onsale typecase-badge">-' . round( (float) $typecase_badge ) . '%</span>';		
		}else{
			$typecase_badge = "";
		}		

}else {
		$regularPrice   = $product->get_regular_price();
		$salePrice      = $product->get_sale_price();
		$price          = $product->get_price();
		$variationPrice = ['min' => '', 'max' => ''];

		if ( $salePrice > 1 ) {
			$typecase_badge = 100 - ( (float) $salePrice / (float) $regularPrice * 100 );
			$typecase_badge = '<span class="onsale typecase-badge">-' . round( (float) $typecase_badge ) . '%</span>';
		}else{
			$typecase_badge = "";
		}
}
// array_push( $productsResults , [
//    'title'          => $product->get_name(),
//    'productId'      => $product->get_id(),
//    'permalink'      => $product->get_permalink(),
//    'thumbnail'      => $product->get_image(),
//    'excerpt'        => $product->get_short_description(),
//    'regularPrice'   => $regularPrice,
//    'price'          => $price,
//    'salePrice'      => $salePrice,
//    // 'category'       => $term_name,
//    'variationPrice' => $variationPrice,
// ]);
?>
<div class="vt_wc_item">
	<div class="vt_wc_item_in">
		<?php if( $thumbnail_id ){ ?>
		<div class="vt_wc_imgw vt_radus_e">
			<div class="vt_wc_imgin">
				<?php
						$image_src = \Elementor\Group_Control_Image_Size::get_attachment_image_src( $thumbnail_id, 'thumbnail_size', $settings );
						echo sprintf( '<img src="%s" title="%s" alt="%s"%s />', esc_attr( $image_src ), get_the_title( $thumbnail_id ), $this->typecase_get_attachment_alt($thumbnail_id), '' );
				?>
			</div>
			<a class="vt_wc_link" aria-label="<?php echo esc_url(get_permalink($product->get_id())); ?>" href="<?php echo esc_url(get_permalink($product->get_id())); ?>"></a>
			<?php echo wp_kses_post($typecase_badge); ?>
			<div class="vt_wc_btnw">
				<?php
							 if ( $product->is_type( 'external' ) ) {
								echo sprintf( '<a href="%s" target="_blank" data-quantity="1" class="%s" %s>%s</a>',
								esc_url( $product->add_to_cart_url() ),
											esc_attr( implode( ' ', array_filter( array(
													'button', 'product_type_' . $product->get_type(),
													$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
													$product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
													'typecase_add_to_cart_btn'
											) ) ) ),
											wc_implode_html_attributes( array(
													'data-product_id'  => $product->get_id(),
													'data-product_sku' => $product->get_sku(),
													'aria-label'       => $product->add_to_cart_description(),
													'rel'              => 'nofollow',
											) ),
											esc_html( $product->add_to_cart_text() )
							);
							 }else{
								echo sprintf( '<a href="%s" data-quantity="1" class="%s" %s>%s</a>',
								esc_url( $product->add_to_cart_url() ),
											esc_attr( implode( ' ', array_filter( array(
													'button', 'product_type_' . $product->get_type(),
													$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
													$product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
													'typecase_add_to_cart_btn'
											) ) ) ),
											wc_implode_html_attributes( array(
													'data-product_id'  => $product->get_id(),
													'data-product_sku' => $product->get_sku(),
													'aria-label'       => $product->add_to_cart_description(),
													'rel'              => 'nofollow',
											) ),
											esc_html( $product->add_to_cart_text() )
							);
							 }							 											
					?>
				</div>
		</div>
		<?php }?>
		<div class="vt_wc_info">
				<h2 class="vt_wc_title"><a href="<?php echo esc_url($product->get_permalink()); ?>"><?php echo wp_kses_post($product->get_title()); ?></a></h2>
					<?php
							// $rating_count = $product->get_rating_count();
							// $review_count = $product->get_review_count();
							// $average = $product->get_average_rating();
							// $product_id = $product->get_id();
							// echo typecase_display_product_rating( $average, $rating_count, $product_id );
						?>
					<div class="vt_wc_price"><?php echo wp_kses_post($product->get_price_html()); ?></div>
		</div>
	</div>
</div>
