<?php
defined('ABSPATH') || die();
include_once( TYPECASE_ADDONS_DIR_PATH . 'inc/woocommerce/init.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'inc/woocommerce/layout.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/recent-large.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/about-us.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/recent-small.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/recent-number.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/slider-post.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/category-widget.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/contact-form-7.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/author.php' );
include_once( TYPECASE_ADDONS_DIR_PATH . 'widget/layout.php' );


function typecase_active_plugin(){
    if (is_plugin_active('typecase-function/typecase-function.php')){
	    update_option('elementor_cpt_support', array('post', 'page', 'vt_layout'));
    }
}
add_action('admin_init', 'typecase_active_plugin');
function typecase_lang() {
    load_plugin_textdomain( 'typecase', FALSE, TYPECASE_ADDONS_DIR_PATH . 'languages/' );
}
add_action( 'init', 'typecase_lang' );
add_filter('wpcf7_autop_or_not', '__return_false');
add_filter( 'widget_text', 'do_shortcode' );

function typecase_theme_init() {
    if ( get_theme_mod( 'disable_widget_block', true )){
        remove_theme_support( 'widgets-block-editor' );
    }
}
add_action( 'after_setup_theme', 'typecase_theme_init', 1 );

function typecase_get_menus(){
    $menus = [];
    $get_menus = wp_get_nav_menus();
    if ( ! empty( $get_menus ) ){
        $menus = wp_list_pluck( $get_menus, 'name', 'slug' );
    }
    return $menus;
}

function typecase_get_all_posts() {
    $options = array();
    $all_posts = get_posts(
        array(
            'posts_per_page'         => -1,
            'post_type'              => array( 'vt_layout' ),
            'update_post_term_cache' => false,
            'update_post_meta_cache' => false,
            'fields'                 => array( 'ids' ),
        )
    );
    if ( ! empty( $all_posts ) && ! is_wp_error( $all_posts ) ) {
        foreach ( $all_posts as $post ) {
            $options[ $post->ID ] = strlen( $post->post_title ) > 30 ? substr( $post->post_title, 0, 30 ) . '...' : $post->post_title;
        }
    }
    return $options;
}

if ( !function_exists( 'typecase_contact_info' ) ){
function typecase_contact_info($contactmethods) {
    $contactmethods['facebook'] = esc_html__( 'Facebook', 'typecase' );
    $contactmethods['twitter'] = esc_html__( 'Twitter', 'typecase' );
    $contactmethods['instagram'] = esc_html__( 'Instagram', 'typecase' );
    $contactmethods['pinterest'] = esc_html__( 'Pinterest', 'typecase' );
    $contactmethods['youtube'] = esc_html__( 'Youtube', 'typecase' );
    $contactmethods['vimeo'] = esc_html__( 'Vimeo', 'typecase' );
    $contactmethods['linkedin'] = esc_html__( 'Linkedin', 'typecase' );
    $contactmethods['behance'] = esc_html__( 'Behance', 'typecase' );
    $contactmethods['deviantart'] = esc_html__( 'DeviantArt', 'typecase' );
    $contactmethods['dribble'] = esc_html__( 'Dribble', 'typecase' );
    $contactmethods['rss'] = esc_html__( 'Rss feed', 'typecase' );
    $contactmethods['tiktok'] = esc_html__( 'TikTok', 'typecase' );    
    $contactmethods['delicious'] = esc_html__( 'Delicious', 'typecase' );
    $contactmethods['digg'] = esc_html__( 'Digg', 'typecase' );
    $contactmethods['dribbble'] = esc_html__( 'Dribbble', 'typecase' );
    $contactmethods['flickr'] = esc_html__( 'Flickr', 'typecase' );
    $contactmethods['github'] = esc_html__( 'Github', 'typecase' );
    $contactmethods['lastfm'] = esc_html__( 'Lastfm', 'typecase' );
    $contactmethods['paypal'] = esc_html__( 'Paypal', 'typecase' );
    $contactmethods['reddit'] = esc_html__( 'Reddit', 'typecase' );
    $contactmethods['skype'] = esc_html__( 'Skype', 'typecase' );
    $contactmethods['share'] = esc_html__( 'Share', 'typecase' );
    $contactmethods['spotify'] = esc_html__( 'Spotify', 'typecase' );
    $contactmethods['stack-exchange'] = esc_html__( 'Stackexchange', 'typecase' );
    $contactmethods['stack-overflow'] = esc_html__( 'Stackoverflow', 'typecase' );
    $contactmethods['steam'] = esc_html__( 'Steam', 'typecase' );
    $contactmethods['stumbleupon'] = esc_html__( 'StumbleUpon', 'typecase' );
    $contactmethods['tumblr'] = esc_html__( 'Tumblr', 'typecase' );
    $contactmethods['vk'] = esc_html__( 'VKontakte', 'typecase' );
    $contactmethods['windows'] = esc_html__( 'Windows', 'typecase' );
    $contactmethods['wordpress'] = esc_html__( 'Woordpress', 'typecase' );
    $contactmethods['yahoo'] = esc_html__( 'Yahoo', 'typecase' );

    return $contactmethods;
}
add_filter('user_contactmethods', 'typecase_contact_info');
}

if ( !function_exists( 'typecase_author_share_link' ) ){
function typecase_author_share_link( $author_id ) {?>
    <ul class="vt_auth_link clearfix">
    <?php if ((get_the_author_meta('url')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('url')); ?>" target="_blank" rel="nofollow"><i class="vti-globe"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('facebook')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('facebook')); ?>" target="_blank" rel="nofollow"><i class="vti-facebook"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('twitter')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('twitter')); ?>" target="_blank" rel="nofollow"><i class="vti-twitter"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('instagram')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('instagram')); ?>" target="_blank" rel="nofollow"><i class="vti-instagram"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('pinterest')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('pinterest')); ?>" target="_blank" rel="nofollow"><i class="vti-pinterest"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('youtube')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('youtube')); ?>" target="_blank" rel="nofollow"><i class="vti-youtube"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('vimeo')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('vimeo')); ?>" target="_blank" rel="nofollow"><i class="vti-vimeo"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('linkedin')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('linkedin')); ?>" target="_blank" rel="nofollow"><i class="vti-linkedin"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('behance')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('behance')); ?>" target="_blank" rel="nofollow"><i class="vti-behance"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('deviantart')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('deviantart')); ?>" target="_blank" rel="nofollow"><i class="vti-deviantart"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('dribble')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('dribble')); ?>" target="_blank" rel="nofollow"><i class="vti-dribble"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('rss')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('rss')); ?>" target="_blank" rel="nofollow"><i class="vti-rss"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('tiktok')) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('tiktok')); ?>" target="_blank" rel="nofollow"><i class="vti-tiktok"></i></a></li>
    <?php }?>

    
    <?php if ((get_the_author_meta('delicious')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('delicious')); ?>" target="_blank" rel="nofollow"><i class="vti-delicious"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('digg')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('digg')); ?>" target="_blank" rel="nofollow"><i class="vti-digg"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('dribbble')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('dribbble')); ?>" target="_blank" rel="nofollow"><i class="vti-dribble"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('flickr')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('flickr')); ?>" target="_blank" rel="nofollow"><i class="vti-flickr"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('github')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('github')); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" data-name="Layer 1" viewBox="2 2.25 20 19.51"><path d="M12,2.2467A10.00042,10.00042,0,0,0,8.83752,21.73419c.5.08752.6875-.21247.6875-.475,0-.23749-.01251-1.025-.01251-1.86249C7,19.85919,6.35,18.78423,6.15,18.22173A3.636,3.636,0,0,0,5.125,16.8092c-.35-.1875-.85-.65-.01251-.66248A2.00117,2.00117,0,0,1,6.65,17.17169a2.13742,2.13742,0,0,0,2.91248.825A2.10376,2.10376,0,0,1,10.2,16.65923c-2.225-.25-4.55-1.11254-4.55-4.9375a3.89187,3.89187,0,0,1,1.025-2.6875,3.59373,3.59373,0,0,1,.1-2.65s.83747-.26251,2.75,1.025a9.42747,9.42747,0,0,1,5,0c1.91248-1.3,2.75-1.025,2.75-1.025a3.59323,3.59323,0,0,1,.1,2.65,3.869,3.869,0,0,1,1.025,2.6875c0,3.83747-2.33752,4.6875-4.5625,4.9375a2.36814,2.36814,0,0,1,.675,1.85c0,1.33752-.01251,2.41248-.01251,2.75,0,.26251.1875.575.6875.475A10.0053,10.0053,0,0,0,12,2.2467Z"></path></svg></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('lastfm')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('lastfm')); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="0.4 0.4 19.2 19.2"><path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6 9.6-4.298 9.6-9.6S15.302.4 10 .4zm2.644 12.43c-2.002 0-2.697-.91-3.066-2.043l-.371-1.166c-.277-.851-.501-1.467-1.519-1.467-.706 0-1.626.463-1.626 1.898 0 1.119.77 1.82 1.568 1.82.677 0 1.084-.381 1.296-.572l.354 1.012c-.241.174-.734.517-1.707.517-1.346 0-2.625-.957-2.625-2.73 0-1.844 1.333-2.93 2.705-2.93 1.54 0 2.113.56 2.6 2.078l.382 1.166c.278.852.865 1.471 2.034 1.471.787 0 1.204-.176 1.204-.607 0-.338-.197-.584-.787-.723l-.787-.188c-.961-.232-1.343-.734-1.343-1.529 0-1.271 1.018-1.668 2.061-1.668 1.181 0 1.898.432 1.99 1.482l-1.157.139c-.046-.5-.347-.711-.903-.711-.509 0-.821.234-.821.631 0 .35.15.559.66.676l.74.164c.995.233 1.528.723 1.528 1.668-.001 1.169-.974 1.612-2.41 1.612z"></path></svg></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('paypal')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('paypal')); ?>" target="_blank" rel="nofollow"><i class="vti-paypal"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('reddit')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('reddit')); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="0 2 16.07 13"><path d="m6 9.5-.5-.001V9.5zM10.5 9.5h.5l-.5-.001z"></path><path d="M16.07 8c0-1.103-.897-2-2-2-.441 0-.86.144-1.202.405-1.116-.775-2.578-1.237-4.133-1.354l.839-1.968 2.441.57C12.093 4.408 12.725 5 13.5 5c.827 0 1.5-.673 1.5-1.5S14.327 2 13.5 2c-.524 0-.985.271-1.253.68l-2.853-.667a.5.5 0 0 0-.575.291l-1.16 2.72c-1.679.058-3.279.531-4.487 1.355A2.002 2.002 0 0 0 0 8a1.98 1.98 0 0 0 1.011 1.731A2.978 2.978 0 0 0 1 10c0 2.757 3.14 5 7 5 3.859 0 7-2.243 7-5 0-.078-.003-.155-.008-.232A1.98 1.98 0 0 0 16.07 8zM13.5 3a.5.5 0 1 1-.002 1.002A.5.5 0 0 1 13.5 3zm-9 6.5c0-.551.449-1 1-1s1 .449 1 1a1.001 1.001 0 0 1-2 0zm5.809 3.317a3.936 3.936 0 0 1-4.618 0 .5.5 0 1 1 .586-.81 2.933 2.933 0 0 0 3.446 0 .5.5 0 1 1 .586.81zM10.5 10.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z"></path></svg></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('skype')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('skype')); ?>" target="_blank" rel="nofollow"><i class="vti-skype"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('share')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('share')); ?>" target="_blank" rel="nofollow"><i class="vti-sharethis"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('spotify')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('spotify')); ?>" target="_blank" rel="nofollow"><i class="vti-spotify"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('stack-exchange')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('stack-exchange')); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="8.66 6 22.68 28"><path d="M31.34 24.53A4.32 4.32 0 0 1 27 28.68h-1.24L20.45 34v-5.32H13a4.32 4.32 0 0 1-4.32-4.15ZM27 6H13a4.32 4.32 0 0 0-4.3 3.74h22.6A4.32 4.32 0 0 0 27 6ZM8.66 11.57v4.65h22.68v-4.65Zm0 11.13h22.68v-4.65H8.66Z"></path></svg></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('stack-overflow')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('stack-overflow')); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="0 0 20.28 24"><path d="m17.12 21.857h-14.977v-6.428h-2.143v8.571h19.259v-8.571h-2.139zm-12.616-7.018.442-2.102 10.486 2.21-.442 2.09zm1.379-5.009.898-1.955 9.71 4.54-.898 1.942zm2.692-4.768 1.366-1.647 8.218 6.87-1.366 1.647zm5.313-5.062 6.388 8.585-1.716 1.286-6.386-8.585zm-9.616 19.701v-2.13h10.714v2.13z"></path></svg></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('steam')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('steam')); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="4.83 4.79 38.24 38.42"><path d="M24 4.79A19.21 19.21 0 0 0 4.83 22.32l10 4.24a5.65 5.65 0 0 1 3.89-1l4.57-6.79a7 7 0 1 1 7.15 7.5l-6.66 4.31a4.44 4.44 0 0 1 0 .63 5.68 5.68 0 0 1-11.32.67l-7.18-3A19.21 19.21 0 1 0 24 4.79Z"></path><path d="M30.28 24a4.74 4.74 0 1 0-4.73-4.74A4.74 4.74 0 0 0 30.28 24zm0-8.41a3.67 3.67 0 1 1-3.67 3.67 3.67 3.67 0 0 1 3.67-3.67zM18.18 27h-.42a4.49 4.49 0 0 0-1.16.29l.75.32 1.45.61A2.88 2.88 0 0 1 20.33 32a2.83 2.83 0 0 1-1.63 1.57 2.86 2.86 0 0 1-2.15 0l-2.28-1a4.18 4.18 0 0 0 8.12-1.07v-.32A4.2 4.2 0 0 0 18.18 27z"></path></svg></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('stumbleupon')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('stumbleupon')); ?>" target="_blank" rel="nofollow"><i class="vti-stumbleupon"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('tumblr')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('tumblr')); ?>" target="_blank" rel="nofollow"><i class="vti-tumblr"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('vk')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('vk')); ?>" target="_blank" rel="nofollow"><i class="vti-vk"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('windows')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('windows')); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="2 2 20 20"><path d="M22 2 11.2 3.6v8l10.8-.1V2zM10.2 12.5 2 12.4v6.8l8.1 1.1.1-7.8zM2 4.8v6.8h8.1V3.7L2 4.8zm9.1 7.7v7.9L22 22v-9.4l-10.9-.1z"></path></svg></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('wordpress')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('wordpress')); ?>" target="_blank" rel="nofollow"><i class="vti-wordpress"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('yahoo')) != ''){ ?>
        <li><a href="<?php echo esc_url(get_the_author_meta('yahoo')); ?>" target="_blank" rel="nofollow"><i class="vti-yahoo"></i></a></li>
    <?php }?>


    </ul>
<?php }}

if ( !function_exists( 'typecase_author_list_share' ) ){
function typecase_author_list_share( $author_id ) {?>
    <ul class="vt_auth_link clearfix">
    <?php if ((get_the_author_meta('url', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('url', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-globe"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('facebook', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('facebook', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-facebook"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('twitter', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('twitter', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-twitter"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('instagram', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('instagram', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-instagram"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('pinterest', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('pinterest', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-pinterest"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('youtube', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('youtube', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-youtube"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('vimeo', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('vimeo', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-vimeo"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('linkedin', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('linkedin', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-linkedin"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('behance', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('behance', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-behance"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('deviantart', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('deviantart', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-deviantart"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('dribble', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('dribble', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-dribble"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('rss', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('rss', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-rss"></i></a></li>
    <?php }?>
    <?php if ((get_the_author_meta('tiktok', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('tiktok', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-tiktok"></i></a></li>
    <?php }?>

    <?php if ((get_the_author_meta('delicious', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('delicious', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-delicious"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('digg', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('digg', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-digg"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('dribbble', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('dribbble', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-dribble"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('flickr', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('flickr', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-flickr"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('github', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('github', $author_id)); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" data-name="Layer 1" viewBox="2 2.25 20 19.51"><path d="M12,2.2467A10.00042,10.00042,0,0,0,8.83752,21.73419c.5.08752.6875-.21247.6875-.475,0-.23749-.01251-1.025-.01251-1.86249C7,19.85919,6.35,18.78423,6.15,18.22173A3.636,3.636,0,0,0,5.125,16.8092c-.35-.1875-.85-.65-.01251-.66248A2.00117,2.00117,0,0,1,6.65,17.17169a2.13742,2.13742,0,0,0,2.91248.825A2.10376,2.10376,0,0,1,10.2,16.65923c-2.225-.25-4.55-1.11254-4.55-4.9375a3.89187,3.89187,0,0,1,1.025-2.6875,3.59373,3.59373,0,0,1,.1-2.65s.83747-.26251,2.75,1.025a9.42747,9.42747,0,0,1,5,0c1.91248-1.3,2.75-1.025,2.75-1.025a3.59323,3.59323,0,0,1,.1,2.65,3.869,3.869,0,0,1,1.025,2.6875c0,3.83747-2.33752,4.6875-4.5625,4.9375a2.36814,2.36814,0,0,1,.675,1.85c0,1.33752-.01251,2.41248-.01251,2.75,0,.26251.1875.575.6875.475A10.0053,10.0053,0,0,0,12,2.2467Z"></path></svg></a></li>
<?php }?>
<?php if ((get_the_author_meta('lastfm', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('lastfm', $author_id)); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="0.4 0.4 19.2 19.2"><path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6 9.6-4.298 9.6-9.6S15.302.4 10 .4zm2.644 12.43c-2.002 0-2.697-.91-3.066-2.043l-.371-1.166c-.277-.851-.501-1.467-1.519-1.467-.706 0-1.626.463-1.626 1.898 0 1.119.77 1.82 1.568 1.82.677 0 1.084-.381 1.296-.572l.354 1.012c-.241.174-.734.517-1.707.517-1.346 0-2.625-.957-2.625-2.73 0-1.844 1.333-2.93 2.705-2.93 1.54 0 2.113.56 2.6 2.078l.382 1.166c.278.852.865 1.471 2.034 1.471.787 0 1.204-.176 1.204-.607 0-.338-.197-.584-.787-.723l-.787-.188c-.961-.232-1.343-.734-1.343-1.529 0-1.271 1.018-1.668 2.061-1.668 1.181 0 1.898.432 1.99 1.482l-1.157.139c-.046-.5-.347-.711-.903-.711-.509 0-.821.234-.821.631 0 .35.15.559.66.676l.74.164c.995.233 1.528.723 1.528 1.668-.001 1.169-.974 1.612-2.41 1.612z"></path></svg></a></li>
<?php }?>
<?php if ((get_the_author_meta('paypal', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('paypal', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-paypal"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('reddit', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('reddit', $author_id)); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="0 2 16.07 13"><path d="m6 9.5-.5-.001V9.5zM10.5 9.5h.5l-.5-.001z"></path><path d="M16.07 8c0-1.103-.897-2-2-2-.441 0-.86.144-1.202.405-1.116-.775-2.578-1.237-4.133-1.354l.839-1.968 2.441.57C12.093 4.408 12.725 5 13.5 5c.827 0 1.5-.673 1.5-1.5S14.327 2 13.5 2c-.524 0-.985.271-1.253.68l-2.853-.667a.5.5 0 0 0-.575.291l-1.16 2.72c-1.679.058-3.279.531-4.487 1.355A2.002 2.002 0 0 0 0 8a1.98 1.98 0 0 0 1.011 1.731A2.978 2.978 0 0 0 1 10c0 2.757 3.14 5 7 5 3.859 0 7-2.243 7-5 0-.078-.003-.155-.008-.232A1.98 1.98 0 0 0 16.07 8zM13.5 3a.5.5 0 1 1-.002 1.002A.5.5 0 0 1 13.5 3zm-9 6.5c0-.551.449-1 1-1s1 .449 1 1a1.001 1.001 0 0 1-2 0zm5.809 3.317a3.936 3.936 0 0 1-4.618 0 .5.5 0 1 1 .586-.81 2.933 2.933 0 0 0 3.446 0 .5.5 0 1 1 .586.81zM10.5 10.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z"></path></svg></a></li>
<?php }?>
<?php if ((get_the_author_meta('skype', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('skype', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-skype"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('share', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('share', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-sharethis"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('spotify', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('spotify', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-spotify"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('stack-exchange', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('stack-exchange', $author_id)); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="8.66 6 22.68 28"><path d="M31.34 24.53A4.32 4.32 0 0 1 27 28.68h-1.24L20.45 34v-5.32H13a4.32 4.32 0 0 1-4.32-4.15ZM27 6H13a4.32 4.32 0 0 0-4.3 3.74h22.6A4.32 4.32 0 0 0 27 6ZM8.66 11.57v4.65h22.68v-4.65Zm0 11.13h22.68v-4.65H8.66Z"></path></svg></a></li>
<?php }?>
<?php if ((get_the_author_meta('stack-overflow', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('stack-overflow', $author_id)); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="0 0 20.28 24"><path d="m17.12 21.857h-14.977v-6.428h-2.143v8.571h19.259v-8.571h-2.139zm-12.616-7.018.442-2.102 10.486 2.21-.442 2.09zm1.379-5.009.898-1.955 9.71 4.54-.898 1.942zm2.692-4.768 1.366-1.647 8.218 6.87-1.366 1.647zm5.313-5.062 6.388 8.585-1.716 1.286-6.386-8.585zm-9.616 19.701v-2.13h10.714v2.13z"></path></svg></a></li>
<?php }?>
<?php if ((get_the_author_meta('steam', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('steam', $author_id)); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="4.83 4.79 38.24 38.42"><path d="M24 4.79A19.21 19.21 0 0 0 4.83 22.32l10 4.24a5.65 5.65 0 0 1 3.89-1l4.57-6.79a7 7 0 1 1 7.15 7.5l-6.66 4.31a4.44 4.44 0 0 1 0 .63 5.68 5.68 0 0 1-11.32.67l-7.18-3A19.21 19.21 0 1 0 24 4.79Z"></path><path d="M30.28 24a4.74 4.74 0 1 0-4.73-4.74A4.74 4.74 0 0 0 30.28 24zm0-8.41a3.67 3.67 0 1 1-3.67 3.67 3.67 3.67 0 0 1 3.67-3.67zM18.18 27h-.42a4.49 4.49 0 0 0-1.16.29l.75.32 1.45.61A2.88 2.88 0 0 1 20.33 32a2.83 2.83 0 0 1-1.63 1.57 2.86 2.86 0 0 1-2.15 0l-2.28-1a4.18 4.18 0 0 0 8.12-1.07v-.32A4.2 4.2 0 0 0 18.18 27z"></path></svg></a></li>
<?php }?>
<?php if ((get_the_author_meta('stumbleupon', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('stumbleupon', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-stumbleupon"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('tumblr', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('tumblr', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-tumblr"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('vk', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('vk', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-vk"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('windows', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('windows', $author_id)); ?>" target="_blank" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" fill="currentColor" viewBox="2 2 20 20"><path d="M22 2 11.2 3.6v8l10.8-.1V2zM10.2 12.5 2 12.4v6.8l8.1 1.1.1-7.8zM2 4.8v6.8h8.1V3.7L2 4.8zm9.1 7.7v7.9L22 22v-9.4l-10.9-.1z"></path></svg></a></li>
<?php }?>
<?php if ((get_the_author_meta('wordpress', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('wordpress', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-wordpress"></i></a></li>
<?php }?>
<?php if ((get_the_author_meta('yahoo', $author_id)) != ''){ ?>
    <li><a href="<?php echo esc_url(get_the_author_meta('yahoo', $author_id)); ?>" target="_blank" rel="nofollow"><i class="vti-yahoo"></i></a></li>
<?php }?>
    </ul>
<?php }}

// if( !function_exists('typecase_get_product_lists') ){
// 	function typecase_get_product_lists(){
// 		$product_lists = array();
// 		$args = array(
// 			'numberposts'=>-1,
// 			'return' => 'ids',
// 		);
// 		$products_lists = wc_get_products($args);
// 		if( is_array($products_lists) && !empty($products_lists) ){
// 			foreach( $products_lists as $index=>$id ){
// 				$product_lists[$id] = get_the_title($id);
// 			}
// 		}
// 		 return $product_lists;
// 	}
// }

// function typecase_display_product_rating( $average, $rating_count, $id ) {
//     if ( 0 == $average ) {
// 		$html  = '<div class="star-rating">';
// 		$html .= wc_get_star_rating_html( $average, $rating_count );
// 		$html .= '</div>';
// 		return $html;
// 	}else{
// 		return wc_get_rating_html( $average, $rating_count );
// 	}
// }

function typecase_post_type_layout() {
	$labels = array(
    	'name'                => _x('Layouts', 'post type general name', 'typecase'),
    	'singular_name'       => _x('Layout', 'post type singular name', 'typecase'),
    	'add_new'             => _x('Add New Layout', 'typecase'),
    	'add_new_item'        => __('Add New Layout', 'typecase'),
    	'edit_item'           => __('Edit Layout', 'typecase'),
    	'new_item'            => __('New Layout', 'typecase'),
    	'view_item'           => __('View Layout', 'typecase'),
    	'search_items'        => __('Search Layout', 'typecase'),
    	'not_found'           =>  __('No Layout found', 'typecase'),
    	'not_found_in_trash'  => __('No Layout found in Trash', 'typecase'), 
    	'parent_item_colon'   => ''
	);		
	$args = array(
    	'labels'              => $labels,
    	'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true, 
        'query_var' => true,
        'rewrite' => true,        
        'hierarchical' => false,
        'show_in_nav_menus' => false,
        'show_in_admin_bar' => true,        
        'exclude_from_search' => true,
        'menu_position' => 20,
        'capability_type' => 'post',
    	'supports'            => array('title', 'editor'),
    	'menu_icon'           => 'dashicons-align-center'
	); 		
	register_post_type( 'vt_layout', $args );
} 
add_action('init', 'typecase_post_type_layout');
function typecase_e_layout_add_column( $columns ) {
    $columns['vt_e_layouts'] = esc_html__( 'Layout Shortcode', 'typecase' );
    return $columns;
}
add_filter( 'manage_vt_layout_posts_columns', 'typecase_e_layout_add_column' );
function typecase_e_column_shortcode_content( $column, $post_id ) {
    if ( 'vt_e_layouts' === $column ) {
        echo '<input type="text" class="widefat" value=\'[vt_layout id="' . $post_id . '"]\' readonly="">';
    }
}
add_action( 'manage_vt_layout_posts_custom_column', 'typecase_e_column_shortcode_content', 10, 2 );
function typecase_add_shortcode() {
    add_meta_box(
        'typecase-meta-shortcode',
        esc_html__( 'Layout Shortcode', 'typecase' ),
        'typecase_meta_shortcode',
        'vt_layout',
        'side',
        'high'
    );
}
add_action( 'add_meta_boxes', 'typecase_add_shortcode' );
function typecase_meta_shortcode( $post ) { ?>    
    <input type='text' class='widefat' value='[vt_layout id="<?php echo $post->ID; ?>"]' readonly="">
    <?php
}
if ( ! function_exists( 'typecase_render_ecss' ) ) {
	function typecase_render_ecss() {
		if ( ! class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
			return;
		}
		$template_ids = array();
        $elayout = get_posts( array(
            'post_type'      => 'vt_layout',
            'posts_per_page' => -1,      
            'fields'         => 'ids',
            'meta_query' => array(
                array(
                    'key'   => 'vt_erender',
                    'value' => 'on',
                )
            )
            )
        );
        if( !empty( $elayout ) ){
            $template_ids = $elayout;
        }

		if ( ! empty( $template_ids ) ) {
			foreach ( $template_ids as $template_id ) {
				$css_file = new \Elementor\Core\Files\CSS\Post( $template_id );
				$css_file->enqueue();
			}
		}
	}
}
add_action( 'wp_enqueue_scripts', 'typecase_render_ecss', 500 );

add_shortcode( 'vt_layout', 'typecase_e_template' );
function typecase_e_template( $atts ) {
    if(!empty($atts)){
        if (did_action('elementor/loaded')) {
            return \Elementor\Plugin::$instance->frontend->get_builder_content("{$atts['id']}");
        }else{
            $args = array(
                'post_type'     => 'vt_layout',
                'post_status'   => array( 'publish' ),
                'include'   => $atts['id'],            
        );
        $megamenus = get_posts($args);
        if(!empty($megamenus)){
            foreach ($megamenus as $megamenu){
                return $megamenu->post_content;
            }
            }
        }
    }
}

function typecase_og_title() {
    if ( is_singular() ) {
        return get_the_title();
    }
    return wp_get_document_title();
}

function typecase_og_permalink() {
    if ( is_singular() ) {
        return get_permalink();
    }
    global $wp;
    return home_url( add_query_arg( array(), $wp->request ) );
}
function typecase_meta_head() {
	if ( !empty( get_theme_mod( 'vt_opt_seo' ) ) ) {
		return;
	}
	if ( is_singular() ) {
		global $post;
		$image = get_the_post_thumbnail_url( $post, 'large' );
	}
	if ( empty( $image ) ) {
		$image = get_theme_mod( 'typecase_seo_img' );
		if ( empty( $image ) ) {
			$image = get_site_icon_url();
		}
	}		
	?>
	<?php if ( is_front_page() ) {?>
    <meta name="description" content="<?php echo get_bloginfo( 'description' ); ?>">
    <?php } elseif ( is_singular( 'post' ) ) {?>    
    <meta name="description" content="<?php echo wp_strip_all_tags(get_the_excerpt()); ?>">
    <?php }?>    
    <?php if ( ! empty( $image ) ) { ?>
    <meta property="og:image" content="<?php echo esc_url( $image ); ?>">    
    <?php }?>    
    <meta property="og:title" content="<?php echo typecase_og_title(); ?>">
    <meta property="og:url" content="<?php echo typecase_og_permalink(); ?>">
    <meta property="og:site_name" content="<?php echo get_bloginfo( 'name' ); ?>">	
    <?php if ( is_front_page() ) { ?>
    <meta property="og:description" content="<?php echo get_bloginfo( 'description' ); ?>"/>
    <?php } elseif ( is_singular( 'post' ) ) {?>
    <meta property="og:description" content="<?php echo wp_strip_all_tags(get_the_excerpt()); ?>" />
	<?php }?>
    <?php if ( ! empty( get_theme_mod( 'vt_seo_fb_app_id' ) ) ) { ?>
    <meta property="fb:facebook_app_id" content="<?php echo esc_attr( get_theme_mod( 'vt_seo_fb_app_id' ) ); ?>"/>
    <?php }
    if ( is_singular() ) { ?>
	<meta property="og:type" content="article"/>
    <meta property="article:published_time" content="<?php echo gmdate( 'c', strtotime( $post->post_date_gmt ) ); ?>"/>
    <meta property="article:modified_time" content="<?php echo gmdate( 'c', strtotime( $post->post_modified_gmt ) ); ?>"/>
    <meta name="author" content="<?php the_author_meta( 'display_name', $post->post_author ); ?>"/>
    <meta name="twitter:card" content="summary_large_image"/>
    <meta name="twitter:creator" content="<?php echo '@' . get_theme_mod( 'vt_seo_twiter_name','envato' ); ?>"/>
    <?php if ( ! empty( get_theme_mod( 'vt_seo_twiter_label','Written by' ) ) ) { ?>
    <meta name="twitter:label1" content="<?php echo get_theme_mod( 'vt_seo_twiter_label','Written by' ); ?>"/>
    <?php }?>
    <meta name="twitter:data1" content="<?php the_author_meta( 'display_name', $post->post_author ); ?>"/>
	<?php
    }
}
add_action( 'wp_head', 'typecase_meta_head', 10 );

function typecase_bac_PostViews($post_ID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($post_ID, $count_key, true);
    if($count == ''){
        $count = 0; // set the counter to zero.
        delete_post_meta($post_ID, $count_key);
        add_post_meta($post_ID, $count_key, '0');
        $input = number_format($count);
        $input_count = substr_count($input, ',');
        if($input_count != '0'){
        if($input_count == '1'){
   return ''.round($count/1000, 1) .'k';
        } else if($input_count == '2'){
   return ''.round($count/1000000, 1) .'k';
        } else if($input_count == '3'){
   return substr($input, 0,  -12).'bil';
        } else {
   return;
        }
    } else {
        return ''.$input;
    }

    }else{
        $count++;
        update_post_meta($post_ID, $count_key, $count);
        if($count == '1'){
        //return '<i class="icon-vt_fire"></i>'.$count;
        $input = number_format($count);
        $input_count = substr_count($input, ',');
        if($input_count != '0'){
        if($input_count == '1'){
   return ''.round($count/1000, 1) .'k';
        } else if($input_count == '2'){
   return ''.round($count/1000000, 1) .'k';
        } else if($input_count == '3'){
   return substr($input, 0,  -12).'bil';
        } else {
   return;
        }
    } else {
        return ''.$input;
    }

        }
        else {
        //return '<i class="icon-vt_fire"></i>'.$count;
        $input = number_format($count);
        $input_count = substr_count($input, ',');
        if($input_count != '0'){
        if($input_count == '1'){
   return ''.round($count/1000, 1) .'k';
        } else if($input_count == '2'){
   return ''.round($count/1000000, 1) .'k';
        } else if($input_count == '3'){
   return substr($input, 0,  -12).'bil';
        } else {
   return;
        }
    } else {
        return ''.$input;
    }

        }
    }
}

function typecase_get_PostViews($post_ID){
    $count_key = 'post_views_count';

    $count = get_post_meta($post_ID, $count_key, true);
    if($count){
    $input = number_format($count);
    $input_count = substr_count($input, ',');
    if($input_count != '0'){
        if($input_count == '1'){
   return round($count/1000, 1) .'k';
        } else if($input_count == '2'){
   return round($count/1000000, 1) .'k';
        } else if($input_count == '3'){
   return substr($input, 0,  -12).'bil';
        } else {
   return;
        }
    } else {
        return $input;
    }
    }else{
        return 0;
    }
    //return $count;
}
function typecase_post_column_views($newcolumn){
    $newcolumn['post_views'] = esc_html__('Views', 'typecase');
    return $newcolumn;
}

function typecase_post_custom_column_views($column_name, $id){
    if($column_name === 'post_views'){
        echo typecase_get_PostViews(get_the_ID());
    }
}
add_filter('manage_post_posts_columns', 'typecase_post_column_views');
add_action('manage_post_posts_custom_column', 'typecase_post_custom_column_views',10,2);

function typecase_admin_action(){
    if(isset($_REQUEST['vt_license_key']) && $_REQUEST['action_code'] == 'theme_activate_license'){
        if(!empty($_REQUEST['vt_license_key']) && strlen($_REQUEST['vt_license_key']) == 36) {
               $url = TYPECASE_API;
               $data = array(
                   'purchase_code' => $_REQUEST['vt_license_key'],
                   'author' => 'Visionvative',
                   'item_main' => TYPECASE_ID
               );
               $data = wp_json_encode( $data );
               $args = array(
                   'method'    => 'POST',
                   'sslverify'   => false,
                   'httpversion' => '1.0',
                   'data_format' => 'body',
                   'timeout'     => 60,
                   'redirection' => 5,
                   'blocking'    => true,
                   'body'      => $data,
               );
               $response = wp_remote_post( $url, $args );
               $response_body = wp_remote_retrieve_body( $response );
               $au_id = json_decode($response_body);
               typecase_pcheck($_REQUEST['vt_license_key'], $au_id);
               wp_redirect(admin_url()."admin.php?page=vtwelcome.php&purchase_code=".$_REQUEST['vt_license_key']);
               die;
        }
    }
    typecase_is_pcode();
    add_menu_page('Typecase', 'Typecase', 'administrator', 'vtwelcome.php', 'typecase_welcome_pages', '', 3);
}
add_action('admin_menu', 'typecase_admin_action');
function typecase_pcheck($p_code = '', $au_id = ''){
    if(isset($_REQUEST['vt_license_key']) && $_REQUEST['action_code'] == 'theme_activate_license'){
    $url = "https://api.envato.com/v3/market/author/sale?code=" . $p_code;
    $curl = curl_init($url);
    $bearer   = 'bearer ' . $au_id;
    $header   = array();
    $header[] = 'Content-length: 0';
    $header[] = 'Content-type: application/json; charset=utf-8';
    $header[] = 'Authorization: ' . $bearer;
    $verify_url = 'https://api.envato.com/v1/market/private/user/verify-purchase:' . $p_code . '.json';
    $ch_verify = curl_init($verify_url . '?code=' . $p_code);
    curl_setopt($ch_verify, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch_verify, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch_verify, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch_verify, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch_verify, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
    $cinit_verify_data = curl_exec($ch_verify);
    curl_close($ch_verify);
    $response = json_decode($cinit_verify_data, true);
    $item_name = $response['verify-purchase']['item_name'];
    if (empty($item_name)) {
        delete_option( "item_code_".TYPECASE_ID,'');
        return false;
    }else{
        update_option("item_code_".TYPECASE_ID, $p_code);
        return true;
    }
    }
}
if(!function_exists('typecase_is_registered')){
    function typecase_is_registered() {
        $typecase_is_registered = get_option("item_code_".TYPECASE_ID);
        if(!empty($typecase_is_registered)) {
            return $typecase_is_registered;
        }else {
            // return false;
            return true;
        }
    }
}
if(!function_exists('typecase_is_pcode')){
    function typecase_is_pcode() {
        $typecase_is_pcode = get_option("item_code_".TYPECASE_ID);
        if(!empty($typecase_is_pcode)) {
   if(strlen($typecase_is_pcode) == 36) {
       return false;
   }else{
       update_option("item_code_".TYPECASE_ID, '');
   }
        }
        else {
   return false;
        }
    }
}
function typecase_welcome_pages() {?>
    <div class="clear"></div>
    <div class="wrap-theside vt-admin-pro-wrap">
        <div class="wrap vt-admin-pro-inner theside-page-welcome about-wrap">
   <div class="vt-admin-nav-wrap">
       <ul>
           <li><a class="active-nav" href="<?php echo esc_url( admin_url( 'admin.php?page=vtwelcome.php' ) ); ?>"><?php esc_html_e("Activation Theme", 'typecase');?></a></li>
           <li><a href="<?php echo esc_url( admin_url( 'admin.php?page=radium_demo_installer' ) ); ?>"><?php esc_html_e("Import Demo", 'typecase');?></a></li>
       </ul>
       <a class="vt-doc-nav" href="<?php echo esc_url( 'https://docs.visionvative.com/typecase' ); ?>" target="_blank" rel="nofollow"><?php esc_html_e("Documentations", 'typecase');?></a>
   </div>
   <div class="wrap-vt-heading">
   <p class="vt-name-wrap"><?php echo TYPECASE_THEMENAME; ?><span>Version <?php echo wp_get_theme()->get( 'Version' );?></span></p>
  
        </div>
   <div class="vt-wrap-from">
   <div class="vt-ac-form">
       <?php
       $purchase_code = '';
       if(get_option("item_code_".TYPECASE_ID) && !empty(get_option("item_code_".TYPECASE_ID))) {
           $purchase_code = get_option("item_code_".TYPECASE_ID);
       }
       $typecase_is_registered = false;
       $typecase_is_registered = typecase_is_registered();
       if($typecase_is_registered){
           echo '<h3 class="vt-ac-sucess">Thanks for the purchase!</h3>';
       }else{
           echo '<h3 class="vt-ac-failed">Please Verify Your Theme!</h3>';
       }
       ?>

       </div>
   </div>
        </div>
    </div>
<?php
}

if (!function_exists('typecase_vtmedia_gallery_upload_get_images')) {
	function typecase_vtmedia_gallery_upload_get_images(){
		$ids=$_POST['ids'];
		$ids=explode(",",$ids);
		foreach($ids as $id):
			$image = wp_get_attachment_image_src($id,'thumbnail', true);
			echo '<li class="vtmedia-gallery-image-holder"><img src="'.esc_url($image[0]).'"/></li>';
		endforeach;
		exit;
	}
	add_action( 'wp_ajax_typecase_vtmedia_gallery_upload_get_images', 'typecase_vtmedia_gallery_upload_get_images');
}

add_action( 'wp_footer', 'typecase_gdpr' );
if ( ! function_exists( 'typecase_gdpr' ) ) :
	function typecase_gdpr() {
		$cookiebox = get_theme_mod('vt_cookie_enable');
		if ( empty( $cookiebox ) ) {
			return;
		}
		?>
		<aside id="vt-gdpr" class="vt-gdpr">
            <div class="vt-gdpr-inner">
                <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" ><path d="M18.6963 9.14791C18.5321 4.7503 15.1177 0.982363 10.7543 0.382973C10.2368 0.31202 9.71106 0.285301 9.2037 0.301926L7.74901 0.29777C7.74842 0.29777 7.74812 0.29777 7.74753 0.29777C7.58128 0.29777 7.42542 0.362192 7.30786 0.479754C7.1897 0.597317 7.12469 0.754067 7.12469 0.920613C7.12469 1.2163 7.33517 1.4731 7.62522 1.53099L7.7784 1.56186H7.7787C8.68328 1.74266 9.34501 2.51305 9.35125 3.41407C9.35125 4.36139 8.82637 5.22055 7.98176 5.65636L7.75673 5.77244L7.8357 6.01291C8.04144 6.63872 8.07083 7.28324 7.92358 7.92835C7.50944 9.74285 5.73858 10.9099 3.8074 10.6456C2.64187 10.4853 2.09265 9.9091 1.86911 9.57986C1.70909 9.34385 1.44576 9.20313 1.16492 9.20313C0.930982 9.20313 0.704763 9.30139 0.544451 9.47239C0.384138 9.64339 0.30131 9.87525 0.316154 10.1086C0.630841 14.9278 4.66478 18.7031 9.49969 18.7031C12.0231 18.7031 14.377 17.7021 16.1283 15.8843C17.8784 14.0677 18.7904 11.6752 18.6963 9.14791ZM15.7005 15.4725C14.0624 17.173 11.8601 18.1094 9.49969 18.1094C4.97679 18.1094 1.20322 14.5778 0.908716 10.0697C0.903966 9.99875 0.928607 9.93047 0.977591 9.87822C1.02687 9.82597 1.09337 9.79688 1.16492 9.79688C1.24894 9.79688 1.3285 9.84022 1.37808 9.91325C1.65714 10.3244 2.33312 11.0423 3.72665 11.2335C5.96658 11.5422 8.01947 10.1769 8.50248 8.06046C8.65567 7.38893 8.64469 6.71799 8.46953 6.06219C9.38539 5.49516 9.945 4.50033 9.9447 3.38972C9.93639 2.22924 9.07426 1.21571 7.89478 0.979692L7.74129 0.948817C7.72823 0.946145 7.71844 0.933973 7.71844 0.920613L7.74753 0.89152L9.2129 0.895379C9.698 0.878754 10.1896 0.904582 10.6738 0.971082C14.7559 1.53188 17.9496 5.05668 18.1031 9.17018C18.191 11.5348 17.3378 13.7729 15.7005 15.4725Z"></path> <path d="M11.875 2.96875C11.384 2.96875 10.9844 3.36834 10.9844 3.85938C10.9844 4.35041 11.384 4.75 11.875 4.75C12.366 4.75 12.7656 4.35041 12.7656 3.85938C12.7656 3.36834 12.366 2.96875 11.875 2.96875ZM11.875 4.15625C11.7114 4.15625 11.5781 4.02295 11.5781 3.85938C11.5781 3.6958 11.7114 3.5625 11.875 3.5625C12.0386 3.5625 12.1719 3.6958 12.1719 3.85938C12.1719 4.02295 12.0386 4.15625 11.875 4.15625Z"></path> <path d="M14.8438 5.04688C14.3527 5.04688 13.9531 5.44647 13.9531 5.9375C13.9531 6.42853 14.3527 6.82812 14.8438 6.82812C15.3348 6.82812 15.7344 6.42853 15.7344 5.9375C15.7344 5.44647 15.3348 5.04688 14.8438 5.04688ZM14.8438 6.23438C14.6802 6.23438 14.5469 6.10108 14.5469 5.9375C14.5469 5.77392 14.6802 5.64062 14.8438 5.64062C15.0073 5.64062 15.1406 5.77392 15.1406 5.9375C15.1406 6.10108 15.0073 6.23438 14.8438 6.23438Z"></path> <path d="M14.8438 9.79688C14.3527 9.79688 13.9531 10.1965 13.9531 10.6875C13.9531 11.1785 14.3527 11.5781 14.8438 11.5781C15.3348 11.5781 15.7344 11.1785 15.7344 10.6875C15.7344 10.1965 15.3348 9.79688 14.8438 9.79688ZM14.8438 10.9844C14.6802 10.9844 14.5469 10.8514 14.5469 10.6875C14.5469 10.5236 14.6802 10.3906 14.8438 10.3906C15.0073 10.3906 15.1406 10.5236 15.1406 10.6875C15.1406 10.8514 15.0073 10.9844 14.8438 10.9844Z"></path> <path d="M10.3906 8.90625C9.89959 8.90625 9.5 9.30584 9.5 9.79688C9.5 10.2879 9.89959 10.6875 10.3906 10.6875C10.8817 10.6875 11.2812 10.2879 11.2812 9.79688C11.2812 9.30584 10.8817 8.90625 10.3906 8.90625ZM10.3906 10.0938C10.227 10.0938 10.0938 9.96075 10.0938 9.79688C10.0938 9.6333 10.227 9.5 10.3906 9.5C10.5542 9.5 10.6875 9.6333 10.6875 9.79688C10.6875 9.96075 10.5542 10.0938 10.3906 10.0938Z"></path> <path d="M9.79688 14.5469C9.30584 14.5469 8.90625 14.9465 8.90625 15.4375C8.90625 15.9285 9.30584 16.3281 9.79688 16.3281C10.2879 16.3281 10.6875 15.9285 10.6875 15.4375C10.6875 14.9465 10.2879 14.5469 9.79688 14.5469ZM9.79688 15.7344C9.6333 15.7344 9.5 15.6014 9.5 15.4375C9.5 15.2736 9.6333 15.1406 9.79688 15.1406C9.96045 15.1406 10.0938 15.2736 10.0938 15.4375C10.0938 15.6014 9.96045 15.7344 9.79688 15.7344Z"></path> <path d="M5.04688 12.7656C4.55584 12.7656 4.15625 13.1652 4.15625 13.6562C4.15625 14.1473 4.55584 14.5469 5.04688 14.5469C5.53791 14.5469 5.9375 14.1473 5.9375 13.6562C5.9375 13.1652 5.53791 12.7656 5.04688 12.7656ZM5.04688 13.9531C4.8833 13.9531 4.75 13.8201 4.75 13.6562C4.75 13.4924 4.8833 13.3594 5.04688 13.3594C5.21045 13.3594 5.34375 13.4924 5.34375 13.6562C5.34375 13.8201 5.21045 13.9531 5.04688 13.9531Z"></path> <path d="M13.6562 13.9531H13.0625V14.5469H13.6562V13.9531Z"></path> <path d="M12.1719 6.53125H11.5781V7.125H12.1719V6.53125Z"></path> <path d="M8.01562 12.1719H7.42188V12.7656H8.01562V12.1719Z"></path> <path d="M16.625 8.01562H16.0312V8.60938H16.625V8.01562Z"></path> <path d="M6.53125 15.4375H5.9375V16.0312H6.53125V15.4375Z"></path></svg>
    			<p class="cookie-content"><?php echo wp_kses_post(get_theme_mod('vt_cookie_dec')); ?></p>
    			<div class="vt-gdpr-w">
    				<a id="vt-gdpr-accept" class="vt-gdpr-accept" href="#"><?php echo esc_html__(get_theme_mod('vt_cookie_btn', 'Accept')); ?></a>
    			</div>
            </div>
		</aside>
	<?php
	}
endif;

function typecase_imgmlz( $html, $post_id, $post_thumbnail_id, $size, $attr ) {
	return str_replace( '<img', '<img loading="lazy"', $html );
}
function typecase_addimgclass( $html = '', $new_class = '' ) {
	if(empty(get_theme_mod('vt_opt_lazy_img'))){
		$pattern = '/class="([^"]*)"/';
		if ( preg_match( $pattern, $html, $matches ) ) {
			$predefined_classes = explode( ' ', $matches[1] );
			if ( ! in_array( $new_class, $predefined_classes, true ) && ! in_array( 'rev-slidebg', $predefined_classes, true ) && ! in_array( 'vt-bgs', $predefined_classes, true ) ) {
				$predefined_classes[] = $new_class;
				$html        = str_replace(
					$matches[0],
					sprintf( 'class="%s"', implode( ' ', $predefined_classes ) ),
					$html
				);
			}
		} else {
			$html = preg_replace( '/(\<.+("\s))/', sprintf( '$1class="%s" ', $new_class ), $html );
		}
    }
	return $html;
}
function typecase_filimg( $content ) {
    if(empty(get_theme_mod('vt_opt_lazy_img'))){
		if ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) {
			return $content;            
		}
		if ( is_feed()
			|| intval( get_query_var( 'print' ) ) === 1
			|| intval( get_query_var( 'printpage' ) ) === 1
			|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Opera Mini' ) !== false
		) {
			return $content;
		}
		$matches   = array();
		$resp_replace       = 'data-sizes="auto" data-srcset=';
		$skip_images_regex  = '/class=".*lazyload.*"/';
		$skip_images_regex2 = '/class=".*rev-slidebg.*"/';
		$skip_images_regex3 = '/class=".*attachment-full.*"/';
		$skip_images_regex4 = '/class=".*attachment-woocommerce_thumbnail.*"/';
        $placeholder        = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
		preg_match_all( '/<img\s+.*?>/', $content, $matches );
		$search  = array();
		$replace = array();

		foreach ( $matches[0] as $img_html ) {
			if ( ! preg_match( $skip_images_regex, $img_html ) && ! preg_match( $skip_images_regex2, $img_html ) && ! preg_match( $skip_images_regex3, $img_html ) && ! preg_match( $skip_images_regex4, $img_html ) ) {
				$replace_html = preg_replace( '/<img(.*?)src=/i', '<img$1src="' . $placeholder . '" data-src=', $img_html );
				$replace_html = preg_replace( '/srcset=/i', $resp_replace, $replace_html );
				$replace_html = typecase_addimgclass( $replace_html, 'lazyload' );
				array_push( $search, $img_html );
				array_push( $replace, $replace_html );
			}
		}
		$content = str_replace( $search, $replace, $content );
    }
	return $content;
}
function typecase_lsmall_img( $attr, $attachment, $size ) {
    if(empty(get_theme_mod('vt_opt_lazy_img'))){
        if ( is_string( $size ) ) {
            $placeholder = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
            $name = explode( '_', $size );
            if ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() || is_embed() ) {
                $placeholder = wp_get_attachment_image_src( $attachment->ID, 'typecase_medium' );
                $placeholder = $placeholder[0];
            }else{
                if ( 'typecase' === $name[0] ) {
                    $name[2]     = 'sload';
                    $size        = implode( '_', $name );                    
                    $placeholder = wp_get_attachment_image_src( $attachment->ID, $size );
                    $placeholder = $placeholder[0];
                }else{
                    $placeholder = wp_get_attachment_image_src( $attachment->ID, 'typecase_large_sload' );
                    $placeholder = $placeholder[0];
                }
            }
            $attr['data-src']   = $attr['src'];
            $attr['src']        = $placeholder;
            $attr['class']     .= ' vt-lazyload lazyload';
            unset( $attr['sizes'] );
            if ( isset( $attr['srcset'] ) ) {
                $attr['data-srcset'] = $attr['srcset'];
                unset( $attr['srcset'] );
                unset( $attr['data-srcset'] );
            }
        }
    }
	return $attr;
}
function typecase_img_sizes($img_in) {
    if(empty(get_theme_mod('vt_opt_lazy_img'))){
        $noscript_pos = strpos( $img_in, '</noscript>') + 11;
        $noscript_img = substr ( $img_in , 0 , $noscript_pos );
        $_img = substr ( $img_in , $noscript_pos );
        return $noscript_img . str_replace( 'sizes=', 'data-sizes=', $_img );
    }
}

if ( ! is_admin() ) {
    if(empty(get_theme_mod('vt_opt_lazy_img'))){
        add_filter( 'the_content', 'typecase_filimg', 200 );
        add_filter( 'wp_get_attachment_image_attributes', 'typecase_lsmall_img', 10, 3 );
        add_filter('the_content','typecase_img_sizes');
    }
}

function typecase_font_info() {
	if (isset($_GET['taxonomy']) && $_GET['taxonomy'] == 'vt_custom_fonts') {
    ?>
    <div class="notice notice-warning">
       <ol>
		 <li>Prepare your webfont files by convert your <code>ttf</code> fonts at <a href="https://www.fontsquirrel.com/tools/webfont-generator" target="_blank" rel="nofollow">Font Squirrel</a></li>
		 <li>Upload your font files</li>
		 <li>Your font will show in Appearance → Customise → Theme options → Typography with prefix name Custom font</li>
	   </ol>
    </div>
    <?php
}}
add_action( 'admin_notices', 'typecase_font_info' );

function typecase_elementor_page() {
    if ( ! is_page() ) {
        return false;
    }
    $document = false;
    if ( class_exists( 'Elementor\Plugin' ) ) {
        $document = Elementor\Plugin::$instance->documents->get( get_the_ID() );
    }
    if ( $document && $document->is_built_with_elementor() ) {
        return true;
    }
    return false;
}
function typecase_icon_font() {
    if ( get_theme_mod( 'vt_opt_font_icons', true ) && ! is_admin() ) {
        echo '<link rel="preload" href="' . get_theme_file_uri( 'css/fonts/vt_font.woff' ) . '" as="font" type="font/woff" crossorigin="anonymous"> ';
    }
}
add_action( 'wp_head', 'typecase_icon_font', 9 );
function typecase_gfont() {
   $in = ob_get_clean();
   if ( ! get_theme_mod( 'vt_opt_google_font', true ) || is_admin() || ! empty( $_GET['elementor-preview'] ) ) {
       echo $in;
       return false;
   }

   $markup = preg_replace( '/<!--(.*)-->/Uis', '', $in );
   preg_match_all( '#<link(?:\s+(?:(?!href\s*=\s*)[^>])+)?(?:\s+href\s*=\s*([\'"])((?:https?:)?\/\/fonts\.googleapis\.com\/css(?:(?!\1).)+)\1)(?:\s+[^>]*)?>#iU', $markup, $matches );

   if ( ! $matches[2] ) {
       echo $in;
       return false;
   }

   $fonts_data    = array();
   $index         = 0;
   $fonts_string  = '';
   $subset_string = '';
   $add_pos       = '<link';

   foreach ( $matches[2] as $font ) {
       if ( ! preg_match( '/rel=["\']dns-prefetch["\']/', $matches[0][ $index ] ) ) {
           $font = str_replace( array( '%7C', '%7c' ), '|', $font );
           if ( strpos( $font, 'fonts.googleapis.com/css2' ) !== false ) {
      $font = rawurldecode( $font );
      $font = str_replace( array(
          'css2?',
          'ital,wght@',
          'wght@',
          'ital@',
          '0,',
          '1,',
          ':1',
          ';',
          '&family='
      ), array( 'css?', '', '', '', '', 'italic', ':italic', ',', '%7C' ), $font );
           }
           $font      = explode( 'family=', $font );
           $font      = ( isset( $font[1] ) ) ? explode( '&', $font[1] ) : array();
           $this_font = array_values( array_filter( explode( '|', reset( $font ) ) ) );
           if ( ! empty( $this_font ) ) {
      $fonts_data[ $index ]['fonts'] = $this_font;
      $subset      = ( is_array( $font ) ) ? end( $font ) : '';
      if ( false !== strpos( $subset, 'subset=' ) ) {
          $subset        = str_replace( array( '%2C', '%2c' ), ',', $subset );
          $subset        = explode( 'subset=', $subset );
          $fonts_data[ $index ]['subsets'] = explode( ',', $subset[1] );
      }
           }
           $in = str_replace( $matches[0][ $index ], '', $in );
       }
       $index ++;
   }

   foreach ( $fonts_data as $font ) {
       $fonts_string .= '|' . trim( implode( '|', $font['fonts'] ), '|' );
       if ( ! empty( $font['subsets'] ) ) {
           $subset_string .= ',' . trim( implode( ',', $font['subsets'] ), ',' );
       }
   }

   if ( ! empty( $subset_string ) ) {
       $subset_string = str_replace( ',', '%2C', ltrim( $subset_string, ',' ) );
       $fonts_string  = $fonts_string . '&#038;subset=' . $subset_string;
   }

   $fonts_string = str_replace( '|', '%7C', ltrim( $fonts_string, '|' ) );
   $fonts_string .= '&amp;display=swap';
   $fonts_html   = '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>';
   $fonts_html   .= '<link rel="preload" as="style" onload="this.onload=null;this.rel=\'stylesheet\'" id="typecase_fonts_url_preload" href="https://fonts.googleapis.com/css?family=' . $fonts_string . '" crossorigin>';
   $fonts_html   .= '<noscript><link rel="stylesheet" href="https://fonts.googleapis.com/css?family=' . $fonts_string . '"></noscript>';
   echo substr_replace( $in, $fonts_html . $add_pos, strpos( $in, $add_pos ), strlen( $add_pos ) );
   return false;
}
add_action( 'wp_head', 'typecase_gfont', PHP_INT_MAX );
function typecase_enqueue_optimized() {
    if ( ! empty( $_GET['elementor-preview'] ) || is_admin() ) {
        return false;
    }
    if ( get_theme_mod( 'vt_opt_dashicons', true ) && ! is_user_logged_in() ) {
        wp_deregister_style( 'dashicons' );
    }
    if ( get_theme_mod( 'vt_opt_polyfill', true ) && ! is_admin() ) {
        wp_deregister_script( 'wp-polyfill' );
    }
    if ( get_theme_mod( 'vt_opt_gutenberg', true ) && typecase_elementor_page() ) {
        wp_deregister_style( 'wp-block-library' );
    }
    if ( get_theme_mod( 'vt_opt_woo_block', true ) ) {
        wp_deregister_style( 'wc-blocks-vendors-style' );
        wp_deregister_style( 'wc-blocks-style' );
    }
}
if( !function_exists('typecase_bb_img_size') ) {
	function typecase_bb_img_size( $author_avatar, $topic_id, $size ) {
		$author_avatar = '';
		if ($size == 14) {
			$size = 40;
		}
		$topic_id = bbp_get_topic_id( $topic_id );
		if ( !empty( $topic_id ) ) {
			if ( !bbp_is_topic_anonymous( $topic_id ) ) {
				$author_avatar = get_avatar( bbp_get_topic_author_id( $topic_id ), $size );
			} else {
				$author_avatar = get_avatar( get_post_meta( $topic_id, '_bbp_anonymous_email', true ), $size );
			}
		}
		return $author_avatar;
	}
	add_filter('bbp_get_topic_author_avatar', 'typecase_bb_img_size', 20, 3);
	add_filter('bbp_get_reply_author_avatar', 'typecase_bb_img_size', 20, 3);
	add_filter('bbp_get_current_user_avatar', 'typecase_bb_img_size', 20, 3);
}

add_action('wp', 'typecase_post_opt_check');
function typecase_post_opt_check(){
    $single_auto_load_opt = get_theme_mod('single_auto_load_post','disable');
    $single_auto_load = get_post_meta( get_the_ID(), 'single_auto_load_post', true );
    if(empty($single_auto_load)){
        $spl_load = $single_auto_load_opt;
    }else{
        $spl_load = $single_auto_load;
    }
    if($spl_load == 'disable'){
        return;
    }
if (is_single()) {
    add_action('wp_footer', 'typecase_post_disp_opt'); 
}
}

function typecase_set_get_post($count, $check_type = 'previous', $check_term = false){
    $single_auto_load_opt = get_theme_mod('single_auto_load_post','disable');
    $single_auto_load = get_post_meta( get_the_ID(), 'single_auto_load_post', true );
    if(empty($single_auto_load)){
        $spl_load = $single_auto_load_opt;
    }else{
        $spl_load = $single_auto_load;
    }
    if($spl_load == 'disable'){
        return;
    }
    wp_reset_query();
    $check_post = get_queried_object();
    if (!$check_post || !$check_post->ID) { return; }
    $query_args = [ 'post_type' => 'post', 'posts_per_page' => $count, 'no_found_rows' => true, 'supress_filters' => true, 'ignore_sticky_posts' => true ];
    if ($check_type !== 'random') {
        $post_nav = $check_type === 'previous' ? 'before' : 'after';
        $query_args += [ 'date_query' => [ [ $post_nav => $check_post->post_date, 'inclusive' => false ] ], 'order' => $post_nav === 'before' ? 'DESC' : 'ASC' ];
    }else { 
        $query_args += [ 'orderby' => 'rand', 'post__not_in' => [$check_post->ID] ]; 
    }
    if ($check_term) {
        $terms = wp_get_post_terms($check_post->ID, 'category', ['fields' => 'ids']);
        if ($terms) { $query_args['tax_query'] = [ [ 'taxonomy' => 'category', 'field' => 'term_id', 'terms' => $terms ] ]; }
    }
    $posts_query = get_posts( apply_filters('vt_splq_opts', $query_args));
    return $posts_query;
}

function typecase_post_disp_opt(){
    $single_auto_load_opt = get_theme_mod('single_auto_load_post','disable');
    $single_auto_load = get_post_meta( get_the_ID(), 'single_auto_load_post', true );
    if(empty($single_auto_load)){
        $spl_load = $single_auto_load_opt;
    }else{
        $spl_load = $single_auto_load;
    }
    if($spl_load == 'disable'){
        return;
    }
    $auto_load_num = get_theme_mod('auto_load_num','10');
    $single_auto_load_type = get_theme_mod('single_auto_load_type','previous');
    $auto_same_cat = get_theme_mod('auto_same_cat',1);
    $posts_query = typecase_set_get_post($auto_load_num, $single_auto_load_type, $auto_same_cat );
    if (!$posts_query) { return; }
    $posts_display  = [];
    foreach ($posts_query as $post) {
        // 'title' => $post->post_title,
        $posts_display[] = [ 'id' => $post->ID, 'title' => '', 'url' => get_permalink($post) ];
    }
    printf( '<script data-cfasync="false">JlOptPosts = %s;</script>', json_encode($posts_display) );
}

add_action( 'wp_enqueue_scripts', 'typecase_enqueue_optimized', 999 );
if ( ! function_exists( 'typecase_core_enqueue' ) ) {
	function typecase_core_enqueue() {
		if ( is_admin() ) {
			return false;
		}
		wp_enqueue_script( 'imagesloaded' );        
	}
}
add_action( 'wp_enqueue_scripts', 'typecase_core_enqueue', 1 );
function typecase_info_scripts(){
    wp_enqueue_style('typecase-info', TYPECASE_ADDONS_ASSETS . 'css/info.css', null, TYPECASE_ADDONS_VERSION);
}
add_action('elementor/editor/after_enqueue_styles', 'typecase_info_scripts');
add_action( 'wp_enqueue_scripts', 'typecase_addons_css' );
if ( ! function_exists( 'typecase_addons_css' ) ) {
  function typecase_addons_css() {
    if ( class_exists('bbPress', false) || class_exists( 'Buddypress', false ) ) {
        wp_enqueue_style( 'style-vtbb', TYPECASE_ADDONS_ASSETS .'/css/vtbb.css', false, TYPECASE_ADDONS_VERSION );        
    }        
  }
}

function typecase_admin_enqueue() {
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_media();
    wp_enqueue_script( 'category-colorpicker-js', TYPECASE_ADDONS_ASSETS . 'js/meta.js', array( 'wp-color-picker' ) );
    wp_enqueue_style( 'category-template-style-admin', TYPECASE_ADDONS_ASSETS .'css/meta.css', false, TYPECASE_ADDONS_VERSION );
    wp_localize_script( 'category-colorpicker-js', 'vtParamsOpt', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ), 'vidimg' => esc_url(TYPECASE_ADDONS_ASSETS.'images/video.png'), 'mp3img' => esc_url(TYPECASE_ADDONS_ASSETS.'images/mp3.png') ) );
}
add_action('admin_enqueue_scripts', 'typecase_admin_enqueue' );