<?php
if ( ! defined( 'ABSPATH' ) ) exit;
	class typecase_Meta_Box{
		protected $_metabox;
		function __construct( $metabox ) {
			if ( !is_admin() ) return;
			$this->_metabox = $metabox;
			add_action( 'admin_menu', array( &$this, 'add' ) );
			add_action( 'save_post', array( &$this, 'save' ) );
		}
		function add() {
			$this->_metabox['context'] = empty($this->_metabox['context']) ? 'normal' : $this->_metabox['context'];
			$this->_metabox['priority'] = empty($this->_metabox['priority']) ? 'high' : $this->_metabox['priority'];

			foreach ( $this->_metabox['pages'] as $page ) {
				add_meta_box( $this->_metabox['id'], $this->_metabox['title'], array(&$this, 'show'), $page, $this->_metabox['context'], $this->_metabox['priority']) ;
			}
		}
		function show() {
			global $post;
			echo '<input type="hidden" name="wp_meta_box_nonce" value="', wp_create_nonce( basename(__FILE__) ), '" />';
			echo '<div class="vt_tabbox_wrapper">';
			if ( get_post_type( get_the_ID() ) == 'post' ) {
			?>
			<div class="vt_nab_tab">
	        <a id="options-group-1-tab" class="generalsetting-tab" href="#options-group-1">Post Settings</a>
	        <a id="options-group-2-tab" class="generalsetting-tab" href="#options-group-2">Post Review</a>
	        <a id="options-group-3-tab" class="generalsetting-tab" href="#options-group-3">Post Format gallery</a>
	        <a id="options-group-4-tab" class="generalsetting-tab" href="#options-group-4">Post Format quote</a>
	        <a id="options-group-5-tab" class="generalsetting-tab" href="#options-group-5">Post Format video</a>
	        <a id="options-group-6-tab" class="generalsetting-tab" href="#options-group-6">Post Format audio</a>
	        <a id="options-group-7-tab" class="generalsetting-tab" href="#options-group-7">Sponsored Post</a>
	        <a id="options-group-8-tab" class="generalsetting-tab" href="#options-group-8">Sources & Via</a>
	        </div>
			<?php }
				if ( get_post_type( get_the_ID() ) == 'page' ) {
			?>
			<div class="vt_nab_tab">
	        <a id="options-group-1-tab" class="generalsetting-tab" href="#options-group-1">Page Settings</a>
	        <a id="options-group-2-tab" style="display:none;" class="generalsetting-tab" href="#options-group-2">Home Post Pagination</a>
	        </div>
			<?php }
			foreach ( $this->_metabox['fields'] as $field ) {
				if ( !isset( $field['name'] ) ) $field['name'] = '';
				if ( !isset( $field['desc'] ) ) $field['desc'] = '';
				if ( !isset( $field['std'] ) ) $field['std'] = '';
				$meta = get_post_meta($post->ID, $field['id'], true);
				$meta = ( '' === $meta || array() === $meta ) ? $field['std'] : $meta;
				echo '<div class="vt_trow group" id="'.$field['id'].'">';
					echo '<div class="vt_th"><label for="input-'.$field['id'].'">'.$field['label'].'</label></div>';

					echo '<div class="vt_td">';
					switch($field['type']) {
						case 'text':
							echo '<input type="text" name="'.$field['id'].'" id="input-'.$field['id'].'" value="'.$meta.'" size="64" />';
							echo '<br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
							break;
						case 'image':
							echo '<input class="vision_cat_header_image_id '.$field['id'].'" type="hidden" name="'.$field['id'].'" value="'.$meta.'" size="64" />';
							echo '<span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
							echo '<div class="vision_cat_header '.$field['id'].'" style="margin-bottom:10px; width: 100px; white-space: nowrap;">';
							if(!empty($meta)){
								$review_img = wp_get_attachment_image_src($meta, 'thumbnail');
								$attach_type = wp_get_attachment_url( $meta );
								if (str_contains($attach_type, '.mp4')){
									echo '<img src="'.esc_url(TYPECASE_ADDONS_ASSETS.'images/video.png').'" style="max-width: 70px;"/>';
									echo '<p class="media_url">'.$attach_type.'</p>';
								}elseif(str_contains($attach_type, '.mp3')){
									echo '<img src="'.esc_url(TYPECASE_ADDONS_ASSETS.'images/mp3.png').'" style="max-width: 70px;"/>';
									echo '<p class="media_url">'.$attach_type.'</p>';
								}else{
									if(!empty($review_img)){
										echo '<img src="'.$review_img[0].'" style="max-width: 70px;"/>';
										echo '<p class="media_url"></p>';
									}
								}
							}else{
							echo '<img src="'.esc_url(TYPECASE_ADDONS_ASSETS.'images/none_image.png').'" style="max-width: 70px;"/>';
							echo '<p class="media_url"></p>';
							}
							echo'</div>';
							echo '<button type="submit" class="vt_meta_media vtaddbtn" id="'.$field['id'].'">Add Media</button>';
							echo '<button type="submit" class="vt_remove_media vtremovebtn" id="'.$field['id'].'">Remove Media</button>';
							break;
						case 'color':
							echo '<input type="text" class="colorpicker" name="'.$field['id'].'" id="input-'.$field['id'].'" value="'.$meta.'" size="64" />';
							echo '<br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
							break;
						case 'line':
							echo '<span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
							break;
						case 'topen':
							echo '<div id="'.$field['id'].'">';
							break;
						case 'tclose':
							echo '</div>';
							break;
						case 'gallery':
							echo '<br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
							?>
							<ul class="vtmedia-gallery-images-holder clearfix">
								<?php
								$image_gallery_val = get_post_meta( $post->ID, $field['id'], true);
								if($image_gallery_val!='' ) $image_gallery_array=explode(',',$image_gallery_val);
								if(isset($image_gallery_array) && count($image_gallery_array)!=0):
									foreach($image_gallery_array as $gimg_id):
										$gimage_wp = wp_get_attachment_image_src($gimg_id,'thumbnail', true);
										echo '<li class="vtmedia-gallery-image-holder"><img src="'.esc_url($gimage_wp[0]).'"/></li>';
									endforeach;
								endif;
								?>
							</ul>
							<input type="hidden" value="<?php echo esc_attr($image_gallery_val); ?>" id="<?php echo esc_attr( $field['id']) ?>" name="<?php echo esc_attr( $field['id']) ?>">
							<div class="vtmedia-gallery-uploader">
								<a class="vtmedia-gallery-upload-btn btn btn-sm btn-primary"
								   href="javascript:void(0)"><?php esc_html_e('Upload or Edit', 'typecase'); ?></a>
								<a class="vtmedia-gallery-clear-btn btn btn-sm btn-default pull-right"
								   href="javascript:void(0)"><?php esc_html_e('Remove All', 'typecase'); ?></a>
							</div>
							<?php
							break;
						case 'textarea':
							echo '<textarea name="'.$field['id'].'" id="input-'.$field['id'].'" cols="60" rows="4">'.$meta.'</textarea>';
							echo '<br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
							break;
						case 'checkbox':
							echo '<input style="margin-right: 10px;" type="checkbox" name="'.$field['id'].'" id="input-'.$field['id'].'" ',$meta ? ' checked="checked"' : '','/>';
							echo '<label for="input-'.$field['id'].'">'.$field['desc'].'</label>';
							break;
						case 'select':
							echo '<select name="'.$field['id'].'" id="input-'.$field['id'].'">';
							foreach ($field['options'] as $key => $val) {
								echo '<option', $meta == $key ? ' selected="selected"' : '', ' value="'.$key.'">'.$val.'</option>';
							}
							echo '</select><br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
							break;
						case 'radio':
							foreach ( $field['options'] as $key => $val ) {
								echo '<input type="radio" name="'.$field['id'].'" id="input-'.$field['id'].'_'.$key.'" value="'.$key.'" ',$meta == $key ? ' checked="checked"' : '',' />';
								echo '<label for="'.$field['id'].'_'.$key.'">'.$val.'</label><br>';
							}
							break;
						case 'rating_criteria':
                            $rows = array();
                            if($meta) $rows = $meta;
                            $c = 0;
                            if ( count( $rows ) > 0 ) {
                                foreach( $rows as $row ) {
                                    if ( isset( $row['c_label'] ) || isset( $row['score'] ) ) {
                                        echo '
                                        <p class="rating_row vt_cus_repeater" style="margin-bottom:10px;">
                                        <label for="'.$field['id'].'['.$c.'][c_label]">Label :</label>
                                        <input type="text" name="'.$field['id'].'['.$c.'][c_label]" value="'.$row['c_label'].'" />
                                        <label for="'.$field['id'].'['.$c.'][score]">Score :</label>
                                        <input type="text" name="'.$field['id'].'['.$c.'][score]" value="'.$row['score'].'" />
                                        <a class="remove_review button-secondary">Remove</a>
                                        </p>';
                                        $c = $c + 1;
                                    }
                                }
                            }
                            echo '<span id="criteria-placeholder"></span>';
                            echo '<a class="add-criteria button-primary" href="#">Add Criteria</a>';
                            echo '<br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
                            ?>
                            <script>
                                var $ = jQuery.noConflict();
                                $(document).ready(function() {
                                    var count = <?php echo esc_attr($c); ?>;
                                    $('.add-criteria').click(function() {
                                        count = count + 1;
                                        $('#criteria-placeholder').append('<p class="rating_row vt_cus_repeater" style="margin-bottom:10px;"><label for="<?php echo esc_attr($field['id']); ?>['+count+'][c_label]">Label : </label><input type="text" name="<?php echo esc_attr($field['id']); ?>['+count+'][c_label]" value="" /><label for="<?php echo esc_attr($field['id']); ?>['+count+'][score]"> Score : </label><input type="text" name="<?php echo esc_attr($field['id']); ?>['+count+'][score]" value="" /> <a class="remove_review button-secondary">Remove</a></p>');
                                        return false;
                                    });

                                    $('body').on('click', '.remove_review', function(){
                                        $(this).parent('.rating_row').remove();
                                    });

                                });
                            </script>
                            <?php
                        break;
                        case 'source_options':
                            $rows = array();
                            if($meta) $rows = $meta;
                            $c = 0;
                            if ( count( $rows ) > 0 ) {
                                foreach( $rows as $row ) {
                                    if ( isset( $row['c_label'] ) || isset( $row['url'] ) ) {
                                        echo '
                                        <p class="opt-source-row vt_cus_repeater" style="margin-bottom:10px;">
                                        <label for="'.$field['id'].'['.$c.'][c_label]">Label :</label>
                                        <input type="text" name="'.$field['id'].'['.$c.'][c_label]" value="'.$row['c_label'].'" />
                                        <label for="'.$field['id'].'['.$c.'][url]">URL :</label>
                                        <input type="text" name="'.$field['id'].'['.$c.'][url]" value="'.$row['url'].'" />
                                        <a class="opt-remove-source button-secondary">Remove</a>
                                        </p>';
                                        $c = $c + 1;
                                    }
                                }
                            }
                            echo '<span id="opt-source-placeholder"></span>';
                            echo '<a class="add-opt-source button-primary" href="#">Add Post Source</a>';
                            echo '<br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
                            ?>
                            <script>
                                var $ = jQuery.noConflict();
                                $(document).ready(function() {
                                    var count_source = <?php echo esc_attr($c); ?>;
                                    $('.add-opt-source').click(function() {
                                        count_source = count_source + 1;
                                        $('#opt-source-placeholder').append('<p class="opt-source-row vt_cus_repeater" style="margin-bottom:10px;"><label for="<?php echo esc_attr($field['id']); ?>['+count_source+'][c_label]">Label : </label><input type="text" name="<?php echo esc_attr($field['id']); ?>['+count_source+'][c_label]" value="" /><label for="<?php echo esc_attr($field['id']); ?>['+count_source+'][url]"> URL : </label><input type="text" name="<?php echo esc_attr($field['id']); ?>['+count_source+'][url]" value="" /> <a class="opt-remove-source button-secondary">Remove</a></p>');
                                        return false;
                                    });

                                    $('body').on('click', '.opt-remove-source', function(){
                                        $(this).parent('.opt-source-row').remove();
                                    });

                                });
                            </script>
                            <?php
                        break;
                        case 'via_options':
                            $rows = array();
                            if($meta) $rows = $meta;
                            $c = 0;
                            if ( count( $rows ) > 0 ) {
                                foreach( $rows as $row ) {
                                    if ( isset( $row['c_label'] ) || isset( $row['url'] ) ) {
                                        echo '
                                        <p class="opt-via-row vt_cus_repeater" style="margin-bottom:10px;">
                                        <label for="'.$field['id'].'['.$c.'][c_label]">Label :</label>
                                        <input type="text" name="'.$field['id'].'['.$c.'][c_label]" value="'.$row['c_label'].'" />
                                        <label for="'.$field['id'].'['.$c.'][url]">URL :</label>
                                        <input type="text" name="'.$field['id'].'['.$c.'][url]" value="'.$row['url'].'" />
                                        <a class="opt-remove-via button-secondary">Remove</a>
                                        </p>';
                                        $c = $c + 1;
                                    }
                                }
                            }
                            echo '<span id="opt-via-placeholder"></span>';
                            echo '<a class="add-opt-via button-primary" href="#">Add Post Via</a>';
                            echo '<br /><span style="margin-top: 0px; display: block;" class="description">'.$field['desc'].'</span>';
                            ?>
                            <script>
                                var $ = jQuery.noConflict();
                                $(document).ready(function() {
                                    var count_via = <?php echo esc_attr($c); ?>;
                                    $('.add-opt-via').click(function() {
                                        count_via = count_via + 1;
                                        $('#opt-via-placeholder').append('<p class="opt-via-row vt_cus_repeater" style="margin-bottom:10px;"><label for="<?php echo esc_attr($field['id']); ?>['+count_via+'][c_label]">Label : </label><input type="text" name="<?php echo esc_attr($field['id']); ?>['+count_via+'][c_label]" value="" /><label for="<?php echo esc_attr($field['id']); ?>['+count_via+'][url]"> URL : </label><input type="text" name="<?php echo esc_attr($field['id']); ?>['+count_via+'][url]" value="" /> <a class="opt-remove-via button-secondary">Remove</a></p>');
                                        return false;
                                    });

                                    $('body').on('click', '.opt-remove-via', function(){
                                        $(this).parent('.opt-via-row').remove();
                                    });

                                });
                            </script>
                            <?php
                        break;

					}
					echo '</div>';
				echo '</div>';

			}

			echo '</div>';
		}


		// Save data from metabox
		function save( $post_id)  {
			// verify nonce
			if ( ! isset( $_POST['wp_meta_box_nonce'] ) || !wp_verify_nonce( $_POST['wp_meta_box_nonce'], basename(__FILE__) ) ) {
				return $post_id;
			}

			// check autosave
			if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
				return $post_id;

			// check permissions
			if ('page' == $_POST['post_type']) {
				if (!current_user_can('edit_page', $post_id))
					return $post_id;
				} elseif (!current_user_can('edit_post', $post_id)) {
					return $post_id;
			}

			// loop through fields and save the data
			foreach ( $this->_metabox['fields'] as $field ) {

				$old = get_post_meta($post_id, $field['id'], true);

				$new = isset( $_POST[$field['id']] ) ? $_POST[$field['id']] : null;

				if ($new && $new != $old) {
					update_post_meta($post_id, $field['id'], $new);
				}
				elseif ('' == $new && $old) {
					delete_post_meta($post_id, $field['id'], $old);
				}

			} // end foreach
		}
	}



/*	Initialize Metabox
 *	--------------------------------------------------------- */
	function typecase_init_metaboxes() {
		if ( class_exists( 'typecase_Meta_Box' ) ) {



//// user metabox field
add_filter( 'typecase_meta_metaboxes', 'typecase_meta_metaboxes' );

function typecase_meta_metaboxes( array $metaboxes ) {

	$option_sidebar = array();
	$sidebars = get_option('sbg_sidebars');
	$option_sidebar['default']= esc_html__( 'Default Sidebar', 'typecase' );
	if(isset($sidebars)) {
		if(is_array($sidebars)) {
			foreach($sidebars as $sidebar) {
				$sidebar_lower = strtolower($sidebar);
				$sidebarid = str_replace(' ','-', $sidebar_lower);
				$option_sidebar[$sidebarid] = $sidebar;
			}
		}
	}

	//Header
	$args = array(
		'post_type'     => 'vt_layout',
		'post_status'   => array( 'publish' ),
		'numberposts'   => -1,
		'orderby'       => 'title',
		'order'         => 'ASC',
		'suppress_filters'   => false
   );
   $layouts = get_posts($args);
   $vt_layouts = array();
   $vt_layouts['']= esc_html__( 'Default Layout', 'typecase' );
   
   if(!empty($layouts)){
	   foreach ($layouts as $layout){
		   $vt_layouts[$layout->ID] = $layout->post_title;
	   }
   }

   //menu
   $menus = get_terms('nav_menu');
   $menus_select = array(
		'' => 'Default Menu'
	);
	foreach($menus as $each_menu){
		$menus_select[$each_menu->slug] = $each_menu->name;
	}



		$metaboxes[] = array(
			'id'		 => 'vt_single_post_layouts',
			'title'      => esc_html__('Single Post Options', 'typecase'),
			'pages'      => array('post'), // Post type
			'context'    => 'normal',
			'priority'   => 'high',
			'fields' => array(

				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-1',
					'type'	=> 'topen'
				),
                // tab open

                array(
					'label' => esc_html__('Enable Full Post', 'typecase'),
					'desc'	=> esc_html__('Check this to enable single post content full width', 'typecase'),
					'id'	=> 'single_post_full_single_post_full',
					'type'	=> 'checkbox'
				),

				array(
					'label' => esc_html__('Transparent header', 'typecase'),
					'desc'	=> esc_html__('Check this to remove background header', 'typecase'),
					'id'	=> 'vt_header_tp',
					'type'	=> 'checkbox'
				),

				array(
					'label' => esc_html__('Disable left post share', 'typecase'),		
					'desc'	=> esc_html__('Check this to hide left post share', 'typecase'),			
					'id'	=> 'disable_post_share',
					'type'	=> 'checkbox'
				),

				array(
					'label' => esc_html__('Post Subtitle', 'typecase'),
					'id'	=> 'single_post_subtitle',
					'type'	=> 'text'
				),
				array(
					'label' => esc_html__('Select Post Layout', 'typecase'),
					'desc'	=> '',
					'id'	=> 'single_post_layout',
					'std' => '',
					'type'	=> 'select',
					'options' => array (
						'' => esc_html__('Use Customizer Setting', 'typecase'),
						'single1' => esc_html__('Post Layout 1', 'typecase'),
						'single2' => esc_html__('Post Layout 2', 'typecase'),
						'single3' => esc_html__('Post Layout 3', 'typecase'),
						'single4' => esc_html__('Post Layout 4', 'typecase'),
						'single5' => esc_html__('Post Layout 5', 'typecase'),
						'single6' => esc_html__('Post Layout 6', 'typecase'),
						'single7' => esc_html__('Post Layout 7', 'typecase'),
						'single8' => esc_html__('Post Layout 8', 'typecase'),
						'single9' => esc_html__('Post Layout 9', 'typecase'),
						'single10' => esc_html__('Post Layout 10', 'typecase'),
						'single11' => esc_html__('Post Layout 11', 'typecase'),
						'single12' => esc_html__('Post Layout 12', 'typecase'),
						'single13' => esc_html__('Post Layout 13', 'typecase'),
						'single14' => esc_html__('Post Layout 14', 'typecase'),						
						)
				),
				array(
					'label' => esc_html__('Post sidebar', 'typecase'),
					'desc'	=> '',
					'id'	=> 'single_post_sidebar',
					'std' => '',
					'type'	=> 'select',
					'options' => $option_sidebar
				),

				array(
					'label' => esc_html__('Sidebar Position', 'typecase'),
					'desc'	=> '',
					'id'	=> 'post_sidebar_position',
					'std' => '',
					'type'	=> 'select',
					'options' => array (
						'' => esc_html__('Use Customizer Setting', 'typecase'),
						'vt_sleft_side' => esc_html__('Left Sidebar', 'typecase'),
						'vt_sright_side' => esc_html__('Right Sidebar', 'typecase')
						)
				),

				array(
					'label' => esc_html__('Auto load next post', 'typecase'),
					'desc'	=> '',
					'id'	=> 'single_auto_load_post',
					'std' => '',
					'type'	=> 'select',
					'options' => array (
						'' => esc_html__('Use Customizer Setting', 'typecase'),
						'enable' => esc_html__('Enable', 'typecase'),
						'disable' => esc_html__('Disable', 'typecase')
						)
				),

                // tab close
				array(
					'label' => "",
					'id'	=> 'post_option_close',
					'type'	=> 'tclose'
				),
				// tab close

				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-2',
					'type'	=> 'topen'
				),
                // tab open

                array(
                    'label' => esc_html__('Enable Review', 'nanopress'),
                    'desc'  => esc_html__('Check this to enable review', 'typecase'),
                    'id'    => 'single_post_review',
                    'type'  => 'checkbox'
                ),
                array(
                    'label' => esc_html__('Rating Criteria', 'typecase'),
                    'desc'  => esc_html__('Label : A name of criteria - Score : A number value between 0 - 10, incerement 0.1', 'typecase'),
                    'id'    => 'rating_criteria',
                    'type'  => 'rating_criteria'
                ),
				array(
                    'label' => esc_html__('Custom total value', 'typecase'),
					'desc'  => esc_html__('Display custom total value with number only (EX:0.1 - 10)', 'typecase'),
                    'id'    => 'review_cus_total',
                    'type'  => 'text',
                    'std'   => ''
                ),
                array(
                    'label' => esc_html__('Hide/Show Review bar', 'typecase'),
                    'id'    => 'vt_review_bar',
                    'std' => '',
					'type'	=> 'select',
					'options' => array (
						'' => esc_html__('Use Customizer Setting', 'typecase'),
						'show' => esc_html__('show', 'typecase'),
						'hide' => esc_html__('hide', 'typecase')						
					)
                ),
				array(
                    'label' => esc_html__('Rating Type', 'typecase'),
                    'id'    => 'rating_type',
                    'type'  => 'select',
                    'options' => array ( 
						'star' => esc_html__('Star', 'typecase'),
						'number' => esc_html__('Number', 'typecase'), 
						'letter' => esc_html__('Letter Grade', 'typecase'), 
						'percent' => esc_html__('Percentage', 'typecase')
					)
                ),
                array(
						'label' => esc_html__('Review Image', 'typecase'),
						'desc'	=> "",
						'id'	=> 'review_image',
						'type'	=> 'image',
						'std'	=> ''
					),
                array(
                    'label' => esc_html__('Review color', 'typecase'),
                    'id'    => 'review_color',
                    'type'  => 'color',
                    'std'   => ''
                ),
                array(
                    'label' => esc_html__('Review Title', 'typecase'),
                    'id'    => 'review_box_title',
                    'type'  => 'text',
                    'std'   => 'Review Overview'
                ),
                array(
                    'label' => esc_html__('Summary', 'typecase'),
                    'desc'  => esc_html__('Summary in review box', 'typecase'),
                    'id'    => 'review_summary',
                    'type'  => 'textarea',
                    'std'   => ''
                ),
                array(
                    'label' => esc_html__('Positives', 'typecase'),
                    'desc'  => esc_html__('Positives review each line in review box.', 'typecase'),
                    'id'    => 'review_pos',
                    'type'  => 'textarea',
                    'std'   => ''
                ),
                array(
                    'label' => esc_html__('Negatives', 'typecase'),
                    'desc'  => esc_html__('Negatives review each line in review box', 'typecase'),
                    'id'    => 'review_neg',
                    'type'  => 'textarea',
                    'std'   => ''
                ),

                array(
                    'label' => esc_html__('Review Button Label', 'typecase'),
                    'id'    => 'review_btn_label',
                    'type'  => 'text',
                    'std'   => ''
                ),

                array(
                    'label' => esc_html__('Review Button URL', 'typecase'),
                    'id'    => 'review_btn_url',
                    'type'  => 'text',
                    'std'   => ''
                ),

                // tab close
				array(
					'label' => "",
					'id'	=> 'review_close',
					'type'	=> 'tclose'
				),
				// tab close



				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-3',
					'type'	=> 'topen'
				),
                // tab open

                array(
					'label' => esc_html__('Gallery type', 'typecase'),
					'desc'	=> '',
					'id'	=> 'vt_gallery_type',
					'std' => '',
					'type'	=> 'select',
					'options' => array (
						'' => esc_html__('Use Customizer Setting', 'typecase'),
						'slider' => esc_html__('Slider', 'typecase'),
						'popup' => esc_html__('Popup', 'typecase')
						)
				),

                // gallery
				array(
					'label' => esc_html__('gallery', 'typecase'),
					'id'	=> 'gallery_post_format',
					'type'	=> 'gallery'
				),

				// tab close
				array(
					'label' => "",
					'id'	=> 'post_gallery_close',
					'type'	=> 'tclose'
				),
				// tab close

				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-4',
					'type'	=> 'topen'
				),
                // tab open

				// quote
				array(
					'label' => esc_html__('Quote title', 'typecase'),
					'id'	=> 'quote_post_title',
					'type'	=> 'textarea'
				),
				array(
					'label' => esc_html__('Quote author', 'typecase'),
					'id'	=> 'quote_post_author',
					'type'	=> 'text'
				),

				// tab close
				array(
					'label' => "",
					'id'	=> 'post_quote_close',
					'type'	=> 'tclose'
				),
				// tab close

				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-5',
					'type'	=> 'topen'
				),
                // tab open

				array(
					'label' => esc_html__('Video Type', 'typecase'),
					'desc'	=> '',
					'id'	=> 'vt_vid_type',
					'std' => 'video_post_embed',
					'type'	=> 'select',
					'options' => array (
						'video_post_embed' => esc_html__('Video embed', 'typecase'),
						'video_local' => esc_html__('Video HTML5 MP4', 'typecase'),
						)
				),
				array(
					'label' => esc_html__('Video style', 'typecase'),
					'desc'	=> '',
					'id'	=> 'vt_video_style',
					'std' => '',
					'type'	=> 'select',
					'options' => array (
						'' => esc_html__('Use Customizer Setting', 'typecase'),
						'background' => esc_html__('Background video', 'typecase'),
						'popup' => esc_html__('Popup', 'typecase')
						)
				),
				// video
				array(
					'label' => esc_html__('Video url', 'typecase'),
					'desc'  => esc_html__('Youtube video url, Vimeo video url, Dailymotion video url', 'typecase'),
					'id'	=> 'video_post_embed',
					'type'	=> 'textarea'
				),
				array(
						'label' => esc_html__('Video MP4', 'typecase'),
						'desc'	=> "",
						'id'	=> 'video_local',
						'type'	=> 'image',
						'std'	=> ''
					),

				// tab close
				array(
					'label' => "",
					'id'	=> 'post_video_close',
					'type'	=> 'tclose'
				),
				// tab close

				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-6',
					'type'	=> 'topen'
				),
                // tab open

				// audio
				array(
					'label' => esc_html__('Audio Type', 'typecase'),
					'desc'	=> '',
					'id'	=> 'vt_audio_type',
					'std' => 'audio_post_embed',
					'type'	=> 'select',
					'options' => array (
						'audio_post_embed' => esc_html__('Audio embed', 'typecase'),
						'audio_local' => esc_html__('Audio HTML5 MP3', 'typecase')
						)
				),
				array(
					'label' => esc_html__('Audio Embed', 'typecase'),
					'id'	=> 'audio_post_embed',
					'type'	=> 'textarea'
				),
				array(
						'label' => esc_html__('Audio MP3', 'typecase'),
						'desc'	=> "",
						'id'	=> 'audio_local',
						'type'	=> 'image',
						'std'	=> ''
				),

				// tab close
				array(
					'label' => "",
					'id'	=> 'post_audio_close',
					'type'	=> 'tclose'
				),
				// tab close

				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-7',
					'type'	=> 'topen'
				),
                // tab open

                array(
					'label' => esc_html__('Enable Sponsored Post', 'typecase'),
					'desc'	=> esc_html__('Check this to enable sponsored post', 'typecase'),
					'id'	=> 'enable_sponsored_post',
					'type'	=> 'checkbox'
				),

				array(
					'label' => esc_html__('Sponsor URL', 'typecase'),
					'id'	=> 'sponsored_post_url',
					'type'	=> 'text'
				),				
				array(
						'label' => esc_html__('Sponsor logo', 'typecase'),
						'desc'	=> "",
						'id'	=> 'sponsored_logo',
						'type'	=> 'image',
						'std'	=> ''
				),


				// tab close
				array(
					'label' => "",
					'id'	=> 'post_sponsor_close',
					'type'	=> 'tclose'
				),
				// tab close


				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-8',
					'type'	=> 'topen'
				),
                // tab open

                array(
                    'label' => esc_html__('Post Sources', 'typecase'),
                    'id'    => 'source_options',
                    'type'  => 'source_options'
                ),

                array(
                    'label' => esc_html__('Post Via', 'typecase'),
                    'id'    => 'via_options',
                    'type'  => 'via_options'
                ),



				// tab close
				array(
					'label' => "",
					'id'	=> 'post_source_via_close',
					'type'	=> 'tclose'
				),
				// tab close



			)
		);


$metaboxes[] = array(
			'id'		 => 'vt_option_page',
			'title'      => esc_html__('Page options', 'typecase'),
			'pages'      => array('page'), // Post type
			'context'    => 'normal',
			'priority'   => 'high',
			'fields' => array(

				// tab open
                array(
					'label' => "",
					'id'	=> 'options-group-1',
					'type'	=> 'topen'
				),
                // tab open

				array(
					'label' => esc_html__('Transparent header', 'typecase'),
					'desc'	=> esc_html__('Check this to remove background header', 'typecase'),
					'id'	=> 'vt_header_tp',
					'type'	=> 'checkbox'
				),				

				array(
					'label' => esc_html__('Page Subtitle', 'typecase'),
					'id'	=> 'single_page_subtitle',
					'type'	=> 'text'
				),

				array(
					'label' => esc_html__('Page sidebar', 'typecase'),
					'desc'	=> '',
					'id'	=> 'single_page_sidebar',
					'std' => '',
					'type'	=> 'select',
					'options' => $option_sidebar
				),

				array(
					'label' => esc_html__('Select Layout Header', 'typecase'),
					'desc'	=> esc_html__('Choose layout to overwrite default header', 'typecase'),
					'id'	=> 'custom_header_layout',
					'std' => '',
					'type'	=> 'select',
					'options' => $vt_layouts
				),

				array(
					'label' => esc_html__('Select Layout Header Sticky', 'typecase'),
					'desc'	=> esc_html__('Choose layout to overwrite default sticky header: Note this options work when you choose (Layout Header)', 'typecase'),
					'id'	=> 'custom_header_sticky',
					'std' => '',
					'type'	=> 'select',
					'options' => $vt_layouts
				),

				array(
					'label' => esc_html__('Select mobile menu', 'typecase'),
					'desc'	=> esc_html__('Choose menu to overwrite default mobile menu', 'typecase'),
					'id'	=> 'custom_mobile_menu',
					'std' => '',
					'type'	=> 'select',
					'options' => $menus_select
				),

				array(
					'label' => esc_html__('Select Layout Footer', 'typecase'),
					'desc'	=> esc_html__('Choose layout to overwrite default footer', 'typecase'),
					'id'	=> 'custom_footer_layout',
					'std' => '',
					'type'	=> 'select',
					'options' => $vt_layouts
				),

				// tab close
				array(
					'label' => "",
					'id'	=> 'post_options_close',
					'type'	=> 'tclose'
				),
				// tab close


				// // tab open
                // array(
				// 	'label' => "",
				// 	'id'	=> 'options-group-2',
				// 	'type'	=> 'topen'
				// ),
                // // tab open

				// array(
				// 	'label' => esc_html__('Enable Home Recent post (Select page template: Home Page Builder to display)', 'typecase'),
				// 	'desc'	=> esc_html__('Check this to enable recent post pagination number', 'typecase'),
				// 	'id'	=> 'vt_home_recent',
				// 	'type'	=> 'checkbox'
				// ),
				// array(
				// 	'label' => esc_html__('Select Post Layout', 'typecase'),
				// 	'desc'	=> '',
				// 	'id'	=> 'vt_post_layout',
				// 	'std' => '',
				// 	'type'	=> 'select',
				// 	'options' => array (
				// 		'archive1' => 'Grid post 2 columns',
				// 		'archive2' => 'Grid post 3 columns',
				// 		'archive3' => 'Grid post 4 columns',
				// 		'archive4' => 'Post mian + list',
				// 		'archive5' => 'Post mix + list',
				// 		'archive6' => 'Post mian + grid',
				// 		'archive7' => 'Post list',
				// 		'archive8' => 'Post classic',
				// 		'archive9' => 'Post overlay 2 columns',
				// 		'archive10' => 'Post overlay 3 columns',
				// 		'archive11' => 'Post overlay 4 columns',						
				// 		)
				// ),

				// array(
				// 	'label' => esc_html__('Number of post', 'typecase'),
				// 	'id'	=> 'vt_home_recent_number',
				// 	'type'	=> 'text'
				// ),

				// array(
				// 	'label' => esc_html__('Number of post offset', 'typecase'),
				// 	'id'	=> 'vt_home_recent_offset',
				// 	'type'	=> 'text'
				// ),

                // // tab close
				// array(
				// 	'label' => "",
				// 	'id'	=> 'post_pagination_close',
				// 	'type'	=> 'tclose'
				// ),
				// // tab close

			)
		);

		$metaboxes[] = array(
			'id'		 => 'vt_option_layout',
			'title'      => esc_html__('Layout options', 'typecase'),
			'pages'      => array('vt_layout'),
			'context'    => 'normal',
			'priority'   => 'high',
			'fields' => array(

				array(
					'label' => esc_html__('Prevent flickers layout', 'typecase'),
					'desc'	=> esc_html__('Check this option to render CSS on header for layout in (Widget, Post content)', 'typecase'),
					'id'	=> 'vt_erender',
					'type'	=> 'checkbox'
				),

			)
		);
	return $metaboxes;
}
			$metaboxes = array();
			$metaboxes = apply_filters ( 'typecase_meta_metaboxes' , $metaboxes );
			foreach ( $metaboxes as $metabox ) {
				$my_box = new typecase_Meta_Box( $metabox );
			}
		}
	}
add_action( 'init', 'typecase_init_metaboxes', 9999 );
