<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
if ( ! class_exists( 'typecase_font_tax' ) ) :
	class typecase_font_tax {
		private static $instance = null;
		public static $fonts = null;
		public static $capability = 'edit_theme_options';
		public static $register_taxonomy_slug = 'vt_custom_fonts';
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		public function __construct() {
			add_action( 'init', array( $this, 'create_custom_fonts_taxonomies' ) );
		}
		public function create_custom_fonts_taxonomies() {
			$labels = array(
				'name'              => apply_filters( 'vt_custom_fonts_menu_title', __( 'Custom Fonts', 'custom-fonts' ) ),
				'singular_name'     => __( 'Font', 'custom-fonts' ),
				'menu_name'         => _x( 'Custom Fonts', 'Admin menu name', 'custom-fonts' ),
				'search_items'      => __( 'Search Fonts', 'custom-fonts' ),
				'all_items'         => __( 'All Fonts', 'custom-fonts' ),
				'parent_item'       => __( 'Parent Font', 'custom-fonts' ),
				'parent_item_colon' => __( 'Parent Font:', 'custom-fonts' ),
				'edit_item'         => __( 'Edit Font', 'custom-fonts' ),
				'update_item'       => __( 'Update Font', 'custom-fonts' ),
				'add_new_item'      => __( 'Add New Font', 'custom-fonts' ),
				'new_item_name'     => __( 'New Font Name', 'custom-fonts' ),
				'not_found'         => __( 'No fonts found', 'custom-fonts' ),
				'back_to_items'     => __( '← Go to Fonts', 'custom-fonts' ),
			);

			$args = array(
				'hierarchical'      => false,
				'labels'            => $labels,
				'public'            => false,
				'show_in_nav_menus' => false,
				'show_ui'           => true,
				'capabilities'      => array( self::$capability ),
				'query_var'         => false,
				'rewrite'           => false,
			);

			register_taxonomy(
				self::$register_taxonomy_slug,
				apply_filters( 'vt_taxonomy_objects_custom_fonts', array() ),
				apply_filters( 'vt_taxonomy_args_custom_fonts', $args )
			);
		}
		protected static function default_args( $fonts ) {
			return wp_parse_args(
				$fonts,
				array(
					'font_fallback'   => '',
					'font-display'    => 'swap',
					'repeater_fields' => array(
						'400' => array(
							'font_woff_2' => '',
							'font_woff'   => '',
							'font_ttf'    => '',
							'font_svg'    => '',
							'font_eot'    => '',
							'font_otf'    => '',
						),
					),
				)
			);
		}
		public static function typecase_get_fonts() {
			if ( is_null( self::$fonts ) ) {
				self::$fonts = array();

				$terms = get_terms(
					self::$register_taxonomy_slug,
					array(
						'hide_empty' => false,
					)
				);
				if ( ! empty( $terms ) ) {
					foreach ( $terms as $term ) {
						self::$fonts[ $term->slug ] = self::get_font_links( $term->term_id );
					}
				}
			}
			return self::$fonts;
		}
		public static function get_links_by_name( $name ) {

			$terms      = get_terms(
				self::$register_taxonomy_slug,
				array(
					'hide_empty' => false,
				)
			);
			$font_links = array();
			if ( ! empty( $terms ) ) {

				foreach ( $terms as $term ) {
					if ( $term->name == $name ) {
						$font_links[ $term->name ] = self::get_font_links( $term->term_id );
					}
				}
			}
			return $font_links;
		}
		public static function get_font_links( $term_id ) {
			$links = get_option( 'taxonomy_' . self::$register_taxonomy_slug . "_{$term_id}", array() );
			return $links;
		}
		public static function update_font_links( $posted, $term_id ) {
			$links = self::get_font_links( $term_id );
			$links = $posted;
			update_option( 'taxonomy_' . self::$register_taxonomy_slug . "_{$term_id}", $links );
		}
	}
	typecase_font_tax::get_instance();
endif;