<?php
if ( ! defined( 'ABSPATH' ) ) exit;
function typecase_woo_addon() {
  return typecase_woo_addon::instance();
}
typecase_woo_addon();
final class typecase_woo_addon {
  private static $_instance = null;
  public function __construct() {
    add_action( 'init', array( $this, 'typecase_woo_init' ) );
  }
  public static function instance() {
    if ( is_null( self::$_instance ) )
      self::$_instance = new self();
    return self::$_instance;
  }  
  
  public function typecase_woo_init() {
    if ( class_exists( 'woocommerce' ) ) {
      add_filter( 'woocommerce_sale_flash',  array( $this, 'typecase_woocommerce_sale_flash' ), 20, 3 );
      add_filter( 'woocommerce_loop_add_to_cart_link',  array( $this, 'typecase_external_add_product_link' ), 10, 2 );
      remove_action( 'woocommerce_external_add_to_cart', 'woocommerce_external_add_to_cart', 30 );      
      add_action( 'woocommerce_external_add_to_cart', array( $this,'typecase_external_add_to_cart'), 30 );
    
      if(empty(get_theme_mod('remove_woo_swatches'))){
            add_action( 'wp_enqueue_scripts', array( $this, 'frontend_scripts' ) );
            add_action( 'admin_enqueue_scripts', array( $this, 'backend_scripts' ) );
            // add field for attributes
            add_filter( 'product_attributes_type_selector', array( $this, 'type_selector' ) );
            $attrs = wc_get_attribute_taxonomies();
            foreach ( $attrs as $attr ) {
                $name = $attr->attribute_name;
                add_action( 'pa_' . $name . '_add_form_fields', array($this,'show_field') );
                add_action( 'pa_' . $name . '_edit_form_fields', array( $this,'show_field') );
                add_action( 'create_pa_' . $name, array($this,'save_field') );
                add_action( 'edited_pa_' . $name, array( $this, 'save_field' ) );
                add_filter( "manage_edit-pa_{$name}_columns", array($this,'custom_columns') );
                add_filter( "manage_pa_{$name}_custom_column", array($this,'custom_columns_content'), 10, 3 );
            }
            add_filter( 'woocommerce_dropdown_variation_attribute_options_html', array($this,'variation_attribute_options_html'), 199, 2 );            
        }
    }

  }  
  
  public function typecase_woocommerce_sale_flash( $html = '', $post = '', $product = null ) {
	if ( $product->is_type( 'grouped' ) ) {
		return '<span class="onsale typecase-badge">' . esc_html__( 'Sale', 'typecase' ) . '</span>';
	} elseif ( $product->is_type( 'variable' ) ) {
		$percentages = array();
		$prices      = $product->get_variation_prices();
		foreach ( $prices['price'] as $key => $price ) {
			if ( $prices['regular_price'][ $key ] !== $price ) {
				$percentages[] = 100 - ( $prices['sale_price'][ $key ] / $prices['regular_price'][ $key ] * 100 );
			}
		}
		$percentage = max( $percentages );
	} else {
		$regular_price = $product->get_regular_price();
		$sale_price    = $product->get_sale_price();

		$percentage = 100 - ( (float) $sale_price / (float) $regular_price * 100 );
	}
	if ( $percentage > 1 ) {
		return '<span class="onsale typecase-badge">-' . round( (float) $percentage ) . '%</span>';
	}
}

  public function typecase_external_add_product_link( $link ) {
    global $product;
        if ( $product->is_type( 'external' ) ) {
          $link =	sprintf( apply_filters( 'external_add_product_link_html', '<a rel="nofollow noopener noreferrer" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s" target="_blank">%s</a>' ),
            esc_url( $product->add_to_cart_url() ),
            esc_attr( isset( $quantity ) ? $quantity : 1 ),
            esc_attr( $product->get_id() ),
            esc_attr( $product->get_sku() ),
            esc_attr( isset( $class ) ? $class : apply_filters( 'external_add_product_link_html_classes', 'button product_type_external' ) ),
            esc_html( $product->add_to_cart_text() )
          );
        }
        return $link;
  }

  public function typecase_external_add_to_cart() {
    global $product;
        if ( ! $product->add_to_cart_url() ) {
          return;
        }
        $product_url = $product->add_to_cart_url();
        $button_text = $product->single_add_to_cart_text();
        do_action( 'woocommerce_before_add_to_cart_button' ); ?>
        <p class="cart">
            <a href="<?php echo esc_url( $product_url ); ?>" rel="nofollow noopener noreferrer" class="single_add_to_cart_button button alt" target="_blank"><?php echo esc_html( $button_text ); ?></a>
        </p>
        <?php do_action( 'woocommerce_after_add_to_cart_button' );
  }

  // swatcher

  public function frontend_scripts(){
      wp_enqueue_script( 'wc-add-to-cart-variation' );
      wp_enqueue_style( 'typecase-swatches', plugins_url( 'swatches/css/swatches.css', __FILE__ ), '1.0' );
      wp_enqueue_script( 'typecase-swatches', plugins_url( 'swatches/js/swatches.js', __FILE__ ), array( 'jquery' ), '1.0', true );
  }

  public function backend_scripts(){
      wp_enqueue_script( 'typecase-backend', plugins_url( 'swatches/js/backend.js', __FILE__ ), array('jquery','wp-color-picker'), '1.0', true );
      wp_localize_script( 'typecase-backend', 'product_attribute_vars', array('placeholder_img' => wc_placeholder_img_src()) );
  }    

  public function type_selector( $types ){
      global $pagenow;

      if ( ( defined( 'DOING_AJAX' ) && DOING_AJAX ) || ( $pagenow === 'post-new.php' ) || ( $pagenow === 'post.php' )  ) {
          return $types;
      } else {
          $types['color']  = esc_html__( 'Color', 'typecase' );
          $types['image']  = esc_html__( 'Image', 'typecase' );
          $types['button']  = esc_html__( 'Button', 'typecase' );

          return $types;
      }
  }

  public function show_field( $term_or_tax ){
      if ( is_object( $term_or_tax ) ) {
          // is term
          $term_id    = $term_or_tax->term_id;
          $attr_id    = wc_attribute_taxonomy_id_by_name( $term_or_tax->taxonomy );
          $attr_info  = wc_get_attribute( $attr_id );
          $html_start = '<tr class="form-field"><th><label>';
          $html_mid   = '</label></th><td>';
          $html_end   = '</td></tr>';
      } else {
          // is taxonomy
          $term_id    = 0;
          $attr_id    = wc_attribute_taxonomy_id_by_name( $term_or_tax );
          $attr_info  = wc_get_attribute( $attr_id );
          $html_start = '<div class="form-field"><label>';
          $html_mid   = '</label>';
          $html_end   = '</div>';
      }
      $type = $attr_info->type;

      $value   = get_term_meta( $term_id, 'product_attribute_'.$type, true ) ? : '';

      if ( $type == 'color' ) {
          echo $html_start . esc_html__( 'Color', 'typecase' ) . $html_mid . '<input class="product_attribute_color" id="product_attribute_color" name="product_attribute_color" value="' . esc_attr( $value ) . '" type="text"/>' . $html_end;
      }
      if ( $type == 'image' ) {
          wp_enqueue_media();
          $image = $value ? wp_get_attachment_thumb_url( $value ) : wc_placeholder_img_src();

          echo $html_start . 'Image' . $html_mid; ?>
              <div id="product_attribute_image_thumbnail">
                  <img src="<?php echo esc_url( $image ); ?>" width="60px" height="60px"/>
              </div>
              <div id="product_attribute_image_wrapper">
                  <input type="hidden" id="product_attribute_image" name="product_attribute_image" value="<?php echo esc_attr( $value ); ?>"/>
                  <button id="product_attribute_upload_image" type="button" class="product_attribute_upload_image button"><?php esc_html_e( 'Upload/Add image', 'typecase' ); ?></button>
                  <button id="product_attribute_remove_image" type="button" class="product_attribute_remove_image button"><?php esc_html_e( 'Remove image', 'typecase' ); ?></button>
              </div>
          <?php
          echo $html_end;
      }
  }

  public function save_field( $term_id ){
      $terms = [
          'product_attribute_color',
          'product_attribute_image',
          'product_attribute_button'
      ];
      foreach ( $terms as $term ) {
          if ( isset( $_POST[$term] ) ) {
              update_term_meta( $term_id, $term, sanitize_text_field( $_POST[$term] ) );
          }
      }
  }

  public function variation_attribute_options_html( $html, $args ){
      $term_html = '';
      $attr_id   = wc_attribute_taxonomy_id_by_name( $args['attribute'] );
      
      $options               = $args['options'];
      $product               = $args['product'];
      $attribute             = $args['attribute'];

      if ( $attr_id ) {
          $attr_info    = wc_get_attribute( $attr_id );
          $curr['type'] = isset( $attr_info->type ) ? $attr_info->type : '';
          $curr['slug'] = isset( $attr_info->slug ) ? $attr_info->slug : '';
          $curr['name'] = isset( $attr_info->name ) ? $attr_info->name : '';

          if ( $curr['type'] == 'color' || $curr['type'] == 'image' || $curr['type'] == 'button' ) {
              $term_html .= '<div class="typecase-terms typecase-type-'.esc_attr( $curr['type'] ).'" data-attribute="'.esc_attr( $args['attribute'] ).'">';
              
              if ( $product && taxonomy_exists( $attribute ) ) {
                  $terms = wc_get_product_terms(
                      $product->get_id(),
                      $attribute,
                      array(
                          'fields' => 'all',
                      )
                  );

                  foreach ( $terms as $term ) {
                      if ( in_array( $term->slug, $options, true ) ) {
                          $name    = get_term_meta( $term->term_id, 'product_attribute_'.$curr['type'], true ) ? : '';
                          $val     = get_term_meta( $term->term_id, 'product_attribute_'.$curr['type'], true ) ? : '';
                          $img     = $val ? wp_get_attachment_thumb_url( $val ) : wc_placeholder_img_src();
                          $style   =  $curr['type'] == 'color' && ! empty( $val ) ? ' style="background-color:' . esc_attr( $val ) . '"' : '';

                          if ( $curr['type'] == 'color' || $curr['type'] == 'button' ) {
                              $term_html .= '<span class="typecase-term" data-term="'.esc_attr( $term->slug ).'"'.$style.'>'.esc_html( $term->name ).'</span>';
                          }
                          if ( $curr['type'] == 'image' ) {
                              $term_html .= '<span class="typecase-term" data-term="'.esc_attr( $term->slug ).'"><img src="'.esc_url( $img ).'" alt="'.esc_attr( $term->name ).'"/></span>';
                          }
                              
                      }
                  }
              }

              $term_html .= '</div>';
          }
      }
      return $term_html . $html;
  }

  public function custom_columns( $columns ){
      $columns['product_attribute_value']   = esc_html__( 'Value', 'typecase' );

      return $columns;
  }

  public function custom_columns_content( $columns, $column, $term_id ){
      if ( 'product_attribute_value' === $column ) {
          $term = get_term( $term_id );
          $id   = wc_attribute_taxonomy_id_by_name( $term->taxonomy );
          $attr = wc_get_attribute( $id );

          switch ( $attr->type ) {
              case 'image':
              $val = get_term_meta( $term_id, 'product_attribute_image', true );
              echo '<img class="typecase-column-item" src="' . esc_url( wp_get_attachment_thumb_url( $val ) ) . '"/>';
              break;

              case 'color':
              $val = get_term_meta( $term_id, 'product_attribute_color', true );
              echo '<span class="typecase-column-item" style="background-color: ' . esc_attr( $val ) . '; display:block; height: 30px; width: 30px; border-radius: 100px;"></span>';
              break;
          }
      }
  }

}


function typecase_woocommerce_layered_nav_term_html( $term_html, $term, $link, $count ) {

	$attribute_label_name = wc_attribute_label($term->taxonomy);;
	$attribute_id = wc_attribute_taxonomy_id_by_name($attribute_label_name);
	$attr  = wc_get_attribute($attribute_id);
	$array = json_decode(json_encode($attr), true);

	if($array['type'] == 'color'){
		$color = get_term_meta( $term->term_id, 'product_attribute_color', true );
		$term_html = '<div class="type-color"><span class="color-box" style="background-color:'.esc_attr($color).';"></span>'.$term_html.'</div>';
	}
	
	if($array['type'] == 'button'){
		$term_html = '<div class="type-button"><span class="button-box"></span>'.$term_html.'</div>';
	}

    return $term_html; 
}; 
         
add_filter( 'woocommerce_layered_nav_term_html', 'typecase_woocommerce_layered_nav_term_html', 10, 4 ); 



function typecase_remove_woo_filter(){
	if(empty(get_theme_mod('remove_woo_swatches'))){        
	$output = '';

	$_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes();
    $min_price = isset( $_GET['min_price'] ) ? wc_clean( $_GET['min_price'] ) : 0; 
    $max_price = isset( $_GET['max_price'] ) ? wc_clean( $_GET['max_price'] ) : 0; 

	if(! empty( $_chosen_attributes ) || isset($_GET['filter_cat']) || 0 < $min_price || 0 < $max_price || typecase_stock_status() == 'instock' || typecase_on_sale() == 'onsale'){

		global $wp;
	
		if ( '' === get_option( 'permalink_structure' ) ) {
			$baselink = remove_query_arg( array( 'page', 'paged' ), add_query_arg( $wp->query_string, '', home_url( $wp->request ) ) );
		} else {
			$baselink = preg_replace( '%\/page/[0-9]+%', '', home_url( add_query_arg( null, null ) ) );
		}

        if(class_exists('typecasetxt')){
            $sting_filter = typecasetxt::typecase_clear_filter();
        }else{
            $sting_filter = esc_html__('Clear filters','typecase');
        }

		$output .= '<ul class="vt_remove_filter">';
		
		$output .= '<li><a href="'.esc_url(remove_query_arg(array_keys($_GET))).'" class="remove-filter-element clear-all">'.$sting_filter.'</a></li>';

		if ( ! empty( $_chosen_attributes ) ) {
			foreach ( $_chosen_attributes as $taxonomy => $data ) {
				foreach ( $data['terms'] as $term_slug ) {
					$term = get_term_by( 'slug', $term_slug, $taxonomy );
					
					$filter_name    = 'filter_' . wc_attribute_taxonomy_slug( $taxonomy );
					$explode_old = explode(',',$_GET[$filter_name]);
					$explode_termid = explode(',',$term->slug);
					$klbdata = array_diff( $explode_old, $explode_termid);
					$klbdataimplode = implode(',',$klbdata);
					
					if(empty($klbdataimplode)){
						$link = remove_query_arg($filter_name);
					} else {
						$link = add_query_arg($filter_name,implode(',',$klbdata),$baselink );
					}

					$output .= '<li><a href="'.esc_url($link).'" class="remove-filter-element attributes">'.esc_html($term->name).'</a></li>';

				}
			}
		}

		if(typecase_stock_status() == 'instock'){
		$output .= '<li><a href="'.esc_url(remove_query_arg('stock_status')).'" class="remove-filter-element stock_status">'.esc_html__('In Stock','typecase').'</a></li>';
		}
		
		if(typecase_on_sale() == 'onsale'){
		$output .= '<li><a href="'.esc_url(remove_query_arg('on_sale')).'" class="remove-filter-element on_sale">'.esc_html__('On Sale','typecase').'</a></li>';
		}

		if($min_price){
		$output .= '<li><a href="'.esc_url(remove_query_arg('min_price')).'" class="remove-filter-element min_price">' . sprintf( __( 'Min %s', 'woocommerce' ), wc_price( $min_price ) ) . '</a></li>';
		}
		
		if($max_price){
		$output .= '<li><a href="'.esc_url(remove_query_arg('max_price')).'" class="remove-filter-element max_price">' . sprintf( __( 'Max %s', 'woocommerce' ), wc_price( $max_price ) ) . '</a></li>';
		}
		
		if(isset($_GET['filter_cat'])){
			$terms = get_terms( array(
				'taxonomy' => 'product_cat',
				'hide_empty' => false,
				'parent'    => 0,
				'include' 	=> explode(',',$_GET['filter_cat']),
			) );
			
			foreach ( $terms as $term ) {
				$term_children = get_term_children( $term->term_id, 'product_cat' );
				$output .= '<li><a href="'.esc_url( typecase_get_cat_url($term->term_id) ).'" class="remove-filter-element product_cat" id="'.esc_attr($term->term_id).'">'.esc_html($term->name).'</a></li>';
				if($term_children){
					foreach($term_children as $child){
						$childterm = get_term_by( 'id', $child, 'product_cat' );
						if(in_array($childterm->term_id, explode(',',$_GET['filter_cat']))){ 
							$output .= '<li><a href="'.esc_url( typecase_get_cat_url($childterm->term_id) ).'" class="remove-filter-element product_cat" id="'.esc_attr($childterm->term_id).'">'.esc_html($childterm->name).'</a></li>';
						}
					}
				}
			}
		
		}
		
		$output .= '</ul>';
	}
	
	return $output;
}
}


function typecase_get_cat_url($termid){
	global $wp;
	if ( '' === get_option( 'permalink_structure' ) ) {
		$link = remove_query_arg( array( 'page', 'paged' ), add_query_arg( $wp->query_string, '', home_url( $wp->request ) ) );
	} else {
		$link = preg_replace( '%\/page/[0-9]+%', '', add_query_arg( null, null ) );
	}

	if(isset($_GET['filter_cat'])){
		$explode_old = explode(',',$_GET['filter_cat']);
		$explode_termid = explode(',',$termid);
		
		if(in_array($termid, $explode_old)){
			$data = array_diff( $explode_old, $explode_termid);
			$checkbox = 'checked';
		} else {
			$data = array_merge($explode_termid , $explode_old);
		}
	} else {
		$data = array($termid);
	}
	
	$dataimplode = implode(',',$data);
	
	if(empty($dataimplode)){
		$link = remove_query_arg('filter_cat',$link);
	} else {
		$link = add_query_arg('filter_cat',implode(',',$data),$link);
	}
	
	return $link;
}

function typecase_stock_status(){
	$stock_status  = isset( $_GET['stock_status'] ) ? $_GET['stock_status'] : '';

	if($stock_status == 'instock'){
		return $stock_status;
	}
}

function typecase_on_sale(){
	$on_sale  = isset( $_GET['on_sale'] ) ? $_GET['on_sale'] : '';

	if($on_sale == 'onsale'){
		return $on_sale;
	}
}
