<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init','typecase_about_us_load_widgets');
function typecase_about_us_load_widgets(){
		register_widget("typecase_about_us_widget");
}

class typecase_about_us_widget extends WP_widget{

/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/

	public function __construct() {
		$widget_ops = array( 'classname' => 'visionwp_about_us_widget', 'description' => esc_html__( 'About us and social icons' , 'typecase') );
		parent::__construct('typecase_about_us_widget', esc_html__('&nbsp;About us', 'typecase'), $widget_ops);
	}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget($args,$instance){
	extract($args);		
		
		$title = isset($instance['title']) ? $instance['title'] : "About us";
		$feed_description = isset($instance['feed_description']) ? $instance['feed_description'] : "Mauris mattis auctor cursus. Phasellus tellus tellus, imperdiet ut imperdiet eu, iaculis a sem imperdiet ut imperdiet eu.";
		$alignment = isset($instance['alignment']) ? $instance['alignment'] : "center";
        $space_element = isset($instance['space_element']) ? $instance['space_element'] : "20px";
        $image_uri = isset($instance['image_uri']) ? $instance['image_uri'] : "";
        $signature_uri = isset($instance['signature_uri']) ? $instance['signature_uri'] : "";
        $auth_img_radius = isset($instance['auth_img_radius']) ? $instance['auth_img_radius'] : "200px";
        $author_img_width = isset($instance['author_img_width']) ? $instance['author_img_width'] : "180px";
        $sign_img_width = isset($instance['sign_img_width']) ? $instance['sign_img_width'] : "120px";
		$facebook = isset($instance['facebook']) ? $instance['facebook'] : "#";
		$twitter = isset($instance['twitter']) ? $instance['twitter'] : "#";        
        $instagram = isset($instance['instagram']) ? $instance['instagram'] : "#";                
        $pinterest = isset($instance['pinterest']) ? $instance['pinterest'] : "#";
        $youtube = isset($instance['youtube']) ? $instance['youtube'] : "#";
        $vimeo = isset($instance['vimeo']) ? $instance['vimeo'] : "#";        
        $sound_cloud = isset($instance['sound_cloud']) ? $instance['sound_cloud'] : "#";
        $spotify_i = isset($instance['spotify_i']) ? $instance['spotify_i'] : "#";        
        $linkedin = isset($instance['linkedin']) ? $instance['linkedin'] : "#";        
        $behance = isset($instance['behance']) ? $instance['behance'] : "#";
        $telegram = isset($instance['telegram']) ? $instance['telegram'] : "#";
		$tumblr = isset($instance['tumblr']) ? $instance['tumblr'] : "#";
		$deviantart = isset($instance['deviantart']) ? $instance['deviantart'] : "#";
		$dribble = isset($instance['dribble']) ? $instance['dribble'] : "#";
		$dropbox = isset($instance['dropbox']) ? $instance['dropbox'] : "#";
		$rss = isset($instance['rss']) ? $instance['rss'] : "#";
		$skype = isset($instance['skype']) ? $instance['skype'] : "#";
		$stumbleupon = isset($instance['stumbleupon']) ? $instance['stumbleupon'] : "#";
		$wordpress = isset($instance['wordpress']) ? $instance['wordpress'] : "#";
		$yahoo = isset($instance['yahoo']) ? $instance['yahoo'] : "#";
		$flickr = isset($instance['flickr']) ? $instance['flickr'] : "#";
		$wechat = isset($instance['wechat']) ? $instance['wechat'] : "#";        
        $tiktok = isset($instance['tiktok']) ? $instance['tiktok'] : "#";        
        $vk = isset($instance['vk']) ? $instance['vk'] : "#";        
        
        if(empty($auth_img_radius)){
            $auth_img_radius = '0px';
        }
        if(empty($author_img_width)){
            $author_img_width = 'auto';
        }
        $author_img_width = 'style="max-width:'.$author_img_width.'; border-radius:'.$auth_img_radius.'"';
        
        if(!empty($sign_img_width)){
            $sign_img_width = 'style="max-width:'.$sign_img_width.'"';
        }
        
        if(! empty($space_element)){
            $space_element = 'style="gap:'.$space_element.';"';
        }

        if(empty($space_element)){
            $space_element = '';
        }
                
		?>

<?php print $before_widget;?>
<div class="widget_vt_wrapper vt_wab_<?php echo esc_attr($alignment);?>">
    <?php if($title) { print $before_title.esc_attr($title).$after_title; }?>
    <div class="vt_shab_w" <?php echo $space_element;?>>
        <?php if(!empty($image_uri)){
        echo '<span class="ab_img_w" '.$author_img_width.'>';
        echo wp_get_attachment_image( $image_uri, 'typecase_featuresmall', "", array( "class" => "vt_f_img_bg" ) );
        echo '</span>';
        }?>        
        <?php if(!empty($feed_description)){?>
        <p><?php echo esc_attr($feed_description); ?></p>
        <?php }?>
        <?php if(!empty($signature_uri)){
        echo '<span class="ab_img_w ab_img_sg" '.$sign_img_width.'>';
        echo wp_get_attachment_image( $signature_uri, 'typecase_featuresmall', "", array( "class" => "vt_f_img_bg" ) );
        echo '</span>';
        }?>
        <div class="vt_sh_widget">
            <ul class="vt_sh_ic_li">
                <?php if($facebook !=''){?>
                <li><a href="<?php echo esc_url($facebook);?>" class="facebook" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('facebook', 'typecase');?>" ><i class="vti-facebook"></i></a></li>
                <?php }?>
                <?php if($behance !=''){?>
                <li><a href="<?php echo esc_url($behance);?>" class="behance" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('behance', 'typecase');?>" ><i class="vti-behance"></i></a></li>
                <?php }?>
                <?php if($telegram !=''){?>
                <li><a href="<?php echo esc_url($telegram);?>" class="telegram" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('telegram', 'typecase');?>" ><i class="vti-telegram"></i></a></li>
                <?php }?>
                <?php if($vimeo !=''){?>
                <li><a href="<?php echo esc_url($vimeo);?>" class="vimeo" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('vimeo', 'typecase');?>" ><i class="vti-vimeo"></i></a></li>
                <?php }?>
                <?php if($youtube !=''){?>
                <li><a href="<?php echo esc_url($youtube);?>" class="youtube" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('youtube', 'typecase');?>" ><i class="vti-youtube"></i></a></li>
                <?php }?>
                <?php if($tumblr !=''){?>
                <li><a href="<?php echo esc_url($tumblr);?>" class="tumblr" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('tumblr', 'typecase');?>" ><i class="vti-tumblr"></i></a></li>
                <?php }?>
                <?php if($instagram !=''){?>
                <li><a href="<?php echo esc_url($instagram);?>" class="instagram" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('instagram', 'typecase');?>" ><i class="vti-instagram"></i></a></li>
                <?php }?>
                <?php if($linkedin !=''){?>
                <li><a href="<?php echo esc_url($linkedin);?>" class="linkedin" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('linkedin', 'typecase');?>" ><i class="vti-linkedin"></i></a></li>
                <?php }?>
                <?php if($pinterest !=''){?>
                <li><a href="<?php echo esc_url($pinterest);?>" class="pinterest" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('pinterest', 'typecase');?>" ><i class="vti-pinterest"></i></a></li>
                <?php }?>
                <?php if($twitter !=''){?>
                <li><a href="<?php echo esc_url($twitter);?>" class="twitter" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('twitter', 'typecase');?>" ><i class="vti-twitter"></i></a></li>
                <?php }?>
                <?php if($deviantart !=''){?>
                <li><a href="<?php echo esc_url($deviantart);?>" class="deviantart" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('deviantart', 'typecase');?>" ><i class="vti-deviantart"></i></a></li>
                <?php }?>
                <?php if($dribble !=''){?>
                <li><a href="<?php echo esc_url($dribble);?>" class="dribble" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('dribble', 'typecase');?>" ><i class="vti-dribble"></i></a></li>
                <?php }?>
                <?php if($dropbox !=''){?>
                <li><a href="<?php echo esc_url($dropbox);?>" class="dropbox" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('dropbox', 'typecase');?>" ><i class="vti-dropbox"></i></a></li>
                <?php }?>
                <?php if($rss !=''){?>
                <li><a href="<?php echo esc_url($rss);?>" class="rss" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('rss', 'typecase');?>" ><i class="vti-rss"></i></a></li>
                <?php }?>
                <?php if($skype !=''){?>
                <li><a href="<?php echo esc_url($skype);?>" class="skype" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('skype', 'typecase');?>" ><i class="vti-skype"></i></a></li>
                <?php }?>
                <?php if($stumbleupon !=''){?>
                <li><a href="<?php echo esc_url($stumbleupon);?>" class="stumbleupon" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('stumbleupon', 'typecase');?>" ><i class="vti-stumbleupon"></i></a></li>
                <?php }?>
                <?php if($wordpress !=''){?>
                <li><a href="<?php echo esc_url($wordpress);?>" class="wordpress" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('wordpress', 'typecase');?>" ><i class="vti-wordpress"></i></a></li>
                <?php }?>
                <?php if($yahoo !=''){?>
                <li><a href="<?php echo esc_url($yahoo);?>" class="yahoo" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('yahoo', 'typecase');?>" ><i class="vti-yahoo"></i></a></li>
                <?php }?>
                <?php if($flickr !=''){?>
                <li><a href="<?php echo esc_url($flickr);?>" class="flickr" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('flickr', 'typecase');?>" ><i class="vti-flickr"></i></a></li>
                <?php }?>
                <?php if($sound_cloud !=''){?>
                <li><a href="<?php echo esc_url($sound_cloud);?>" class="soundcloud" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('soundcloud', 'typecase');?>" ><i class="vti-soundcloud"></i></a></li>
                <?php }?>
                <?php if($spotify_i !=''){?>
                <li><a href="<?php echo esc_url($spotify_i);?>" class="soundcloud" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('spotify', 'typecase');?>" ><i class="vti-spotify"></i></a></li>
                <?php }?>
                <?php if($wechat !=''){?>
                <li><a href="<?php echo esc_url($wechat);?>" class="soundcloud" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('wechat', 'typecase');?>" ><i class="vti-wechat"></i></a></li>
                <?php }?>        
                <?php if($tiktok !=''){?>
                <li><a href="<?php echo esc_url($tiktok);?>" class="tiktok" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('tiktok', 'typecase');?>" ><i class="vti-tiktok"></i></a></li>
                <?php }?>        
                <?php if($vk !=''){?>
                <li><a href="<?php echo esc_url($vk);?>" class="vk" target="_blank" rel="noopener nofollow" aria-label="<?php esc_html_e('vk', 'typecase');?>" ><i class="vti-vk"></i></a></li>
                <?php }?>        
                                            
            </ul>
        </div>
    </div>
    <?php
		print $after_widget;
	print "</div>";
	}

/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['feed_description'] = $new_instance['feed_description'];
		$instance['alignment'] = $new_instance['alignment'];
        $instance['space_element'] = $new_instance['space_element'];
        $instance['image_uri'] = $new_instance['image_uri'];
        $instance['signature_uri'] = $new_instance['signature_uri'];
        $instance['auth_img_radius'] = $new_instance['auth_img_radius'];
        $instance['author_img_width'] = $new_instance['author_img_width'];
        $instance['sign_img_width'] = $new_instance['sign_img_width'];
		$instance['facebook'] = $new_instance['facebook'];
		$instance['behance'] = $new_instance['behance'];
        $instance['telegram'] = $new_instance['telegram'];
		$instance['vimeo'] = $new_instance['vimeo'];
		$instance['youtube'] = $new_instance['youtube'];
		$instance['tumblr'] = $new_instance['tumblr'];
		$instance['instagram'] = $new_instance['instagram'];
		$instance['linkedin'] = $new_instance['linkedin'];
		$instance['pinterest'] = $new_instance['pinterest'];
		$instance['twitter'] = $new_instance['twitter'];
		$instance['blogger'] = $new_instance['blogger'];
		$instance['deviantart'] = $new_instance['deviantart'];
		$instance['dribble'] = $new_instance['dribble'];
		$instance['dropbox'] = $new_instance['dropbox'];
		$instance['rss'] = $new_instance['rss'];
		$instance['skype'] = $new_instance['skype'];
		$instance['stumbleupon'] = $new_instance['stumbleupon'];
		$instance['wordpress'] = $new_instance['wordpress'];
		$instance['yahoo'] = $new_instance['yahoo'];
		$instance['flickr'] = $new_instance['flickr'];
		$instance['sound_cloud'] = $new_instance['sound_cloud'];
        $instance['spotify_i'] = $new_instance['spotify_i'];
        $instance['wechat'] = $new_instance['wechat'];  
        $instance['tiktok'] = $new_instance['tiktok'];  
        $instance['vk'] = $new_instance['vk'];              
		return $instance;
	}

	function form($instance){
			$defaults = array(
                'title' => esc_html__( 'About us' , 'typecase'),
                'feed_description' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis', 
                'alignment' => 'center', 
                'space_element' => '30px', 
                'image_uri' => '', 
                'signature_uri' => '',                
                'auth_img_radius' => '200px',                 
                'author_img_width' => '180px',                 
                'sign_img_width' => '120px',                                  
                'facebook' => '#', 
                'behance' => '#', 
                'telegram' => '#', 
                'vimeo' => '#', 
                'youtube' => '#', 
                'tumblr' => '#', 
                'instagram' => '#', 
                'linkedin' => '#', 
                'pinterest' => '#', 
                'twitter' => '#', 
                'blogger' => '#', 
                'deviantart' => '#', 
                'dribble' => '#', 
                'dropbox' => '#', 
                'rss' => '#', 
                'skype' => '#', 
                'stumbleupon' => '#', 
                'wordpress' => '#', 
                'yahoo' => '#', 
                'flickr' => '#', 
                'sound_cloud' => '#', 
                'spotify_i' => '#', 
                'wechat' => '#',
                'tiktok' => '#',
                'vk' => '#');                
			$instance = wp_parse_args((array) $instance, $defaults); 
		?>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
            <?php esc_html_e( 'Title:', 'typecase'); ?></label>
        <input class="widefat" width="100%" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
    </p>

    <p>
        <?php
        if (!empty($instance['image_uri'])){
        $image_uri = wp_get_attachment_image_src($instance['image_uri'], 'thumbnail');?>
        <img class="<?php echo esc_attr($this->id);?>_img" src="<?php echo esc_url($image_uri[0]); ?>" style="margin:0;padding:0;max-width:100%;display:block"/>
        <?php }else{?>
        <img class="<?php echo esc_attr($this->id);?>_img" src="" style="margin:0;padding:0;max-width:100%;display:block"/>
        <?php }?>
        <input type="hidden" class="widefat <?php echo esc_attr($this->id);?>_url" name="<?php echo esc_attr($this->get_field_name( 'image_uri' ));?>" value="<?php echo esc_attr($instance['image_uri']); ?>" style="margin-top:5px;" />
        <input type="button" id="<?php echo esc_attr($this->id); ?>" class="button button-primary vt_custom_upload_media" value="Upload Image" style="margin-top:5px;" />
    </p>

    <p>
        <?php
        if (!empty($instance['signature_uri'])){
        $signature_uri = wp_get_attachment_image_src($instance['signature_uri'], 'thumbnail');?>
        <img class="<?php echo esc_attr($this->id);?>_signimg" src="<?php echo esc_url($signature_uri[0]); ?>" style="margin:0;padding:0;max-width:100%;display:block"/>
        <?php }else{?>
        <img class="<?php echo esc_attr($this->id);?>_signimg" src="" style="margin:0;padding:0;max-width:100%;display:block"/>
        <?php }?>
        <input type="hidden" class="widefat <?php echo esc_attr($this->id);?>_signurl" name="<?php echo esc_attr($this->get_field_name( 'signature_uri' ));?>" value="<?php echo esc_attr($instance['signature_uri']); ?>" style="margin-top:5px;" />
        <input type="button" id="<?php echo esc_attr($this->id); ?>" class="button button-primary vt_sign_media" value="Upload Image" style="margin-top:5px;" />
    </p>

    <p><label for="<?php echo esc_attr( $this->get_field_id( 'alignment' ) ); ?>">
    <?php esc_html_e( 'Alignment' , 'typecase' ); ?></label></label>
    <select style="width: 100%;" id="<?php echo esc_attr( $this->get_field_id( 'alignment' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'alignment' ) ); ?>">
        <option value="left" <?php if ( $instance['alignment']=='left' ) echo 'selected="selected"'; ?>>Left</option>
        <option value="center" <?php if ( $instance['alignment']=='center' ) echo 'selected="selected"'; ?>>Center</option>
        <option value="right" <?php if ( $instance['alignment']=='right' ) echo 'selected="selected"'; ?>>Right</option>        
    </select></p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('space_element')); ?>">
            <?php esc_html_e( 'Space image and text: 100px' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('space_element')); ?>" name="<?php echo esc_attr($this->get_field_name('space_element')); ?>" type="text" value="<?php echo esc_attr($instance['space_element']); ?>" />
    </p>    

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('auth_img_radius')); ?>">
            <?php esc_html_e( 'Image border radius EX: 200px' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('auth_img_radius')); ?>" name="<?php echo esc_attr($this->get_field_name('auth_img_radius')); ?>" type="text" value="<?php echo esc_attr($instance['auth_img_radius']); ?>" />
    </p>    

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('author_img_width')); ?>">
            <?php esc_html_e( 'Image width EX: 100px' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('author_img_width')); ?>" name="<?php echo esc_attr($this->get_field_name('author_img_width')); ?>" type="text" value="<?php echo esc_attr($instance['author_img_width']); ?>" />
    </p>    

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('sign_img_width')); ?>">
            <?php esc_html_e( 'Image signature width EX: 100px' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('sign_img_width')); ?>" name="<?php echo esc_attr($this->get_field_name('sign_img_width')); ?>" type="text" value="<?php echo esc_attr($instance['sign_img_width']); ?>" />
    </p>    

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('feed_description')); ?>">
            <?php esc_html_e( 'Feed description:', 'typecase'); ?></label>
        <textarea class="widefat" style="width: 100%; height:150px;" id="<?php echo esc_attr($this->get_field_id('feed_description')); ?>" name="<?php echo esc_attr($this->get_field_name('feed_description')); ?>"><?php echo esc_attr($instance['feed_description']); ?></textarea>
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('facebook')); ?>">
            <?php esc_html_e( 'Facebook Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('facebook')); ?>" name="<?php echo esc_attr($this->get_field_name('facebook')); ?>" type="text" value="<?php echo esc_url($instance['facebook']); ?>" />
    </p>    
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('behance')); ?>">
            <?php esc_html_e( 'Behance Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('behance')); ?>" name="<?php echo esc_attr($this->get_field_name('behance')); ?>" type="text" value="<?php echo esc_url($instance['behance']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('telegram')); ?>">
            <?php esc_html_e( 'Telegram Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('telegram')); ?>" name="<?php echo esc_attr($this->get_field_name('telegram')); ?>" type="text" value="<?php echo esc_url($instance['telegram']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('vimeo')); ?>">
            <?php esc_html_e( 'Vimeo Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('vimeo')); ?>" name="<?php echo esc_attr($this->get_field_name('vimeo')); ?>" type="text" value="<?php echo esc_url($instance['vimeo']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('youtube')); ?>">
            <?php esc_html_e( 'Youtube Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('youtube')); ?>" name="<?php echo esc_attr($this->get_field_name('youtube')); ?>" type="text" value="<?php echo esc_url($instance['youtube']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('tumblr')); ?>">
            <?php esc_html_e( 'tumblr Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('tumblr')); ?>" name="<?php echo esc_attr($this->get_field_name('tumblr')); ?>" type="text" value="<?php echo esc_url($instance['tumblr']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('instagram')); ?>">
            <?php esc_html_e( 'Instagram Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('instagram')); ?>" name="<?php echo esc_attr($this->get_field_name('instagram')); ?>" type="text" value="<?php echo esc_url($instance['instagram']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('linkedin')); ?>">
            <?php esc_html_e( 'Linkedin Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('linkedin')); ?>" name="<?php echo esc_attr($this->get_field_name('linkedin')); ?>" type="text" value="<?php echo esc_url($instance['linkedin']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('pinterest')); ?>">
            <?php esc_html_e( 'Pinterest Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('pinterest')); ?>" name="<?php echo esc_attr($this->get_field_name('pinterest')); ?>" type="text" value="<?php echo esc_url($instance['pinterest']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('twitter')); ?>">
            <?php esc_html_e( 'Twitter Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('twitter')); ?>" name="<?php echo esc_attr($this->get_field_name('twitter')); ?>" type="text" value="<?php echo esc_url($instance['twitter']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('blogger')); ?>">
            <?php esc_html_e( 'Blogger Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('blogger')); ?>" name="<?php echo esc_attr($this->get_field_name('blogger')); ?>" type="text" value="<?php echo esc_url($instance['blogger']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('deviantart')); ?>">
            <?php esc_html_e( 'Deviantart Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('deviantart')); ?>" name="<?php echo esc_attr($this->get_field_name('deviantart')); ?>" type="text" value="<?php echo esc_url($instance['deviantart']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('dribble')); ?>">
            <?php esc_html_e( 'Dribble Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('dribble')); ?>" name="<?php echo esc_attr($this->get_field_name('dribble')); ?>" type="text" value="<?php echo esc_url($instance['dribble']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('stumbleupon')); ?>">
            <?php esc_html_e( 'Stumbleupon Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('stumbleupon')); ?>" name="<?php echo esc_attr($this->get_field_name('stumbleupon')); ?>" type="text" value="<?php echo esc_url($instance['stumbleupon']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('dropbox')); ?>">
            <?php esc_html_e( 'Dropbox Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('dropbox')); ?>" name="<?php echo esc_attr($this->get_field_name('dropbox')); ?>" type="text" value="<?php echo esc_url($instance['dropbox']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('rss')); ?>">
            <?php esc_html_e( 'RSS Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('rss')); ?>" name="<?php echo esc_attr($this->get_field_name('rss')); ?>" type="text" value="<?php echo esc_url($instance['rss']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('skype')); ?>">
            <?php esc_html_e( 'Skype Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('skype')); ?>" name="<?php echo esc_attr($this->get_field_name('skype')); ?>" type="text" value="<?php echo esc_url($instance['skype']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('wordpress')); ?>">
            <?php esc_html_e( 'Wordpress Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('wordpress')); ?>" name="<?php echo esc_attr($this->get_field_name('wordpress')); ?>" type="text" value="<?php echo esc_url($instance['wordpress']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('yahoo')); ?>">
            <?php esc_html_e( 'Yahoo Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('yahoo')); ?>" name="<?php echo esc_attr($this->get_field_name('yahoo')); ?>" type="text" value="<?php echo esc_url($instance['yahoo']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('flickr')); ?>">
            <?php esc_html_e( 'Flickr Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('flickr')); ?>" name="<?php echo esc_attr($this->get_field_name('flickr')); ?>" type="text" value="<?php echo esc_url($instance['flickr']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('sound_cloud')); ?>">
            <?php esc_html_e( 'Sound Cloud Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('sound_cloud')); ?>" name="<?php echo esc_attr($this->get_field_name('sound_cloud')); ?>" type="text" value="<?php echo esc_url($instance['sound_cloud']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('spotify_i')); ?>">
            <?php esc_html_e( 'spotify Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('spotify_i')); ?>" name="<?php echo esc_attr($this->get_field_name('spotify_i')); ?>" type="text" value="<?php echo esc_url($instance['spotify_i']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('wechat')); ?>">
            <?php esc_html_e( 'wechat Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('wechat')); ?>" name="<?php echo esc_attr($this->get_field_name('wechat')); ?>" type="text" value="<?php echo esc_url($instance['wechat']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('tiktok')); ?>">
            <?php esc_html_e( 'TikTok Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('tiktok')); ?>" name="<?php echo esc_attr($this->get_field_name('tiktok')); ?>" type="text" value="<?php echo esc_url($instance['tiktok']); ?>" />
    </p>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('vk')); ?>">
            <?php esc_html_e( 'VK Url:' , 'typecase' ); ?></label>
        <input class="widefat" style="width: 100%;" id="<?php echo esc_attr($this->get_field_id('vk')); ?>" name="<?php echo esc_attr($this->get_field_name('vk')); ?>" type="text" value="<?php echo esc_url($instance['vk']); ?>" />
    </p>    

    <?php

	}
}
?>