<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init','typecase_category_widget');

function typecase_category_widget(){
		register_widget("typecase_category_image_widget_register");
}

class typecase_category_image_widget_register extends WP_widget{

/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	public function __construct() {
		$widget_ops = array( 'classname' => 'visionwp_cat_image', 'description' => esc_html__( 'Dispaly Category With Image' , 'typecase') );
		parent::__construct('typecase_category_image_widget_register', esc_html__('&nbsp;Category Image', 'typecase'), $widget_ops);
	}
/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget($args,$instance){
	extract($args);		
		
		$title = isset($instance['title']) ? $instance['title']: "Display Category With image";
		$number_of_cat = isset($instance['number_of_cat']) ? $instance['number_of_cat']: "4";
		$cat_id = isset($instance['cat_id']) ? $instance['cat_id']: "";	
		
		print $before_widget;
        if ( $title ){ 
        	print $before_title . esc_attr($title) . $after_title; 
        }
		?>
    	<?php
    		if($cat_id){
    			$cat_id = explode(",",$cat_id);
    		}else{
    			$cat_id = "";
    		}
			$args = array(
		    'orderby'       => 'include', 
			'order'         => 'ASC',
			'hide_empty'    => false,
		    'fields'        => 'all',
		    'pad_counts'    => false, 
		    'include'       => $cat_id,
		    'number'        => $number_of_cat,
		    );
			$categories = get_terms('category', $args);
			if ($categories) {
            echo '<div class="vt_cat_lopt vt_cat_opt1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
              $vision_header_id = absint( get_term_meta( $tag->term_id, 'vision_header_id', true ) );
              	echo '<div class="vt_cat_opt_w vt_radus_e vt_cat_cid_'.esc_attr($tag->term_id).'">';
				echo '<a class="vt_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';								
				if ($vision_header_id){
					echo '<div class="vt_cimg">';
					echo wp_get_attachment_image( $vision_header_id, 'typecase_layouts', "", array( "class" => "vt_f_img_bg" ) );				
					echo '</div>';
				}
             	echo '<span class="vt_cat_lbw"><span class="vt_cm_name">'.esc_attr($tag->name).'</span><span class="vt_cm_count">'.esc_attr($tag->count).'</span></span>';
            	echo '</div>';
            }
            echo "</div>";
            }
			?>
    <?php
		print $after_widget;		
	}
/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['number_of_cat'] = $new_instance['number_of_cat'];
		$instance['cat_id'] = $new_instance['cat_id'];		
		return $instance;
	}
	function form($instance){	
		$defaults = array( 'title' => esc_html__( 'Categories' , 'typecase'), 'number_of_cat' => '4', 'cat_id' => '');
		$instance = wp_parse_args((array) $instance, $defaults); 
	?>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
            <?php esc_html_e( 'Title:', 'typecase'); ?></label>
        <input class="widefat" width="100%" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('number_of_cat')); ?>">
            <?php esc_html_e( 'Number Of Category:', 'typecase'); ?></label>
        <input class="widefat" width="100%" id="<?php echo esc_attr($this->get_field_id('number_of_cat')); ?>" name="<?php echo esc_attr($this->get_field_name('number_of_cat')); ?>" type="text" value="<?php echo esc_attr($instance['number_of_cat']); ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('cat_id')); ?>">
            <?php esc_html_e( 'Category id EX: 1,2,3', 'typecase'); ?></label>
        <input class="widefat" width="100%" id="<?php echo esc_attr($this->get_field_id('cat_id')); ?>" name="<?php echo esc_attr($this->get_field_name('cat_id')); ?>" type="text" value="<?php echo esc_attr($instance['cat_id']); ?>" />
    </p>
    <?php
	}
}
?>