<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init','typecase_c7_widget');
function typecase_c7_widget(){
		register_widget("typecase_c7");
}

class typecase_c7 extends WP_widget{

/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/

	public function __construct() {
		$widget_ops = array( 'classname' => 'vt_c7_widget', 'description' => esc_html__( 'Add contact form 7 to widget areas' , 'typecase') );
		parent::__construct('typecase_c7', esc_html__('&nbsp;Contact form 7', 'typecase'), $widget_ops);
	}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget($args,$instance){
	extract($args);		
		$cf7 = isset($instance["cf7"]) ? $instance["cf7"] : "";
		$title = isset($instance['title']) ? $instance['title'] : "";
		?>
<?php print $before_widget;?>
<div class="widget_vt_wrapper vt-cf7-wrapper">
    <?php
		if ( ! empty( $title ) ) {
			print $before_title.esc_attr($title).$after_title;
		}
	?>
    <div class="vt-contact-form-7">
		<?php if ( ! empty( $cf7 ) ) {
			echo do_shortcode( '[contact-form-7 id="' . esc_attr($cf7) . '"]' );
		} ?>
	</div>
    <?php
	print $after_widget;
	print "</div>";
	}

/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['cf7'] = $new_instance['cf7'];
		$instance['title'] = $new_instance['title'];		
		return $instance;
	}

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/

	function form( $instance ) {
		?>
    <?php
			$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
			$cf7 = isset($instance['cf7']) ? esc_attr($instance['cf7']) : '';
		?>

    <p>
        <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
            <?php esc_html_e( 'Title:', 'typecase'); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
    </p>

    <p>
    <label for="<?php echo esc_attr($this->get_field_id('cf7')); ?>">
    	<?php esc_html_e('Choose your form:', 'typecase');?>
 	</label>
        <?php
        $options       = array();
		$contact_forms = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );
		if ( ! empty( $contact_forms ) ) {
				$options[''] = esc_html__( 'Default', 'typecase' );
			foreach ( $contact_forms as $contact_form ) {
				$options[ $contact_form->ID ] = esc_html( $contact_form->post_title );
			}
		}	
		?>

		<select id="<?php echo $this->get_field_id('cf7'); ?>" name="<?php echo $this->get_field_name('cf7'); ?>" class="widefat" style="width:100%;">
            <option><?php esc_html_e( 'Default', 'typecase' );?></option>
            <?php 
            if ( ! empty( $contact_forms ) ) {            
            	foreach ( $contact_forms as $contact_form ) {?>
            <option <?php if ( !empty($instance['cf7']) ) { selected( $instance['cf7'], $contact_form->ID ); } ?> value="<?php echo $contact_form->ID; ?>">
            	<?php esc_html_e( $contact_form->post_title ) ?>
            </option>
            <?php }}?>
        </select>
</p>
    <?php
	}
}
?>