<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init','typecase_widget_layouts');
function typecase_widget_layouts(){
		register_widget("typecase_widget_add_layouts");
}

class typecase_widget_add_layouts extends WP_widget{

/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/

	public function __construct() {
		$widget_ops = array( 'classname' => 'vt_cus_layouts_widget', 'description' => esc_html__( 'Add custom layouts' , 'typecase') );
		parent::__construct('typecase_widget_add_layouts', esc_html__('&nbsp;Custom layouts', 'typecase'), $widget_ops);
	}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget($args,$instance){
	extract($args);		
		$vtlayout = isset($instance["vtlayout"]) ? $instance["vtlayout"] : "";
		?>
<?php print $before_widget;?>
<div class="widget_vt_wrapper vt-cuslayouts-wrapper">
    <div class="vt_cuslayouts_inner">
		<?php if ( ! empty( $vtlayout ) ) {
			echo do_shortcode( '[vt_layout id="' . esc_attr($vtlayout) . '"]' );
		} ?>
	</div>
    <?php
	print $after_widget;
	print "</div>";
	}

/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['vtlayout'] = $new_instance['vtlayout'];
		return $instance;
	}

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/

	function form( $instance ) {
		?>
    <?php
			$vtlayout = isset($instance['vtlayout']) ? esc_attr($instance['vtlayout']) : '';
		?>

    <p>
    <label for="<?php echo esc_attr($this->get_field_id('vtlayout')); ?>">
    	<?php esc_html_e('Choose your layouts:', 'typecase');?>
 	</label>
        <?php
        $options       = array();
		$custom_layouts = get_posts( 'post_type="vt_layout"&numberposts=-1' );
		if ( ! empty( $custom_layouts ) ) {
				$options[''] = esc_html__( 'Default', 'typecase' );
			foreach ( $custom_layouts as $add_layouts ) {
				$options[ $add_layouts->ID ] = esc_html( $add_layouts->post_title );
			}
		}	
		?>

		<select id="<?php echo $this->get_field_id('vtlayout'); ?>" name="<?php echo $this->get_field_name('vtlayout'); ?>" class="widefat" style="width:100%;">
            <option><?php esc_html_e( 'Default', 'typecase' );?></option>
            <?php 
            if ( ! empty( $custom_layouts ) ) {            
            	foreach ( $custom_layouts as $add_layouts ) {?>
            <option <?php if ( !empty($instance['vtlayout']) ) { selected( $instance['vtlayout'], $add_layouts->ID ); } ?> value="<?php echo $add_layouts->ID; ?>">
            	<?php esc_html_e( $add_layouts->post_title ) ?>
            </option>
            <?php }}?>
        </select>
</p>
    <?php
	}
}
?>