<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init', 'typecase_recent_large__widgets');

function typecase_recent_large__widgets() {
    register_widget('typecase_recent_large_widgets');
}

class typecase_recent_large_widgets extends WP_Widget {

/*-----------------------------------------------------------------------------------*/
/*  Widget Setup
/*-----------------------------------------------------------------------------------*/

    public function __construct() {
        $widget_ops = array(
            'classname' => 'main_post_style',
            'description' => esc_html__('Display post on menu or widget.', 'typecase')
        );
        parent::__construct('typecase_recent_large_widgets', esc_html__('&nbsp;Recent post large', 'typecase'), $widget_ops);
    }

/*-----------------------------------------------------------------------------------*/
/*  Display Widget
/*-----------------------------------------------------------------------------------*/
    function widget($args, $instance) {

        extract($args);

        $cats = isset($instance["cats"]) ? $instance["cats"] : "";
        $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
        $number = isset($instance['number']) ? absint($instance['number']) : 4;
        $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;

        print $before_widget;

        // Widget title

        if ( $title ){ 
        print $before_title;
        print esc_attr($title);
        print $after_title;
        }
       ?>
        <div class="vt_wgli_w">
            <?php $visionwp_args = array(
                        'showposts' => $number,
                        'ignore_sticky_posts' => 1,
                        'category__in' => $cats,
                        'offset' => $number_offset
            );
            $visionwp_widget = null;
            $visionwp_widget = new WP_Query($visionwp_args);
            ?>
            <?php while ($visionwp_widget->have_posts()) {
                $visionwp_widget->the_post();?>                         
                <div class="vt_cgrid_layout">
                    <?php if ( has_post_thumbnail()) {?>
                        <div class="vt_img_holder">
                        <div class="vt_imgw vt_radus_e">
                            <div class="vt_imgin">
                                <?php the_post_thumbnail('typecase_layouts');?>
                            </div>
                            <?php typecase_video_media(get_the_ID());?>
                            <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
                            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
                        </div>
                        </div>
                    <?php }?>
                    <div class="vt_fe_text">
                        <?php typecase_post_cat(get_the_ID());?>
                        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
                        <?php typecase_post_meta(get_the_ID());?>
                    </div>
                </div>              
            <?php }?>
        </div>
<?php
wp_reset_postdata();
print $after_widget;
}

/*-----------------------------------------------------------------------------------*/
/*  Update Widget
/*-----------------------------------------------------------------------------------*/

function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance['title'] = strip_tags($new_instance['title']);
    $instance['cats'] = isset($new_instance['cats']) ? $new_instance['cats'] : "";
    $instance['number'] = absint($new_instance['number']);
    $instance['number_offset'] = absint($new_instance['number_offset']);
     
    return $instance;
}


function form( $instance ) {
    $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
    $number = isset($instance['number']) ? absint($instance['number']) : 4;
    $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;
?>
<p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
        <?php esc_html_e('Title:', 'typecase'); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

<p><label for="<?php echo esc_attr($this->get_field_id('number')); ?>">
        <?php esc_html_e('Number of posts to show:', 'typecase'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" style="width: 100%;"  /></p>

<p><label for="<?php echo esc_attr($this->get_field_id('number_offset')); ?>">
        <?php esc_html_e('Offset posts:', 'typecase'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number_offset')); ?>" name="<?php echo esc_attr($this->get_field_name('number_offset')); ?>" type="text" value="<?php echo esc_attr($number_offset); ?>" style="width: 100%;" /></p>
<p>
    <label for="<?php echo esc_attr($this->get_field_id('cats')); ?>">
        <?php esc_html_e('Choose your category:', 'typecase');?>
        <?php
                   $categories=  get_categories();
                     print "<br/>";
                     foreach ($categories as $cat) {
                    $option = '<input type="checkbox" id="' . $this->get_field_id('cats') . '[]" name="' . $this->get_field_name('cats') . '[]"';
              
                    if (!empty($instance['cats'])) {
                        foreach ($instance['cats'] as $cats) {
                            if ($cats == $cat->term_id) {
                                $option = $option . ' checked="checked"';
                            }
                        }
                    }              
                    $option .= ' value="' . $cat->term_id . '" />';
                    $option .= '&nbsp;';
                    $option .= $cat->cat_name.' ('.esc_html( $cat->category_count ).')';
                    $option .= '<br />';
                    print $option;
                }
                    
                    ?>
    </label>
</p>
<?php }}?>