<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action( 'widgets_init', 'typecase_recent_number' );

function typecase_recent_number() {
    register_widget( 'typecase_recent_number_widget' );
}

class typecase_recent_number_widget extends WP_Widget {

/*-----------------------------------------------------------------------------------*/
/*  Widget Setup
/*-----------------------------------------------------------------------------------*/
            
    public function __construct() {
        $widget_ops = array(
            'classname'   => 'post_list_widget', 
            'description' => esc_html__('Display a list of number recent post.', 'typecase')
        );
        parent::__construct('typecase_recent_number_widget', esc_html__('&nbsp;Recently Posts number', 'typecase'), $widget_ops);
    }

/*-----------------------------------------------------------------------------------*/
/*  Display Widget
/*-----------------------------------------------------------------------------------*/

    function widget($args, $instance) {
        extract($args);
        $cats = isset($instance["cats"]) ? $instance["cats"] : "";
        $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
        $number = isset($instance['number']) ? absint($instance['number']) : 4;
        $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;
        
        $post_cat_args = array(
            'showposts' => $number,
            'category__in' => $cats,
            'ignore_sticky_posts' => 1,
            'offset' => $number_offset
        );

        $post_cat_widget = null;
        $post_cat_widget = new WP_Query($post_cat_args);

        print $before_widget;
        print '<div class="widget_vt_wrapper vt_cli_num">';
        if ( $title ){ 
        print $before_title . esc_attr($title) . $after_title; 
        }        

        // Post list in widget
        print '<div class="bt_post_widget">';
            while ($post_cat_widget->have_posts()) {
            $post_cat_widget->the_post();
            $post_id = get_the_ID(); ?>
            <div class="vt_mmlist_w">
					<div class="vt_mmlist_layout vt_lisep">
						<div class="vt_li_in">
					    <div class="vt_fe_num"></div>
					    <div class="vt_fe_text">    
					    	<?php typecase_post_cat(get_the_ID());?>
					        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>	
					        <?php typecase_post_meta_date(get_the_ID());?>                
					    </div>
					</div>
					</div>
				</div>
            <?php }
        wp_reset_postdata();
            print "</div>\n";
        print $after_widget;
        print "</div>";
    }

/*-----------------------------------------------------------------------------------*/
/*  Update Widget
/*-----------------------------------------------------------------------------------*/
    
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['cats'] = isset($new_instance['cats']) ? $new_instance['cats'] : "";
        $instance['number'] = absint($new_instance['number']);
        $instance['number_offset'] = absint($new_instance['number_offset']);
         
        return $instance;
    }

/*-----------------------------------------------------------------------------------*/
/*  Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/
    
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
        $number = isset($instance['number']) ? absint($instance['number']) : 4;
        $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;
        
?>
<p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
    <?php esc_html_e('Title:', 'typecase'); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

<p><label for="<?php echo esc_attr($this->get_field_id('number')); ?>">
        <?php esc_html_e('Number of posts to show:', 'typecase'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" style="width: 100%;"  /></p>

<p><label for="<?php echo esc_attr($this->get_field_id('number_offset')); ?>">
        <?php esc_html_e('Offset posts:', 'typecase'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number_offset')); ?>" name="<?php echo esc_attr($this->get_field_name('number_offset')); ?>" type="text" value="<?php echo esc_attr($number_offset); ?>" style="width: 100%;" /></p>
<p>
    <label for="<?php echo esc_attr($this->get_field_id('cats')); ?>">
        <?php esc_html_e('Choose your category:', 'typecase');?>

        <?php
                   $categories=  get_categories();
                     print "<br/>";
                     foreach ($categories as $cat) {
                    $option = '<input type="checkbox" id="' . $this->get_field_id('cats') . '[]" name="' . $this->get_field_name('cats') . '[]"';
              
                    if (!empty($instance['cats'])) {
                        foreach ($instance['cats'] as $cats) {
                            if ($cats == $cat->term_id) {
                                $option = $option . ' checked="checked"';
                            }
                        }
                    }            
                    $option .= ' value="' . $cat->term_id . '" />';
                    $option .= '&nbsp;';
                    $option .= $cat->cat_name.' ('.esc_html( $cat->category_count ).')';
                    $option .= '<br />';
                    print $option;
                }                
                ?>
    </label>
</p>
<?php }}?>