<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('widgets_init', 'typecase_recent_large_slider__widgets');

function typecase_recent_large_slider__widgets() {
    register_widget('typecase_recent_large_slider_widgets');
}

class typecase_recent_large_slider_widgets extends WP_Widget {

/*-----------------------------------------------------------------------------------*/
/*  Widget Setup
/*-----------------------------------------------------------------------------------*/

    public function __construct() {
        $widget_ops = array(
            'classname' => 'vt_widget_slider',
            'description' => esc_html__('Display slider on widget', 'typecase')
        );
        parent::__construct('typecase_recent_large_slider_widgets', esc_html__('&nbsp;Widget slider', 'typecase'), $widget_ops);
    }

/*-----------------------------------------------------------------------------------*/
/*  Display Widget
/*-----------------------------------------------------------------------------------*/
    function widget($args, $instance) {

        extract($args);

        $cats = isset($instance["cats"]) ? $instance["cats"] : "";
        $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
        $number = isset($instance['number']) ? absint($instance['number']) : 4;
        $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;
        $vt_postide = isset($instance["vt_postide"]) ? $instance["vt_postide"] : "";        
        // array to call recent posts.
        if($vt_postide){$vt_postide = explode(",",$vt_postide);}else{$vt_postide = "";}

        $visionwp_args = array(
            'showposts' => $number,
            'category__in' => $cats,
            'post__not_in'     => $vt_postide,
            'ignore_sticky_posts' => 1,
            'offset' => $number_offset
        );

        $visionwp_widget = null;
        $visionwp_widget = new WP_Query($visionwp_args);

        print $before_widget;

        // Widget title

       if ( $title !="" ){ 
            print $before_title . esc_attr($title) . $after_title; 
        }
        // Post list in widget
        $post_id = (rand(10,100));
       ?>
<div class="vt-w-slider vt_full_feature_w vt_wid_slider">
    <div class="vt-pgal-slider swiper-container" data-swpid="<?php echo esc_attr($post_id)?>">
        <div class="swiper-wrapper">
            <?php while ($visionwp_widget->have_posts()) {
                $visionwp_widget->the_post(); ?>
                <div class="swiper-slide">
                    <div class="slide-inner" data-swiper-parallax="100%">
                        <div class="vt_ov_layout vt_ov_el vt_radus_e">
                            <?php if ( has_post_thumbnail()) {?>
                                <div class="vt_img_holder">
                                    <div class="vt_imgw">
                                        <div class="vt_imgin">
                                            <?php the_post_thumbnail('typecase_list');?>
                                        </div>
                                        <?php typecase_video_media(get_the_ID());?>
                                        <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
                                        <a class="vt_imgl" href="<?php the_permalink();?>"></a>
                                    </div>
                                </div>
                            <?php }?>
                            <div class="vt_fe_text">
                                <div class="vt_fe_inner">
                                <?php typecase_post_cat(get_the_ID());?>
                                <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
                                <?php typecase_post_meta(get_the_ID());?>
                                <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php }?>
        </div>
        <div class="vtc-pagination-<?php echo esc_attr($post_id)?> vt_spw"><div class="swiper-pagination"></div></div>
  </div>
</div>
<?php
        wp_reset_postdata();
        print $after_widget;
    }

/*-----------------------------------------------------------------------------------*/
/*  Update Widget
/*-----------------------------------------------------------------------------------*/

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['cats'] = isset($instance["cats"]) ? $instance["cats"] : "";
        $instance['vt_postide'] = ( ! empty( $new_instance['vt_postide'] ) ) ? strip_tags( $new_instance['vt_postide'] ) : '';
        $instance['number'] = absint($new_instance['number']);
        $instance['number_offset'] = absint($new_instance['number_offset']);

        return $instance;
    }


    function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
        $number = isset($instance['number']) ? absint($instance['number']) : 4;
        if ( isset( $instance[ 'vt_postide' ] ) ) {$vt_postide = $instance[ 'vt_postide' ];}else {$vt_postide = "";}
        $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;
        ?>
<p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
        <?php esc_html_e('Title:', 'typecase'); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" style="width: 100%;" /></p>


<p><label for="<?php echo esc_attr($this->get_field_id('number')); ?>">
        <?php esc_html_e('Number of posts to show:', 'typecase'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" style="width: 100%;" /></p>
<p><label for="<?php echo esc_attr($this->get_field_id('number_offset')); ?>">
        <?php esc_html_e('Offset posts:', 'typecase'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number_offset')); ?>" name="<?php echo esc_attr($this->get_field_name('number_offset')); ?>" type="text" value="<?php echo esc_attr($number_offset); ?>" style="width: 100%;" /></p>
    <p class="vt_post_id">
    <label for="<?php echo esc_attr($this->get_field_id( 'vt_postide' )); ?>"><strong>
            <?php esc_html_e( 'Exclude Posts ID: EX(1,2,3,4)', 'typecase' ); ?></strong></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'vt_postide' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vt_postide' )); ?>" type="text" value="<?php echo esc_attr( $vt_postide ); ?>" />
</p>

<p>
    <label for="<?php echo esc_attr($this->get_field_id('cats')); ?>">
        <?php esc_html_e('Choose your category:', 'typecase'); ?>

        <?php
                $categories = get_categories();
                print "<br/>";
                foreach ($categories as $cat) {
                    $option = '<input type="checkbox" id="' . $this->get_field_id('cats') . '[]" name="' . $this->get_field_name('cats') . '[]"';
                    if (!empty($instance['cats'])) {
                        foreach ($instance['cats'] as $cats) {
                            if ($cats == $cat->term_id) {
                                $option = $option . ' checked="checked"';
                            }
                        }
                    }
                    $option .= ' value="' . $cat->term_id . '" />';
                    $option .= '&nbsp;';
                    $option .= $cat->cat_name.' ('.esc_html( $cat->category_count ).')';
                    $option .= '<br />';
                    print $option;
                }
                ?>
    </label>
</p>

<?php
    }

}
?>