<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( post_password_required() ) {
	return false;
}?>
    <div id="comments" class="comments-area">
		<?php if ( have_comments() ) : ?>
            <div class="vt_commentlist_wrap">
                <ul class="vt_commentlist">
					<?php wp_list_comments( array(
							'avatar_size' => 100,
							'style'       => 'ul',
							'short_ping'  => true,
						)
					);
					?>
                </ul>
				<?php the_comments_pagination( array(
						'prev_text' => '<span class="vt_nav_previous">' . esc_html( '&larr; Older Comments', 'typecase' ) . '</span>',
						'next_text' => '<span class="vt_nav_next">' . esc_html( 'Newer Comments &rarr;', 'typecase' ) . '</span>',
					)
				); ?>
            </div>
		<?php endif;
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ): ?>
            <p class="no-comments"><?php echo esc_html( 'Comments are closed.', 'typecase' ); ?></p>
		<?php endif; ?>
		<?php comment_form(); ?>
    </div>