<?php
define( 'TYPECASE_VERSION', '1.0.0' );
load_theme_textdomain('typecase', get_template_directory() . '/langs');
add_action( 'after_setup_theme', 'typecase_theme_setup', 1 );
if ( ! function_exists( 'typecase_theme_setup' ) ) {
  function typecase_theme_setup() {
    if ( ! isset( $GLOBALS['content_width'] ) ) {
      $GLOBALS['content_width'] = 1200;
    }
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    add_theme_support( 'post-formats', array('gallery', 'quote', 'video', 'audio') );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support('bbpress');
    add_theme_support( "title-tag" );
    add_theme_support('post-thumbnails');
    add_theme_support( 'align-wide' );
    add_theme_support( 'wp-block-styles' );
    add_theme_support( 'editor-styles' );
    add_theme_support( 'responsive-embeds' );
    add_theme_support(
      'html5',
        array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
            'script',
            'style'
        )
    );    
  }
}

add_action( 'init', 'typecase_image_size' );
if ( !function_exists( 'typecase_image_size' ) ) {
	function typecase_image_size() {
    add_image_size('typecase_large', 1600, 0, false);  
    add_image_size('typecase_medium', 1100, 0, false);
    add_image_size('typecase_small', 150, 150, true);
    add_image_size('typecase_layouts', 680, 580, true);
    add_image_size('typecase_list', 600, 0, false);
    add_image_size('typecase_large_sload', 20, 0, false);
    add_image_size('typecase_medium_sload', 20, 0, false);
    add_image_size('typecase_small_sload', 20, 20, true);
    add_image_size('typecase_layouts_sload', 20, 15, true);
    add_image_size('typecase_list_sload', 20, 0, false);
  }
}

add_action('init', 'typecase_register_menu');
if ( !function_exists( 'typecase_register_menu' ) ) {
  function typecase_register_menu() {
    register_nav_menus(
        array(
          'main_menu' => esc_html__('Main menu', 'typecase'),
          'mobile_menu' => esc_html__('Mobile main menu', 'typecase'),
        )
    );
    $header_layout= get_theme_mod('header_layout_design','header_3');
    if( $header_layout == 'header_3' || $header_layout == 'header_4' || $header_layout == 'header_5' || $header_layout == 'header_6' || $header_layout == 'header_7' || $header_layout == 'header_8' || $header_layout == 'header_9'){
      register_nav_menus(
        array(
          'top_menu' => esc_html__('Top menu', 'typecase'),
        )
      );
    }
     $sub_footer = get_theme_mod('sub_footer', 'sub_footer0');
    if( $sub_footer == 'sub_footer1' || $sub_footer == 'sub_footer3' || $sub_footer == 'sub_footer5' || $sub_footer == 'sub_footer6' ){
        register_nav_menus(
          array(
            'footer_menu' => esc_html__('Footer menu', 'typecase')
          )
        );
    }
  }
}

add_action( 'wp_ajax_ajax_action', 'typecase_day_night');
add_action( 'wp_ajax_nopriv_ajax_action', 'typecase_day_night' );
if ( !function_exists( 'typecase_day_night' ) ) {
    function typecase_day_night() {
        $vt_dn_option = isset( $_COOKIE['vtmode_dn'] ) ? $_COOKIE['vtmode_dn'] : '';
        if ( 'true' === $vt_dn_option ){
            return 'options_dark_skin';
        }
    }
}

add_filter( 'body_class','typecase_body_classes' );
if ( !function_exists( 'typecase_body_classes' ) ) {
  function typecase_body_classes( $classes ) {
      $vt_dn_option = isset( $_COOKIE['vtmode_dn'] ) ? $_COOKIE['vtmode_dn'] : '';
      $vt_header_tp = get_post_meta( get_the_ID(), 'vt_header_tp', true );
      $title_link = get_theme_mod('typecase_title_link','vt_tline');
      $post_sidebar_opt = get_theme_mod('post_sidebar_position','vt_sright_side');
      $post_sidebar_meta = get_post_meta( get_the_ID(), 'post_sidebar_position', true );
      $footer_logo = get_theme_mod('footer_logo','logo_foot_white');
      $sticky_logo = get_theme_mod('sticky_logo','logo_sticky_normal');
      $typecase_widget_font = get_theme_mod('typecase_widget_font','vt_weg_title');
      $mb_nav_left = get_theme_mod('mb_nav_left');
      $mb_nav_right = get_theme_mod('mb_nav_right');
      $post_sidebar = get_theme_mod('post_sidebar','default');
      $page_sidebar = get_theme_mod('page_sidebar','default');
      $category_sidebar = get_theme_mod('category_sidebar','default');
      $tag_sidebar = get_theme_mod('tag_sidebar','default');
      $archive_sidebar = get_theme_mod('archive_sidebar','default');
      $author_sidebar = get_theme_mod('author_sidebar','default');
      $search_sidebar = get_theme_mod('search_sidebar','default');
      if(!empty($mb_nav_left)){
        $classes[] = 'vt_mb_nav_pos_left';
      }
      if(!empty($mb_nav_right)){
        $classes[] = 'vt_mb_nav_pos_right';
      }
      $classes[] = $footer_logo;
      $classes[] = $sticky_logo;
      $classes[] = $typecase_widget_font;
      if(empty($post_sidebar_meta)){
        $classes[] = $post_sidebar_opt;
      }else{
        $classes[] = $post_sidebar_meta;
      }
      $classes[] = 'vt_nav_stick vt_nav_active vt_nav_slide mobile_nav_class is-lazyload';
      $classes[] = typecase_day_night();
      if ($vt_dn_option !='false') {
        if(get_theme_mod('enable_dark_skin')){
        $classes[] = 'options_dark_skin vt_en_day_night';
        }else{
        $classes[] = ' vt_en_day_night';
        }
      }else{
        $classes[] = ' vt_en_day_night';
      }      
      if($category_sidebar == "default" || $tag_sidebar == "default" || $archive_sidebar == "default" || $author_sidebar == "default" || $search_sidebar == "default"){
        if (is_active_sidebar('general-sidebar')) {
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_category() ) {
        if($category_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_tag() ) {
        if($tag_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_search() ) {
        if($search_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_tax() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_date() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_home() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_post_type_archive() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }
      if ( is_author() ) {
        if($author_sidebar != "default"){
          $classes[] = 'vt-has-sidebar';
        }
      }

      if ($title_link == 'vt_tline'){
        $classes[] = 'vt_tline';
      }else{
        $classes[] = 'vt_tcolor';
      }
      if ($vt_header_tp == 'on'){
        $classes[] = 'vt_header_tp';
      }
      if ( get_theme_mod('header_layout_design') == '' ){
        $classes[] = get_theme_mod('header_layout_design');
      }      
      return $classes;
  }
}

add_filter('nav_menu_item_id', 'typecase_my_css_attributes_filter', 100, 1);
if ( !function_exists( 'typecase_my_css_attributes_filter' ) ) {
  function typecase_my_css_attributes_filter($var) {
    return is_array($var) ? array() : '';
  }
}

add_filter('wp_list_categories', 'typecase_cat_count_span');
if ( !function_exists( 'typecase_cat_count_span' ) ) {
  function typecase_cat_count_span($links) {
    $links = str_replace('</a> (', '<span>', $links);
    $links = str_replace(')', '</span></a>', $links);
    return $links;
  }
}

add_filter( 'get_archives_link', 'typecase_archives_count_span' );
if ( !function_exists( 'typecase_archives_count_span' ) ) {
  function typecase_archives_count_span($links) {
    $links = str_replace( '</a>&nbsp;(', '<span>', $links );
    $links = str_replace(')', '</span></a>', $links);
    return $links;
  }
}

add_action('widgets_init', 'typecase_sidebar_register');
if ( !function_exists( 'typecase_sidebar_register' ) ) {
  function typecase_sidebar_register() {
      register_sidebar(array(
          'name' => esc_html__('General Sidebar', 'typecase'),
          'id' => 'general-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => '</div>',
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Mobile Section Sidebar', 'typecase'),
          'id' => 'mobile-menu-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => '</div>',
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
        'name' => esc_html__('Header Section Sidebar', 'typecase'),
        'id' => 'header-sidebar',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
        'after_title' => '</h2></div>',
    ));
      register_sidebar(array(
          'name' => esc_html__('First Footer Sidebar', 'typecase'),
          'id' => 'footer1-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Second Footer Sidebar', 'typecase'),
          'id' => 'footer2-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Third Footer Sidebar', 'typecase'),
          'id' => 'footer3-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Fourth Footer Sidebar', 'typecase'),
          'id' => 'footer4-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));

      if ( class_exists('bbPress', false) ) {
        register_sidebar(array(
          'name' => esc_html__('bbPress Sidebar', 'typecase'),
          'id' => 'bbpress-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));        
      }

      if ( class_exists( 'Buddypress', false ) ) {
        register_sidebar(array(
          'name' => esc_html__('BuddyPress Sidebar', 'typecase'),
          'id' => 'bdpress-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="vt_title_c">',
          'after_title' => '</h2></div>',
      ));        
      }

  }
}

if ( !function_exists( 'typecase_post_type' ) ) {
  function typecase_post_type(){
      if(has_post_format( 'video')){
          if (empty($videourl)){
            $post_type_image = '<span class="vt_post_type_icon"></span>';
          }
      }else{
          $post_type_image = '';
      }
      return $post_type_image;
  }
}

if(!function_exists('typecase_esc_data')){
  function typecase_esc_data() {
    $allowed_tags =
        array(
          'a' => array(
            'href' => array(),
            'title' => array(),
            'class' => array(),
            'data' => array(),
            'data-style' => array(),
            'rel'   => array()
          ),
          'div' => array(
            'class' => array(),
            'data' => array(),
            'data-style' => array()
          ),
          'span' => array(
            'class' => array(),
            'data' => array(),
            'data-style' => array()
          ),
          'iframe' => array(
            'src' => array(),
            'class' => array(),
            'data' => array(),
            'data-style' => array(),
            'allow' => array(),
            'allowfullscreen' => array(),
            'width' => array(),
            'height' => array(),
            'frameborder' => array()
          )
    );
    return $allowed_tags;
  }
}

if ( !function_exists( 'typecase_post_meta' ) ) {
  function typecase_post_meta() {
    if(get_theme_mod('hide_front_author_date') !=1){
      echo '<span class="vt_post_meta">';
  		if(get_theme_mod('hide_front_author') !=1){
        if( !empty( get_theme_mod('show_author_img' ) ) ){
          echo '<span class="vt_author_img_w">';
          echo '<span class="vt_aimg_in">';
          echo get_avatar(get_the_author_meta('ID'), 50, '', '', array( 'class' => 'lazyload' ));
          echo '</span>';
          echo the_author_posts_link();
          echo '</span>';
        }else{
          echo '<span class="vt_author_img_w">';
          echo esc_html__('By ', 'typecase');
          echo the_author_posts_link();
          echo '</span>';
        }
      }
      if(get_theme_mod('hide_front_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
  		echo'</span>';
    }
  }
}

if(!function_exists('typecase_author_date_meta')){
  function typecase_author_date_meta() {
    if(get_theme_mod('hide_front_author_date') !=1){
      echo '<span class="vt_post_meta">';
  		if(get_theme_mod('hide_front_author') !=1){
        echo '<span class="vt_author_img_w">';
        echo esc_html__('By ', 'typecase');
        echo the_author_posts_link();
        echo '</span>';
      }
      if(get_theme_mod('hide_front_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
  		echo'</span>';
    }
  }
}

if(!function_exists('typecase_post_meta_date')){
  function typecase_post_meta_date() {
    if(get_theme_mod('hide_front_author_date') !=1){
      echo '<span class="vt_post_meta">';
      if(get_theme_mod('hide_front_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
      echo'</span>';
    }
  }
}

if(!function_exists('typecase_post_ov_cat')){
  function typecase_post_ov_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_overlay', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_3' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;            
      }
    }
  }
}

if(!function_exists('typecase_post_list_cat')){
  function typecase_post_list_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_list', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_3' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;            
      }
    }
  }
}

if(!function_exists('typecase_post_small_cat')){
  function typecase_post_small_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_small_list', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;      
      case 'cat_label_3' :
        if ($categories) {
              echo '<span class="vt_f_cat vt_lb3">';
              foreach( $categories as $tag) {
                $tag_link = get_category_link($tag->term_id);
               echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
              }
              echo "</span>";
              }
        break;            
      }
    }
  }
}

if(!function_exists('typecase_post_tumb_cat')){
  function typecase_post_tumb_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_grid','cat_label_1');
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
			case 'cat_label_4' :
			if ($categories) {
            echo '<span class="vt_f_cat vt_lb4">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
              echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
			break;
      case 'cat_label_5' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb5">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
              echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_6' :
        if ($categories) {
              echo '<span class="vt_f_cat vt_lb6">';
              foreach( $categories as $tag) {
                $tag_link = get_category_link($tag->term_id);
                echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
              }
              echo "</span>";
              }
        break;
        case 'cat_label_7' :
          if ($categories) {
                echo '<span class="vt_f_cat vt_lb7">';
                foreach( $categories as $tag) {
                  $tag_link = get_category_link($tag->term_id);
                  echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
                }
                echo "</span>";
                }
          break;
      }
    }
  }
}

if(!function_exists('typecase_post_cat')){
  function typecase_post_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_grid','cat_label_1');
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
			case 'cat_label_1' :
			if ($categories) {
            echo '<span class="vt_f_cat vt_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
			break;
			case 'cat_label_2' :
			if ($categories) {
            echo '<span class="vt_f_cat vt_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
			break;
			case 'cat_label_3' :
			if ($categories) {
            echo '<span class="vt_f_cat vt_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
              echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
			break;	
      		      
      }
    }
  }
}

if ( !function_exists( 'typecase_single_meta_list' ) ) {
  function typecase_single_meta_list() {
    $enable_sponsored_post = get_post_meta( get_the_ID(), 'enable_sponsored_post', true );
    if(!empty($enable_sponsored_post)){
      typecase_sponsored();
    }else{
      echo '<span class="vt_post_meta vt_slimeta">';
  		if(get_theme_mod('disable_post_meta_author') !=1){
          echo '<span class="vt_author_img_w">';
          echo '<span class="vt_aimg_in">';
          echo get_avatar(get_the_author_meta('ID'), 50, '', '', array( 'class' => 'lazyload' ));
          echo '</span>';
          echo the_author_posts_link();
          echo '</span>';
      }
      if(get_theme_mod('disable_post_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
      if(get_theme_mod('disable_post_readtime') !=1){
        echo '<span class="post-read-time">'.typecase_read_time().'</span>';
      }
      if(get_theme_mod('disable_post_view') !=1){
        if(function_exists('typecase_bac_PostViews')){
        echo '<span class="vt_view_options">';        
        echo typecase_bac_PostViews(get_the_ID()).' '.esc_html__('Views', 'typecase');        
        echo '</span>';
        }
      }
  		echo'</span>';
    }
  }
}

if(!function_exists('typecase_post_single_cat')){
  function typecase_post_single_cat() {
    if(get_theme_mod('disable_post_category') !=1){
      $cat_style = get_theme_mod('category_label_single', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_txt vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_3' :
      if ($categories) {
            echo '<span class="vt_f_cat vt_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="vt_cat_lbl vt_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;            
      }
    }
  }
}

if(!function_exists('typecase_post_sidebar')){
  function typecase_post_sidebar() {
      $sidebar_post_options = get_post_meta(get_the_ID(), 'single_post_sidebar', true);
      if(isset($sidebar_post_options)){
  		    $custom_sidebar = $sidebar_post_options;
  				$post_sidebar = get_theme_mod('post_sidebar');
  				if(!empty($post_sidebar)) {
  						$custom_sidebar = $post_sidebar;
  				}
  				global $wp_registered_sidebars;
  				foreach ( $wp_registered_sidebars as $sidebar ) {
    				if($sidebar['id'] == $custom_sidebar){
    							 $dyn_side = $sidebar['id'];
    				}
  				}
  		}
  		if(isset($dyn_side)) {
  					if (is_active_sidebar($dyn_side)) { dynamic_sidebar($dyn_side);}
  		} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar'); }
  		}
  }
}

if(!function_exists('typecase_page_sidebar')){
  function typecase_page_sidebar() {
  	   $sidebar_page_options = get_post_meta(get_the_ID(), 'single_page_sidebar', true);
  	   if(isset($sidebar_page_options)){
  			   $custom_sidebar = $sidebar_page_options;
  				$page_sidebar = get_theme_mod('page_sidebar');
  					if(!empty($page_sidebar)) {
  						$custom_sidebar = $page_sidebar;
  					}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $dyn_side = $sidebar['id'];
  						}
  					}
  			}
  			if(isset($dyn_side)) {
  					if (is_active_sidebar($dyn_side)) { dynamic_sidebar($dyn_side);}
  			} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar'); }
  			}
  }
}

if(!function_exists('typecase_category_sidebar')){
  function typecase_category_sidebar() {
        $category_sidebar = get_theme_mod('category_sidebar','default');
  			$custom_sidebar ='';
  				if(!empty($category_sidebar)) {	$custom_sidebar = $category_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('typecase_tag_sidebar')){
  function typecase_tag_sidebar() {
  $tag_sidebar = get_theme_mod('tag_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($tag_sidebar)) {	$custom_sidebar = $tag_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('typecase_archive_sidebar')){
  function typecase_archive_sidebar() {
  $archive_sidebar = get_theme_mod('archive_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($archive_sidebar)) {	$custom_sidebar = $archive_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('typecase_author_sidebar')){
  function typecase_author_sidebar() {
  $author_sidebar = get_theme_mod('author_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($author_sidebar)) {	$custom_sidebar = $author_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('typecase_search_sidebar')){
  function typecase_search_sidebar() {
  $search_sidebar = get_theme_mod('search_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($search_sidebar)) {	$custom_sidebar = $search_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('typecase_read_time')){
  function typecase_read_time($postid = '') {
    if($postid == '') {
      $postid = get_the_ID();
    }
    $content = get_post_field( 'post_content', $postid );
    $post_words_count = str_word_count( strip_tags( $content ) );
    $readtime = round($post_words_count / 265);
    if($readtime < 1) {
      $readtime = 1;
    }
    $readtime_html = $readtime.' '.esc_html__('Mins read', 'typecase');
    return $readtime_html;
  }
}

if ( ! function_exists( 'typecase_comment_heading' ) ) {
	function typecase_comment_heading( $post_id = '' ) {
		if ( empty( $post_id ) ) {
			$post_id = get_the_ID();
		}
		$output = esc_html( 'Leave a comment', 'typecase' );
		$count  = intval( get_comments_number( $post_id ) );

		if ( $count > 1 ) {
			$output = sprintf( esc_html( '%s Comments', 'typecase' ), $count );
		} elseif ( 1 === $count ) {
			$output = esc_html( '1 Comment', 'typecase' );
		}
		return $output;
	}
}
if ( ! function_exists( 'typecase_comment' ) ) {
	function typecase_comment( ) {
    if( !empty(get_theme_mod('disable_section_comment')) ){
			return false;
		}
    if ( post_password_required() ) {
			return false;
		}
    if ( comments_open() || get_comments_number() ) {
		$class_name = 'vt_comment_wrap';
		if ( ! get_comments_number() ) {
			$class_name .= ' vt_no_comment';
		}
		?>
        <div class="single_section_comment">
            <div class="vt_comment_head">
            <h3 class="vt_comment_head_title"><?php echo typecase_comment_heading( get_the_ID() ); ?></h3>
            </div>
            <div class="<?php echo esc_attr( $class_name ); ?>"><?php comments_template(); ?></div>
        </div>
		<?php
	  }
  }
}

add_filter( 'comment_form_defaults', 'typecase_comment_placeholder', 10 );
if ( ! function_exists( 'typecase_comment_placeholder' ) ) {
	function typecase_comment_placeholder( $defaults ) {
		if ( ! empty( $defaults['fields']['author'] ) ) {
			$defaults['fields']['author'] = str_replace( '<input', '<input placeholder="' . esc_html( 'Your name', 'typecase' ) . '"', $defaults['fields']['author'] );
		}
		if ( ! empty( $defaults['fields']['email'] ) ) {
			$defaults['fields']['email'] = str_replace( '<input', '<input placeholder="' . esc_html( 'Your email', 'typecase' ) . '"', $defaults['fields']['email'] );
		}
		if ( ! empty( $defaults['fields']['url'] ) ) {
			$defaults['fields']['url'] = str_replace( '<input', '<input placeholder="' . esc_html( 'Your Website', 'typecase' ) . '"', $defaults['fields']['url'] );
		}
		if ( ! empty( $defaults['comment_field'] ) ) {
			$defaults['comment_field'] = str_replace( '<textarea', '<textarea placeholder="' . esc_html( 'Leave a comment', 'typecase' ) . '"', $defaults['comment_field'] );
		}
		return $defaults;
	}
}

if ( ! function_exists( 'typecase_pagination' ) ) {
    function typecase_pagination( $typecase_qry = NULL ) {
        $typecase_pagination_type = 'numbered';
        if ( is_category() ) {
                $typecase_cat_id = get_query_var('cat');
                $typecase_pagination_type = get_term_meta( $typecase_cat_id, 'vt_archive_pagination', true);
        }
        if ( is_home() ) {}
        if ( is_tag() ) {}
        if ( $typecase_qry == NULL ) {
            global $wp_query;
            $typecase_total = $GLOBALS['wp_query']->max_num_pages;
            $typecase_paged = get_query_var('paged');
        } else {
            if ( is_page() ) {
                $typecase_total = $typecase_qry->max_num_pages;
                $typecase_pagination_type = 'n';
                $typecase_paged = get_query_var('page');
            } else {
                global $wp_query;
                $typecase_paged = get_query_var('paged');
                $typecase_total = $GLOBALS['wp_query']->max_num_pages;
            }
        }
        if ( $typecase_pagination_type == 'load_more' ) {
        typecase_blocknav_loadmore( $typecase_qry );
        } elseif ( $typecase_pagination_type == 'auto_load' ) {
        typecase_blocknav_autoload( $typecase_qry );
        }else {
            $typecase_pagination = paginate_links( array(
                'base'     => str_replace( 99999, '%#%', esc_url( get_pagenum_link(99999) ) ),
                'format'   => '',
                'total'    => $typecase_total,
                'current'  => max( 1, $typecase_paged ),
                'mid_size' => 2,
                'prev_text' => '<i class="vti-left-chevron"></i>',
                'next_text' => '<i class="vti-right-chevron"></i>',
                'type' => 'list',
            ) );
            echo '<nav class="visionwp_pagination">' . $typecase_pagination . '</nav>';
        }
    }
}

if ( ! function_exists( 'typecase_get_qry' ) ) {
    function typecase_get_qry() {
      if ( is_home() ) {
        $typecase_paged = get_query_var('paged');
        if ( $typecase_paged == false ) {
          $typecase_paged = 1;
        }
        $typecase_offset_loop = NULL;
        $typecase_grid_size = NULL;
        $typecase_featured_qry = array('offset' => $typecase_grid_size, 'orderby' => 'date', 'order' => 'DESC',  'post_status' => 'publish', 'typecase_offset_loop' => $typecase_offset_loop, 'paged' => $typecase_paged );
        $typecase_qry = new WP_Query( $typecase_featured_qry );
      }elseif ( is_category() ) {
          $typecase_paged = get_query_var('paged');
          $typecase_grid_size = $typecase_current_cat = NULL;          
          if ( $typecase_paged == false ) {
              $typecase_paged = 1;
          }          
          $typecase_current_cat = get_query_var('cat');
          $typecase_grid_size = typecase_get_category_offset();          
          if ( $typecase_grid_size != NULL ) {
              $typecase_offset_loop = 'on';
          } else {
              $typecase_offset_loop = NULL;
          }
          $typecase_featured_qry = array( 'cat' => $typecase_current_cat, 'offset' => $typecase_grid_size, 'orderby' => 'date', 'order' => 'DESC',  'post_status' => 'publish', 'typecase_offset_loop' => $typecase_offset_loop, 'paged' => $typecase_paged );
          $typecase_qry = new WP_Query( $typecase_featured_qry );
      } elseif ( is_page() ) {
            $typecase_paged = get_query_var('page');
            $typecase_arr = NULL;
            if ( $typecase_paged == false ) {
                $typecase_paged = 1;
            }
            $typecase_page_id = get_the_ID();
            $typecase_hp_category_filter = 'off';
            $typecase_lb_offset = 'on';

            if ( $typecase_hp_category_filter == 'off' ) {
                $typecase_hp_category = '';
                foreach ( $typecase_hp_category as $typecase_cat ) {
                    $typecase_arr .= $typecase_cat . ',';
                }
                $typecase_arr = rtrim( $typecase_arr, ",");
            }
            if ( $typecase_lb_offset != NULL ) {
                $typecase_offset_loop = 'on';
            } else {
                $typecase_offset_loop = NULL;
            }
            $typecase_qry = new WP_Query( array('post_status' => 'publish', 'ignore_sticky_posts' => true, 'paged' => $typecase_paged, 'cat' => $typecase_arr, 'offset' => $typecase_lb_offset, 'typecase_offset_loop' => $typecase_offset_loop  ) );
        } else {
            global $wp_query;
            $typecase_qry = $wp_query;
        }
        return $typecase_qry;
    }
}

add_action( 'pre_get_posts', 'typecase_offset_loop_pre_get_posts' );
if ( ! function_exists( 'typecase_offset_loop_pre_get_posts' ) ) {
    function typecase_offset_loop_pre_get_posts( $query ){
        if ( isset( $query->query_vars['typecase_offset_loop'] ) && ( $query->query_vars['typecase_offset_loop'] == 'on' ) ) {
            if ( is_category() ) { $typecase_grid_size = typecase_get_category_offset(); }
            $typecase_posts_per_page = get_option('posts_per_page');
            if ( $query->is_paged == true ) {
                $typecase_page_offset = $typecase_grid_size + ( ( $query->query_vars['paged'] - 1 ) * $typecase_posts_per_page );
                $query->set( 'offset', $typecase_page_offset );
            } else {
                $query->set( 'offset', $typecase_grid_size );
            }
        }
         if ( ( is_category() || is_tag() || is_home() ) && $query->is_main_query() && ( ! is_admin() ) ) {
            $query->set( 'post_type', 'post' );
        }
        return $query;
    }
}

if ( ! function_exists( 'typecase_get_category_offset' ) ) {
    function typecase_get_category_offset() {
        $typecase_return = 0;
            $typecase_cat_id = get_query_var('cat');
            $typecase_offset = 'on';
            if ( $typecase_offset == 'on' || $typecase_offset == 'off' || $typecase_offset == '' ) {
                $typecase_grid_onoff = get_term_meta( $typecase_cat_id, 'typecase_cat_featured_op', true);
                if ($typecase_grid_onoff == 'style_1'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_2'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_3'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_4'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_5'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_6'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_7'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_8'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_9'){
                    $typecase_return = NULL;
                }elseif($typecase_grid_onoff == 'style_10'){
                    $typecase_return = NULL;
                }else{
                    $typecase_return = NULL;
                }
            }
        return $typecase_return;
    }
}

if ( ! function_exists( 'typecase_pagination_offset' ) ) {
    function typecase_pagination_offset($found_posts, $query) {
        $typecase_grid_size = 0;
        if ( is_category() ) { $typecase_grid_size = typecase_get_category_offset(); }
        if ( is_home() ) { $typecase_grid_size = 0; }
        if ( is_page() ) {
            $typecase_grid_size = 0;
        }
        return ( $found_posts - $typecase_grid_size );
    }
}
add_filter('found_posts', 'typecase_pagination_offset', 1, 2 );

include get_template_directory() . '/inc/misc/core.php';
include get_template_directory() . '/inc/misc/layout-grid.php';
include get_template_directory() . '/inc/misc/layout-grid-number.php';
include get_template_directory() . '/inc/misc/layout-list.php';
include get_template_directory() . '/inc/misc/layout-list-mix.php';
include get_template_directory() . '/inc/misc/layout-list-number.php';
include get_template_directory() . '/inc/misc/layout-small-list.php';
include get_template_directory() . '/inc/misc/layout-mini-list.php';
include get_template_directory() . '/inc/misc/layout-classic.php';
include get_template_directory() . '/inc/misc/layout-overlay.php';
include get_template_directory() . '/inc/misc/layout-slider.php';
include get_template_directory() . '/inc/misc/layout-slider-tab.php';
include get_template_directory() . '/inc/misc/layout-hover.php';
include get_template_directory() . '/inc/misc/layout-center-slider.php';
include get_template_directory() . '/inc/misc/layout-carousel.php';
include get_template_directory() . '/inc/misc/layout-featured-1.php';
include get_template_directory() . '/inc/misc/layout-featured-2.php';
include get_template_directory() . '/inc/misc/layout-featured-3.php';
include get_template_directory() . '/inc/misc/layout-featured-4.php';
include get_template_directory() . '/inc/misc/layout-featured-5.php';
include get_template_directory() . '/inc/misc/layout-featured-6.php';
include get_template_directory() . '/inc/misc/layout-featured-7.php';
include get_template_directory() . '/inc/misc/layout-featured-8.php';
include get_template_directory() . '/inc/misc/layout-featured-9.php';
include get_template_directory() . '/inc/misc/layout-featured-10.php';
include get_template_directory() . '/inc/misc/layout-featured-11.php';
include get_template_directory() . '/inc/misc/layout-featured-12.php';
include get_template_directory() . '/inc/misc/layout-featured-13.php';
include get_template_directory() . '/inc/misc/layout-featured-14.php';
include get_template_directory() . '/inc/misc/layout-featured-18.php';
include get_template_directory() . '/inc/misc/layout-featured-19.php';
include get_template_directory() . '/inc/misc/layout-featured-20.php';
include get_template_directory() . '/inc/misc/layout-marquee.php';
include get_template_directory() . '/inc/misc/layout-newsticker.php';
include get_template_directory() . '/inc/misc/layout-small-main-right-list.php';
include get_template_directory() . '/inc/misc/layout-small-main-below-2list.php';
include get_template_directory() . '/inc/misc/layout-small-main-below-list.php';
include get_template_directory() . '/inc/misc/layout-small-2main-below-list.php';
include get_template_directory() . '/inc/misc/layout-small-ov-main-below-list.php';
include get_template_directory() . '/inc/misc/layout-video.php';
include get_template_directory() . '/inc/misc/menu-p-layout.php';
include get_template_directory() . '/inc/customizer/customizer.php';
include get_template_directory() . '/inc/functions/menu-option.php';
include get_template_directory() . '/inc/functions/class-tgm-plugin-activation.php';
include get_template_directory() . '/inc/functions/required-plugins.php';

if ( ! function_exists( 'typecase_fonts' ) ) {
  function typecase_fonts() {
  	  $google_font = '';
      $title_style_text = get_theme_mod('typecase_title_font_family', 'Inter Tight');
      $typecase_title_font_weight = get_theme_mod('typecase_title_font_weight', '800');
      if (strpos($title_style_text, 'vt_c_') !== false){
        $title_style_text = '';
      }else{
        $title_style_text = $title_style_text.':'.$typecase_title_font_weight.'|';
      }
      $paragrap_style_text = get_theme_mod('typecase_p_font_family', 'Inter');
      $typecase_p_font_weight = get_theme_mod('typecase_p_font_weight', '400');
      if (strpos($paragrap_style_text, 'vt_c_') !== false){
        $paragrap_style_text = '';
      }else{
        $paragrap_style_text = $paragrap_style_text.':'.$typecase_p_font_weight.'|';
      }
      $menu_font_style = get_theme_mod('typecase_menu_font_family', 'Inter Tight');
      $typecase_menu_font_weight = get_theme_mod('typecase_menu_font_weight', '700');
      $typecase_sub_menu_font_weight = ','.get_theme_mod('typecase_sub_menu_font_weight', '500');
      $cat_font_weight = get_theme_mod('typecase_cat_font_weight', '700');
      $typecase_meta_font_weight = get_theme_mod('typecase_meta_font_weight', '400');
      if (strpos($menu_font_style, 'vt_c_') !== false){
        $menu_font_style = '';
      }else{
        $menu_font_style = $menu_font_style.':'.$typecase_menu_font_weight.','.$typecase_sub_menu_font_weight.','.$cat_font_weight.','.$typecase_meta_font_weight.',';
      }
      if (strpos($title_style_text, 'vt_c_') !== false && strpos($paragrap_style_text, 'vt_c_') !== false && strpos($menu_font_style, 'vt_c_') !== false) {
        $google_font ='';
      }else{
        $google_font = add_query_arg( array(
           'family' => urlencode ( $title_style_text.$paragrap_style_text.$menu_font_style ),
           'display' => 'swap',
        ), '//fonts.googleapis.com/css' );
      }
      return esc_url_raw($google_font);
  }
}

add_action( 'wp_enqueue_scripts', 'typecase_font_scripts' );
if ( ! function_exists( 'typecase_font_scripts' ) ) {
  function typecase_font_scripts() {
    $title_style_text = get_theme_mod('typecase_title_font_family', 'Inter Tight');
    $paragrap_style_text = get_theme_mod('typecase_p_font_family', 'Inter');
    $menu_font_style = get_theme_mod('typecase_menu_font_family', 'Inter Tight');
    if (strpos($title_style_text, 'vt_c_') !== false && strpos($paragrap_style_text, 'vt_c_') !== false && strpos($menu_font_style, 'vt_c_') !== false) {
    }else{
      wp_enqueue_style( 'typecase_fonts_url', typecase_fonts(), array(), TYPECASE_VERSION );
    }
  }
}

add_action( 'enqueue_block_editor_assets', 'typecase_editor', 90 );
if ( ! function_exists( 'typecase_editor' ) ) {
  function typecase_editor() {
      wp_enqueue_style( 'typecase-editor-fonts', typecase_fonts(), array(), TYPECASE_VERSION );
      wp_enqueue_style( 'typecase-editor-style', get_template_directory_uri().'/css/editor.css', false, TYPECASE_VERSION );
      wp_add_inline_style( 'typecase-editor-style', typecase_editor_dynamic_css() );
  }
}

add_action( 'wp_enqueue_scripts', 'typecase_load_css' );
if ( ! function_exists( 'typecase_load_css' ) ) {
  function typecase_load_css() {
  		wp_enqueue_style( 'typecase_layout', get_template_directory_uri().'/css/layout.css', false, TYPECASE_VERSION );
      wp_enqueue_style( 'typecase_style', get_template_directory_uri().'/style.css', false, TYPECASE_VERSION );
      wp_enqueue_style( 'magnific-popup', get_template_directory_uri().'/css/magnific-popup.css', false, TYPECASE_VERSION );
      wp_enqueue_style( 'swiper', get_template_directory_uri().'/css/swiper.min.css', false, TYPECASE_VERSION );
      wp_add_inline_style( 'typecase_style', typecase_generate_dynamic_css() );
  }
}

add_action( 'wp_enqueue_scripts', 'typecase_enqueue_script' );
if ( ! function_exists( 'typecase_enqueue_script' ) ) {
  function typecase_enqueue_script() {
  	  wp_enqueue_script( 'swiper', get_template_directory_uri().'/js/swiper.min.js', array('jquery'), TYPECASE_VERSION, true );
      wp_enqueue_script( 'waypoints', get_template_directory_uri().'/js/waypoints.min.js', array('jquery'), TYPECASE_VERSION, true );
      wp_enqueue_script( 'cookie', get_template_directory_uri().'/js/cookie.min.js', array('jquery'), TYPECASE_VERSION, true );
      wp_enqueue_script( 'lazysizes', get_template_directory_uri().'/js/lazysizes.min.js', array('jquery'), TYPECASE_VERSION, true );
      wp_enqueue_script( 'magnific-popup', get_template_directory_uri().'/js/magnific-popup.min.js', array('jquery'), TYPECASE_VERSION, true );
      wp_enqueue_script( 'typecase-custom', get_template_directory_uri().'/js/custom.js', array('jquery'), TYPECASE_VERSION, true );
      wp_localize_script( 'typecase-custom', 'vtParamsOpt', 
      array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'opt_dark' => get_theme_mod('enable_dark_skin'),
        'pop_close_b' => '<svg width="32" height="32" viewBox="0 0 32 32"><g><path d="M 10.050,23.95c 0.39,0.39, 1.024,0.39, 1.414,0L 17,18.414l 5.536,5.536c 0.39,0.39, 1.024,0.39, 1.414,0 c 0.39-0.39, 0.39-1.024,0-1.414L 18.414,17l 5.536-5.536c 0.39-0.39, 0.39-1.024,0-1.414c-0.39-0.39-1.024-0.39-1.414,0 L 17,15.586L 11.464,10.050c-0.39-0.39-1.024-0.39-1.414,0c-0.39,0.39-0.39,1.024,0,1.414L 15.586,17l-5.536,5.536 C 9.66,22.926, 9.66,23.56, 10.050,23.95z"></path></g></svg>',
        'pop_nav_b' => '<svg x="0px" y="0px" width="30px" height="30px" viewBox="0 0 30 30" enable-background="new 0 0 30 30" xml:space="preserve"><g><polygon fill="#BABABA" points="19.178,25.979 19.982,25.388 12.633,15.378 19.982,5.37 19.178,4.778 11.393,15.378"></polygon></g></svg>'
      ));
  }
}
?>