<div class="typecase-share-buttons">
	<amp-social-share type="facebook" class="button__share share-button-fb"
					  data-url="<?php echo esc_url( get_permalink() ); ?>"
					  data-param-app_id="<?php echo esc_attr( get_theme_mod( 'vt_seo_fb_app_id' ) ); ?>"
					  data-media="<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>"
					  data-description="<?php the_title_attribute(); ?>">
                      <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0.13 1030.01 1023.78"> <title></title> <g id="icomoon-ignore"> </g> <path d="M1030.008 515.133c0-284.411-230.593-515.004-515.004-515.004s-515.004 230.593-515.004 515.004c0 257.073 188.32 470.113 434.535 508.738v-359.859h-130.768v-148.922h130.768v-113.387c0-129.051 76.907-200.38 194.543-200.38 56.307 0 115.275 10.085 115.275 10.085v126.734h-64.976c-63.989 0-83.946 39.698-83.946 80.426v96.563h142.828l-22.832 148.922h-119.996v359.859c246.258-38.668 434.578-251.751 434.578-508.781z"></path> </svg>
	</amp-social-share>
	<amp-social-share type="twitter" class="button__share share-button-tw"
					  data-url="<?php echo esc_url( get_permalink() ); ?>"
					  data-media="<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>"
					  data-description="<?php the_title_attribute(); ?>">
                      <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="-0.01 -0.01 1250.7 1023.98"> <title></title> <g id="icomoon-ignore"> </g> <path d="M1222.349 118.163c-19.648 8.715-39.849 16.069-60.489 22.041 24.437-27.636 43.068-60.155 54.442-95.739 2.55-7.976-0.093-16.707-6.649-21.924-6.548-5.221-15.646-5.846-22.856-1.573-43.835 25.998-91.128 44.682-140.716 55.608-49.951-48.81-117.796-76.587-187.932-76.587-148.046 0-268.493 120.442-268.493 268.485 0 11.66 0.738 23.255 2.199 34.689-183.712-16.13-354.505-106.426-471.788-250.293-4.18-5.128-10.619-7.892-17.211-7.363-6.596 0.516-12.523 4.236-15.856 9.953-23.787 40.817-36.363 87.501-36.363 134.999 0 64.693 23.098 126.075 63.899 174.037-12.406-4.297-24.445-9.667-35.935-16.045-6.169-3.433-13.697-3.381-19.826 0.133-6.132 3.514-9.977 9.977-10.139 17.042-0.028 1.19-0.028 2.38-0.028 3.587 0 96.566 51.973 183.506 131.432 230.891-6.826-0.682-13.649-1.67-20.427-2.965-6.988-1.335-14.173 1.114-18.886 6.443-4.72 5.326-6.282 12.749-4.107 19.527 29.412 91.826 105.135 159.367 196.679 179.959-75.926 47.555-162.752 72.464-253.9 72.464-19.019 0-38.146-1.118-56.866-3.333-9.3-1.105-18.192 4.386-21.359 13.229-3.167 8.848 0.19 18.712 8.101 23.783 117.094 75.078 252.488 114.762 391.537 114.762 273.354 0 444.357-128.903 539.673-237.040 118.857-134.837 187.024-313.312 187.024-489.657 0-7.367-0.113-14.807-0.339-22.222 46.893-35.33 87.267-78.088 120.12-127.232 4.991-7.464 4.45-17.328-1.331-24.199-5.773-6.875-15.396-9.098-23.61-5.459z"></path> </svg>
	</amp-social-share>
	<amp-social-share type="pinterest" class="button__share share-button-pin"
					  data-url="<?php echo esc_url( get_permalink() ); ?>"
					  data-media="<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>"
					  data-description="<?php the_title_attribute(); ?>">
                      <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 804.83 1024"> <title></title> <g id="icomoon-ignore"> </g> <path d="M700.452 104.933c-70.486-67.666-168.031-104.933-274.665-104.933-162.889 0-263.073 66.771-318.432 122.781-68.227 69.026-107.351 160.679-107.351 251.464 0 113.986 47.678 201.474 127.52 234.022 5.36 2.196 10.754 3.303 16.041 3.303 16.844 0 30.19-11.021 34.814-28.7 2.695-10.143 8.94-35.164 11.655-46.026 5.813-21.451 1.116-31.769-11.559-46.707-23.092-27.323-33.846-59.633-33.846-101.683 0-124.901 93.004-257.646 265.378-257.646 136.771 0 221.733 77.735 221.733 202.868 0 78.964-17.009 152.092-47.902 205.923-21.468 37.403-59.217 81.989-117.17 81.989-25.061 0-47.572-10.294-61.777-28.241-13.419-16.966-17.841-38.883-12.445-61.724 6.097-25.807 14.41-52.727 22.455-78.753 14.674-47.532 28.545-92.426 28.545-128.244 0-61.265-37.664-102.43-93.714-102.43-71.232 0-127.038 72.349-127.038 164.709 0 45.296 12.038 79.175 17.488 92.185-8.973 38.021-62.305 264.060-72.421 306.685-5.849 24.882-41.086 221.409 17.237 237.081 65.529 17.607 124.102-173.798 130.063-195.427 4.832-17.59 21.738-84.103 32.099-124.99 31.633 30.471 82.567 51.070 132.128 51.070 93.43 0 177.454-42.043 236.595-118.378 57.358-74.040 88.948-177.236 88.948-290.564 0-88.598-38.047-175.941-104.378-239.63z"></path> </svg>
	</amp-social-share>
	<amp-social-share type="whatsapp" class="button__share share-button-wa">
    <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 -0.26 1018.18 1024.26"> <title></title> <g id="icomoon-ignore"> </g> <path d="M746.773 614.809c-10.23-5.115-76.723-35.804-86.953-40.919s-20.46-5.115-30.689 5.115c-10.23 10.23-30.689 40.919-40.919 51.149-5.115 10.23-15.345 10.23-25.574 5.115-35.804-15.345-71.608-35.804-102.298-61.379-25.574-25.574-51.149-56.264-71.608-86.953-5.115-10.23 0-20.46 5.115-25.574s10.23-15.345 20.46-20.46c5.115-5.115 10.23-15.345 10.23-20.46 5.115-5.115 5.115-15.345 0-20.46s-30.689-66.494-40.919-92.068c-5.115-35.804-15.345-35.804-25.574-35.804h-25.574c-10.23 0-25.574 10.23-30.689 15.345-30.689 30.689-46.034 66.494-46.034 107.413 5.115 46.034 20.46 92.068 51.149 132.987 56.264 81.838 127.872 148.332 214.825 189.251 25.574 10.23 46.034 20.46 71.608 25.574 25.574 10.23 51.149 10.23 81.838 5.115 35.804-5.115 66.494-30.689 86.953-61.379 10.23-20.46 10.23-40.919 5.115-61.379l-20.46-10.23zM874.645 149.355c-199.481-199.481-521.718-199.481-721.199 0-163.676 163.676-194.366 414.306-81.838 613.786l-71.608 260.859 271.089-71.608c76.723 40.919 158.561 61.379 240.4 61.379 281.319 0 506.374-225.055 506.374-506.374 5.115-132.987-51.149-260.859-143.217-358.042zM736.543 865.439c-66.494 40.919-143.217 66.494-225.055 66.494-76.723 0-148.332-20.46-214.825-56.264l-15.345-10.23-158.561 40.919 40.919-153.447-10.23-15.345c-122.757-204.595-61.379-460.34 138.102-588.212s455.225-61.379 577.982 132.987c122.757 199.481 66.494 460.34-132.987 583.097z"></path> </svg>
	</amp-social-share>
</div>
	<?php

	if ( get_theme_mod( 'hide_amp_related', 0 ) == 1 ) {
		return;
	}
	global $post;

	$terms = get_the_terms( $post->ID, 'category' );
	$term_ids = array();
	if ( empty( $terms ) || is_wp_error( $terms ) ) {
		return;
	}

	foreach ( $terms as $key ) {
		$term_ids[] = $key->term_id;
	}

	$args = array( 'category__in' => $term_ids, 'post__not_in' => array( $post->ID ), 'posts_per_page' => 4, 'ignore_sticky_posts' => 1 );
	$qry = new wp_query( $args );
	if ( $qry->have_posts() ) {
		?>
		<div class="related_posts_wrap">
			<h3><?php esc_attr_e( 'Related Content', 'typecase' ); ?></h3>
			<?php while ( $qry->have_posts() ) { ?>
				<?php $qry->the_post(); ?>
				<?php global $post; ?>
				<div class="related_post_items">
					<?php $tid = get_post_meta( $post->ID, '_thumbnail_id', true ); ?>
					<?php if ( ! empty( $tid ) ) { ?>
						<div class="amp_img_w">
							<a href="<?php the_permalink(); ?>amp/" rel="bookmark" title="<?php the_title_attribute(); ?>">
								<amp-img src="<?php echo esc_url( wp_get_attachment_thumb_url( $tid ) ); ?>" width="75" height="75" alt="<?php the_title_attribute(); ?>" ></amp-img>
							</a>
						</div>
					<?php } ?>
					<div class="vt_title_wrap">
						<h4><a href="<?php the_permalink(); ?>amp/" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>
					</div>
				</div>
			<?php } ?>
		</div>
		<?php
		wp_reset_postdata();
	}
