<?php
if ( ! class_exists( 'typecase_customizer_default' ) ) {
	final class typecase_customizer_default {
		private static $instance = null;
		private $wp_customize;
		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		private function __construct() {
			add_action( 'customize_controls_print_scripts', array( $this, 'typecase_customize_controls_print_scripts' ) );
			add_action( 'wp_ajax_customizer_reset', array( $this, 'typecase_ajax_customizer_reset' ) );
			add_action( 'customize_register', array( $this, 'typecase_customize_register' ) );
		}

		public function typecase_customize_controls_print_scripts() {
			wp_enqueue_style( 'css-for-customize', get_template_directory_uri() . '/inc/customizer/css/customizer-control.css' );
			wp_enqueue_script( 'js-for-customize', get_template_directory_uri() . '/inc/customizer/js/customizer-control.js', array( 'jquery', 'customize-controls' ) );
			wp_localize_script( 'js-for-customize', 'typecase_customizer_reset', array(
				'reset'   => esc_html__( 'Reset', 'typecase' ),
				'confirm' => esc_html__( "Clicking the Reset button will revert all settings in the customizer except for menus, widgets and site identity.", 'typecase' ),
				'nonce'   => array(
					'reset' => wp_create_nonce( 'customizer-reset' ),
				)
			) );
		}
		public function typecase_customize_register( $wp_customize ) {
			$this->wp_customize = $wp_customize;
		}

		public function typecase_ajax_customizer_reset() {
			if ( ! $this->wp_customize->is_preview() ) {
				wp_send_json_error( 'not_preview' );
			}
			if ( ! check_ajax_referer( 'customizer-reset', 'nonce', false ) ) {
				wp_send_json_error( 'invalid_nonce' );
			}
			$this->typecase_reset_customizer();
			wp_send_json_success();
		}
		public function typecase_reset_customizer() {
			$settings = $this->wp_customize->settings();
			foreach ( $settings as $setting ) {
				if ( 'theme_mod' == $setting->type ) {
					remove_theme_mod( $setting->id );
				}
			}
		}
	}
}
typecase_customizer_default::get_instance();

function typecase_register_theme_customizer( $wp_customize ) {
	class typecase_control_image_select extends WP_Customize_Control {
	    public function render_content(){
	        if ( empty( $this->choices ) ){ return; }
	        if ( ! empty( $this->label ) ) : ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php endif;
				if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo esc_html($this->description) ; ?></span>
			<?php endif;
	        $html = array();
			$tpl  = '<label class="vtc-image-select"><img src="%s"><input type="%s" class="hidden" name="%s" value="%s" %s%s></label>';
			$field = $this->input_attrs;
			foreach ( $this->choices as $value => $image )
			{
				$html[] = sprintf(
					$tpl,
					$image,
					$field['multiple'] ? 'checkbox' : 'radio',
					$this->id,
					esc_attr( $value ),
					$this->get_link(),
					checked( $this->value(), $value, false )
				);
			}
			echo implode(' ', $html);
	    }
	}
	// Header text
	class typecase_Customize_Control_Title extends WP_Customize_Control {
	    public function render_content(){
	        if ( empty( $this->label ) ){ return; }
	        if ( ! empty( $this->label ) ) : ?>
					<h2 class="vtc_headding"><?php echo esc_html( $this->label ); ?>
				<?php endif;
				if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo esc_html($this->description) ; ?></span>
			</h2><?php endif;
	    }
	}

	$option_sidebar = array();
	$sidebars = get_option('sbg_sidebars');
	$option_sidebar['default']= esc_html__( 'Default Sidebar', 'typecase' );
	if(isset($sidebars)) {
		if(is_array($sidebars)) {
			foreach($sidebars as $sidebar) {
				$sidebar_lower = strtolower($sidebar);
				$sidebarid = str_replace(' ','-', $sidebar_lower);
				$option_sidebar[$sidebarid] = $sidebar;
			}
		}
	}

	//Layouts
	$args = array(
		'post_type'     => 'vt_layout',
		'post_status'   => array( 'publish' ),
		'numberposts'   => -1,
		'orderby'       => 'title',
		'order'         => 'ASC',
		'suppress_filters'   => false
   );
   $layouts = get_posts($args);
   $vt_layouts = array();
   $vt_layouts['default']= esc_html__( 'Default Layout', 'typecase' );
   
   if(!empty($layouts)){
	   foreach ($layouts as $layout){
		   $vt_layouts[$layout->ID] = $layout->post_title;
	   }
   }

	// Custom fonts
	$vt_custom_font = array();
	if(function_exists('typecase_bac_PostViews')){
		$fonts = typecase_font_tax::typecase_get_fonts();
		if ( empty ($fonts)) {
			$vt_custom_font = array();
		}else{
			foreach ( $fonts as $font => $values ) {
				$vt_custom_font['vt_c_'.$font] = 'Custom font - '.$font;
			}
		}
	}else{
		$vt_custom_font = array();
	}

	// Font and Google Font
	$vt_google_font = array(
	'ABeeZee' => 'ABeeZee',
	'Abel' => 'Abel',
	'Abhaya Libre' => 'Abhaya Libre',
	'Abril Fatface' => 'Abril Fatface',
	'Aclonica' => 'Aclonica',
	'Acme' => 'Acme',
	'Actor' => 'Actor',
	'Adamina' => 'Adamina',
	'Advent Pro' => 'Advent Pro',
	'Aguafina Script' => 'Aguafina Script',
	'Akaya Kanadaka' => 'Akaya Kanadaka',
	'Akaya Telivigala' => 'Akaya Telivigala',
	'Akronim' => 'Akronim',
	'Aladin' => 'Aladin',
	'Alata' => 'Alata',
	'Alatsi' => 'Alatsi',
	'Aldrich' => 'Aldrich',
	'Alef' => 'Alef',
	'Alegreya' => 'Alegreya',
	'Alegreya SC' => 'Alegreya SC',
	'Alegreya Sans' => 'Alegreya Sans',
	'Alegreya Sans SC' => 'Alegreya Sans SC',
	'Aleo' => 'Aleo',
	'Alex Brush' => 'Alex Brush',
	'Alfa Slab One' => 'Alfa Slab One',
	'Alice' => 'Alice',
	'Alike' => 'Alike',
	'Alike Angular' => 'Alike Angular',
	'Allan' => 'Allan',
	'Allerta' => 'Allerta',
	'Allerta Stencil' => 'Allerta Stencil',
	'Allison' => 'Allison',
	'Allura' => 'Allura',
	'Almarai' => 'Almarai',
	'Almendra' => 'Almendra',
	'Almendra Display' => 'Almendra Display',
	'Almendra SC' => 'Almendra SC',
	'Alumni Sans' => 'Alumni Sans',
	'Amarante' => 'Amarante',
	'Amaranth' => 'Amaranth',
	'Amatic SC' => 'Amatic SC',
	'Amethysta' => 'Amethysta',
	'Amiko' => 'Amiko',
	'Amiri' => 'Amiri',
	'Amita' => 'Amita',
	'Anaheim' => 'Anaheim',
	'Andada Pro' => 'Andada Pro',
	'Andika' => 'Andika',
	'Andika New Basic' => 'Andika New Basic',
	'Angkor' => 'Angkor',
	'Annie Use Your Telescope' => 'Annie Use Your Telescope',
	'Anonymous Pro' => 'Anonymous Pro',
	'Antic' => 'Antic',
	'Antic Didone' => 'Antic Didone',
	'Antic Slab' => 'Antic Slab',
	'Anton' => 'Anton',
	'Antonio' => 'Antonio',
	'Arapey' => 'Arapey',
	'Arbutus' => 'Arbutus',
	'Arbutus Slab' => 'Arbutus Slab',
	'Architects Daughter' => 'Architects Daughter',
	'Archivo' => 'Archivo',
	'Archivo Black' => 'Archivo Black',
	'Archivo Narrow' => 'Archivo Narrow',
	'Are You Serious' => 'Are You Serious',
	'Aref Ruqaa' => 'Aref Ruqaa',
	'Arima Madurai' => 'Arima Madurai',
	'Arimo' => 'Arimo',
	'Arizonia' => 'Arizonia',
	'Armata' => 'Armata',
	'Arsenal' => 'Arsenal',
	'Artifika' => 'Artifika',
	'Arvo' => 'Arvo',
	'Arya' => 'Arya',
	'Asap' => 'Asap',
	'Asap Condensed' => 'Asap Condensed',
	'Asar' => 'Asar',
	'Asset' => 'Asset',
	'Assistant' => 'Assistant',
	'Astloch' => 'Astloch',
	'Asul' => 'Asul',
	'Athiti' => 'Athiti',
	'Atkinson Hyperlegible' => 'Atkinson Hyperlegible',
	'Atma' => 'Atma',
	'Atomic Age' => 'Atomic Age',
	'Aubrey' => 'Aubrey',
	'Audiowide' => 'Audiowide',
	'Autour One' => 'Autour One',
	'Average' => 'Average',
	'Average Sans' => 'Average Sans',
	'Averia Gruesa Libre' => 'Averia Gruesa Libre',
	'Averia Libre' => 'Averia Libre',
	'Averia Sans Libre' => 'Averia Sans Libre',
	'Averia Serif Libre' => 'Averia Serif Libre',
	'Azeret Mono' => 'Azeret Mono',
	'B612' => 'B612',
	'B612 Mono' => 'B612 Mono',
	'Bad Script' => 'Bad Script',
	'Bahiana' => 'Bahiana',
	'Bahianita' => 'Bahianita',
	'Bai Jamjuree' => 'Bai Jamjuree',
	'Ballet' => 'Ballet',
	'Baloo 2' => 'Baloo 2',
	'Baloo Bhai 2' => 'Baloo Bhai 2',
	'Baloo Bhaina 2' => 'Baloo Bhaina 2',
	'Baloo Chettan 2' => 'Baloo Chettan 2',
	'Baloo Da 2' => 'Baloo Da 2',
	'Baloo Paaji 2' => 'Baloo Paaji 2',
	'Baloo Tamma 2' => 'Baloo Tamma 2',
	'Baloo Tammudu 2' => 'Baloo Tammudu 2',
	'Baloo Thambi 2' => 'Baloo Thambi 2',
	'Balsamiq Sans' => 'Balsamiq Sans',
	'Balthazar' => 'Balthazar',
	'Bangers' => 'Bangers',
	'Barlow' => 'Barlow',
	'Barlow Condensed' => 'Barlow Condensed',
	'Barlow Semi Condensed' => 'Barlow Semi Condensed',
	'Barriecito' => 'Barriecito',
	'Barrio' => 'Barrio',
	'Basic' => 'Basic',
	'Baskervville' => 'Baskervville',
	'Battambang' => 'Battambang',
	'Baumans' => 'Baumans',
	'Bayon' => 'Bayon',
	'Be Vietnam' => 'Be Vietnam',
	'Be Vietnam Pro' => 'Be Vietnam Pro',
	'Bebas Neue' => 'Bebas Neue',
	'Belgrano' => 'Belgrano',
	'Bellefair' => 'Bellefair',
	'Belleza' => 'Belleza',
	'Bellota' => 'Bellota',
	'Bellota Text' => 'Bellota Text',
	'BenchNine' => 'BenchNine',
	'Benne' => 'Benne',
	'Bentham' => 'Bentham',
	'Berkshire Swash' => 'Berkshire Swash',
	'Besley' => 'Besley',
	'Beth Ellen' => 'Beth Ellen',
	'Bevan' => 'Bevan',
	'Big Shoulders Display' => 'Big Shoulders Display',
	'Big Shoulders Inline Display' => 'Big Shoulders Inline Display',
	'Big Shoulders Inline Text' => 'Big Shoulders Inline Text',
	'Big Shoulders Stencil Display' => 'Big Shoulders Stencil Display',
	'Big Shoulders Stencil Text' => 'Big Shoulders Stencil Text',
	'Big Shoulders Text' => 'Big Shoulders Text',
	'Bigelow Rules' => 'Bigelow Rules',
	'Bigshot One' => 'Bigshot One',
	'Bilbo' => 'Bilbo',
	'Bilbo Swash Caps' => 'Bilbo Swash Caps',
	'BioRhyme' => 'BioRhyme',
	'BioRhyme Expanded' => 'BioRhyme Expanded',
	'Birthstone' => 'Birthstone',
	'Birthstone Bounce' => 'Birthstone Bounce',
	'Biryani' => 'Biryani',
	'Bitter' => 'Bitter',
	'Black And White Picture' => 'Black And White Picture',
	'Black Han Sans' => 'Black Han Sans',
	'Black Ops One' => 'Black Ops One',
	'Blinker' => 'Blinker',
	'Bodoni Moda' => 'Bodoni Moda',
	'Bokor' => 'Bokor',
	'Bona Nova' => 'Bona Nova',
	'Bonbon' => 'Bonbon',
	'Bonheur Royale' => 'Bonheur Royale',
	'Boogaloo' => 'Boogaloo',
	'Bowlby One' => 'Bowlby One',
	'Bowlby One SC' => 'Bowlby One SC',
	'Brawler' => 'Brawler',
	'Bree Serif' => 'Bree Serif',
	'Brygada 1918' => 'Brygada 1918',
	'Bubblegum Sans' => 'Bubblegum Sans',
	'Bubbler One' => 'Bubbler One',
	'Buda' => 'Buda',
	'Buenard' => 'Buenard',
	'Bungee' => 'Bungee',
	'Bungee Hairline' => 'Bungee Hairline',
	'Bungee Inline' => 'Bungee Inline',
	'Bungee Outline' => 'Bungee Outline',
	'Bungee Shade' => 'Bungee Shade',
	'Butcherman' => 'Butcherman',
	'Butterfly Kids' => 'Butterfly Kids',
	'Cabin' => 'Cabin',
	'Cabin Condensed' => 'Cabin Condensed',
	'Cabin Sketch' => 'Cabin Sketch',
	'Caesar Dressing' => 'Caesar Dressing',
	'Cagliostro' => 'Cagliostro',
	'Cairo' => 'Cairo',
	'Caladea' => 'Caladea',
	'Calistoga' => 'Calistoga',
	'Calligraffitti' => 'Calligraffitti',
	'Cambay' => 'Cambay',
	'Cambo' => 'Cambo',
	'Candal' => 'Candal',
	'Cantarell' => 'Cantarell',
	'Cantata One' => 'Cantata One',
	'Cantora One' => 'Cantora One',
	'Capriola' => 'Capriola',
	'Caramel' => 'Caramel',
	'Carattere' => 'Carattere',
	'Cardo' => 'Cardo',
	'Carme' => 'Carme',
	'Carrois Gothic' => 'Carrois Gothic',
	'Carrois Gothic SC' => 'Carrois Gothic SC',
	'Carter One' => 'Carter One',
	'Castoro' => 'Castoro',
	'Catamaran' => 'Catamaran',
	'Caudex' => 'Caudex',
	'Caveat' => 'Caveat',
	'Caveat Brush' => 'Caveat Brush',
	'Cedarville Cursive' => 'Cedarville Cursive',
	'Ceviche One' => 'Ceviche One',
	'Chakra Petch' => 'Chakra Petch',
	'Changa' => 'Changa',
	'Changa One' => 'Changa One',
	'Chango' => 'Chango',
	'Charm' => 'Charm',
	'Charmonman' => 'Charmonman',
	'Chathura' => 'Chathura',
	'Chau Philomene One' => 'Chau Philomene One',
	'Chela One' => 'Chela One',
	'Chelsea Market' => 'Chelsea Market',
	'Chenla' => 'Chenla',
	'Cherish' => 'Cherish',
	'Cherry Cream Soda' => 'Cherry Cream Soda',
	'Cherry Swash' => 'Cherry Swash',
	'Chewy' => 'Chewy',
	'Chicle' => 'Chicle',
	'Chilanka' => 'Chilanka',
	'Chivo' => 'Chivo',
	'Chonburi' => 'Chonburi',
	'Cinzel' => 'Cinzel',
	'Cinzel Decorative' => 'Cinzel Decorative',
	'Clicker Script' => 'Clicker Script',
	'Coda' => 'Coda',
	'Coda Caption' => 'Coda Caption',
	'Codystar' => 'Codystar',
	'Coiny' => 'Coiny',
	'Combo' => 'Combo',
	'Comfortaa' => 'Comfortaa',
	'Comic Neue' => 'Comic Neue',
	'Coming Soon' => 'Coming Soon',
	'Commissioner' => 'Commissioner',
	'Concert One' => 'Concert One',
	'Condiment' => 'Condiment',
	'Content' => 'Content',
	'Contrail One' => 'Contrail One',
	'Convergence' => 'Convergence',
	'Cookie' => 'Cookie',
	'Copse' => 'Copse',
	'Corben' => 'Corben',
	'Cormorant' => 'Cormorant',
	'Cormorant Garamond' => 'Cormorant Garamond',
	'Cormorant Infant' => 'Cormorant Infant',
	'Cormorant SC' => 'Cormorant SC',
	'Cormorant Unicase' => 'Cormorant Unicase',
	'Cormorant Upright' => 'Cormorant Upright',
	'Courgette' => 'Courgette',
	'Courier Prime' => 'Courier Prime',
	'Cousine' => 'Cousine',
	'Coustard' => 'Coustard',
	'Covered By Your Grace' => 'Covered By Your Grace',
	'Crafty Girls' => 'Crafty Girls',
	'Creepster' => 'Creepster',
	'Crete Round' => 'Crete Round',
	'Crimson Pro' => 'Crimson Pro',
	'Crimson Text' => 'Crimson Text',
	'Croissant One' => 'Croissant One',
	'Crushed' => 'Crushed',
	'Cuprum' => 'Cuprum',
	'Cute Font' => 'Cute Font',
	'Cutive' => 'Cutive',
	'Cutive Mono' => 'Cutive Mono',
	'DM Mono' => 'DM Mono',
	'DM Sans' => 'DM Sans',
	'DM Serif Display' => 'DM Serif Display',
	'DM Serif Text' => 'DM Serif Text',
	'Damion' => 'Damion',
	'Dancing Script' => 'Dancing Script',
	'Dangrek' => 'Dangrek',
	'Darker Grotesque' => 'Darker Grotesque',
	'David Libre' => 'David Libre',
	'Dawning of a New Day' => 'Dawning of a New Day',
	'Days One' => 'Days One',
	'Dekko' => 'Dekko',
	'Dela Gothic One' => 'Dela Gothic One',
	'Delius' => 'Delius',
	'Delius Swash Caps' => 'Delius Swash Caps',
	'Delius Unicase' => 'Delius Unicase',
	'Della Respira' => 'Della Respira',
	'Denk One' => 'Denk One',
	'Devonshire' => 'Devonshire',
	'Dhurjati' => 'Dhurjati',
	'Didact Gothic' => 'Didact Gothic',
	'Diplomata' => 'Diplomata',
	'Diplomata SC' => 'Diplomata SC',
	'Do Hyeon' => 'Do Hyeon',
	'Dokdo' => 'Dokdo',
	'Domine' => 'Domine',
	'Donegal One' => 'Donegal One',
	'Doppio One' => 'Doppio One',
	'Dorsa' => 'Dorsa',
	'Dosis' => 'Dosis',
	'DotGothic16' => 'DotGothic16',
	'Dr Sugiyama' => 'Dr Sugiyama',
	'Duru Sans' => 'Duru Sans',
	'Dynalight' => 'Dynalight',
	'EB Garamond' => 'EB Garamond',
	'Eagle Lake' => 'Eagle Lake',
	'East Sea Dokdo' => 'East Sea Dokdo',
	'Eater' => 'Eater',
	'Economica' => 'Economica',
	'Eczar' => 'Eczar',
	'El Messiri' => 'El Messiri',
	'Electrolize' => 'Electrolize',
	'Elsie' => 'Elsie',
	'Elsie Swash Caps' => 'Elsie Swash Caps',
	'Emblema One' => 'Emblema One',
	'Emilys Candy' => 'Emilys Candy',
	'Encode Sans' => 'Encode Sans',
	'Encode Sans Condensed' => 'Encode Sans Condensed',
	'Encode Sans Expanded' => 'Encode Sans Expanded',
	'Encode Sans SC' => 'Encode Sans SC',
	'Encode Sans Semi Condensed' => 'Encode Sans Semi Condensed',
	'Encode Sans Semi Expanded' => 'Encode Sans Semi Expanded',
	'Engagement' => 'Engagement',
	'Englebert' => 'Englebert',
	'Enriqueta' => 'Enriqueta',
	'Ephesis' => 'Ephesis',
	'Epilogue' => 'Epilogue',
	'Erica One' => 'Erica One',
	'Esteban' => 'Esteban',
	'Euphoria Script' => 'Euphoria Script',
	'Ewert' => 'Ewert',
	'Exo' => 'Exo',
	'Exo 2' => 'Exo 2',
	'Expletus Sans' => 'Expletus Sans',
	'Explora' => 'Explora',
	'Fahkwang' => 'Fahkwang',
	'Fanwood Text' => 'Fanwood Text',
	'Farro' => 'Farro',
	'Farsan' => 'Farsan',
	'Fascinate' => 'Fascinate',
	'Fascinate Inline' => 'Fascinate Inline',
	'Faster One' => 'Faster One',
	'Fasthand' => 'Fasthand',
	'Fauna One' => 'Fauna One',
	'Faustina' => 'Faustina',
	'Federant' => 'Federant',
	'Federo' => 'Federo',
	'Felipa' => 'Felipa',
	'Fenix' => 'Fenix',
	'Festive' => 'Festive',
	'Finger Paint' => 'Finger Paint',
	'Fira Code' => 'Fira Code',
	'Fira Mono' => 'Fira Mono',
	'Fira Sans' => 'Fira Sans',
	'Fira Sans Condensed' => 'Fira Sans Condensed',
	'Fira Sans Extra Condensed' => 'Fira Sans Extra Condensed',
	'Fjalla One' => 'Fjalla One',
	'Fjord One' => 'Fjord One',
	'Flamenco' => 'Flamenco',
	'Flavors' => 'Flavors',
	'Fleur De Leah' => 'Fleur De Leah',
	'Fondamento' => 'Fondamento',
	'Fontdiner Swanky' => 'Fontdiner Swanky',
	'Forum' => 'Forum',
	'Francois One' => 'Francois One',
	'Frank Ruhl Libre' => 'Frank Ruhl Libre',
	'Fraunces' => 'Fraunces',
	'Freckle Face' => 'Freckle Face',
	'Fredericka the Great' => 'Fredericka the Great',
	'Fredoka One' => 'Fredoka One',
	'Freehand' => 'Freehand',
	'Fresca' => 'Fresca',
	'Frijole' => 'Frijole',
	'Fruktur' => 'Fruktur',
	'Fugaz One' => 'Fugaz One',
	'Fuggles' => 'Fuggles',
	'GFS Didot' => 'GFS Didot',
	'GFS Neohellenic' => 'GFS Neohellenic',
	'Gabriela' => 'Gabriela',
	'Gaegu' => 'Gaegu',
	'Gafata' => 'Gafata',
	'Galada' => 'Galada',
	'Galdeano' => 'Galdeano',
	'Galindo' => 'Galindo',
	'Gamja Flower' => 'Gamja Flower',
	'Gayathri' => 'Gayathri',
	'Gelasio' => 'Gelasio',
	'Gemunu Libre' => 'Gemunu Libre',
	'Gentium Basic' => 'Gentium Basic',
	'Gentium Book Basic' => 'Gentium Book Basic',
	'Geo' => 'Geo',
	'Georama' => 'Georama',
	'Geostar' => 'Geostar',
	'Geostar Fill' => 'Geostar Fill',
	'Germania One' => 'Germania One',
	'Gideon Roman' => 'Gideon Roman',
	'Gidugu' => 'Gidugu',
	'Gilda Display' => 'Gilda Display',
	'Girassol' => 'Girassol',
	'Give You Glory' => 'Give You Glory',
	'Glass Antiqua' => 'Glass Antiqua',
	'Glegoo' => 'Glegoo',
	'Gloria Hallelujah' => 'Gloria Hallelujah',
	'Glory' => 'Glory',
	'Gluten' => 'Gluten',
	'Goblin One' => 'Goblin One',
	'Gochi Hand' => 'Gochi Hand',
	'Goldman' => 'Goldman',
	'Gorditas' => 'Gorditas',
	'Gothic A1' => 'Gothic A1',
	'Gotu' => 'Gotu',
	'Goudy Bookletter 1911' => 'Goudy Bookletter 1911',
	'Gowun Batang' => 'Gowun Batang',
	'Gowun Dodum' => 'Gowun Dodum',
	'Graduate' => 'Graduate',
	'Grand Hotel' => 'Grand Hotel',
	'Grandstander' => 'Grandstander',
	'Gravitas One' => 'Gravitas One',
	'Great Vibes' => 'Great Vibes',
	'Grechen Fuemen' => 'Grechen Fuemen',
	'Grenze' => 'Grenze',
	'Grenze Gotisch' => 'Grenze Gotisch',
	'Grey Qo' => 'Grey Qo',
	'Griffy' => 'Griffy',
	'Gruppo' => 'Gruppo',
	'Gudea' => 'Gudea',
	'Gugi' => 'Gugi',
	'Gupter' => 'Gupter',
	'Gurajada' => 'Gurajada',
	'Habibi' => 'Habibi',
	'Hachi Maru Pop' => 'Hachi Maru Pop',
	'Hahmlet' => 'Hahmlet',
	'Halant' => 'Halant',
	'Hammersmith One' => 'Hammersmith One',
	'Hanalei' => 'Hanalei',
	'Hanalei Fill' => 'Hanalei Fill',
	'Handlee' => 'Handlee',
	'Hanuman' => 'Hanuman',
	'Happy Monkey' => 'Happy Monkey',
	'Harmattan' => 'Harmattan',
	'Headland One' => 'Headland One',
	'Heebo' => 'Heebo',
	'Henny Penny' => 'Henny Penny',
	'Hepta Slab' => 'Hepta Slab',
	'Herr Von Muellerhoff' => 'Herr Von Muellerhoff',
	'Hi Melody' => 'Hi Melody',
	'Hina Mincho' => 'Hina Mincho',
	'Hind' => 'Hind',
	'Hind Guntur' => 'Hind Guntur',
	'Hind Madurai' => 'Hind Madurai',
	'Hind Siliguri' => 'Hind Siliguri',
	'Hind Vadodara' => 'Hind Vadodara',
	'Holtwood One SC' => 'Holtwood One SC',
	'Homemade Apple' => 'Homemade Apple',
	'Homenaje' => 'Homenaje',
	'IBM Plex Mono' => 'IBM Plex Mono',
	'IBM Plex Sans' => 'IBM Plex Sans',
	'IBM Plex Sans Arabic' => 'IBM Plex Sans Arabic',
	'IBM Plex Sans Condensed' => 'IBM Plex Sans Condensed',
	'IBM Plex Sans Devanagari' => 'IBM Plex Sans Devanagari',
	'IBM Plex Sans Hebrew' => 'IBM Plex Sans Hebrew',
	'IBM Plex Sans KR' => 'IBM Plex Sans KR',
	'IBM Plex Sans Thai' => 'IBM Plex Sans Thai',
	'IBM Plex Sans Thai Looped' => 'IBM Plex Sans Thai Looped',
	'IBM Plex Serif' => 'IBM Plex Serif',
	'IM Fell DW Pica' => 'IM Fell DW Pica',
	'IM Fell DW Pica SC' => 'IM Fell DW Pica SC',
	'IM Fell Double Pica' => 'IM Fell Double Pica',
	'IM Fell Double Pica SC' => 'IM Fell Double Pica SC',
	'IM Fell English' => 'IM Fell English',
	'IM Fell English SC' => 'IM Fell English SC',
	'IM Fell French Canon' => 'IM Fell French Canon',
	'IM Fell French Canon SC' => 'IM Fell French Canon SC',
	'IM Fell Great Primer' => 'IM Fell Great Primer',
	'IM Fell Great Primer SC' => 'IM Fell Great Primer SC',
	'Ibarra Real Nova' => 'Ibarra Real Nova',
	'Iceberg' => 'Iceberg',
	'Iceland' => 'Iceland',
	'Imbue' => 'Imbue',
	'Imprima' => 'Imprima',
	'Inconsolata' => 'Inconsolata',
	'Inder' => 'Inder',
	'Indie Flower' => 'Indie Flower',
	'Inika' => 'Inika',
	'Inknut Antiqua' => 'Inknut Antiqua',
	'Inria Sans' => 'Inria Sans',
	'Inria Serif' => 'Inria Serif',
	'Inter' => 'Inter',
	'Inter Tight' => 'Inter Tight',
	'Irish Grover' => 'Irish Grover',
	'Istok Web' => 'Istok Web',
	'Italiana' => 'Italiana',
	'Italianno' => 'Italianno',
	'Itim' => 'Itim',
	'Jacques Francois' => 'Jacques Francois',
	'Jacques Francois Shadow' => 'Jacques Francois Shadow',
	'Jaldi' => 'Jaldi',
	'JetBrains Mono' => 'JetBrains Mono',
	'Jim Nightshade' => 'Jim Nightshade',
	'Jockey One' => 'Jockey One',
	'Jolly Lodger' => 'Jolly Lodger',
	'Jomhuria' => 'Jomhuria',
	'Jomolhari' => 'Jomolhari',
	'Josefin Sans' => 'Josefin Sans',
	'Josefin Slab' => 'Josefin Slab',
	'Jost' => 'Jost',
	'Joti One' => 'Joti One',
	'Jua' => 'Jua',
	'Judson' => 'Judson',
	'Julee' => 'Julee',
	'Julius Sans One' => 'Julius Sans One',
	'Junge' => 'Junge',
	'Jura' => 'Jura',
	'Just Another Hand' => 'Just Another Hand',
	'Just Me Again Down Here' => 'Just Me Again Down Here',
	'K2D' => 'K2D',
	'Kadwa' => 'Kadwa',
	'Kaisei Decol' => 'Kaisei Decol',
	'Kaisei HarunoUmi' => 'Kaisei HarunoUmi',
	'Kaisei Opti' => 'Kaisei Opti',
	'Kaisei Tokumin' => 'Kaisei Tokumin',
	'Kalam' => 'Kalam',
	'Kameron' => 'Kameron',
	'Kanit' => 'Kanit',
	'Kantumruy' => 'Kantumruy',
	'Karantina' => 'Karantina',
	'Karla' => 'Karla',
	'Karma' => 'Karma',
	'Katibeh' => 'Katibeh',
	'Kaushan Script' => 'Kaushan Script',
	'Kavivanar' => 'Kavivanar',
	'Kavoon' => 'Kavoon',
	'Kdam Thmor' => 'Kdam Thmor',
	'Keania One' => 'Keania One',
	'Kelly Slab' => 'Kelly Slab',
	'Kenia' => 'Kenia',
	'Khand' => 'Khand',
	'Khmer' => 'Khmer',
	'Khula' => 'Khula',
	'Kirang Haerang' => 'Kirang Haerang',
	'Kite One' => 'Kite One',
	'Kiwi Maru' => 'Kiwi Maru',
	'Klee One' => 'Klee One',
	'Knewave' => 'Knewave',
	'KoHo' => 'KoHo',
	'Kodchasan' => 'Kodchasan',
	'Koh Santepheap' => 'Koh Santepheap',
	'Kosugi' => 'Kosugi',
	'Kosugi Maru' => 'Kosugi Maru',
	'Kotta One' => 'Kotta One',
	'Koulen' => 'Koulen',
	'Kranky' => 'Kranky',
	'Kreon' => 'Kreon',
	'Kristi' => 'Kristi',
	'Krona One' => 'Krona One',
	'Krub' => 'Krub',
	'Kufam' => 'Kufam',
	'Kulim Park' => 'Kulim Park',
	'Kumar One' => 'Kumar One',
	'Kumar One Outline' => 'Kumar One Outline',
	'Kumbh Sans' => 'Kumbh Sans',
	'Kurale' => 'Kurale',
	'La Belle Aurore' => 'La Belle Aurore',
	'Lacquer' => 'Lacquer',
	'Laila' => 'Laila',
	'Lakki Reddy' => 'Lakki Reddy',
	'Lalezar' => 'Lalezar',
	'Lancelot' => 'Lancelot',
	'Langar' => 'Langar',
	'Lateef' => 'Lateef',
	'Lato' => 'Lato',
	'League Script' => 'League Script',
	'Leckerli One' => 'Leckerli One',
	'Ledger' => 'Ledger',
	'Lekton' => 'Lekton',
	'Lemon' => 'Lemon',
	'Lemonada' => 'Lemonada',
	'Lexend' => 'Lexend',
	'Lexend Deca' => 'Lexend Deca',
	'Lexend Exa' => 'Lexend Exa',
	'Lexend Giga' => 'Lexend Giga',
	'Lexend Mega' => 'Lexend Mega',
	'Lexend Peta' => 'Lexend Peta',
	'Lexend Tera' => 'Lexend Tera',
	'Lexend Zetta' => 'Lexend Zetta',
	'Libre Barcode 128' => 'Libre Barcode 128',
	'Libre Barcode 128 Text' => 'Libre Barcode 128 Text',
	'Libre Barcode 39' => 'Libre Barcode 39',
	'Libre Barcode 39 Extended' => 'Libre Barcode 39 Extended',
	'Libre Barcode 39 Extended Text' => 'Libre Barcode 39 Extended Text',
	'Libre Barcode 39 Text' => 'Libre Barcode 39 Text',
	'Libre Barcode EAN13 Text' => 'Libre Barcode EAN13 Text',
	'Libre Baskerville' => 'Libre Baskerville',
	'Libre Caslon Display' => 'Libre Caslon Display',
	'Libre Caslon Text' => 'Libre Caslon Text',
	'Libre Franklin' => 'Libre Franklin',
	'Life Savers' => 'Life Savers',
	'Lilita One' => 'Lilita One',
	'Lily Script One' => 'Lily Script One',
	'Limelight' => 'Limelight',
	'Linden Hill' => 'Linden Hill',
	'Literata' => 'Literata',
	'Liu Jian Mao Cao' => 'Liu Jian Mao Cao',
	'Livvic' => 'Livvic',
	'Lobster' => 'Lobster',
	'Lobster Two' => 'Lobster Two',
	'Londrina Outline' => 'Londrina Outline',
	'Londrina Shadow' => 'Londrina Shadow',
	'Londrina Sketch' => 'Londrina Sketch',
	'Londrina Solid' => 'Londrina Solid',
	'Long Cang' => 'Long Cang',
	'Lora' => 'Lora',
	'Love Ya Like A Sister' => 'Love Ya Like A Sister',
	'Loved by the King' => 'Loved by the King',
	'Lovers Quarrel' => 'Lovers Quarrel',
	'Luckiest Guy' => 'Luckiest Guy',
	'Lusitana' => 'Lusitana',
	'Lustria' => 'Lustria',
	'M PLUS 1p' => 'M PLUS 1p',
	'M PLUS Rounded 1c' => 'M PLUS Rounded 1c',
	'Ma Shan Zheng' => 'Ma Shan Zheng',
	'Macondo' => 'Macondo',
	'Macondo Swash Caps' => 'Macondo Swash Caps',
	'Mada' => 'Mada',
	'Magra' => 'Magra',
	'Maiden Orange' => 'Maiden Orange',
	'Maitree' => 'Maitree',
	'Major Mono Display' => 'Major Mono Display',
	'Mako' => 'Mako',
	'Mali' => 'Mali',
	'Mallanna' => 'Mallanna',
	'Mandali' => 'Mandali',
	'Manjari' => 'Manjari',
	'Manrope' => 'Manrope',
	'Mansalva' => 'Mansalva',
	'Manuale' => 'Manuale',
	'Marcellus' => 'Marcellus',
	'Marcellus SC' => 'Marcellus SC',
	'Marck Script' => 'Marck Script',
	'Margarine' => 'Margarine',
	'Markazi Text' => 'Markazi Text',
	'Marko One' => 'Marko One',
	'Marmelad' => 'Marmelad',
	'Martel' => 'Martel',
	'Martel Sans' => 'Martel Sans',
	'Marvel' => 'Marvel',
	'Mate' => 'Mate',
	'Mate SC' => 'Mate SC',
	'Maven Pro' => 'Maven Pro',
	'McLaren' => 'McLaren',
	'Meddon' => 'Meddon',
	'MedievalSharp' => 'MedievalSharp',
	'Medula One' => 'Medula One',
	'Meera Inimai' => 'Meera Inimai',
	'Megrim' => 'Megrim',
	'Meie Script' => 'Meie Script',
	'Merienda' => 'Merienda',
	'Merienda One' => 'Merienda One',
	'Merriweather' => 'Merriweather',
	'Merriweather Sans' => 'Merriweather Sans',
	'Metal' => 'Metal',
	'Metal Mania' => 'Metal Mania',
	'Metamorphous' => 'Metamorphous',
	'Metrophobic' => 'Metrophobic',
	'Michroma' => 'Michroma',
	'Milonga' => 'Milonga',
	'Miltonian' => 'Miltonian',
	'Miltonian Tattoo' => 'Miltonian Tattoo',
	'Mina' => 'Mina',
	'Miniver' => 'Miniver',
	'Miriam Libre' => 'Miriam Libre',
	'Mirza' => 'Mirza',
	'Miss Fajardose' => 'Miss Fajardose',
	'Mitr' => 'Mitr',
	'Modak' => 'Modak',
	'Modern Antiqua' => 'Modern Antiqua',
	'Mogra' => 'Mogra',
	'Molengo' => 'Molengo',
	'Molle' => 'Molle',
	'Monda' => 'Monda',
	'Monofett' => 'Monofett',
	'Monoton' => 'Monoton',
	'Monsieur La Doulaise' => 'Monsieur La Doulaise',
	'Montaga' => 'Montaga',
	'MonteCarlo' => 'MonteCarlo',
	'Montez' => 'Montez',
	'Montserrat' => 'Montserrat',
	'Montserrat Alternates' => 'Montserrat Alternates',
	'Montserrat Subrayada' => 'Montserrat Subrayada',
	'Moul' => 'Moul',
	'Moulpali' => 'Moulpali',
	'Mountains of Christmas' => 'Mountains of Christmas',
	'Mouse Memoirs' => 'Mouse Memoirs',
	'Mr Bedfort' => 'Mr Bedfort',
	'Mr Dafoe' => 'Mr Dafoe',
	'Mr De Haviland' => 'Mr De Haviland',
	'Mrs Saint Delafield' => 'Mrs Saint Delafield',
	'Mrs Sheppards' => 'Mrs Sheppards',
	'Mukta' => 'Mukta',
	'Mukta Mahee' => 'Mukta Mahee',
	'Mukta Malar' => 'Mukta Malar',
	'Mukta Vaani' => 'Mukta Vaani',
	'Mulish' => 'Mulish',
	'Muli' => 'Muli',
	'MuseoModerno' => 'MuseoModerno',
	'Mystery Quest' => 'Mystery Quest',
	'NTR' => 'NTR',
	'Nanum Brush Script' => 'Nanum Brush Script',
	'Nanum Gothic' => 'Nanum Gothic',
	'Nanum Gothic Coding' => 'Nanum Gothic Coding',
	'Nanum Myeongjo' => 'Nanum Myeongjo',
	'Nanum Pen Script' => 'Nanum Pen Script',
	'Nerko One' => 'Nerko One',
	'Neucha' => 'Neucha',
	'Neuton' => 'Neuton',
	'New Rocker' => 'New Rocker',
	'New Tegomin' => 'New Tegomin',
	'News Cycle' => 'News Cycle',
	'Newsreader' => 'Newsreader',
	'Niconne' => 'Niconne',
	'Niramit' => 'Niramit',
	'Nixie One' => 'Nixie One',
	'Nobile' => 'Nobile',
	'Nokora' => 'Nokora',
	'Norican' => 'Norican',
	'Nosifer' => 'Nosifer',
	'Notable' => 'Notable',
	'Nothing You Could Do' => 'Nothing You Could Do',
	'Noticia Text' => 'Noticia Text',
	'Noto Kufi Arabic' => 'Noto Kufi Arabic',
	'Noto Music' => 'Noto Music',
	'Noto Naskh Arabic' => 'Noto Naskh Arabic',
	'Noto Nastaliq Urdu' => 'Noto Nastaliq Urdu',
	'Noto Rashi Hebrew' => 'Noto Rashi Hebrew',
	'Noto Sans' => 'Noto Sans',
	'Noto Sans Adlam' => 'Noto Sans Adlam',
	'Noto Sans Adlam Unjoined' => 'Noto Sans Adlam Unjoined',
	'Noto Sans Anatolian Hieroglyphs' => 'Noto Sans Anatolian Hieroglyphs',
	'Noto Sans Arabic' => 'Noto Sans Arabic',
	'Noto Sans Armenian' => 'Noto Sans Armenian',
	'Noto Sans Avestan' => 'Noto Sans Avestan',
	'Noto Sans Balinese' => 'Noto Sans Balinese',
	'Noto Sans Bamum' => 'Noto Sans Bamum',
	'Noto Sans Bassa Vah' => 'Noto Sans Bassa Vah',
	'Noto Sans Batak' => 'Noto Sans Batak',
	'Noto Sans Bengali' => 'Noto Sans Bengali',
	'Noto Sans Bhaiksuki' => 'Noto Sans Bhaiksuki',
	'Noto Sans Brahmi' => 'Noto Sans Brahmi',
	'Noto Sans Buginese' => 'Noto Sans Buginese',
	'Noto Sans Buhid' => 'Noto Sans Buhid',
	'Noto Sans Canadian Aboriginal' => 'Noto Sans Canadian Aboriginal',
	'Noto Sans Carian' => 'Noto Sans Carian',
	'Noto Sans Caucasian Albanian' => 'Noto Sans Caucasian Albanian',
	'Noto Sans Chakma' => 'Noto Sans Chakma',
	'Noto Sans Cham' => 'Noto Sans Cham',
	'Noto Sans Cherokee' => 'Noto Sans Cherokee',
	'Noto Sans Coptic' => 'Noto Sans Coptic',
	'Noto Sans Cuneiform' => 'Noto Sans Cuneiform',
	'Noto Sans Cypriot' => 'Noto Sans Cypriot',
	'Noto Sans Deseret' => 'Noto Sans Deseret',
	'Noto Sans Devanagari' => 'Noto Sans Devanagari',
	'Noto Sans Display' => 'Noto Sans Display',
	'Noto Sans Duployan' => 'Noto Sans Duployan',
	'Noto Sans Egyptian Hieroglyphs' => 'Noto Sans Egyptian Hieroglyphs',
	'Noto Sans Elbasan' => 'Noto Sans Elbasan',
	'Noto Sans Elymaic' => 'Noto Sans Elymaic',
	'Noto Sans Georgian' => 'Noto Sans Georgian',
	'Noto Sans Glagolitic' => 'Noto Sans Glagolitic',
	'Noto Sans Gothic' => 'Noto Sans Gothic',
	'Noto Sans Grantha' => 'Noto Sans Grantha',
	'Noto Sans Gujarati' => 'Noto Sans Gujarati',
	'Noto Sans Gunjala Gondi' => 'Noto Sans Gunjala Gondi',
	'Noto Sans Gurmukhi' => 'Noto Sans Gurmukhi',
	'Noto Sans HK' => 'Noto Sans HK',
	'Noto Sans Hanifi Rohingya' => 'Noto Sans Hanifi Rohingya',
	'Noto Sans Hanunoo' => 'Noto Sans Hanunoo',
	'Noto Sans Hatran' => 'Noto Sans Hatran',
	'Noto Sans Hebrew' => 'Noto Sans Hebrew',
	'Noto Sans Imperial Aramaic' => 'Noto Sans Imperial Aramaic',
	'Noto Sans Indic Siyaq Numbers' => 'Noto Sans Indic Siyaq Numbers',
	'Noto Sans Inscriptional Pahlavi' => 'Noto Sans Inscriptional Pahlavi',
	'Noto Sans Inscriptional Parthian' => 'Noto Sans Inscriptional Parthian',
	'Noto Sans JP' => 'Noto Sans JP',
	'Noto Sans Javanese' => 'Noto Sans Javanese',
	'Noto Sans KR' => 'Noto Sans KR',
	'Noto Sans Kaithi' => 'Noto Sans Kaithi',
	'Noto Sans Kannada' => 'Noto Sans Kannada',
	'Noto Sans Kayah Li' => 'Noto Sans Kayah Li',
	'Noto Sans Kharoshthi' => 'Noto Sans Kharoshthi',
	'Noto Sans Khmer' => 'Noto Sans Khmer',
	'Noto Sans Khojki' => 'Noto Sans Khojki',
	'Noto Sans Khudawadi' => 'Noto Sans Khudawadi',
	'Noto Sans Lao' => 'Noto Sans Lao',
	'Noto Sans Lepcha' => 'Noto Sans Lepcha',
	'Noto Sans Limbu' => 'Noto Sans Limbu',
	'Noto Sans Linear A' => 'Noto Sans Linear A',
	'Noto Sans Linear B' => 'Noto Sans Linear B',
	'Noto Sans Lisu' => 'Noto Sans Lisu',
	'Noto Sans Lycian' => 'Noto Sans Lycian',
	'Noto Sans Lydian' => 'Noto Sans Lydian',
	'Noto Sans Mahajani' => 'Noto Sans Mahajani',
	'Noto Sans Malayalam' => 'Noto Sans Malayalam',
	'Noto Sans Mandaic' => 'Noto Sans Mandaic',
	'Noto Sans Manichaean' => 'Noto Sans Manichaean',
	'Noto Sans Marchen' => 'Noto Sans Marchen',
	'Noto Sans Masaram Gondi' => 'Noto Sans Masaram Gondi',
	'Noto Sans Math' => 'Noto Sans Math',
	'Noto Sans Mayan Numerals' => 'Noto Sans Mayan Numerals',
	'Noto Sans Medefaidrin' => 'Noto Sans Medefaidrin',
	'Noto Sans Meroitic' => 'Noto Sans Meroitic',
	'Noto Sans Miao' => 'Noto Sans Miao',
	'Noto Sans Modi' => 'Noto Sans Modi',
	'Noto Sans Mongolian' => 'Noto Sans Mongolian',
	'Noto Sans Mono' => 'Noto Sans Mono',
	'Noto Sans Mro' => 'Noto Sans Mro',
	'Noto Sans Multani' => 'Noto Sans Multani',
	'Noto Sans Myanmar' => 'Noto Sans Myanmar',
	'Noto Sans N Ko' => 'Noto Sans N Ko',
	'Noto Sans Nabataean' => 'Noto Sans Nabataean',
	'Noto Sans New Tai Lue' => 'Noto Sans New Tai Lue',
	'Noto Sans Newa' => 'Noto Sans Newa',
	'Noto Sans Nushu' => 'Noto Sans Nushu',
	'Noto Sans Ogham' => 'Noto Sans Ogham',
	'Noto Sans Ol Chiki' => 'Noto Sans Ol Chiki',
	'Noto Sans Old Hungarian' => 'Noto Sans Old Hungarian',
	'Noto Sans Old Italic' => 'Noto Sans Old Italic',
	'Noto Sans Old North Arabian' => 'Noto Sans Old North Arabian',
	'Noto Sans Old Permic' => 'Noto Sans Old Permic',
	'Noto Sans Old Persian' => 'Noto Sans Old Persian',
	'Noto Sans Old Sogdian' => 'Noto Sans Old Sogdian',
	'Noto Sans Old South Arabian' => 'Noto Sans Old South Arabian',
	'Noto Sans Old Turkic' => 'Noto Sans Old Turkic',
	'Noto Sans Oriya' => 'Noto Sans Oriya',
	'Noto Sans Osage' => 'Noto Sans Osage',
	'Noto Sans Osmanya' => 'Noto Sans Osmanya',
	'Noto Sans Pahawh Hmong' => 'Noto Sans Pahawh Hmong',
	'Noto Sans Palmyrene' => 'Noto Sans Palmyrene',
	'Noto Sans Pau Cin Hau' => 'Noto Sans Pau Cin Hau',
	'Noto Sans Phags Pa' => 'Noto Sans Phags Pa',
	'Noto Sans Phoenician' => 'Noto Sans Phoenician',
	'Noto Sans Psalter Pahlavi' => 'Noto Sans Psalter Pahlavi',
	'Noto Sans Rejang' => 'Noto Sans Rejang',
	'Noto Sans Runic' => 'Noto Sans Runic',
	'Noto Sans SC' => 'Noto Sans SC',
	'Noto Sans Samaritan' => 'Noto Sans Samaritan',
	'Noto Sans Saurashtra' => 'Noto Sans Saurashtra',
	'Noto Sans Sharada' => 'Noto Sans Sharada',
	'Noto Sans Shavian' => 'Noto Sans Shavian',
	'Noto Sans Siddham' => 'Noto Sans Siddham',
	'Noto Sans Sinhala' => 'Noto Sans Sinhala',
	'Noto Sans Sogdian' => 'Noto Sans Sogdian',
	'Noto Sans Sora Sompeng' => 'Noto Sans Sora Sompeng',
	'Noto Sans Soyombo' => 'Noto Sans Soyombo',
	'Noto Sans Sundanese' => 'Noto Sans Sundanese',
	'Noto Sans Syloti Nagri' => 'Noto Sans Syloti Nagri',
	'Noto Sans Symbols' => 'Noto Sans Symbols',
	'Noto Sans Symbols 2' => 'Noto Sans Symbols 2',
	'Noto Sans Syriac' => 'Noto Sans Syriac',
	'Noto Sans TC' => 'Noto Sans TC',
	'Noto Sans Tagalog' => 'Noto Sans Tagalog',
	'Noto Sans Tagbanwa' => 'Noto Sans Tagbanwa',
	'Noto Sans Tai Le' => 'Noto Sans Tai Le',
	'Noto Sans Tai Tham' => 'Noto Sans Tai Tham',
	'Noto Sans Tai Viet' => 'Noto Sans Tai Viet',
	'Noto Sans Takri' => 'Noto Sans Takri',
	'Noto Sans Tamil' => 'Noto Sans Tamil',
	'Noto Sans Tamil Supplement' => 'Noto Sans Tamil Supplement',
	'Noto Sans Telugu' => 'Noto Sans Telugu',
	'Noto Sans Thaana' => 'Noto Sans Thaana',
	'Noto Sans Thai' => 'Noto Sans Thai',
	'Noto Sans Thai Looped' => 'Noto Sans Thai Looped',
	'Noto Sans Tifinagh' => 'Noto Sans Tifinagh',
	'Noto Sans Tirhuta' => 'Noto Sans Tirhuta',
	'Noto Sans Ugaritic' => 'Noto Sans Ugaritic',
	'Noto Sans Vai' => 'Noto Sans Vai',
	'Noto Sans Wancho' => 'Noto Sans Wancho',
	'Noto Sans Warang Citi' => 'Noto Sans Warang Citi',
	'Noto Sans Yi' => 'Noto Sans Yi',
	'Noto Sans Zanabazar Square' => 'Noto Sans Zanabazar Square',
	'Noto Serif' => 'Noto Serif',
	'Noto Serif Ahom' => 'Noto Serif Ahom',
	'Noto Serif Armenian' => 'Noto Serif Armenian',
	'Noto Serif Balinese' => 'Noto Serif Balinese',
	'Noto Serif Bengali' => 'Noto Serif Bengali',
	'Noto Serif Devanagari' => 'Noto Serif Devanagari',
	'Noto Serif Display' => 'Noto Serif Display',
	'Noto Serif Dogra' => 'Noto Serif Dogra',
	'Noto Serif Ethiopic' => 'Noto Serif Ethiopic',
	'Noto Serif Georgian' => 'Noto Serif Georgian',
	'Noto Serif Grantha' => 'Noto Serif Grantha',
	'Noto Serif Gujarati' => 'Noto Serif Gujarati',
	'Noto Serif Gurmukhi' => 'Noto Serif Gurmukhi',
	'Noto Serif Hebrew' => 'Noto Serif Hebrew',
	'Noto Serif JP' => 'Noto Serif JP',
	'Noto Serif KR' => 'Noto Serif KR',
	'Noto Serif Kannada' => 'Noto Serif Kannada',
	'Noto Serif Khmer' => 'Noto Serif Khmer',
	'Noto Serif Lao' => 'Noto Serif Lao',
	'Noto Serif Malayalam' => 'Noto Serif Malayalam',
	'Noto Serif Myanmar' => 'Noto Serif Myanmar',
	'Noto Serif Nyiakeng Puachue Hmong' => 'Noto Serif Nyiakeng Puachue Hmong',
	'Noto Serif SC' => 'Noto Serif SC',
	'Noto Serif Sinhala' => 'Noto Serif Sinhala',
	'Noto Serif TC' => 'Noto Serif TC',
	'Noto Serif Tamil' => 'Noto Serif Tamil',
	'Noto Serif Tangut' => 'Noto Serif Tangut',
	'Noto Serif Telugu' => 'Noto Serif Telugu',
	'Noto Serif Thai' => 'Noto Serif Thai',
	'Noto Serif Tibetan' => 'Noto Serif Tibetan',
	'Noto Serif Yezidi' => 'Noto Serif Yezidi',
	'Noto Traditional Nushu' => 'Noto Traditional Nushu',
	'Nova Cut' => 'Nova Cut',
	'Nova Flat' => 'Nova Flat',
	'Nova Mono' => 'Nova Mono',
	'Nova Oval' => 'Nova Oval',
	'Nova Round' => 'Nova Round',
	'Nova Script' => 'Nova Script',
	'Nova Slim' => 'Nova Slim',
	'Nova Square' => 'Nova Square',
	'Numans' => 'Numans',
	'Nunito' => 'Nunito',
	'Nunito Sans' => 'Nunito Sans',
	'Odibee Sans' => 'Odibee Sans',
	'Odor Mean Chey' => 'Odor Mean Chey',
	'Offside' => 'Offside',
	'Oi' => 'Oi',
	'Old Standard TT' => 'Old Standard TT',
	'Oldenburg' => 'Oldenburg',
	'Oleo Script' => 'Oleo Script',
	'Oleo Script Swash Caps' => 'Oleo Script Swash Caps',
	'Open Sans' => 'Open Sans',
	'Open Sans Condensed' => 'Open Sans Condensed',
	'Oranienbaum' => 'Oranienbaum',
	'Orbitron' => 'Orbitron',
	'Oregano' => 'Oregano',
	'Orelega One' => 'Orelega One',
	'Orienta' => 'Orienta',
	'Original Surfer' => 'Original Surfer',
	'Oswald' => 'Oswald',
	'Otomanopee One' => 'Otomanopee One',
	'Over the Rainbow' => 'Over the Rainbow',
	'Overlock' => 'Overlock',
	'Overlock SC' => 'Overlock SC',
	'Overpass' => 'Overpass',
	'Overpass Mono' => 'Overpass Mono',
	'Ovo' => 'Ovo',
	'Oxanium' => 'Oxanium',
	'Oxygen' => 'Oxygen',
	'Oxygen Mono' => 'Oxygen Mono',
	'PT Mono' => 'PT Mono',
	'PT Sans' => 'PT Sans',
	'PT Sans Caption' => 'PT Sans Caption',
	'PT Sans Narrow' => 'PT Sans Narrow',
	'PT Serif' => 'PT Serif',
	'PT Serif Caption' => 'PT Serif Caption',
	'Pacifico' => 'Pacifico',
	'Padauk' => 'Padauk',
	'Palanquin' => 'Palanquin',
	'Palanquin Dark' => 'Palanquin Dark',
	'Palette Mosaic' => 'Palette Mosaic',
	'Pangolin' => 'Pangolin',
	'Paprika' => 'Paprika',
	'Parisienne' => 'Parisienne',
	'Passero One' => 'Passero One',
	'Passion One' => 'Passion One',
	'Pathway Gothic One' => 'Pathway Gothic One',
	'Patrick Hand' => 'Patrick Hand',
	'Patrick Hand SC' => 'Patrick Hand SC',
	'Pattaya' => 'Pattaya',
	'Patua One' => 'Patua One',
	'Pavanam' => 'Pavanam',
	'Paytone One' => 'Paytone One',
	'Peddana' => 'Peddana',
	'Peralta' => 'Peralta',
	'Permanent Marker' => 'Permanent Marker',
	'Petit Formal Script' => 'Petit Formal Script',
	'Petrona' => 'Petrona',
	'Philosopher' => 'Philosopher',
	'Piazzolla' => 'Piazzolla',
	'Piedra' => 'Piedra',
	'Pinyon Script' => 'Pinyon Script',
	'Pirata One' => 'Pirata One',
	'Plaster' => 'Plaster',
	'Play' => 'Play',
	'Playball' => 'Playball',
	'Playfair Display' => 'Playfair Display',
	'Playfair Display SC' => 'Playfair Display SC',
	'Podkova' => 'Podkova',
	'Poiret One' => 'Poiret One',
	'Poller One' => 'Poller One',
	'Poly' => 'Poly',
	'Pompiere' => 'Pompiere',
	'Pontano Sans' => 'Pontano Sans',
	'Poor Story' => 'Poor Story',
	'Poppins' => 'Poppins',
	'Port Lligat Sans' => 'Port Lligat Sans',
	'Port Lligat Slab' => 'Port Lligat Slab',
	'Potta One' => 'Potta One',
	'Pragati Narrow' => 'Pragati Narrow',
	'Prata' => 'Prata',
	'Preahvihear' => 'Preahvihear',
	'Press Start 2P' => 'Press Start 2P',
	'Pridi' => 'Pridi',
	'Princess Sofia' => 'Princess Sofia',
	'Prociono' => 'Prociono',
	'Prompt' => 'Prompt',
	'Prosto One' => 'Prosto One',
	'Proza Libre' => 'Proza Libre',
	'Public Sans' => 'Public Sans',
	'Puritan' => 'Puritan',
	'Purple Purse' => 'Purple Purse',
	'Qahiri' => 'Qahiri',
	'Quando' => 'Quando',
	'Quantico' => 'Quantico',
	'Quattrocento' => 'Quattrocento',
	'Quattrocento Sans' => 'Quattrocento Sans',
	'Questrial' => 'Questrial',
	'Quicksand' => 'Quicksand',
	'Quintessential' => 'Quintessential',
	'Qwigley' => 'Qwigley',
	'Racing Sans One' => 'Racing Sans One',
	'Radley' => 'Radley',
	'Rajdhani' => 'Rajdhani',
	'Rakkas' => 'Rakkas',
	'Raleway' => 'Raleway',
	'Raleway Dots' => 'Raleway Dots',
	'Ramabhadra' => 'Ramabhadra',
	'Ramaraja' => 'Ramaraja',
	'Rambla' => 'Rambla',
	'Rammetto One' => 'Rammetto One',
	'Rampart One' => 'Rampart One',
	'Ranchers' => 'Ranchers',
	'Rancho' => 'Rancho',
	'Ranga' => 'Ranga',
	'Rasa' => 'Rasa',
	'Rationale' => 'Rationale',
	'Ravi Prakash' => 'Ravi Prakash',
	'Recursive' => 'Recursive',
	'Red Hat Display' => 'Red Hat Display',
	'Red Hat Text' => 'Red Hat Text',
	'Red Rose' => 'Red Rose',
	'Redressed' => 'Redressed',
	'Reem Kufi' => 'Reem Kufi',
	'Reenie Beanie' => 'Reenie Beanie',
	'Reggae One' => 'Reggae One',
	'Revalia' => 'Revalia',
	'Rhodium Libre' => 'Rhodium Libre',
	'Ribeye' => 'Ribeye',
	'Ribeye Marrow' => 'Ribeye Marrow',
	'Righteous' => 'Righteous',
	'Risque' => 'Risque',
	'Roboto' => 'Roboto',
	'Roboto Condensed' => 'Roboto Condensed',
	'Roboto Mono' => 'Roboto Mono',
	'Roboto Slab' => 'Roboto Slab',
	'Rochester' => 'Rochester',
	'Rock Salt' => 'Rock Salt',
	'RocknRoll One' => 'RocknRoll One',
	'Rokkitt' => 'Rokkitt',
	'Romanesco' => 'Romanesco',
	'Ropa Sans' => 'Ropa Sans',
	'Rosario' => 'Rosario',
	'Rosarivo' => 'Rosarivo',
	'Rouge Script' => 'Rouge Script',
	'Rowdies' => 'Rowdies',
	'Rozha One' => 'Rozha One',
	'Rubik' => 'Rubik',
	'Rubik Beastly' => 'Rubik Beastly',
	'Rubik Mono One' => 'Rubik Mono One',
	'Ruda' => 'Ruda',
	'Rufina' => 'Rufina',
	'Ruge Boogie' => 'Ruge Boogie',
	'Ruluko' => 'Ruluko',
	'Rum Raisin' => 'Rum Raisin',
	'Ruslan Display' => 'Ruslan Display',
	'Russo One' => 'Russo One',
	'Ruthie' => 'Ruthie',
	'Rye' => 'Rye',
	'STIX Two Text' => 'STIX Two Text',
	'Sacramento' => 'Sacramento',
	'Sahitya' => 'Sahitya',
	'Sail' => 'Sail',
	'Saira' => 'Saira',
	'Saira Condensed' => 'Saira Condensed',
	'Saira Extra Condensed' => 'Saira Extra Condensed',
	'Saira Semi Condensed' => 'Saira Semi Condensed',
	'Saira Stencil One' => 'Saira Stencil One',
	'Salsa' => 'Salsa',
	'Sanchez' => 'Sanchez',
	'Sancreek' => 'Sancreek',
	'Sansita' => 'Sansita',
	'Sansita Swashed' => 'Sansita Swashed',
	'Sarabun' => 'Sarabun',
	'Sarala' => 'Sarala',
	'Sarina' => 'Sarina',
	'Sarpanch' => 'Sarpanch',
	'Satisfy' => 'Satisfy',
	'Sawarabi Gothic' => 'Sawarabi Gothic',
	'Sawarabi Mincho' => 'Sawarabi Mincho',
	'Scada' => 'Scada',
	'Scheherazade' => 'Scheherazade',
	'Scheherazade New' => 'Scheherazade New',
	'Schoolbell' => 'Schoolbell',
	'Scope One' => 'Scope One',
	'Seaweed Script' => 'Seaweed Script',
	'Secular One' => 'Secular One',
	'Sedgwick Ave' => 'Sedgwick Ave',
	'Sedgwick Ave Display' => 'Sedgwick Ave Display',
	'Sen' => 'Sen',
	'Sevillana' => 'Sevillana',
	'Seymour One' => 'Seymour One',
	'Shadows Into Light' => 'Shadows Into Light',
	'Shadows Into Light Two' => 'Shadows Into Light Two',
	'Shanti' => 'Shanti',
	'Share' => 'Share',
	'Share Tech' => 'Share Tech',
	'Share Tech Mono' => 'Share Tech Mono',
	'Shippori Mincho' => 'Shippori Mincho',
	'Shippori Mincho B1' => 'Shippori Mincho B1',
	'Shojumaru' => 'Shojumaru',
	'Short Stack' => 'Short Stack',
	'Shrikhand' => 'Shrikhand',
	'Siemreap' => 'Siemreap',
	'Sigmar One' => 'Sigmar One',
	'Signika' => 'Signika',
	'Signika Negative' => 'Signika Negative',
	'Simonetta' => 'Simonetta',
	'Single Day' => 'Single Day',
	'Sintony' => 'Sintony',
	'Sirin Stencil' => 'Sirin Stencil',
	'Six Caps' => 'Six Caps',
	'Skranji' => 'Skranji',
	'Slabo 13px' => 'Slabo 13px',
	'Slabo 27px' => 'Slabo 27px',
	'Slackey' => 'Slackey',
	'Smokum' => 'Smokum',
	'Smythe' => 'Smythe',
	'Sniglet' => 'Sniglet',
	'Snippet' => 'Snippet',
	'Snowburst One' => 'Snowburst One',
	'Sofadi One' => 'Sofadi One',
	'Sofia' => 'Sofia',
	'Solway' => 'Solway',
	'Song Myung' => 'Song Myung',
	'Sonsie One' => 'Sonsie One',
	'Sora' => 'Sora',
	'Sorts Mill Goudy' => 'Sorts Mill Goudy',
	'Source Code Pro' => 'Source Code Pro',
	'Source Sans Pro' => 'Source Sans Pro',
	'Source Serif Pro' => 'Source Serif Pro',
	'Space Grotesk' => 'Space Grotesk',
	'Space Mono' => 'Space Mono',
	'Spartan' => 'Spartan',
	'Special Elite' => 'Special Elite',
	'Spectral' => 'Spectral',
	'Spectral SC' => 'Spectral SC',
	'Spicy Rice' => 'Spicy Rice',
	'Spinnaker' => 'Spinnaker',
	'Spirax' => 'Spirax',
	'Squada One' => 'Squada One',
	'Sree Krushnadevaraya' => 'Sree Krushnadevaraya',
	'Sriracha' => 'Sriracha',
	'Srisakdi' => 'Srisakdi',
	'Staatliches' => 'Staatliches',
	'Stalemate' => 'Stalemate',
	'Stalinist One' => 'Stalinist One',
	'Stardos Stencil' => 'Stardos Stencil',
	'Stick' => 'Stick',
	'Stick No Bills' => 'Stick No Bills',
	'Stint Ultra Condensed' => 'Stint Ultra Condensed',
	'Stint Ultra Expanded' => 'Stint Ultra Expanded',
	'Stoke' => 'Stoke',
	'Strait' => 'Strait',
	'Style Script' => 'Style Script',
	'Stylish' => 'Stylish',
	'Sue Ellen Francisco' => 'Sue Ellen Francisco',
	'Suez One' => 'Suez One',
	'Sulphur Point' => 'Sulphur Point',
	'Sumana' => 'Sumana',
	'Sunflower' => 'Sunflower',
	'Sunshiney' => 'Sunshiney',
	'Supermercado One' => 'Supermercado One',
	'Sura' => 'Sura',
	'Suranna' => 'Suranna',
	'Suravaram' => 'Suravaram',
	'Suwannaphum' => 'Suwannaphum',
	'Swanky and Moo Moo' => 'Swanky and Moo Moo',
	'Syncopate' => 'Syncopate',
	'Syne' => 'Syne',
	'Syne Mono' => 'Syne Mono',
	'Syne Tactile' => 'Syne Tactile',
	'Tajawal' => 'Tajawal',
	'Tangerine' => 'Tangerine',
	'Taprom' => 'Taprom',
	'Tauri' => 'Tauri',
	'Taviraj' => 'Taviraj',
	'Teko' => 'Teko',
	'Telex' => 'Telex',
	'Tenali Ramakrishna' => 'Tenali Ramakrishna',
	'Tenor Sans' => 'Tenor Sans',
	'Text Me One' => 'Text Me One',
	'Texturina' => 'Texturina',
	'Thasadith' => 'Thasadith',
	'The Girl Next Door' => 'The Girl Next Door',
	'Tienne' => 'Tienne',
	'Tillana' => 'Tillana',
	'Timmana' => 'Timmana',
	'Tinos' => 'Tinos',
	'Titan One' => 'Titan One',
	'Titillium Web' => 'Titillium Web',
	'Tomorrow' => 'Tomorrow',
	'Tourney' => 'Tourney',
	'Trade Winds' => 'Trade Winds',
	'Train One' => 'Train One',
	'Trirong' => 'Trirong',
	'Trispace' => 'Trispace',
	'Trocchi' => 'Trocchi',
	'Trochut' => 'Trochut',
	'Truculenta' => 'Truculenta',
	'Trykker' => 'Trykker',
	'Tulpen One' => 'Tulpen One',
	'Turret Road' => 'Turret Road',
	'Ubuntu' => 'Ubuntu',
	'Ubuntu Condensed' => 'Ubuntu Condensed',
	'Ubuntu Mono' => 'Ubuntu Mono',
	'Uchen' => 'Uchen',
	'Ultra' => 'Ultra',
	'Uncial Antiqua' => 'Uncial Antiqua',
	'Underdog' => 'Underdog',
	'Unica One' => 'Unica One',
	'UnifrakturCook' => 'UnifrakturCook',
	'UnifrakturMaguntia' => 'UnifrakturMaguntia',
	'Unkempt' => 'Unkempt',
	'Unlock' => 'Unlock',
	'Unna' => 'Unna',
	'Urbanist' => 'Urbanist',
	'VT323' => 'VT323',
	'Vampiro One' => 'Vampiro One',
	'Varela' => 'Varela',
	'Varela Round' => 'Varela Round',
	'Varta' => 'Varta',
	'Vast Shadow' => 'Vast Shadow',
	'Vesper Libre' => 'Vesper Libre',
	'Viaoda Libre' => 'Viaoda Libre',
	'Vibes' => 'Vibes',
	'Vibur' => 'Vibur',
	'Vidaloka' => 'Vidaloka',
	'Viga' => 'Viga',
	'Voces' => 'Voces',
	'Volkhov' => 'Volkhov',
	'Vollkorn' => 'Vollkorn',
	'Vollkorn SC' => 'Vollkorn SC',
	'Voltaire' => 'Voltaire',
	'Waiting for the Sunrise' => 'Waiting for the Sunrise',
	'Wallpoet' => 'Wallpoet',
	'Walter Turncoat' => 'Walter Turncoat',
	'Warnes' => 'Warnes',
	'Wellfleet' => 'Wellfleet',
	'Wendy One' => 'Wendy One',
	'WindSong' => 'WindSong',
	'Wire One' => 'Wire One',
	'Work Sans' => 'Work Sans',
	'Xanh Mono' => 'Xanh Mono',
	'Yaldevi' => 'Yaldevi',
	'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
	'Yantramanav' => 'Yantramanav',
	'Yatra One' => 'Yatra One',
	'Yellowtail' => 'Yellowtail',
	'Yeon Sung' => 'Yeon Sung',
	'Yeseva One' => 'Yeseva One',
	'Yesteryear' => 'Yesteryear',
	'Yomogi' => 'Yomogi',
	'Yrsa' => 'Yrsa',
	'Yusei Magic' => 'Yusei Magic',
	'ZCOOL KuaiLe' => 'ZCOOL KuaiLe',
	'ZCOOL QingKe HuangYou' => 'ZCOOL QingKe HuangYou',
	'ZCOOL XiaoWei' => 'ZCOOL XiaoWei',
	'Zen Dots' => 'Zen Dots',
	'Zen Loop' => 'Zen Loop',
	'Zen Tokyo Zoo' => 'Zen Tokyo Zoo',
	'Zeyada' => 'Zeyada',
	'Zhi Mang Xing' => 'Zhi Mang Xing',
	'Zilla Slab' => 'Zilla Slab',
	'Zilla Slab Highlight' => 'Zilla Slab Highlight'
	);
	$faces = array_merge($vt_custom_font, $vt_google_font);
	// Font Size
	$font_sizes = array();
	$font_sizes_px_none = array();
	for ($i = 7; $i <= 70; $i++){
		$font_sizes[$i.'px'] = $i.'px';
		$font_sizes_px_none[$i] = $i.'px';
	}

	$num_sizes = array();
	for ($i = 1; $i <= 50; $i++){
		$num_sizes[$i] = $i;
	}
	// Font Weights
	$font_weights  = array(
		'100' => esc_html__('Thin', 'typecase'),
		'200' => esc_html__('Extra-Light', 'typecase'),
		'300' => esc_html__('Light', 'typecase'),
		'400' => esc_html__('Regular', 'typecase'),
		'500' => esc_html__('Medium', 'typecase'),
		'600' => esc_html__('Semi-Bold', 'typecase'),
		'700' => esc_html__('Bold', 'typecase'),
		'800' => esc_html__('Extra-Bold', 'typecase'),
		'900' => esc_html__('Black', 'typecase')
	);

	$wp_customize->add_panel( 'typecase_theme_options', array(
	    'priority' => 1,
	    'title' => esc_html__( 'Theme Options', 'typecase' ),
	    'description' => esc_html__( 'Options for theme customizing', 'typecase' ),
	));

	$wp_customize->add_section(
		'typecase_logo_favicon' ,
		array(
   		'title'      => esc_html__( 'Logo Settings', 'typecase' ),
   		'description'=> esc_html__( 'Please choose your logo', 'typecase' ),
   		'priority'  => 1,
   		'panel' => 'typecase_theme_options'
	));
    $wp_customize->add_setting(
    'typecase_logo',
    array(
	'default' 			=> '',
	'transport'   		=> 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
	));
    $wp_customize->add_control(
    	new WP_Customize_Image_Control(
    	$wp_customize,
    	'typecase_logo',
    	array(
        'label'    => esc_html__( 'Normal Logo', 'typecase' ),
        'section'  => 'typecase_logo_favicon',
        'settings' => 'typecase_logo'
    )));

    $wp_customize->add_setting(
    'typecase_logow',
    array(
	'default' 			=> '',
	'transport'   		=> 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
	));
    $wp_customize->add_control(
    	new WP_Customize_Image_Control(
    	$wp_customize,
    	'typecase_logow',
    	array(
        'label'    => esc_html__( 'White Logo', 'typecase' ),
        'section'  => 'typecase_logo_favicon',
        'settings' => 'typecase_logow'
    )));    

    $wp_customize->add_setting(
	    'logo_width',
	    array(
	        'default'    =>  esc_attr__( '150px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'logo_width',
	    array(
	        'section'   => 'typecase_logo_favicon',
	        'label'     => esc_html__('Logo Width EX: 100px','typecase'),
	        'type'      => 'text'
	    )
	);
	$wp_customize->add_setting(
	    'm_logo_width',
	    array(
	        'default'    =>  esc_attr__( '120px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'm_logo_width',
	    array(
	        'section'   => 'typecase_logo_favicon',
	        'label'     => esc_html__('Mobile Logo Width EX: 100px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    's_logo_width',
	    array(	        
			'default'    =>  esc_attr__( '150px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    's_logo_width',
	    array(
	        'section'   => 'typecase_logo_favicon',
	        'label'     => esc_html__('Sidebar Logo Width EX: 100px','typecase'),
	        'type'      => 'text'
	    )
	);	

	$wp_customize->add_setting(
	    'foot_logo_width',
	    array(	        
			'default'    =>  esc_attr__( '150px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'foot_logo_width',
	    array(
	        'section'   => 'typecase_logo_favicon',
	        'label'     => esc_html__('Footer Logo Width EX: 100px','typecase'),
	        'type'      => 'text'
	    )
	);

	/*General Setting*/
	$wp_customize->add_section(
		    'typecase_general_setting',
		    array(
		        'title'     => esc_html__('General Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'max_content_width',
	    array(
	        'default'    =>  '1200px',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'max_content_width',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Content width EX: 1200px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'header_layout_design',
	    array(
	        'default'    =>  esc_attr__( 'header_1', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    new typecase_control_image_select (
	        $wp_customize,
	        'header_layout_design',
	        array(
	            'label'      	=> esc_html__( 'Header Layout (header menu and logo)', 'typecase' ),
	            'section'		=> 'typecase_general_setting',
	            'settings'		=> 'header_layout_design',
	            'choices'		=> array(
	            	'header_1'  => get_template_directory_uri().'/inc/customizer/images/header1.png',
                    'header_2' => get_template_directory_uri().'/inc/customizer/images/header2.png',
                    'header_3'   => get_template_directory_uri().'/inc/customizer/images/header3.png',
					'header_4'   => get_template_directory_uri().'/inc/customizer/images/header4.png',
					'header_5'   => get_template_directory_uri().'/inc/customizer/images/header5.png',
					'header_6'   => get_template_directory_uri().'/inc/customizer/images/header6.png',
					'header_7'   => get_template_directory_uri().'/inc/customizer/images/header7.png',
					'header_8'   => get_template_directory_uri().'/inc/customizer/images/header8.png',
					'header_9'   => get_template_directory_uri().'/inc/customizer/images/header9.png',
	            ),
	            'input_attrs' => array(
	            	'multiple' => false
	            )
	        )
	    )
	);

	$wp_customize->add_setting(
	    'header_layout',
	    array(
	        'default'     => 'default',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'header_layout',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Header Layout Custom Template','typecase'),
			'description' => esc_html__( 'Choose layout to overwrite default header','typecase'),
	        'type'      => 'select',
	        'choices'	=> $vt_layouts
	    )
	);

	$wp_customize->add_setting(
	    'header_sticky',
	    array(
	        'default'     => 'default',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'header_sticky',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Header Sticky Custom Template','typecase'),
			'description' => esc_html__( 'Choose layout to overwrite default sticky header: Note this options work when you choose (Header Layout Custom Template)','typecase'),
	        'type'      => 'select',
	        'choices'	=> $vt_layouts
	    )
	);

	$wp_customize->add_setting(
	    'footer_layout',
	    array(
	        'default'     => 'default',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_layout',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Footer Custom Template','typecase'),
			'description' => esc_html__( 'Choose layout to overwrite default footer','typecase'),
	        'type'      => 'select',
	        'choices'	=> $vt_layouts
	    )
	);	

	$wp_customize->add_setting(
        'typecase_menu_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_menu_sec_options',
            array(
                'label'         => esc_html__( 'Menu Section', 'typecase' ),
                'section'       => 'typecase_general_setting',
                'settings'      => 'typecase_menu_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
	    'section_menu_height',
	    array(
	        'default'    =>  esc_attr__( '70px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'section_menu_height',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Section menu height  EX: 80px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'sticky_logo',
	    array(
	        'default'    =>  esc_attr__( 'logo_sticky_normal', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sticky_logo',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Sticky logo','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(				
				'logo_sticky_white' => esc_html__('Sticky white logo', 'typecase'),
				'logo_sticky_normal' => esc_html__('Sticky normal logo', 'typecase')
			
	        )
	    )
	);

	$wp_customize->add_setting(
        'typecase_logo_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_logo_sec_options',
            array(
                'label'         => esc_html__( 'Logo Section', 'typecase' ),
                'section'       => 'typecase_general_setting',
                'settings'      => 'typecase_logo_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
	    'section_logo_height',
	    array(
	        'default'    =>  esc_attr__( '120px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'section_logo_height',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Section middle logo height  EX: 80px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vt_subcribe_txt',
	    array(
	        'default'    =>  esc_attr__( 'Subscribe', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_subcribe_txt',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Subscribe button text','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vt_subcribe_link',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_subcribe_link',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Subscribe button link','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
        'typecase_top_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_top_sec_options',
            array(
                'label'         => esc_html__( 'Topbar Section', 'typecase' ),
                'section'       => 'typecase_general_setting',
                'settings'      => 'typecase_top_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
	    'section_top_bar_height',
	    array(
	        'default'    =>  esc_attr__( '35px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'section_top_bar_height',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Section top bar height  EX: 35px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'section_top_bar_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'section_top_bar_size',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Section top bar font size  EX: 14px','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
        'hide_top_bar',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'hide_top_bar',
        array(
            'section'   => 'typecase_general_setting',
            'label'     => esc_html__('Hide top bar','typecase'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'topl_text',
	    array(
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'topl_text',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Top left text','typecase'),
	        'type'      => 'textarea'
	    )
	);

	$wp_customize->add_setting(
        'enable_topl_menu',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'enable_topl_menu',
        array(
            'section'   => 'typecase_general_setting',
            'label'     => esc_html__('Show top left menu','typecase'),
            'type'      => 'checkbox'
        )
    );
	

    $wp_customize->add_setting(
	    'topr_text',
	    array(
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'topr_text',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Top right text','typecase'),
	        'type'      => 'textarea'
	    )
	);

	$wp_customize->add_setting(
        'hide_top_social',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'hide_top_social',
        array(
            'section'   => 'typecase_general_setting',
            'label'     => esc_html__('Hide top bar social','typecase'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'show_top_date',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'show_top_date',
        array(
            'section'   => 'typecase_general_setting',
            'label'     => esc_html__('Show top bar date','typecase'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'topbar_date_format',
	    array(	        
	        'default'    =>  esc_attr__( 'l ,  j  F Y', 'typecase' ),
			'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'topbar_date_format',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Topbar date format EX: l ,  j  F Y','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
        'typecase_other_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_other_options',
            array(
                'label'         => esc_html__( 'Other Settings', 'typecase' ),
                'section'       => 'typecase_general_setting',
                'settings'      => 'typecase_other_options',
            )
        )
    );

    $wp_customize->add_setting(
	    'typecase_title_link',
	    array(
	        'default'    =>  esc_attr__( 'vt_tline', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_title_link',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Title hover style','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'vt_tline' => esc_html__('Title hover line', 'typecase'),
			'vt_tcolor' => esc_html__('Title hover text color', 'typecase')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'border_rounded',
	    array(
	        'default'    =>  esc_attr__( '0px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'border_rounded',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Image border radius EX: 10px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'top_border_rounded',
	    array(
	        'default'    =>  esc_attr__( '60px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'top_border_rounded',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Go to top border radius EX: 10px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
        'enable_dark_mode',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'enable_dark_mode',
        array(
            'section'   => 'typecase_general_setting',
            'label'     => esc_html__('Show dark mode button','typecase'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
		'enable_dark_skin',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'enable_dark_skin',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Show default dark skin','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'vt_nav_guide',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'vt_nav_guide',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Show Breadcrumb','typecase'),
	        'type'      => 'checkbox'
	    )
	);

$wp_customize->add_setting(
		'disable_top_search',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_top_search',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Hide search button','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'show_mb_nav',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'show_mb_nav',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Show mobile toggle on desktop','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'mb_nav_left',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'mb_nav_left',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Canvas menu left position on desktop','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'mb_nav_right',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'mb_nav_right',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Canvas menu right position on mobile','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_social_icons',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_social_icons',
	    array(
	        'section'   => 'typecase_general_setting',
	        'label'     => esc_html__('Hide mobile menu social icons','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
        'hide_head_share',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'hide_head_share',
        array(
            'section'   => 'typecase_general_setting',
            'label'     => esc_html__('Hide header social','typecase'),
            'type'      => 'checkbox'
        )
    );


/*Color Setting*/
	$wp_customize->add_section(
		    'typecase_color_setting',
		    array(
		        'title'     => esc_html__('Color Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'typecase_theme_color_settings',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_theme_color_settings',
            array(
                'label'         => esc_html__( 'Theme color', 'typecase' ),
                'section'       => 'typecase_color_setting',
                'settings'      => 'typecase_theme_color_settings',
            )
        )
    );

	$wp_customize->add_setting(
	    'theme_color',
	    array(
	        'default'    =>  esc_attr__( '#ff184e', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_color',
	        array(
	            'label'      => esc_html__( 'Theme color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'theme_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#ff184e', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_color_dark',
	        array(
	            'label'      => esc_html__( 'Theme color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'theme_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_bg_color',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_bg_color',
	        array(
	            'label'      => esc_html__( 'Theme background color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'theme_bg_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_bg_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#111', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Theme background color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'theme_bg_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_text_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_text_color',
	        array(
	            'label'      => esc_html__( 'Theme text color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'theme_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_text_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Theme text color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'theme_text_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
        'typecase_menu_color_settings',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_menu_color_settings',
            array(
                'label'         => esc_html__( 'Menu section color', 'typecase' ),
                'section'       => 'typecase_color_setting',
                'settings'      => 'typecase_menu_color_settings',
            )
        )
    );

	$wp_customize->add_setting(
	    'ac_menu_line_color',
	    array(
	        'default'    =>  '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'ac_menu_line_color',
	        array(
	            'label'      => esc_html__( 'Active & hover line color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'ac_menu_line_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'ac_menu_line_height',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'ac_menu_line_height',
	    array(
	        'section'   => 'typecase_color_setting',
	        'label'     => esc_html__('Active & hover line height','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'menu_bg_color',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_bg_color',
	        array(
	            'label'      => esc_html__( 'Main menu background', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'menu_bg_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_text_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_text_color',
	        array(
	            'label'      => esc_html__( 'Main menu text color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'menu_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_bg_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#111', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Main menu background dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'menu_bg_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_text_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Main menu text color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'menu_text_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_back_color',
	    array(
	        'default'    =>  esc_attr__( '#f7f7f6', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_back_color',
	        array(
	            'label'      => esc_html__( 'Sub menu background color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'submenu_back_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_text_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_text_color',
	        array(
	            'label'      => esc_html__( 'Sub Menu text color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'submenu_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_back_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#222', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_back_color_dark',
	        array(
	            'label'      => esc_html__( 'Sub menu background color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'submenu_back_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_text_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Sub Menu text color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'submenu_text_color_dark'
	        )
	    )
	);



    $wp_customize->add_setting(
	    'menu_line_color',
	    array(
	        'default'    =>  esc_attr__( '#eeedeb', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_line_color',
	        array(
	            'label'      => esc_html__( 'Section menu line color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'menu_line_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_line_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#ffffff26', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_line_color_dark',
	        array(
	            'label'      => esc_html__( 'Section menu line color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'menu_line_color_dark'
	        )
	    )
	);




	$wp_customize->add_setting(
	    'submenu_line_color',
	    array(
	        'default'    =>  esc_attr__( '#ebebe3', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_line_color',
	        array(
	            'label'      => esc_html__( 'Sub line text color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'submenu_line_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_line_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#464646', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_line_color_dark',
	        array(
	            'label'      => esc_html__( 'Sub line color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'submenu_line_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
        'typecase_top_m_title',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_top_m_title',
            array(
                'label'         => esc_html__( 'Top bar section color', 'typecase' ),
                'section'       => 'typecase_color_setting',
                'settings'      => 'typecase_top_m_title',
            )
        )
    );

    $wp_customize->add_setting(
	    'top_menu_bg_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_bg_color',
	        array(
	            'label'      => esc_html__( 'Top bar background', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'top_menu_bg_color'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'top_menu_text_color',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_text_color',
	        array(
	            'label'      => esc_html__( 'Top bar text color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'top_menu_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'top_menu_bg_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Top bar background dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'top_menu_bg_color_dark'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'top_menu_text_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Top bar text color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'top_menu_text_color_dark'
	        )
	    )
	);

    $wp_customize->add_setting(
        'typecase_logo_m_title',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_logo_m_title',
            array(
                'label'         => esc_html__( 'Logo section color', 'typecase' ),
                'section'       => 'typecase_color_setting',
                'settings'      => 'typecase_logo_m_title',
            )
        )
    );

    $wp_customize->add_setting(
	    'head_logo_bg_color',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_bg_color',
	        array(
	            'label'      => esc_html__( 'Section logo background', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'head_logo_bg_color'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'head_logo_text_color',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_text_color',
	        array(
	            'label'      => esc_html__( 'Section logo text color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'head_logo_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'head_logo_bg_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Section logo background dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'head_logo_bg_color_dark'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'head_logo_text_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Section logo text color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'head_logo_text_color_dark'
	        )
	    )
	);


    $wp_customize->add_setting(
        'typecase_single_opts',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_single_opts',
            array(
                'label'         => esc_html__( 'Blog & Single content color', 'typecase' ),
                'section'       => 'typecase_color_setting',
                'settings'      => 'typecase_single_opts',
            )
        )
    );

    $wp_customize->add_setting(
	    'single_color',
	    array(
	        'default'    =>  esc_attr__( '#676767', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_color',
	        array(
	            'label'      => esc_html__( 'Single color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'single_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_color_dark',
	        array(
	            'label'      => esc_html__( 'Single color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'single_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_color',
	    array(
	        'default'    =>  esc_attr__( '#ff184e', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_color',
	        array(
	            'label'      => esc_html__( 'Single link color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'single_link_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#ff184e', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_color_dark',
	        array(
	            'label'      => esc_html__( 'Single link color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'single_link_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_hover_color',
	    array(
	        'default'    =>  esc_attr__( '#ff184e', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_hover_color',
	        array(
	            'label'      => esc_html__( 'Single link hover color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'single_link_hover_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_hover_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#ff184e', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_hover_color_dark',
	        array(
	            'label'      => esc_html__( 'Single link hover color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'single_link_hover_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_meta_color',
	    array(
	        'default'    =>  esc_attr__( '#0a0a0a', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_meta_color',
	        array(
	            'label'      => esc_html__( 'Post meta color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'post_meta_color'
	        )
	    )
	);
$wp_customize->add_setting(
	    'post_meta_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#bbb', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_meta_color_dark',
	        array(
	            'label'      => esc_html__( 'Post meta color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'post_meta_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_except_color',
	    array(
	        'default'    =>  esc_attr__( '#666', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_except_color',
	        array(
	            'label'      => esc_html__( 'Post excerpt color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'post_except_color'
	        )
	    )
	);
$wp_customize->add_setting(
	    'post_except_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#ddd', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_except_color_dark',
	        array(
	            'label'      => esc_html__( 'Post excerpt color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'post_except_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_line_color',
	    array(
	        'default'    =>  esc_attr__( '#dbdbdb', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_line_color',
	        array(
	            'label'      => esc_html__( 'Post line color', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'post_line_color'
	        )
	    )
);

$wp_customize->add_setting(
	    'post_line_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#49494b', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_line_color_dark',
	        array(
	            'label'      => esc_html__( 'Post line color dark mode', 'typecase' ),
	            'section'    => 'typecase_color_setting',
	            'settings'   => 'post_line_color_dark'
	        )
	    )
);

	$wp_customize->add_setting(
        'typecase_foot_opts',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_foot_opts',
            array(
                'label'         => esc_html__( 'Footer color', 'typecase' ),
                'section'       => 'typecase_color_setting',
                'settings'      => 'typecase_foot_opts',
            )
        )
    );

    $wp_customize->add_setting(
        'footer_bg_color',
        array(
            'default'     => esc_attr__( '#111', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_bg_color',
            array(
                'label'      => esc_html__( 'Footer background color', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_bg_color'
            )
        )
    );

	$wp_customize->add_setting(
        'footer_bg_dark',
        array(
            'default'     => esc_attr__( '#000', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_bg_dark',
            array(
                'label'      => esc_html__( 'Footer background color dark mode', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_bg_dark'
            )
        )
    );

    $wp_customize->add_setting(
        'footer_text_color',
        array(
            'default'     => esc_attr__( '#a8a8aa', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_text_color',
            array(
                'label'      => esc_html__( 'Footer text color', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_text_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_text_dark',
        array(
            'default'     => esc_attr__( '#a8a8aa', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_text_dark',
            array(
                'label'      => esc_html__( 'Footer text color dark mode', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_text_dark'
            )
        )
    );    
	
	$wp_customize->add_setting(
        'footer_link_color',
        array(
            'default'     => esc_attr__( '#dcdcdc', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_color',
            array(
                'label'      => esc_html__( 'Footer link color', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_link_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_link_dark',
        array(
            'default'     => esc_attr__( '#dcdcdc', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_dark',
            array(
                'label'      => esc_html__( 'Footer link color dark mode', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_link_dark'
            )
        )
    ); 

	$wp_customize->add_setting(
        'footer_link_hcolor',
        array(
            'default'     => esc_attr__( '#ff184e', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_hcolor',
            array(
                'label'      => esc_html__( 'Footer link hover color', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_link_hcolor'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_link_hdark',
        array(
            'default'     => esc_attr__( '#ff184e', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_hdark',
            array(
                'label'      => esc_html__( 'Footer link hover color dark mode', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_link_hdark'
            )
        )
    );

	$wp_customize->add_setting(
        'footer_head_color',
        array(
            'default'     => esc_attr__( '#FFF', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_head_color',
            array(
                'label'      => esc_html__( 'Footer heading color', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_head_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_head_color_dark',
        array(
            'default'     => esc_attr__( '#FFF', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_head_color_dark',
            array(
                'label'      => esc_html__( 'Footer heading color dark mode', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_head_color_dark'
            )
        )
    );

	$wp_customize->add_setting(
        'footer_line_color',
        array(
            'default'     => esc_attr__( '#49494b', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_line_color',
            array(
                'label'      => esc_html__( 'Footer line color', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_line_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_line_color_dark',
        array(
            'default'     => esc_attr__( '#49494b', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_line_color_dark',
            array(
                'label'      => esc_html__( 'Footer line color dark mode', 'typecase' ),
                'section'    => 'typecase_color_setting',
                'settings'   => 'footer_line_color_dark'
            )
        )
    );


	/*Typography*/
	$wp_customize->add_section(
		    'typecase_typography_setting',
		    array(
		        'title'     => esc_html__('Typography Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'typecase_menu_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_menu_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Navigation Settings', 'typecase' ),
	            'section'		=> 'typecase_typography_setting',
	            'settings'		=> 'typecase_menu_settings_title',
	        )
	    )
	);
	$wp_customize->add_setting(
	    'typecase_menu_font_family',
	    array(
	        'default'    =>  esc_attr__( 'Inter Tight', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_menu_font_family',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Menu font family','typecase'),
	        'type'      => 'select',
	        'choices'	=> $faces
	    )
	);
    $wp_customize->add_setting(
	    'typecase_menu_font_size',
	    array(
	        'default'    =>  esc_attr__( '16px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_menu_font_size',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Main menu font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'typecase_menu_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_menu_font_weight',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Main menu font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'typecase_menu_transform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_menu_transform',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Menu text transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_menu',
	    array(
	        'default'    =>  esc_attr__( '0em', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_menu',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Menu letter spacing','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'spacing_menu',
	    array(
	        'default'    =>  esc_attr__( '30px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'spacing_menu',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Main menu items spacing','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'typecase_sub_menu_font_size',
	    array(
	        'default'    =>  esc_attr__( '14px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_sub_menu_font_size',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Sub menu font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'typecase_sub_menu_font_weight',
	    array(
	        'default'    =>  esc_attr__( '500', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_sub_menu_font_weight',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Sub menu font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);

	$wp_customize->add_setting(
	    'sub_menu_transform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sub_menu_transform',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Sub menu text transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'sub_spacing_menu',
	    array(
	        'default'    =>  esc_attr__( '0em', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sub_spacing_menu',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Sub menu letter spacing','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'typecase_p_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_p_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Paragraph Settings', 'typecase' ),
	            'section'		=> 'typecase_typography_setting',
	            'settings'		=> 'typecase_p_settings_title',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'typecase_p_font_family',
	    array(
	        'default'    =>  esc_attr__( 'Inter', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_p_font_family',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Paragraph font family','typecase'),
	        'type'      => 'select',
	        'choices'	=> $faces
	    )
	);
	$wp_customize->add_setting(
	    'typecase_p_font_size',
	    array(
	        'default'    =>  esc_attr__( '16px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_p_font_size',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Content font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'p_line_height',
	    array(
	        'default'    =>  esc_attr__( '1.8', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'p_line_height',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Content line height','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'body_font_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'body_font_size',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Body & excerpt font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'body_line_height',
	    array(
	        'default'    =>  esc_attr__( '1.5', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'body_line_height',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Body line height','typecase'),
	        'type'      => 'text'
	    )
	);


	$wp_customize->add_setting(
	    'typecase_p_font_weight',
	    array(
	        'default'    =>  esc_attr__( '400', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_p_font_weight',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Paragraph font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);


	$wp_customize->add_setting(
	    'typecase_title_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_title_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Title Settings', 'typecase' ),
	            'section'		=> 'typecase_typography_setting',
	            'settings'		=> 'typecase_title_settings_title',
	        )
	    )
	);
	$wp_customize->add_setting(
	    'typecase_title_font_family',
	    array(
	        'default'    =>  esc_attr__( 'Inter Tight', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_title_font_family',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Title font family','typecase'),
	        'type'      => 'select',
	        'choices'	=> $faces
	    )
	);
	$wp_customize->add_setting(
	    'typecase_title_font_weight',
	    array(
	        'default'    =>  esc_attr__( '800', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_title_font_weight',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Title font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'typecase_title_transform',
	    array(
	        'default'    =>  esc_attr__( 'none', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_title_transform',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Title text transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'letter_spacing_heading',
	    array(
	        'default'    =>  esc_attr__( '0em', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_heading',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Title letter spacing Ex: 0.03em','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'line_height_heading',
	    array(
	        'default'    =>  esc_attr__( '1.2', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'line_height_heading',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Title line height Ex: 1.2 ','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'typecase_cat_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);

	$wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_cat_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Category, Meta', 'typecase' ),
	            'section'		=> 'typecase_typography_setting',
	            'settings'		=> 'typecase_cat_settings_title',
	        )
	    )
	);
	$wp_customize->add_setting(
        'typecase_cat_font_size',
        array(
            'default'    =>  esc_attr__( '15px', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'typecase_cat_font_size',
        array(
            'section'   => 'typecase_typography_setting',
            'label'     => esc_html__('Meta cat font size','typecase'),
            'type'      => 'select',
            'choices'   => $font_sizes
        )
    );
	$wp_customize->add_setting(
	    'typecase_cat_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_cat_font_weight',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Meta cat font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'typecase_cat_transform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_cat_transform',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Meta cat text transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_cat',
	    array(
	        'default'    =>  esc_attr__( '0em', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_cat',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Meta cat letter spacing Ex: 0.03em','typecase'),
	        'type'      => 'text'
	    )
	);
	$wp_customize->add_setting(
        'typecase_meta_font_size',
        array(
            'default'    =>  esc_attr__( '11px', 'typecase' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'typecase_meta_font_size',
        array(
            'section'   => 'typecase_typography_setting',
            'label'     => esc_html__('Meta font size','typecase'),
            'type'      => 'select',
            'choices'   => $font_sizes
        )
    );
	$wp_customize->add_setting(
	    'typecase_meta_font_weight',
	    array(
	        'default'    =>  esc_attr__( '400', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_meta_font_weight',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Meta font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);

	$wp_customize->add_setting(
	    'typecase_meta_a_font_weight',
	    array(	        
			'default'    =>  esc_attr__( '600', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_meta_a_font_weight',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Meta link font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);

	$wp_customize->add_setting(
	    'typecase_meta_transform',
	    array(
	        'default'    =>  esc_attr__( 'uppercase', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_meta_transform',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Meta text transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_meta',
	    array(
	        'default'    =>  esc_attr__( '.04em', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_meta',
	    array(
	        'section'   => 'typecase_typography_setting',
	        'label'     => esc_html__('Meta letter spacing Ex: 0.03em','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
		'typecase_widget_title_setting',
		array(
			'default'     => '',
			'transport'   => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	
	$wp_customize->add_control(
		new typecase_Customize_Control_Title (
			$wp_customize,
			'typecase_widget_title_setting',
			array(
				'label'      	=> esc_html__( 'Widget title setting', 'typecase' ),
				'section'		=> 'typecase_typography_setting',
				'settings'		=> 'typecase_widget_title_setting',
			)
		)
	);
	
	$wp_customize->add_setting(
			'typecase_widget_font',
			array(
				'default'    =>  esc_attr__( 'vt_weg_title', 'typecase' ),
				'transport'  =>  'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'typecase_widget_font',
			array(
				'section'   => 'typecase_typography_setting',
				'label'     => esc_html__('Widget Font','typecase'),
				'type'      => 'select',
				'choices' 	=> array(
					'none' => esc_html__('None', 'typecase'),
					'vt_weg_title' => esc_html__('Title font', 'typecase'),
					'vt_weg_menu' => esc_html__('Menu font', 'typecase')
				)
			)
	);
	
	$wp_customize->add_setting(
			'typecase_widget_font_size',
			array(
				'default'    =>  esc_attr__( '18px', 'typecase' ),
				'transport'   => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'typecase_widget_font_size',
			array(
				'section'   => 'typecase_typography_setting',
				'label'     => esc_html__('Widget font size','typecase'),
				'type'      => 'select',
				'choices'   => $font_sizes
			)
	);
	
	$wp_customize->add_setting(
			'typecase_widget_transform',
			array(
				'default'    =>  esc_attr__( 'uppercase', 'typecase' ),
				'transport'  =>  'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'typecase_widget_transform',
			array(
				'section'   => 'typecase_typography_setting',
				'label'     => esc_html__('Widget text transform','typecase'),
				'type'      => 'select',
				'choices' 	=> array(
					'none' => esc_html__('None', 'typecase'),
					'capitalize' => esc_html__('Capitalize', 'typecase'),
					'uppercase' => esc_html__('Uppercase', 'typecase')
				)
			)
	);
	
	$wp_customize->add_setting(
			'typecase_widget_letter_spacing',
			array(
				'default'    =>  esc_attr__( '0em', 'typecase' ),
				'transport'  =>  'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'typecase_widget_letter_spacing',
			array(
				'section'   => 'typecase_typography_setting',
				'label'     => esc_html__('Widget letter spacing Ex: 0.03em','typecase'),
				'type'      => 'text'
			)
	);

	

	/*Button*/
	$wp_customize->add_section(
		    'typecase_button_setting',
		    array(
		        'title'     => esc_html__('Button & load more Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'typecase_button_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_button_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Button Settings', 'typecase' ),
	            'section'		=> 'typecase_button_setting',
	            'settings'		=> 'typecase_button_settings_title',
	        )
	    )
	);
    $wp_customize->add_setting(
	    'typecase_button_font_size',
	    array(
	        'default'    =>  esc_attr__( '12px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_button_font_size',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Button font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'typecase_button_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_button_font_weight',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Button font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'typecase_button_transform',
	    array(
	        'default'    =>  esc_attr__( 'uppercase', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_button_transform',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Button text transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_button',
	    array(
	        'default'    =>  esc_attr__( '0.1em', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_button',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Button letter spacing','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'button_radius',
	    array(
	        'default'    =>  esc_attr__( '4px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'button_radius',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Button border radius','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'typecase_loadmore_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_loadmore_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Load More Settings', 'typecase' ),
	            'section'		=> 'typecase_button_setting',
	            'settings'		=> 'typecase_loadmore_settings_title',
	        )
	    )
	);
    $wp_customize->add_setting(
	    'typecase_loadmore_font_size',
	    array(
	        'default'    =>  esc_attr__( '12px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_loadmore_font_size',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Load More font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'typecase_loadmore_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_loadmore_font_weight',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Load More font weight','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'typecase_loadmore_transform',
	    array(
	        'default'    =>  esc_attr__( 'uppercase', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'typecase_loadmore_transform',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Load More text transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_loadmore',
	    array(
	        'default'    =>  esc_attr__( '0.1em', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_loadmore',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Load More letter spacing','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'load_more_radius',
	    array(
	        'default'    =>  esc_attr__( '4px', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'load_more_radius',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Load more border radius','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'load_more_width',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'load_more_width',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Load more width EX: 200px','typecase'),
	        'type'      => 'text'
	    )
	);
	
	$wp_customize->add_setting(
	    'load_more_height',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'load_more_height',
	    array(
	        'section'   => 'typecase_button_setting',
	        'label'     => esc_html__('Load more width EX: 40px','typecase'),
	        'type'      => 'text'
	    )
	);


	/*Blog & single post*/
	$wp_customize->add_section(
		    'typecase_blog_single_setting',
		    array(
		        'title'     => esc_html__('Blog & single post Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'typecase_cat_lbl',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_cat_lbl',
	        array(
	            'label'      	=> esc_html__( 'Category label', 'typecase' ),
	            'section'		=> 'typecase_blog_single_setting',
	            'settings'		=> 'typecase_cat_lbl',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_grid',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_grid',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Category label grid layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'typecase'),
			'cat_label_2' => esc_html__('Text only', 'typecase'),
			'cat_label_3' => esc_html__('Background color', 'typecase'),
			'cat_label_4' => esc_html__('Background color overlay bottom', 'typecase'),
			'cat_label_5' => esc_html__('Background color overlay bottom no space', 'typecase'),
			'cat_label_6' => esc_html__('Background color overlay bottom center no space', 'typecase'),
			'cat_label_7' => esc_html__('Background color overlay top', 'typecase'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_list',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_list',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Category label list layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'typecase'),
			'cat_label_2' => esc_html__('Text only', 'typecase'),
			'cat_label_3' => esc_html__('Background color', 'typecase')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_overlay',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_overlay',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Category label overlay layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'typecase'),
			'cat_label_2' => esc_html__('Text only', 'typecase'),
			'cat_label_3' => esc_html__('Background color', 'typecase')
	        )
	    )
	);	

	$wp_customize->add_setting(
	    'category_label_small_list',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_small_list',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Category label small layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'typecase'),
			'cat_label_2' => esc_html__('Text only', 'typecase'),			
			'cat_label_3' => esc_html__('Background color', 'typecase')
	        )
	    )
	);	

	$wp_customize->add_setting(
	    'category_label_single',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_single',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Category label single post','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'typecase'),
			'cat_label_2' => esc_html__('Text only', 'typecase'),
			'cat_label_3' => esc_html__('Background color', 'typecase')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_padding',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_padding',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Category padding EX: 2px 10px','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'category_label_radius',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_radius',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Category border radius EX: 10px','typecase'),
	        'type'      => 'text'
	    )
	);		

	$wp_customize->add_setting(
	    'typecase_achv_layout',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_achv_layout',
	        array(
	            'label'      	=> esc_html__( 'Archive layout options', 'typecase' ),
	            'section'		=> 'typecase_blog_single_setting',
	            'settings'		=> 'typecase_achv_layout',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_archive_layout',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_archive_layout',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Archive layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'typecase'),
				'archive2' => esc_html__('Grid post 3 columns', 'typecase'),
				'archive3' => esc_html__('Grid post 4 columns', 'typecase'),
				'archive4' => esc_html__('Post mian + list', 'typecase'),
				'archive5' => esc_html__('Post mix + list', 'typecase'),
				'archive6' => esc_html__('Post mian + grid', 'typecase'),
				'archive7' => esc_html__('Post list', 'typecase'),
				'archive8' => esc_html__('Post classic', 'typecase'),
				'archive9' => esc_html__('Post overlay 2 columns', 'typecase'),
				'archive10' => esc_html__('Post overlay 3 columns', 'typecase'),
				'archive11' => esc_html__('Post overlay 4 columns', 'typecase'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_archive_category',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_archive_category',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Archive category layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'typecase'),
				'archive2' => esc_html__('Grid post 3 columns', 'typecase'),
				'archive3' => esc_html__('Grid post 4 columns', 'typecase'),
				'archive4' => esc_html__('Post mian + list', 'typecase'),
				'archive5' => esc_html__('Post mix + list', 'typecase'),
				'archive6' => esc_html__('Post mian + grid', 'typecase'),
				'archive7' => esc_html__('Post list', 'typecase'),
				'archive8' => esc_html__('Post classic', 'typecase'),
				'archive9' => esc_html__('Post overlay 2 columns', 'typecase'),
				'archive10' => esc_html__('Post overlay 3 columns', 'typecase'),
				'archive11' => esc_html__('Post overlay 4 columns', 'typecase'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_archive_tag',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_archive_tag',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Archive tag layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'typecase'),
				'archive2' => esc_html__('Grid post 3 columns', 'typecase'),
				'archive3' => esc_html__('Grid post 4 columns', 'typecase'),
				'archive4' => esc_html__('Post mian + list', 'typecase'),
				'archive5' => esc_html__('Post mix + list', 'typecase'),
				'archive6' => esc_html__('Post mian + grid', 'typecase'),
				'archive7' => esc_html__('Post list', 'typecase'),
				'archive8' => esc_html__('Post classic', 'typecase'),
				'archive9' => esc_html__('Post overlay 2 columns', 'typecase'),
				'archive10' => esc_html__('Post overlay 3 columns', 'typecase'),
				'archive11' => esc_html__('Post overlay 4 columns', 'typecase'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_archive_search',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_archive_search',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Archive search layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'typecase'),
				'archive2' => esc_html__('Grid post 3 columns', 'typecase'),
				'archive3' => esc_html__('Grid post 4 columns', 'typecase'),
				'archive4' => esc_html__('Post mian + list', 'typecase'),
				'archive5' => esc_html__('Post mix + list', 'typecase'),
				'archive6' => esc_html__('Post mian + grid', 'typecase'),
				'archive7' => esc_html__('Post list', 'typecase'),
				'archive8' => esc_html__('Post classic', 'typecase'),
				'archive9' => esc_html__('Post overlay 2 columns', 'typecase'),
				'archive10' => esc_html__('Post overlay 3 columns', 'typecase'),
				'archive11' => esc_html__('Post overlay 4 columns', 'typecase'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_archive_author',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_archive_author',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Archive author layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'typecase'),
				'archive2' => esc_html__('Grid post 3 columns', 'typecase'),
				'archive3' => esc_html__('Grid post 4 columns', 'typecase'),
				'archive4' => esc_html__('Post mian + list', 'typecase'),
				'archive5' => esc_html__('Post mix + list', 'typecase'),
				'archive6' => esc_html__('Post mian + grid', 'typecase'),
				'archive7' => esc_html__('Post list', 'typecase'),
				'archive8' => esc_html__('Post classic', 'typecase'),
				'archive9' => esc_html__('Post overlay 2 columns', 'typecase'),
				'archive10' => esc_html__('Post overlay 3 columns', 'typecase'),
				'archive11' => esc_html__('Post overlay 4 columns', 'typecase'),				
	        )
	    )
	);	

	$wp_customize->add_setting(
		'typecase_achv_metas',
		array(
			'default'     => '',
			'transport'   => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		new typecase_Customize_Control_Title (
			$wp_customize,
			'typecase_achv_metas',
			array(
				'label'      	=> esc_html__( 'Archive meta', 'typecase' ),
				'section'		=> 'typecase_blog_single_setting',
				'settings'		=> 'typecase_achv_metas',
			)
		)
	);

	$wp_customize->add_setting(
		'show_author_img',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'show_author_img',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Show meta author image','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_author',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_author',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Hide meta author','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_cat',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_cat',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Hide meta category','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_date',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_date',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Hide meta date','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_author_date',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_author_date',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Hide meta author & date','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
	    'btn_txt',
	    array(
			'default'    =>  esc_attr__( 'Continue Reading', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'btn_txt',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Read more text','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'typecase_single_layout',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new typecase_Customize_Control_Title (
	        $wp_customize,
	        'typecase_single_layout',
	        array(
	            'label'      	=> esc_html__( 'Single post options', 'typecase' ),
	            'section'		=> 'typecase_blog_single_setting',
	            'settings'		=> 'typecase_single_layout',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_post_layout_options',
	    array(
	        'default'    =>  esc_attr__( 'single1', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'single_post_layout_options',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Single Post Layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'single1' => esc_html__('Post Layout 1', 'typecase'),
			'single2' => esc_html__('Post Layout 2', 'typecase'),
			'single3' => esc_html__('Post Layout 3', 'typecase'),
			'single4' => esc_html__('Post Layout 4', 'typecase'),
			'singll5' => esc_html__('Post Layout 5', 'typecase'),
			'single6' => esc_html__('Post Layout 6', 'typecase'),
			'single7' => esc_html__('Post Layout 7', 'typecase'),
			'single8' => esc_html__('Post Layout 8', 'typecase'),
			'single9' => esc_html__('Post Layout 9', 'typecase'),
			'single10' => esc_html__('Post Layout 10', 'typecase'),
			'single11' => esc_html__('Post Layout 11', 'typecase'),
			'single12' => esc_html__('Post Layout 12', 'typecase'),
			'single13' => esc_html__('Post Layout 13', 'typecase'),
			'single14' => esc_html__('Post Layout 14', 'typecase'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_sidebar_position',
	    array(
	        'default'    =>  esc_attr__( 'vt_sright_side', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'post_sidebar_position',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Sidebar Position','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
				'vt_sleft_side' => 'Left Sidebar',
				'vt_sright_side' => 'Right Sidebar'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_video_style',
	    array(
	        'default'    =>  esc_attr__( 'background', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_video_style',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Post Video Layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'background' => esc_html__('Video background', 'typecase'),
			'popup' => esc_html__('Video popup', 'typecase'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_gallery_type',
	    array(
	        'default'    =>  esc_attr__( 'slider', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_gallery_type',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Single Post Gallery Layout','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'slider' => esc_html__('Gallery Slider', 'typecase'),
					'popup' => esc_html__('Gallery Popup', 'typecase'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_title_size',
	    array(
	        'default'    =>  esc_attr__( '40px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'single_title_size',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Post title font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	
	$wp_customize->add_setting(
	    'typecase_nav_post_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_nav_post_size',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Post Next/Previous font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'typecase_related_size',
	    array(
	        'default'    =>  esc_attr__( '20px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'typecase_related_size',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Related font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
		'disable_post_date',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_date',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post date','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_readtime',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_readtime',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable read time','typecase'),
	        'type'      => 'checkbox'
	    )
	);
	$wp_customize->add_setting(
		'disable_post_view',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_view',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post view','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_meta_author',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_meta_author',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post author','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_author',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_author',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post author box','typecase'),
	        'type'      => 'checkbox'
	    )
	);
	$wp_customize->add_setting(
		'disable_post_category',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_category',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post category','typecase'),
	        'type'      => 'checkbox'
	    )
	);
	$wp_customize->add_setting(
		'disable_post_tag',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_tag',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post tag','typecase'),
	        'type'      => 'checkbox'
	    )
	);
	$wp_customize->add_setting(
		'disable_post_share',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_share',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable left post share','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_share_footer',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_share_footer',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable footer post share','typecase'),
	        'type'      => 'checkbox'
	    )
	);	

	$wp_customize->add_setting(
		'disable_post_nav',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_nav',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post Next/Previous','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_section_comment',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_section_comment',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable section comment','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_related',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_related',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post related','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_fb',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_fb',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post share Facebook','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_tw',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_tw',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post share Twitter','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_pin',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_pin',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post share Pinterest','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_in',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_in',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post share Linkedin','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_mail',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_mail',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Disable post share Mail','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
			'typecase_auto_single',
			array(
					'default'     => '',
					'transport'   => 'refresh',
					'sanitize_callback' => 'sanitize_text_field',
			)
	);
		$wp_customize->add_control(
			new typecase_Customize_Control_Title (
					$wp_customize,
					'typecase_auto_single',
					array(
							'label'      	=> esc_html__( 'Auto load next post options', 'typecase' ),
							'section'		=> 'typecase_blog_single_setting',
							'settings'		=> 'typecase_auto_single',
					)
			)
	);

	$wp_customize->add_setting(
	    'single_auto_load_post',
	    array(
	        'default'    =>  esc_attr__( 'disable', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'single_auto_load_post',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Auto load next post','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        	'enable' => esc_html__('Enable', 'typecase'),
				'disable' => esc_html__('Disable', 'typecase'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'auto_load_num',
	    array(
	        'default'     => 10,
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'auto_load_num',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Auto load number post','typecase'),
	        'type'      => 'select',
	        'choices'	=> $num_sizes
	    )
	);

	$wp_customize->add_setting(
	    'single_auto_load_type',
	    array(
	        'default'    =>  esc_attr__( 'previous', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'single_auto_load_type',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Auto load next type','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        	'previous' => esc_html__('Previous Date', 'typecase'),
				'next' => esc_html__('Next Date', 'typecase'),
				'random' => esc_html__('Random', 'typecase'),
	        )
	    )
	);

	$wp_customize->add_setting(
		'auto_same_cat',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'auto_same_cat',
	    array(
	        'section'   => 'typecase_blog_single_setting',
	        'label'     => esc_html__('Load Same Category','typecase'),
	        'type'      => 'checkbox'
	    )
	);

	/*Single post progress settings*/
	$wp_customize->add_section(
		'typecase_blog_reading_setting',
		array(
			'title'     => esc_html__('Single post progress settings', 'typecase'),
			'priority'  => 1,
			'panel' => 'typecase_theme_options'
		)
);

$wp_customize->add_setting(
	'enable_read_progress',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'enable_read_progress',
	array(
		'section'   => 'typecase_blog_reading_setting',
		'label'     => esc_html__('Enable reading progresss','typecase'),
		'type'      => 'checkbox'
	)
);

$wp_customize->add_setting(
	'sp_progress_height',
	array(
		'default'    =>  esc_attr__( '5px', 'typecase' ),
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'sp_progress_height',
	array(
		'section'   => 'typecase_blog_reading_setting',
		'label'     => esc_html__('Height progress bar EX: 5px','typecase'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'sp_progress_pos',
	array(
		'default'    =>  'top',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'sp_progress_pos',
	array(
		'section'   => 'typecase_blog_reading_setting',
		'label'     => esc_html__('Progress bar position','typecase'),
		'type'      => 'select',
		'choices'	=> array(	        
		'top' => esc_html__('Top position', 'typecase'),
		'bottom' => esc_html__('Bottom position', 'typecase')
		)
	)
);

$wp_customize->add_setting(
	'sp_color1',
	array(
		'default'    =>  esc_attr__( '#ff0080', 'typecase' ),
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sp_color1',
		array(
			'label'      => esc_html__( 'First gradient color', 'typecase' ),
			'section'    => 'typecase_blog_reading_setting',
			'settings'   => 'sp_color1'
		)
	)
);

$wp_customize->add_setting(
	'sp_color2',
	array(
		'default'    =>  esc_attr__( '#8100ff', 'typecase' ),
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sp_color2',
		array(
			'label'      => esc_html__( 'Second gradient color', 'typecase' ),
			'section'    => 'typecase_blog_reading_setting',
			'settings'   => 'sp_color2'
		)
	)
);


	/*Sidebar*/
	$wp_customize->add_section(
		    'typecase_sidebar_setting',
		    array(
		        'title'     => esc_html__('Sidebar Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);
	$wp_customize->add_setting(
        'disable_widget_block',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'disable_widget_block',
        array(
            'section'   => 'typecase_sidebar_setting',
            'label'     => esc_html__('Disable widget block','typecase'),
            'type'      => 'checkbox'
        )
    );
	$wp_customize->add_setting(
	    'post_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'post_sidebar',
	    array(
	        'section'   => 'typecase_sidebar_setting',
	        'label'     => esc_html__('Post sidebar','typecase'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'page_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'page_sidebar',
	    array(
	        'section'   => 'typecase_sidebar_setting',
	        'label'     => esc_html__('Page sidebar','typecase'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'category_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'category_sidebar',
	    array(
	        'section'   => 'typecase_sidebar_setting',
	        'label'     => esc_html__('Category sidebar','typecase'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'tag_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'tag_sidebar',
	    array(
	        'section'   => 'typecase_sidebar_setting',
	        'label'     => esc_html__('Tag sidebar','typecase'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'archive_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'archive_sidebar',
	    array(
	        'section'   => 'typecase_sidebar_setting',
	        'label'     => esc_html__('Archive sidebar','typecase'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'author_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'author_sidebar',
	    array(
	        'section'   => 'typecase_sidebar_setting',
	        'label'     => esc_html__('Author sidebar','typecase'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'search_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'search_sidebar',
	    array(
	        'section'   => 'typecase_sidebar_setting',
	        'label'     => esc_html__('Search sidebar','typecase'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);


	/*Social Header Link*/
	$wp_customize->add_section(
		    'typecase_social_setting',
		    array(
		        'title'     => esc_html__('Social Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'facebook',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'facebook',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Facebook','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'twitter',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'twitter',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Twitter','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'instagram',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'instagram',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Instagram','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'pinterest',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'pinterest',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Pinterest','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'youtube',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'youtube',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Youtube','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vimeo',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vimeo',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Vimeo','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'sound_cloud',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sound_cloud',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Sound Cloud','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'spotify_i',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'spotify_i',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Spotify','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'whatsapp',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'whatsapp',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('whatsapp','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'linkedin',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'linkedin',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Linkedin','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'behance',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'behance',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Behance','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'telegram',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'telegram',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Telegram','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'tumblr',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'tumblr',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Tumblr','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'deviantart',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'deviantart',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Deviantart','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'dribble',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'dribble',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Dribble','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'dropbox',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'dropbox',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Dropbox','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'rss',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'rss',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('RSS','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'skype',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'skype',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Skype','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'stumbleupon',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'stumbleupon',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Stumbleupon','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wordpress',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wordpress',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('WordPress','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'yahoo',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'yahoo',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Yahoo','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'flickr',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'flickr',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('Flickr','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wechat',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wechat',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('wechat','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'tiktok',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'tiktok',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('TikTok','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vk',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vk',
	    array(
	        'section'   => 'typecase_social_setting',
	        'label'     => esc_html__('VK','typecase'),
	        'type'      => 'text'
	    )
	);


	/*Footer*/
	$wp_customize->add_section(
		    'typecase_footer_setting',
		    array(
		        'title'     => esc_html__('Footer Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'typecase_footer_opt',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_footer_opt',
            array(
                'label'         => esc_html__( 'Footer Options', 'typecase' ),
                'section'       => 'typecase_footer_setting',
                'settings'      => 'typecase_footer_opt',
            )
        )
    );

	$wp_customize->add_setting(
	    'footer_columns',
	    array(
	        'default'    =>  'footer3col',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'footer_columns',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Footer columns','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'footer4col' => esc_html__('Footer 4 columns', 'typecase'),
			'footer3col' => esc_html__('Footer 3 columns', 'typecase'),
			'footer2col' => esc_html__('Footer 2 columns', 'typecase'),
			'footer1col' => esc_html__('Footer 1 columns', 'typecase'),
			'footer0col' => esc_html__('No Footer', 'typecase')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'footer_menu_col',
	    array(
	        'default'    =>  '1',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'footer_menu_col',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Footer menu widget columns','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        '1' => esc_html__('Footer menu 1 columns', 'typecase'),
			'2' => esc_html__('Footer menu 2 columns', 'typecase'),
			'3' => esc_html__('Footer menu 3 columns', 'typecase'),
			'4' => esc_html__('Footer menu 4 columns', 'typecase'),
			'5' => esc_html__('Footer menu 5 columns', 'typecase')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'footer_title_size',
	    array(
	        'default'    =>  esc_attr__( '18px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_title_size',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Footer title font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'footer_font_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_font_size',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Footer text font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'footer_copyright_size',
	    array(
	        'default'    =>  esc_attr__( '14px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_copyright_size',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Copyright font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'footer_menu_size',
	    array(
	        'default'    =>  esc_attr__( '14px', 'typecase' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_menu_size',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Footer Menu font size','typecase'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'sub_footer',
	    array(
	        'default'    =>  esc_attr__( 'sub_footer0', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sub_footer',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Sub footer style','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'sub_footer1' => esc_html__('Footer logo Center + Copyright + Menu + Social', 'typecase'),
	        'sub_footer6' => esc_html__('Footer logo Left + Copyright + Menu + Social', 'typecase'),
			'sub_footer2' => esc_html__('Copyright + Social', 'typecase'),
			'sub_footer3' => esc_html__('Copyright + Menu', 'typecase'),
			'sub_footer4' => esc_html__('Copyright Center', 'typecase'),
			'sub_footer5' => esc_html__('Footer Menu Center', 'typecase'),
			'sub_footer0' => esc_html__('Disable', 'typecase')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'footer_logo',
	    array(
	        'default'    =>  esc_attr__( 'logo_foot_white', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'footer_logo',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Footer logo','typecase'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'logo_foot_white' => esc_html__('Footer white logo', 'typecase'),
			'logo_foot_normal' => esc_html__('Footer normal logo', 'typecase')			
	        )
	    )
	);

	$wp_customize->add_setting(
	    'vt_copyright',
	    array(
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'vt_copyright',
	    array(
	        'section'   => 'typecase_footer_setting',
	        'label'     => esc_html__('Footer copyright','typecase'),
	        'type'      => 'textarea'
	    )
	);


/*Advertisement*/
$wp_customize->add_section(
	'typecase_ads_setting',
	array(
		'title'     => esc_html__('Advertisement Settings', 'typecase'),
		'priority'  => 1,
		'panel' => 'typecase_theme_options'
	)
);

/*header above*/
$wp_customize->add_setting(
'typecase_opt_ads_head_above',
array(
	'default'     => '',
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
new typecase_Customize_Control_Title (
	$wp_customize,
	'typecase_opt_ads_head_above',
	array(
		'label'         => esc_html__( 'Header Above Ads Settings', 'typecase' ),		
		'section'       => 'typecase_ads_setting',
		'settings'      => 'typecase_opt_ads_head_above',
	)
)
);

$wp_customize->add_setting(
'home_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'home_hide_head_above',
array(
	'section'   => 'typecase_ads_setting',
	'label'     => esc_html__('Hide on home page','typecase'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'archives_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'archives_hide_head_above',
array(
	'section'   => 'typecase_ads_setting',
	'label'     => esc_html__('Hide on archives page','typecase'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'pages_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'pages_hide_head_above',
array(
	'section'   => 'typecase_ads_setting',
	'label'     => esc_html__('Hide on pages','typecase'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'posts_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'posts_hide_head_above',
array(
	'section'   => 'typecase_ads_setting',
	'label'     => esc_html__('Hide on posts','typecase'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'typecase_ads_head_above',
array(
	'default'    =>  '',
	'transport'  =>  'refresh',
	'sanitize_callback' => 'wp_kses_post',
)
);
$wp_customize->add_control(
'typecase_ads_head_above',
array(
	'section'   => 'typecase_ads_setting',
	'label'     => esc_html__('Header Above Ads','typecase'),
	'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
	'type'      => 'textarea'
)
);

/*header below*/
$wp_customize->add_setting(
	'typecase_opt_ads_head_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_head_below',
		array(
			'label'         => esc_html__( 'Header Below Ads Settings', 'typecase' ),			
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_head_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'home_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'home_hide_head_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on home page','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'archives_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'archives_hide_head_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on archives page','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'pages_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'pages_hide_head_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on pages','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'posts_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'posts_hide_head_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on posts','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_head_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_head_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Header Below Ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);

	/*footer above*/
$wp_customize->add_setting(
	'typecase_opt_ads_footer_above',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_footer_above',
		array(
			'label'         => esc_html__( 'Footer Above Ads Settings', 'typecase' ),			
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_footer_above',
		)
	)
	);
	
	$wp_customize->add_setting(
	'home_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'home_hide_footer_above',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on home page','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'archives_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'archives_hide_footer_above',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on archives page','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'pages_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'pages_hide_footer_above',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on pages','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'posts_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'posts_hide_footer_above',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on posts','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_footer_above',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_footer_above',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Footer Above Ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);

	
	/*footer below*/
$wp_customize->add_setting(
	'typecase_opt_ads_footer_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_footer_below',
		array(
			'label'         => esc_html__( 'Footer Below Ads Settings', 'typecase' ),			
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_footer_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'home_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'home_hide_footer_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on home page','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'archives_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'archives_hide_footer_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on archives page','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'pages_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'pages_hide_footer_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on pages','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'posts_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'posts_hide_footer_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Hide on posts','typecase'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_footer_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_footer_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Footer Below Ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);

	/*single post above content*/
$wp_customize->add_setting(
	'typecase_opt_ads_single_content_above',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_single_content_above',
		array(
			'label'         => esc_html__( 'Single post above content', 'typecase' ),
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_single_content_above',
		)
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_single_content_above',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_single_content_above',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Single post above content ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);

/*single post below content*/
$wp_customize->add_setting(
	'typecase_opt_ads_single_content_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_single_content_below',
		array(
			'label'         => esc_html__( 'Single post below content', 'typecase' ),
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_single_content_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_single_content_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_single_content_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Single post below content ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);
		
	/*single post below author*/
$wp_customize->add_setting(
	'typecase_opt_ads_single_author_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_single_author_below',
		array(
			'label'         => esc_html__( 'Single post below author', 'typecase' ),
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_single_author_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_single_author_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_single_author_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Single post below author ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);

	/*single post above related*/
$wp_customize->add_setting(
	'typecase_opt_ads_single_related_above',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_single_related_above',
		array(
			'label'         => esc_html__( 'Single post above related post', 'typecase' ),
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_single_related_above',
		)
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_single_related_above',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_single_related_above',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Single post above related ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);
	

	/*single post below related*/
$wp_customize->add_setting(
	'typecase_opt_ads_single_related_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new typecase_Customize_Control_Title (
		$wp_customize,
		'typecase_opt_ads_single_related_below',
		array(
			'label'         => esc_html__( 'Single post below related post', 'typecase' ),
			'section'       => 'typecase_ads_setting',
			'settings'      => 'typecase_opt_ads_single_related_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'typecase_ads_single_related_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'typecase_ads_single_related_below',
	array(
		'section'   => 'typecase_ads_setting',
		'label'     => esc_html__('Single post below related ads','typecase'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','typecase'),
		'type'      => 'textarea'
	)
	);

	/*Cookie*/
	$wp_customize->add_section(
		    'typecase_cookie_setting',
		    array(
		        'title'     => esc_html__('Cookie Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'vt_cookie_enable',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_cookie_enable',
        array(
            'section'   => 'typecase_cookie_setting',
            'label'     => esc_html__('Enable Cookie','typecase'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'vt_cookie_dec',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'vt_cookie_dec',
	    array(
	        'section'   => 'typecase_cookie_setting',
	        'label'     => esc_html__('Cookie description','typecase'),
	        'type'      => 'textarea'
	    )
	);
	$wp_customize->add_setting(
	    'vt_cookie_btn',
	    array(
	        'default'    =>  esc_attr__( 'Accept', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_cookie_btn',
	    array(
	        'section'   => 'typecase_cookie_setting',
	        'label'     => esc_html__('Cookie button','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vt_cookie_dec_size',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_cookie_dec_size',
	    array(
	        'section'   => 'typecase_cookie_setting',
	        'label'     => esc_html__('Cookie font size Ex: 12px;','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vt_cookie_btn_size',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_cookie_btn_size',
	    array(
	        'section'   => 'typecase_cookie_setting',
	        'label'     => esc_html__('Cookie button font size Ex: 12px;','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vt_cookie_btn_space',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_cookie_btn_space',
	    array(
	        'section'   => 'typecase_cookie_setting',
	        'label'     => esc_html__('Cookie button letter spacing Ex: 1px;','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vt_cookie_btn_tranform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'typecase' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_cookie_btn_tranform',
	    array(
	        'section'   => 'typecase_cookie_setting',
	        'label'     => esc_html__('Cookie button transform','typecase'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'typecase'),
	        	'capitalize' => esc_html__('Capitalize', 'typecase'),
	        	'uppercase' => esc_html__('Uppercase', 'typecase')
	        )
	    )
	);

/*Optimize / SEO*/
	$wp_customize->add_section(
		    'typecase_optimize_setting',
		    array(
		        'title'     => esc_html__('Optimize / SEO Settings', 'typecase'),
		        'priority'  => 1,
		        'panel' => 'typecase_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'vt_opt_google_font',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_opt_google_font',
        array(
            'section'   => 'typecase_optimize_setting',
            'label'     => esc_html__('Preload Google Fonts','typecase'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'vt_opt_font_icons',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_opt_font_icons',
        array(
            'section'   => 'typecase_optimize_setting',
            'label'     => esc_html__('Preload Font Icon','typecase'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'vt_opt_dashicons',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_opt_dashicons',
        array(
            'section'   => 'typecase_optimize_setting',
            'label'     => esc_html__('Disable Dashicons','typecase'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'vt_opt_polyfill',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_opt_polyfill',
        array(
            'section'   => 'typecase_optimize_setting',
            'label'     => esc_html__('Disable Polyfill','typecase'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'vt_opt_woo_block',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_opt_woo_block',
        array(
            'section'   => 'typecase_optimize_setting',
            'label'     => esc_html__('Disable WooCommerce Block Style','typecase'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'vt_opt_gutenberg',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_opt_gutenberg',
        array(
            'section'   => 'typecase_optimize_setting',
            'label'     => esc_html__('Disable Gutenberg Style','typecase'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'typecase_seo_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new typecase_Customize_Control_Title (
            $wp_customize,
            'typecase_seo_sec_options',
            array(
                'label'         => esc_html__( 'SEO', 'typecase' ),
                'section'       => 'typecase_optimize_setting',
                'settings'      => 'typecase_seo_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
        'vt_opt_seo',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'vt_opt_seo',
        array(
            'section'   => 'typecase_optimize_setting',
            'label'     => esc_html__('Disable Open Graph Meta','typecase'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'vt_seo_twiter_name',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_seo_twiter_name',
	    array(
	        'section'   => 'typecase_optimize_setting',
	        'label'     => esc_html__('SEO Twiter creator name','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vt_seo_fb_app_id',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vt_seo_fb_app_id',
	    array(
	        'section'   => 'typecase_optimize_setting',
	        'label'     => esc_html__('Facebook APP ID','typecase'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
		'typecase_seo_img',
		array(
		'default' 			=> '',
		'transport'   		=> 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control(
			new WP_Customize_Image_Control(
			$wp_customize,
			'typecase_seo_img',
			array(
			'label'    => esc_html__( 'Fallback Open Graph Image', 'typecase' ),
			'section'  => 'typecase_optimize_setting',
			'settings' => 'typecase_seo_img'
		)));


/*AMP*/
$wp_customize->add_section(
	'typecase_amp_setting',
	array(
		'title'     => esc_html__('AMP Settings', 'typecase'),
		'priority'  => 1,
		'panel' => 'typecase_theme_options'
	)
);

$wp_customize->add_setting(
'amp_head_logo',
array(
'default' 			=> '',
'transport'   		=> 'refresh',
'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control(
new WP_Customize_Image_Control(
$wp_customize,
'amp_head_logo',
array(
'label'    => esc_html__( 'Header logo', 'typecase' ),
'section'  => 'typecase_amp_setting',
'settings' => 'amp_head_logo'
)));

$wp_customize->add_setting(
'amp_foot_logo',
array(
'default' 			=> '',
'transport'   		=> 'refresh',
'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control(
new WP_Customize_Image_Control(
$wp_customize,
'amp_foot_logo',
array(
'label'    => esc_html__( 'Footer logo', 'typecase' ),
'section'  => 'typecase_amp_setting',
'settings' => 'amp_foot_logo'
)));

$wp_customize->add_setting(
	'amp_head_logo_width',
	array(
		'default'    =>  esc_attr__( '100px', 'typecase' ),
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'amp_head_logo_width',
	array(
		'section'   => 'typecase_amp_setting',
		'label'     => esc_html__('Logo width EX: 100px','typecase'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'amp_footer_logo_width',
	array(
		'default'    =>  esc_attr__( '150px', 'typecase' ),
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'amp_footer_logo_width',
	array(
		'section'   => 'typecase_amp_setting',
		'label'     => esc_html__('Footer logo width EX: 100px','typecase'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
'amp_head_bg',
array(
	'default'    =>  esc_attr__( '#000', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_head_bg',
	array(
		'label'      => esc_html__( 'Header background color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_head_bg'
	)
)
);

$wp_customize->add_setting(
'amp_head_color',
array(
	'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_head_color',
	array(
		'label'      => esc_html__( 'Header color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_head_color'
	)
)
);

$wp_customize->add_setting(
'amp_content_bg',
array(
	'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_content_bg',
	array(
		'label'      => esc_html__( 'Contetn background color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_content_bg'
	)
)
);

$wp_customize->add_setting(
'amp_content_color',
array(
	'default'    =>  esc_attr__( '#000', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_content_color',
	array(
		'label'      => esc_html__( 'Contetn color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_content_color'
	)
)
);

$wp_customize->add_setting(
'amp_content_link',
array(
	'default'    =>  esc_attr__( '#f00', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_content_link',
	array(
		'label'      => esc_html__( 'Content link color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_content_link'
	)
)
);

$wp_customize->add_setting(
'amp_footer_bg',
array(
	'default'    =>  esc_attr__( '#000', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_footer_bg',
	array(
		'label'      => esc_html__( 'Footer background color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_footer_bg'
	)
)
);

$wp_customize->add_setting(
'amp_footer_color',
array(
	'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_footer_color',
	array(
		'label'      => esc_html__( 'Footer color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_footer_color'
	)
)
);

$wp_customize->add_setting(
'amp_footer_link',
array(
	'default'    =>  esc_attr__( '#f00', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_footer_link',
	array(
		'label'      => esc_html__( 'Footer link color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_footer_link'
	)
)
);

$wp_customize->add_setting(
'amp_sidebar_bg',
array(
	'default'    =>  esc_attr__( '#111', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_sidebar_bg',
	array(
		'label'      => esc_html__( 'Sidebar background color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_sidebar_bg'
	)
)
);

$wp_customize->add_setting(
'amp_sidebar_color',
array(
	'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_sidebar_color',
	array(
		'label'      => esc_html__( 'Sidebar color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_sidebar_color'
	)
)
);

$wp_customize->add_setting(
'amp_sidebar_link',
array(
	'default'    =>  esc_attr__( '#FFF', 'typecase' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_sidebar_link',
	array(
		'label'      => esc_html__( 'Sidebar link color', 'typecase' ),
		'section'    => 'typecase_amp_setting',
		'settings'   => 'amp_sidebar_link'
	)
)
);

$wp_customize->add_setting(
	'hide_amp_related',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'hide_amp_related',
	array(
		'section'   => 'typecase_amp_setting',
		'label'     => esc_html__('Hide related posts','typecase'),
		'type'      => 'checkbox'
	)
);

$wp_customize->add_setting(
	'amp_copyright',
	array(
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
);
$wp_customize->add_control(
	'amp_copyright',
	array(
		'section'   => 'typecase_amp_setting',
		'label'     => esc_html__('Footer copyright','typecase'),
		'type'      => 'textarea'
	)
);




$wp_customize->remove_section( 'colors' );
$wp_customize->remove_section( 'background_image' );
}
add_action( 'customize_register', 'typecase_register_theme_customizer', 110 );
