<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! function_exists( 'typecase_ads_above_head' ) ) {
    function typecase_ads_above_head() {
        $typecase_ads_head_above = get_theme_mod('typecase_ads_head_above');
        $home_hide_head_above = get_theme_mod('home_hide_head_above');
        $archives_hide_head_above = get_theme_mod('archives_hide_head_above');
        $pages_hide_head_above = get_theme_mod('pages_hide_head_above');
        $posts_hide_head_above = get_theme_mod('posts_hide_head_above');                        
        if(empty($typecase_ads_head_above)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_head_adsab">';
        if ( is_category() ) {
            if(empty($archives_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
		} elseif ( is_tag() ) {
            if(empty($archives_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
		} elseif ( is_search() ) {   
            if(empty($archives_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
        } elseif ( is_author() ) {
            if(empty($archives_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
        } elseif ( is_front_page() ) {
            if(empty($home_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
        } elseif ( is_single() ) {
            if(empty($posts_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
        } elseif ( is_page() ) {
            if(empty($pages_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
        } elseif ( is_page_template() ) {
            if(empty($pages_hide_head_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_above));
            }
        }        
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_below_head' ) ) {
    function typecase_ads_below_head() {
        $typecase_ads_head_below = get_theme_mod('typecase_ads_head_below');
        $home_hide_head_below = get_theme_mod('home_hide_head_below');
        $archives_hide_head_below = get_theme_mod('archives_hide_head_below');
        $pages_hide_head_below = get_theme_mod('pages_hide_head_below');
        $posts_hide_head_below = get_theme_mod('posts_hide_head_below');                        
        if(empty($typecase_ads_head_below)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_head_adsbl">';
        if ( is_category() ) {
            if(empty($archives_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
		} elseif ( is_tag() ) {
            if(empty($archives_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
		} elseif ( is_search() ) {   
            if(empty($archives_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
        } elseif ( is_author() ) {
            if(empty($archives_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
        } elseif ( is_front_page() ) {
            if(empty($home_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
        } elseif ( is_single() ) {
            if(empty($posts_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
        } elseif ( is_page() ) {
            if(empty($pages_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
        } elseif ( is_page_template() ) {
            if(empty($pages_hide_head_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_head_below));
            }
        }        
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_above_footer' ) ) {
    function typecase_ads_above_footer() {
        $typecase_ads_footer_above = get_theme_mod('typecase_ads_footer_above');
        $home_hide_footer_above = get_theme_mod('home_hide_footer_above');
        $archives_hide_footer_above = get_theme_mod('archives_hide_footer_above');
        $pages_hide_footer_above = get_theme_mod('pages_hide_footer_above');
        $posts_hide_footer_above = get_theme_mod('posts_hide_footer_above');                        
        if(empty($typecase_ads_footer_above)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_foot_adsab">';
        if ( is_category() ) {
            if(empty($archives_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
		} elseif ( is_tag() ) {
            if(empty($archives_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
		} elseif ( is_search() ) {   
            if(empty($archives_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
        } elseif ( is_author() ) {
            if(empty($archives_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
        } elseif ( is_front_page() ) {
            if(empty($home_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
        } elseif ( is_single() ) {
            if(empty($posts_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
        } elseif ( is_page() ) {
            if(empty($pages_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
        } elseif ( is_page_template() ) {
            if(empty($pages_hide_footer_above)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_above));
            }
        }        
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_below_footer' ) ) {
    function typecase_ads_below_footer() {
        $typecase_ads_footer_below = get_theme_mod('typecase_ads_footer_below');
        $home_hide_footer_below = get_theme_mod('home_hide_footer_below');
        $archives_hide_footer_below = get_theme_mod('archives_hide_footer_below');
        $pages_hide_footer_below = get_theme_mod('pages_hide_footer_below');
        $posts_hide_footer_below = get_theme_mod('posts_hide_footer_below');                        
        if(empty($typecase_ads_footer_below)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_foot_adsbl">';
        if ( is_category() ) {
            if(empty($archives_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
		} elseif ( is_tag() ) {
            if(empty($archives_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
		} elseif ( is_search() ) {   
            if(empty($archives_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
        } elseif ( is_author() ) {
            if(empty($archives_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
        } elseif ( is_front_page() ) {
            if(empty($home_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
        } elseif ( is_single() ) {
            if(empty($posts_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
        } elseif ( is_page() ) {
            if(empty($pages_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
        } elseif ( is_page_template() ) {
            if(empty($pages_hide_footer_below)){            
                echo do_shortcode(wp_kses_post($typecase_ads_footer_below));
            }
        }        
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_content_above' ) ) {
    function typecase_ads_content_above() {
        $typecase_ads_single_content_above = get_theme_mod('typecase_ads_single_content_above');        
        if(empty($typecase_ads_single_content_above)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_con_adsab">';
            echo do_shortcode(wp_kses_post($typecase_ads_single_content_above));
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_content_below' ) ) {
    function typecase_ads_content_below() {
        $typecase_ads_single_content_below = get_theme_mod('typecase_ads_single_content_below');        
        if(empty($typecase_ads_single_content_below)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_con_adsbl">';
            echo do_shortcode(wp_kses_post($typecase_ads_single_content_below));
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_content_author' ) ) {
    function typecase_ads_content_author() {
        $typecase_ads_single_author_below = get_theme_mod('typecase_ads_single_author_below');        
        if(empty($typecase_ads_single_author_below)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_auth_adsbl">';
            echo do_shortcode(wp_kses_post($typecase_ads_single_author_below));
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_related_above' ) ) {
    function typecase_ads_related_above() {
        $typecase_ads_single_related_above = get_theme_mod('typecase_ads_single_related_above');        
        if(empty($typecase_ads_single_related_above)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_rel_adsab">';
            echo do_shortcode(wp_kses_post($typecase_ads_single_related_above));
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_ads_related_below' ) ) {
    function typecase_ads_related_below() {
        $typecase_ads_single_related_below = get_theme_mod('typecase_ads_single_related_below');        
        if(empty($typecase_ads_single_related_below)){
            return;
        }
        echo '<div class="vt_ads_wrap_sec vt_rel_adsbl">';
            echo do_shortcode(wp_kses_post($typecase_ads_single_related_below));
        echo '</div>';
    }
}

if ( ! function_exists( 'typecase_archive_head' ) ) {
    function typecase_archive_head() {
        if ( is_category() ) {
            echo '<div class="vt_pc_sec_title">';
            echo '<h1 class="vt_pc_sec_h">';
			echo single_cat_title( '', false );
            echo '</h1>';
            if ( get_the_archive_description() ) {
                echo '<div class="post_subtitle_text">';
                the_archive_description(); 
                echo '</div>';
            }
            echo '</div>';
		} elseif ( is_tag() ) {
            echo '<div class="vt_pc_sec_title">';
            echo '<h1 class="vt_pc_sec_h">';
			echo single_tag_title( '', false );
            echo '</h1>';
            if ( get_the_archive_description() ) {
                echo '<div class="post_subtitle_text">';
                the_archive_description(); 
                echo '</div>';
            }
            echo '</div>';
		} elseif ( is_search() ) {   
            echo '<div class="vt_pc_sec_title">';
            echo '<h1 class="vt_pc_sec_h">';
			esc_html_e('Search Result for: ', 'typecase');
            the_search_query();
            echo '</h1>';            
            echo '</div>';
        } elseif ( is_tax() ) {
            echo '<div class="vt_pc_sec_title">';
            echo '<h1 class="vt_pc_sec_h">';
			single_term_title( '', false );
            echo '</h1>';            
            echo '</div>';
        } elseif ( is_post_type_archive() ) {
            echo '<div class="vt_pc_sec_title">';
            echo '<h1 class="vt_pc_sec_h">';
			post_type_archive_title( '', false );
            echo '</h1>';            
            echo '</div>';
        } elseif ( is_author() ) {?>
            <div class="auth">
                <div class="author-info vt_auth_head vt_info_auth">
                    <div class="author-avatar">
                        <?php echo get_avatar(get_the_author_meta('user_email'), 165); ?>
                    </div>
                    <div class="author-description">
                        <h5><a itemprop="author" href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ))); ?>">
                            <?php the_author_meta( 'display_name' ); ?></a></h5>
                            <?php if(!empty(get_the_author_meta('description'))){?>
                            <p itemprop="description">
                            <?php echo get_the_author_meta('description'); ?>
                            </p>
                            <?php }?>
                            <?php if(function_exists('typecase_author_contact')){echo typecase_author_contact(get_the_ID());}?>
                            <?php if(function_exists('typecase_author_share_link')){typecase_author_share_link(get_the_ID());}?>
                            <?php
                            echo '<span class="author_postcount">';
                            echo count_user_posts( get_the_author_meta('ID') ).' ';
                            esc_html_e('Articles', 'typecase');
                            echo '</span>';
                            $comment_args = array('post_author' => get_the_author_meta('ID'));
                            $author_comments = get_comments($comment_args);
                            echo '<span class="author_commentcount">';
                            echo count($author_comments).' ';
                            esc_html_e('Comments', 'typecase');
                            echo '</span>'; ?>
                    </div>
                </div>
            </div>
        <?php } elseif ( is_home() ) {
        }else{
            echo '<div class="vt_pc_sec_title">';
            echo '<h1 class="vt_pc_sec_h">';
			echo get_the_archive_title();
            echo '</h1>';            
            echo '</div>';
        }        
    }
}
if ( ! function_exists( 'typecase_archive_opt_sidebar' ) ) {
    function typecase_archive_opt_sidebar() {
        if ( is_category() ) {
            typecase_category_sidebar();
          }
          if ( is_tag() ) {
            typecase_tag_sidebar();
          }
          if ( is_search() ) {
            typecase_search_sidebar();
          }
          if ( is_tax() ) {
            typecase_archive_sidebar();
          }
          if ( is_date() ) {
            typecase_archive_sidebar();
          }          
          if ( is_post_type_archive() ) {
            typecase_archive_sidebar();
          }
          if ( is_author() ) {
            typecase_author_sidebar();
          }
          if ( is_home() ) {
            typecase_archive_sidebar();
          }
    }
}
if ( ! function_exists( 'typecase_nav_guide' ) ) {
    function typecase_nav_guide() {
        if ( apply_filters( 'typecase_use_yoast_breadcrumbs', '' ) == true ) {
            if ( function_exists( 'yoast_breadcrumb' ) ) {
                $nav_3th = 'vt_breadcrumbs';			
                yoast_breadcrumb( '<div class="' . $nav_3th . '">', '</div>' );
            }
            return;
        }
        if ( apply_filters( 'typecase_use_rankmath_breadcrumbs', '' ) == true ) {
            if ( function_exists( 'rank_math_the_breadcrumbs' ) ) {
                $rank_math_class = 'vt_breadcrumbs';			
                $args = array(
                    'wrap_before' => '<div class="' . $rank_math_class . '">',
                    'wrap_after'  => '</div>',
                    'before'      => '',
                    'after'       => '',
                );
                echo rank_math_get_breadcrumbs( $args );
            }
            return;
        }
        if ( get_theme_mod( 'vt_nav_guide' ) != 1 || is_front_page() || class_exists( 'bbPress' ) && is_bbpress() ) {
            return;
        }
        $nav_gopt     = array();
        $i          = 1;
        $main_guide = array(
            esc_html__( 'Home', 'typecase' ) => get_home_url(),
        );
        $nav_filter = apply_filters( 'typecase_breadcrumbs_extension', '' );
        $guid_id    = ! empty( $_GET['ipl'] ) && ! empty( $_GET['pid'] ) ? $_GET['pid'] : '';
        if ( ! empty( $nav_filter ) ) {
            $nav_gopt = $main_guide;
            $nav_gopt = array_merge( $nav_gopt, $nav_filter );
        } elseif ( is_date() ) {
            $nav_gopt    = $main_guide;
            $year      = get_the_time( 'Y' );
            $month     = get_the_time( 'm' );
            $day       = get_the_time( 'd' );
            $month_url = get_month_link( $year, $month );
            $year_url  = get_year_link( $year );
            if ( is_day() ) {
                $nav_gopt[ $year ]  = $year_url;
                $nav_gopt[ $month ] = $month_url;
                $nav_gopt[ $day ]   = '';
            } elseif ( is_month() ) {
                $nav_gopt[ $year ]  = $year_url;
                $nav_gopt[ $month ] = '';
            } elseif ( is_year() ) {
                $nav_gopt[ $year ] = '';
            }
        } elseif ( typecase_check_woo() ) {
            $nav_gopt = $main_guide;
            $nav_gopt[ esc_html__( 'Shop', 'typecase' ) ] = '';
        } elseif ( is_archive() ) {
            $nav_gopt = $main_guide;

            $term = get_queried_object();
            if ( ! $term ) {
                return;
            }
            if ( is_category() || is_tax() ) {
                $current_crumb = typecase_cats( $term->term_id, $term->taxonomy );
                $nav_gopt        = $nav_gopt + $current_crumb;
            } elseif ( is_tag() ) {
                $nav_gopt[ single_tag_title( '', false ) ] = '';
            } elseif ( is_author() ) {
                $nav_gopt[ $term->data->user_nicename ] = '';
            }
        } elseif ( is_single() || ! empty( $guid_id ) ) {
            $nav_gopt = $main_guide;
            if ( ! empty( $guid_id ) ) {
                $post = get_post( $guid_id );
            } else {
                global $post;
            }
            if ( 'product' == $post->post_type && function_exists( 'wc_get_product_terms' ) ) {
                $terms = wc_get_product_terms(
                    $post->ID,
                    'product_cat',
                    array(
                        'orderby' => 'parent',
                        'order'   => 'DESC',
                    )
                );
                if ( ! empty( $terms ) ) {
                    $main_term     = apply_filters( 'woocommerce_breadcrumb_main_term', $terms[0], $terms );
                    $current_crumb = typecase_cats( $main_term->term_id, 'product_cat' );
                    $nav_gopt        = array_merge( $nav_gopt, $current_crumb );
                }
            } else {
                $cats = get_the_category( $post->ID );
                if ( ! empty( $cats ) ) {
                    $current_crumb = typecase_cats( $cats[0]->term_id );
                    $nav_gopt = is_array( $current_crumb ) ? array_merge( $nav_gopt, $current_crumb ) : $nav_gopt;
                }
            }
            $nav_gopt[ get_the_title( $post->ID ) ] = '';		
        } elseif ( is_page() ) {
            $nav_gopt = $main_guide;
            global $post;
            $ancestors = get_post_ancestors( $post );
            if ( ! empty( $ancestors ) ) {
                $nav_gopt[ get_the_title( $ancestors[0] ) ] = get_permalink( $ancestors[0] );
            }
            $nav_gopt[ get_the_title( $post->ID ) ] = '';
        } elseif ( is_search() ) {
            $nav_gopt                       = $main_guide;
            $nav_gopt[ get_search_query() ] = '';
        }
        if ( empty( $nav_gopt ) ) { return; }	
        echo '<div class="vt_breadcrumbs">';
        foreach ( $nav_gopt as $key => $value ) { ?>
            <?php if ( 1 != $i ) {?>
            <i class="vti-right-chevron"></i>
            <?php } ?>
            <span class="vt_item_bread">
                <?php if ( ! empty( $value ) ) { ?>
                    <a href="<?php echo esc_url( $value ); ?>">
                <?php } ?>
                <?php echo esc_html( $key ); ?>
                <?php if ( ! empty( $value ) ) { ?>
                    </a>
                <?php } ?>
            </span>
            <?php $i++; ?>
        <?php } ?>
        </div>
    <?php }
}
if ( ! function_exists( 'typecase_cats' ) ) {
    function typecase_cats( $id, $term_cat = 'category', $active = array() ) {
        $cat_term  = array();
        $main_term = get_term( $id, $term_cat );
        if ( empty( $main_term ) || is_wp_error( $main_term ) ) {
            return $main_term;
        }
        $name = $main_term->name;
        if ( $main_term->parent && $main_term->parent != $main_term->term_id && ! in_array( $main_term->parent, $active ) ) {
            $active[]    = $main_term->parent;
            $main_term_chain = typecase_cats( $main_term->parent, $term_cat, $active );
            $cat_term = $cat_term + $main_term_chain;
        }
        $cat_term[ $main_term->name ] = get_term_link( $main_term->term_id, $term_cat );
        return $cat_term;
    }
}
if ( ! function_exists( 'typecase_active_woo' ) ) {
    function typecase_active_woo() {
        if ( class_exists( 'woocommerce' ) ) {
            return true;
        } else {
            return false;
        }
    }
}
if ( ! function_exists( 'typecase_check_woo' ) ) {
    function typecase_check_woo() {
        if ( typecase_active_woo() && is_shop() ) {
            return true;
        } else {
            return false;
        }
    }
}
if ( ! function_exists( 'typecase_sponsored' ) ) {
    function typecase_sponsored() {
        $enable_sponsored_post = get_post_meta( get_the_ID(), 'enable_sponsored_post', true );
        $sponsored_post_url = get_post_meta( get_the_ID(), 'sponsored_post_url', true );
        $sponsored_logo = get_post_meta( get_the_ID(), 'sponsored_logo', true );        
        if(!empty($enable_sponsored_post)){
            echo '<span class="vt_spon_wrap">';
            echo '<span class="vt_spon_lbl">';
            echo esc_html__( 'Sponsored By:', 'typecase' );
            echo '</span>';
            if(!empty($sponsored_post_url)){
                echo '<a href="'.esc_url($sponsored_post_url).'" target="_blank" rel="nofollow">';
            }
            if(!empty($sponsored_logo)){
                echo wp_get_attachment_image( $sponsored_logo, 'typecase_large', true );
            }
            if(!empty($sponsored_post_url)){
                echo '</a>';
            }
            echo '</span>';
        }        
    }
}

if ( ! function_exists( 'typecase_video_media' ) ) {
  function typecase_video_media() {
    if(has_post_format( 'video')){
        $vt_video_style = get_post_meta( get_the_ID(), 'vt_video_style', true );
        $vt_video_style_opt = get_theme_mod('vt_video_style', 'background');
        $vt_vid_type = get_post_meta( get_the_ID(), 'vt_vid_type', true );
        $video_post_embed = get_post_meta( get_the_ID(), 'video_post_embed', true );
        $video_local = get_post_meta( get_the_ID(), 'video_local', true );
        $attach_vid = wp_get_attachment_url( $video_local );
        if(empty($vt_video_style)) {
            $vt_video_layout = $vt_video_style_opt;
        } else {
            $vt_video_layout = $vt_video_style;
        }
        if ($vt_video_layout == 'popup') {
          if ($vt_vid_type == 'video_post_embed') {?>
            <span class="vt_vid_mp vt_livid">
                <span class="vt_vid_mpin">
                  <a class="vt_pop_vid" href="<?php echo esc_url($video_post_embed);?>"></a>
                    <svg fill="currentColor" viewBox="0 0 22 27"><path d="M1 2.242 20.5 13.5 1 24.758V2.242Z" stroke="currentColor"></path></svg>
                </span>
            </span>
          <?php }else{?>
            <span class="vt_vid_mp vt_livid">
                <span class="vt_vid_mpin">
                  <a class="vt_pop_vid" data-type="iframe" href="<?php echo esc_url($attach_vid);?>"></a>
                    <svg fill="currentColor" viewBox="0 0 22 27"><path d="M1 2.242 20.5 13.5 1 24.758V2.242Z" stroke="currentColor"></path></svg>
                </span>
            </span>
        <?php }
        }else{
            if ($vt_vid_type == 'video_post_embed') {
                if ( strpos( $video_post_embed, 'yout' ) !== false ) {
                    $type = 'yt';
                } elseif( strpos( $video_post_embed, 'vim' ) !== false ) {
                    $type = 'vim';
                } elseif ( strpos( $video_post_embed, 'dailymotion' ) !== false ) {
                    $type = 'daily';
                } else {
                    $type = '';
                }

                switch ( $type ) {
                    case 'vim':
                        $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                            $vid_args['autoplay']   = 1;
                            $vid_args['muted']      = 1;
                            $vid_args['loop']       = 1;
                            $vid_args['portrait']   = 0;
                            $vid_args['byline']     = 0;
                            $vid_args['dnt']        = 0;
                            $vid_args['background'] = 1;
                            $vid_args['title']      = 1;
                        $vid_url = add_query_arg($vid_args, 'https://player.vimeo.com/video/' . $video_post_embed);
                    break;
                    case 'daily':
                        $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                            $vid_args['autoplay']   = 1;
                            $vid_args['muted']      = 1;
                            $vid_args['loop']       = 1;
                        $vid_url = add_query_arg($vid_args, '"https://www.dailymotion.com/embed/' . $video_post_embed);
                    break;
                    case 'yt':
                        preg_match( '([-\w]{11})', $video_post_embed, $matches );
                        if ( ! empty( $matches ) ) {
                                $vid_args['autoplay']       = 1;
                                $vid_args['mute']           = 1;
                                $vid_args['loop']           = 1;
                                $vid_args['rel']            = 0;                                
                                $vid_args['playsinline']    = 1;
                                $vid_args['showinfo']       = 0;
                                $vid_args['modestbranding'] = 1;
                                $vid_args['controls']       = 0;
                                $vid_args['fs']             = 0;
                                $vid_args['iv_load_policy'] = 3;                                
                                $vid_args['playlist']       = $matches[0];
                            $vid_url = add_query_arg( $vid_args, 'https://www.youtube-nocookie.com/embed/' . $matches[0] );
                        }
                        break;
                }
                    if (!empty($vid_url)){
                    echo '<div class="video-wrap overlay-media"><iframe class="frame vt_fm_vid_load" title="media" src="about:blank" data-lazy-src="' . esc_url( $vid_url ) . '" frameborder="0" seamless="seamless" allowfullscreen></iframe></div>';
                    }
            }else{
                echo '<div class="video-wrap overlay-media"><video autoplay="autoplay" loop="loop" muted="muted" playsinline><source src="'.esc_url( $attach_vid ).'" type="video/mp4"></video></div>';
            }
        }
      }
  }
}

if ( ! function_exists( 'typecase_video_bg' ) ) {
    function typecase_video_bg() {
      if(has_post_format( 'video')){
          $vt_video_style = get_post_meta( get_the_ID(), 'vt_video_style', true );
          $vt_video_style_opt = get_theme_mod('vt_video_style', 'background');
          $vt_vid_type = get_post_meta( get_the_ID(), 'vt_vid_type', true );
          $video_post_embed = get_post_meta( get_the_ID(), 'video_post_embed', true );
          $video_local = get_post_meta( get_the_ID(), 'video_local', true );
          $attach_vid = wp_get_attachment_url( $video_local );          
              if ($vt_vid_type == 'video_post_embed') {
                  if ( strpos( $video_post_embed, 'yout' ) !== false ) {
                      $type = 'yt';
                  } elseif( strpos( $video_post_embed, 'vim' ) !== false ) {
                      $type = 'vim';
                  } elseif ( strpos( $video_post_embed, 'dailymotion' ) !== false ) {
                      $type = 'daily';
                  } else {
                      $type = '';
                  }
  
                  switch ( $type ) {
                      case 'vim':
                          $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                              $vid_args['autoplay']   = 1;
                              $vid_args['muted']      = 1;
                              $vid_args['loop']       = 1;
                              $vid_args['portrait']   = 0;
                              $vid_args['byline']     = 0;
                              $vid_args['dnt']        = 0;
                              $vid_args['background'] = 1;
                              $vid_args['title']      = 1;
                          $vid_url = add_query_arg($vid_args, 'https://player.vimeo.com/video/' . $video_post_embed);
                      break;
                      case 'daily':
                          $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                              $vid_args['autoplay']   = 1;
                              $vid_args['muted']      = 1;
                              $vid_args['loop']       = 1;
                          $vid_url = add_query_arg($vid_args, '"https://www.dailymotion.com/embed/' . $video_post_embed);
                      break;
                      case 'yt':
                          preg_match( '([-\w]{11})', $video_post_embed, $matches );
                          if ( ! empty( $matches ) ) {
                                  $vid_args['autoplay']       = 1;
                                  $vid_args['mute']           = 1;
                                  $vid_args['loop']           = 1;
                                  $vid_args['rel']            = 0;                                
                                  $vid_args['playsinline']    = 1;
                                  $vid_args['showinfo']       = 0;
                                  $vid_args['modestbranding'] = 1;
                                  $vid_args['controls']       = 0;
                                  $vid_args['fs']             = 0;
                                  $vid_args['iv_load_policy'] = 3;                                
                                  $vid_args['playlist']       = $matches[0];
                              $vid_url = add_query_arg( $vid_args, 'https://www.youtube-nocookie.com/embed/' . $matches[0] );
                          }
                          break;
                  }
                      if (!empty($vid_url)){
                      echo '<div class="video-wrap overlay-media"><iframe class="frame vt_fm_vid_load" title="media" src="about:blank" data-lazy-src="' . esc_url( $vid_url ) . '" frameborder="0" seamless="seamless" allowfullscreen></iframe></div>';
                      }
              }else{
                  echo '<div class="video-wrap overlay-media"><video autoplay="autoplay" loop="loop" muted="muted" playsinline><source src="'.esc_url( $attach_vid ).'" type="video/mp4"></video></div>';
              }          
        }
    }
  }

if ( ! function_exists( 'typecase_media_url' ) ) {
  function typecase_media_url() {
    if(has_post_format( 'video')){
        $vt_vid_type = get_post_meta( get_the_ID(), 'vt_vid_type', true );
        $video_post_embed = get_post_meta( get_the_ID(), 'video_post_embed', true );
        $video_local = get_post_meta( get_the_ID(), 'video_local', true );
        $attach_vid = wp_get_attachment_url( $video_local );
        if ($vt_vid_type == 'video_post_embed') {
            if ( strpos( $video_post_embed, 'yout' ) !== false ) {
                $type = 'yt';
            } elseif( strpos( $video_post_embed, 'vim' ) !== false ) {
                $type = 'vim';
            } elseif ( strpos( $video_post_embed, 'dailymotion' ) !== false ) {
                $type = 'daily';
            } else {
                $type = '';
            }

            switch ( $type ) {
                case 'vim':
                    $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                        $vid_args['autoplay']   = 1;
                    $vid_url = add_query_arg($vid_args, 'https://player.vimeo.com/video/' . $video_post_embed);
                break;
                case 'daily':
                    $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                        $vid_args['autoplay']   = 1;
                    $vid_url = add_query_arg($vid_args, '"https://www.dailymotion.com/embed/' . $video_post_embed);
                break;
                case 'yt':
                    preg_match( '([-\w]{11})', $video_post_embed, $matches );
                    if ( ! empty( $matches ) ) {
                            $vid_args['autoplay']       = 1;
                            $vid_args['mute']           = 0;
                            $vid_args['rel']            = 1;
                            $vid_args['modestbranding'] = 1;
                            $vid_args['controls']       = 1;
                            $vid_args['loop']           = 0;
                            $vid_args['playsinline']    = 1;
                            $vid_args['showinfo']       = 1;
                            $vid_args['fs']             = 1;
                            $vid_args['iv_load_policy'] = 3;
                            // $vid_args['playlist']       = $matches[0];
                        $vid_url = add_query_arg( $vid_args, 'https://www.youtube-nocookie.com/embed/' . $matches[0] );
                    }
                    break;
            }
                if (!empty($vid_url)){
                echo esc_url( $vid_url );
                }
        }else{
            echo esc_url( $attach_vid );
        }
      }
  }
}

if ( ! function_exists( 'typecase_media_type' ) ) {
  function typecase_media_type() {
    if(has_post_format( 'video')){
      $vt_vid_type = get_post_meta( get_the_ID(), 'vt_vid_type', true );
      if ($vt_vid_type == 'video_post_embed') {
        echo esc_attr('embedvid');
      }else{
        echo esc_attr('localvid');
      }
      }
  }
}

if ( ! function_exists( 'typecase_single_video_media' ) ) {
    function typecase_single_video_media() {
      if(has_post_format( 'video')){
          $vt_vid_type = get_post_meta( get_the_ID(), 'vt_vid_type', true );
          $video_post_embed = get_post_meta( get_the_ID(), 'video_post_embed', true );
          $video_local = get_post_meta( get_the_ID(), 'video_local', true );
          $attach_vid = wp_get_attachment_url( $video_local );                    
              if ($vt_vid_type == 'video_post_embed') {
                  if ( strpos( $video_post_embed, 'yout' ) !== false ) {
                      $type = 'yt';
                  } elseif( strpos( $video_post_embed, 'vim' ) !== false ) {
                      $type = 'vim';
                  } elseif ( strpos( $video_post_embed, 'dailymotion' ) !== false ) {
                      $type = 'daily';
                  } else {
                      $type = '';
                  }
  
                  switch ( $type ) {
                      case 'vim':
                          $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                              $vid_args['autoplay']   = 0;                              
                          $vid_url = add_query_arg($vid_args, 'https://player.vimeo.com/video/' . $video_post_embed);
                      break;
                      case 'daily':
                          $video_post_embed = substr( wp_parse_url( $video_post_embed, PHP_URL_PATH ), 1 );
                              $vid_args['autoplay']   = 0;
                              $vid_args['muted']      = 0;
                              $vid_args['loop']       = 0;
                          $vid_url = add_query_arg($vid_args, '"https://www.dailymotion.com/embed/' . $video_post_embed);
                      break;
                      case 'yt':
                          preg_match( '([-\w]{11})', $video_post_embed, $matches );
                          if ( ! empty( $matches ) ) {
                                  $vid_args['autoplay']       = 0;
                                  $vid_args['mute']           = 0;
                                  $vid_args['rel']            = 0;
                                  $vid_args['modestbranding'] = 1;
                                  $vid_args['controls']       = 1;
                                  $vid_args['loop']           = 0;
                                  $vid_args['playsinline']    = 1;
                                  $vid_args['showinfo']       = 1;
                                  $vid_args['fs']             = 1;
                                  $vid_args['iv_load_policy'] = 3;
                                //   $vid_args['playlist']       = $matches[0];
                              $vid_url = add_query_arg( $vid_args, 'https://www.youtube-nocookie.com/embed/' . $matches[0] );
                          }
                          break;
                  }
                      if (!empty($vid_url)){
                      echo '<div class="vtvid_container"><iframe title="media" src="' . esc_url( $vid_url ) . '" frameborder="0" seamless="seamless" allowfullscreen></iframe></div>';
                      }
              }else{                  
                  echo '<div class="vtvid_local">'.do_shortcode('[video src="'.esc_url($attach_vid).'"][/video]').'</div>';
              }
        }
    }
  }

if ( ! function_exists( 'typecase_button_txt' ) ) {
    function typecase_button_txt() {
        $btn_txt = get_theme_mod( 'btn_txt', 'Continue Reading' );
        if ( ! empty( $btn_txt ) ) {?>
            <a href="<?php the_permalink(); ?>" class="vt_cap_btn vt_btn_ani">
                <?php echo esc_html( $btn_txt ); ?>
            </a>
        <?php }
    }
  }

if ( ! function_exists( 'typecase_blog_param' ) ) {
  function typecase_blog_param() {
    global $wp_query;
    $str   = '';
    $param = array();
    $cur_cat_id = get_query_var('cat');    
    $offset = NULL;
    $param['data-page_current'] = 1;
    if ( get_query_var( 'paged' ) ) {
      $param['data-page_current'] = get_query_var( 'paged' );
    } elseif ( get_query_var( 'page' ) ) {
      $param['data-page_current'] = get_query_var( 'page' );
    }

    if ( ! empty( $wp_query->max_num_pages ) ) {
      $param['data-page_max'] = $wp_query->max_num_pages;
    }
    $param['data-posts_per_page'] = get_option('posts_per_page');
    if ( $offset != NULL) {
    $param['data-offset'] = $offset;
    }
    $param['data-order'] = 'date_post';
    $param['data-section_style'] = 'vt_cat_list';
    if ( is_author() ) {
      $param['data-author'] = get_the_author_meta( 'ID' );
    } elseif ( is_tag() ) {
      $param['data-tags'] = single_tag_title( '', false );
    } elseif ( is_category() ) {
      global $wp_query;
      $param['data-categories'] = $wp_query->get_queried_object_id();
    }

    foreach ( $param as $k => $v ) {
      if ( ! empty( $k ) ) {
        $str .= esc_attr( $k ) . '= ' . esc_attr( $v ) . ' ';
      }
    }
    return $str;
  }
}
if ( ! function_exists( 'typecase_cat_listing' ) ) :
    function typecase_cat_listing( $module = array(), $query_data = null ) {

        if ( method_exists( $query_data, 'have_posts' ) ) :
            $counter = 1;
            while ( $query_data->have_posts() ) :
                $query_data->the_post();
                get_template_part( 'inc/misc/content', 'list' );
            endwhile;
        endif;
    }
endif;

if ( ! function_exists( 'typecase_search_opt' ) ) {
function typecase_search_opt($query) {
    if (!$query->is_search || !$query->is_main_query()) {
        return $query;
    }
    if(
        is_admin() 
        || class_exists( 'Buddypress', false )
        || (function_exists('is_bbpress') && is_bbpress()) 
        || (function_exists('is_shop') && is_shop())
    ){
        return $query;
    }
    if ($query->is_search) {
        $query->set('post_type', array('post'));
    }
    return $query;
}
add_filter('pre_get_posts','typecase_search_opt');
}

if ( !function_exists( 'typecase_rm_type' ) ){
add_action( 'template_redirect', 'typecase_rm_type' );
function typecase_rm_type() {
  ob_start( function ( $type ) {
    return preg_replace( "%[ ]type=['\"]text\/(javascript|css)['\"]%", '', $type );
  } );
}
}
if ( ! function_exists( 'typecase_source' ) ) {
    function typecase_source() {
        $source_options = get_post_meta( get_the_ID(), 'source_options', true );
        $output = '';
        if(!empty($source_options)){
            $output .= '<span class="vt_source_w">';
            $output .= esc_html('Soruce: ', 'typecase');
            foreach ($source_options as $criteria) {
                if($criteria['c_label']){                    
                    $output .=  '<a href="'.esc_url($criteria['url']).'" target="_blank" rel="nofollow">'.esc_html($criteria['c_label']).'</a>';
                }
            }
            $output .= '</span>';
    }
        return $output;
    }
}

if ( ! function_exists( 'typecase_via' ) ) {
    function typecase_via() {
        $via_options = get_post_meta( get_the_ID(), 'via_options', true );
        $output = '';
        if(!empty($via_options)){
            $output .= '<span class="vt_via_w">';
            $output .= esc_html('Via: ', 'typecase');
            foreach ($via_options as $criteria) {
                if($criteria['c_label']){                    
                    $output .= '<a href="'.esc_url($criteria['url']).'" target="_blank" rel="nofollow">'.esc_html($criteria['c_label']).'</a>';
                }
            }
            $output .= '</span>';
        }
        return $output;
    }
}

if ( ! function_exists( 'typecase_rel' ) ) {
    function typecase_rel() {
    if(get_theme_mod('disable_post_related') !=1){
        typecase_ads_related_above();
        $args = array(
        'posts_per_page' => 4,
        'post__not_in'   => array( get_the_ID() ),
        'no_found_rows'  => true,
        );
        $cats = wp_get_post_terms( get_the_ID(), 'category' );
        $cats_ids = array();
        foreach( $cats as $related_cat ) {
            $cats_ids[] = $related_cat->term_id;
        }
        if ( ! empty( $cats_ids ) ) {
            $args['category__in'] = $cats_ids;
        }
        $post_query = new wp_query( $args );
        if ( $post_query->have_posts() ) {
        ?>
        <div class="vt_relsec_wrap">
            <div class="vt_relsec">
                <div class="vt_relsec_in">
                <h4><?php esc_html_e('Related Articles', 'typecase'); ?></h4>
                    <div class="vt_rel_posts">
                    <?php while ( $post_query->have_posts() ) {
                        $post_query->the_post();
                        $post_id = get_the_ID();
                        $categories = get_the_category(get_the_ID());
                        typecase_rgrid();
                    }?>
                    </div>
                </div>
            </div>
        </div>
    <?php }
wp_reset_postdata();
typecase_ads_related_below();
}}}
if ( ! function_exists( 'typecase_rgrid' ) ) {
function typecase_rgrid() {?>
    <div class="vt_cgrid_layout">
		<?php if ( has_post_thumbnail()) {?>
			<div class="vt_img_holder">
			    <div class="vt_imgw vt_radus_e">
			        <div class="vt_imgin">
			            <?php the_post_thumbnail('typecase_layouts');?>
			        </div>
			        <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			        <a class="vt_imgl" href="<?php the_permalink();?>"></a>
                    <?php typecase_post_tumb_cat(get_the_ID());?>
			    </div>
			</div>
		<?php }?>
		<div class="vt_fe_text">
			<?php typecase_post_cat(get_the_ID());?>
			<h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			<p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 12, '...' );?> </p>
			<?php typecase_post_meta(get_the_ID());?>
		</div>
	</div>
<?php }
}

if(!function_exists('typecase_vid_wrap')){
    add_filter('embed_oembed_html', 'typecase_vid_wrap', 10, 4);
    function typecase_vid_wrap($html, $url, $attr, $post_ID) {
        if (strpos($url, 'youtube') !== false || strpos($url, 'vimeo') !== false || strpos($url, 'soundcloud') !== false) {
            $html = '<div class="vtvid_container">'.$html.'</div>';
        }
        return $html;
    }
}

if ( !function_exists( 'typecase_generate_dynamic_css' ) ){
    function typecase_generate_dynamic_css() {
        ob_start();
        get_template_part( 'inc/misc/dynamic-css' );
        $output = ob_get_contents();
        $output = typecase_minify_css($output);
        ob_end_clean();
        return $output;
    }
}

if ( !function_exists( 'typecase_editor_dynamic_css' ) ){
    function typecase_editor_dynamic_css() {
        ob_start();
        get_template_part( 'inc/misc/editor-css' );
        $output = ob_get_contents();
        $output = typecase_minify_css($output);
        ob_end_clean();
        return $output;
    }
}

if ( ! function_exists( 'typecase_minify_css' ) ) {
    function typecase_minify_css( $output ) {
        return preg_replace( '@({)\s+|(\;)\s+|/\*.+?\*\/|\R@is', '$1$2 ', $output );
    }
}

function typecase_sanitize_wp_kses( $data ) {
    return wp_kses( $data, array(
        'a' => array(
            'href'  => array(),
            'class'  => array(),
            'style'    => array(),
            'id'  => array(),
            'target'  => array(),
            'rel' => array(),
            'data-format' => array(),
            'class' => array(),
            'data-source' => array(),
            'data-type' => array(),
            'data-src' => array(),
            'title' => array(),
        ),
        'span' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'p' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
            'br'    => array(),
            'a' => array(
                'href'  => array(),
                'class'  => array(),
                'style'    => array(),
                'id'  => array(),
                'target'  => array(),
                'rel' => array(),
                'data-format' => array(),
                'class' => array(),
                'data-source' => array(),
                'data-type' => array(),
                'data-src' => array(),
                'title' => array(),
            ),
        ),
        'h1' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'h2' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'h3' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'h4' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'h5' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'img' => array(
            'src'    => array(),
            'srcset' => array(),
            'alt'    => array(),
        ),
        'div' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'i' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'u' => array(
            'class' => array(),
            'id'    => array(),
            'style'    => array(),
        ),
        'br'     => array(),
        'b'     => array(
            'style'    => array(),
        ),
        'em'     => array(
            'class' => array(),
            'style'    => array(),
        ),
        'ul'     => array(
            'class' => array(),
            'style'    => array(),
        ),
        'ol'     => array(
            'class' => array(),
            'style'    => array(),
        ),
        'li'     => array(
            'class' => array(),
            'style'    => array(),
        ),
        'strong' => array(
            'class' => array(),
            'style'    => array(),
        ),
        'italic' => array(
            'class' => array(),
            'style'    => array(),
        ),
        'iframe'  => array(
            'class' => array(),
            'id'    => array(),
            'src'    => array(),
            'width'    => array(),
            'style'    => array(),
            'height'    => array(),
        ),
    ));
}

function typecase_review_score($num, $type, $star = false) {
    switch ($type) :
      case 'star' :
        if(!$star == false){
          if ( $num <= 2 ) $output = '<span class="vt_star_val">'.$num.'</span><span class="vt_star_i" title="1 star"><i class="vti-star-full"></i><i class="vti-star"></i><i class="vti-star"></i><i class="vti-star"></i><i class="vti-star"></i></span>';
          if ( $num > 2 && $num <= 4 )
          $output = '<span class="vt_star_val">'.$num.'</span><span class="vt_star_i" title="2 stars"><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star"></i><i class="vti-star"></i><i class="vti-star"></i></span>';
          if ( $num > 4 && $num <= 6 )
          $output = '<span class="vt_star_val">'.$num.'</span><span class="vt_star_i" title="3 stars"><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star"></i><i class="vti-star"></i></span>';
          if ( $num > 6 && $num <= 8 )
          $output = '<span class="vt_star_val">'.$num.'</span><span class="vt_star_i" title="4 stars"><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star"></i></span>';
          if ( $num > 8 && $num <= 10 )
          $output = '<span class="vt_star_val">'.$num.'</span><span class="vt_star_i" title="5 stars"><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star-full"></i><i class="vti-star-full"></i></span>';
        } else {
          $output = $num;
        }
        break;

      case 'letter' :
        if ( $num <= 2 ) $output = 'E';
        if ( $num > 2 && $num <= 4 ) $output = 'D';
        if ( $num > 4 && $num <= 6 ) $output = 'C';
        if ( $num > 6 && $num <= 8 ) $output = 'B';
        if ( $num > 8 && $num <= 10 ) $output = 'A';
        break;

      case 'percent';
        $output = $num * 10 . '<span class="vt_score_sign">%</span>';
        break;

      case 'percent_front';
        $output = $num * 10;
        break;

      case 'number';
        $output = $num + 0;
        break;

    endswitch;
    if(isset($output)){
    return $output;
    }
}

function typecase_review_box($post_id, $class) {
    $single_post_review = get_post_meta( $post_id, 'single_post_review', true );
    $review_box_title = get_post_meta( $post_id, 'review_box_title', true );
    $review_summary = get_post_meta( $post_id, 'review_summary', true );
    $review_imageid = get_post_meta( $post_id, 'review_image', true );
    $review_color = get_post_meta( $post_id, 'review_color', true );
    $review_pos = get_post_meta( $post_id, 'review_pos', true );
    $review_neg = get_post_meta( $post_id, 'review_neg', true );
    $rating_type = get_post_meta( $post_id, 'rating_type', true );
    $review_btn_label = get_post_meta( $post_id, 'review_btn_label', true );
    $review_btn_url = get_post_meta( $post_id, 'review_btn_url', true );
    $rating_type_front = esc_attr('percent_front');
    $rating_criteria = get_post_meta( $post_id, 'rating_criteria', true );
    if($single_post_review){
    if(empty($rating_criteria)){
      $rating_criteria = '';
      $rating_criteria_count = '';
    }else{
      $rating_criteria_count = count($rating_criteria);
    }
    if(empty($review_color)){
      $review_color = esc_attr('#ffcd00');
    }
    $score_array = array();
    if($rating_criteria){
      foreach ($rating_criteria as $criteria) {
        $score_array []= $criteria['score'];
      }
    }
    $final_score = array_sum($score_array);
    $final_score = $final_score / $rating_criteria_count;
    $final_score = number_format($final_score, 1, '.', '');

    $value = typecase_review_score($final_score, $rating_type_front, true);
    $full = 180;
    if($value <= 50){
    $right = $value * 3.6;
    $right = $full-$right;
    $right = '-'. $right;
    }else{
    $right = 0;
    }
    if($value > 50){
    $left = $value -50;
    $left = $left * 3.6;
    $left = $full+$left;
    }else{
    $left = 0;
    }

    $output = '';
    $output .= '<div id="vt-review-box">';
    $output .= '<div class="vt_score_h">';
    if (!empty($review_imageid)) {
    $output .= wp_get_attachment_image( $review_imageid, 'typecase_medium', true );
    }
    $output .= '<div class="vt_score_main_w">';
    $output .= '<div class="vt_score_main">';
    if($rating_type == "star"){
    $output .= '<span class="vt_star_re_w"><span class="vt_star_re" style="background-color:'.esc_attr($review_color).';">'.typecase_review_score($final_score, $rating_type, true).'</span></span>';
    }else{
    $output .= '<div class="container-donut">';
    $output .= '<div class="vt-renut-container">';
    $output .= '<div class="vt-renut">';
    $output .= '<div class="vt-renut-sections" style="transform: rotate(0deg);">';
    $output .= '<div class="vt-renut-section vt-renut-section-right" style="transform: rotate(0deg);">';
    $output .= '<div class="vt-renut-filler" style="background-color:'.esc_attr($review_color).'; transform: rotate('.esc_attr($right).'deg);">';
    $output .= '</div>';
    $output .= '</div>';
    if($value > 50){
    $output .= '<div class="vt-renut-section vt-renut-section-left" style="transform: rotate(0deg);">';
    $output .= '<div class="vt-renut-filler" style="background-color:'.esc_attr($review_color).'; transform: rotate('.esc_attr($left).'deg);">';
    $output .= '</div>';
    $output .= '</div>';
    }
    $output .= '</div>';
    $output .= '<div class="vt-renut-overlay">';
    $output .= '<div class="vt-renut-text">';
    $output .= '<div>';
    $output .= '<span>'.typecase_review_score($final_score, $rating_type, true).'</span>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    }
    $output .= '</div>';
    $output .= '<div class="review-ht">';
    $output .= '<h5 class="itemreviewed">'.esc_html($review_box_title).'</h5>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="vt_rw_w">';
    $output .= '<div class="vt_ideas_sum">';
    $output .= '<div class="vt_sub_title">';
    $output .= '<h6 class="vt_sum_title">'.esc_html( 'Summary', 'typecase' ).'</h6>';
    $output .= '<p>'.esc_html($review_summary).'</p>';
    $output .= '</div>';
    $output .= '<div class="vt_pcw">';
    if($review_pos){
      $output .= '<div class="vt_review_pros">';
      $output .= '<h6>'.esc_html('The Pros', 'typecase').'</h6>';
      $output .= '<span>'.str_replace(array("\r","\n\n","\n"),array('',"\n","</span>\n<span>"),trim($review_pos,"\n\r")).'</span>';
      $output .= '</div>';
    }
    if($review_neg){
      $output .= '<div class="vt_review_cons">';
      $output .= '<h6>'.esc_html('The Cons', 'typecase').'</h6>';
      $output .= '<span>'.str_replace(array("\r","\n\n","\n"),array('',"\n","</span>\n<span>"),trim($review_neg,"\n\r")).'</span>';
      $output .= '</div>';
    }
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<ul>';
    if($rating_criteria){
      foreach ($rating_criteria as $criteria) {
        $percentage_score = $criteria['score'] * 10;

        if($criteria['c_label'])
        $output .= '<li><div class="review-criteria-score clearfix"><span class="left">'.esc_html($criteria['c_label']).'</span><span class="right">'.typecase_review_score($criteria['score'], $rating_type, true).'</span></div>';
        $output .= '<div class="review-criteria-bar-container"><div class="review-criteria-bar" style="background:'.esc_attr($review_color).'; width:'.esc_attr($percentage_score).'%"></div></div></li>';

      }
    }
    $output .= '</ul>';
    if( !empty($review_btn_label) ){
    $output .= '<span class="rw_btnw"><a class="rw_btn" href="'.esc_url($review_btn_url).'" target="_blank">'.esc_html($review_btn_label).'<svg fill="none" stroke="currentColor" stroke-width="1.5px" xmlns="http://www.w3.org/2000/svg" width="23" viewBox="0 0 15.976 11.969"><path d="m9.469.527 5.447 5.516-5.447 5.392"></path><g><path d="M0 5.974h14.5"></path></g><g><path d="M0 5.974h14.5"></path></g></svg></a></span>';
}
    $output .= '</div>';
    $output .= '</div>';
    return $output;    
    }
}
function typecase_review_bar($post_id, $class, $echo = true) {
    $single_post_review = get_post_meta( $post_id, 'single_post_review', true );
    $review_box_title = get_post_meta( $post_id, 'review_box_title', true );
    $review_summary = get_post_meta( $post_id, 'review_summary', true );
    $review_color = get_post_meta( $post_id, 'review_color', true );
    $review_pos = get_post_meta( $post_id, 'review_pos', true );
    $review_neg = get_post_meta( $post_id, 'review_neg', true );
    $rating_type = get_post_meta( $post_id, 'rating_type', true );
    if($rating_type == 'star'){
        $rating_type = esc_attr('number');
    }else{
        $rating_type = get_post_meta( $post_id, 'rating_type', true );
    }
    $rating_type_front = esc_attr('percent_front');
    $rating_criteria = get_post_meta( $post_id, 'rating_criteria', true );
    if($single_post_review){
    if(empty($rating_criteria)){
      $rating_criteria = '';
      $rating_criteria_count = '';
    }else{
      $rating_criteria_count = count($rating_criteria);
    }
    if(empty($review_color)){
      $review_color = esc_attr('#ffcd00');
    }
    $score_array = array();
    if($rating_criteria){
      foreach ($rating_criteria as $criteria) {
        $score_array []= $criteria['score'];
      }

    $final_score = array_sum($score_array);
    $final_score = $final_score / $rating_criteria_count;
    $final_score = number_format($final_score, 1, '.', '');

    $value = typecase_review_score($final_score, $rating_type_front, true);

    $full = 180;
    if($value <= 50){
    $right = $value * 3.6;
    $right = $full-$right;
    $right = '-'. $right;
    }else{
    $right = 0;
    }
    if($value > 50){
    $left = $value -50;
    $left = $left * 3.6;
    $left = $full+$left;
    }else{
    $left = 0;
    }

    $output = '';

    $output .= '<div class="container-donut vt-donut-front">';
    $output .= '<div class="vt-renut-container">';
    $output .= '<div class="vt-renut">';
    $output .= '<div class="vt-renut-sections" style="transform: rotate(0deg);">';
    $output .= '<div class="vt-renut-section vt-renut-section-right" style="transform: rotate(0deg);">';
    $output .= '<div class="vt-renut-filler" style="background-color:'.$review_color.'; transform: rotate('.$right.'deg);">';
    $output .= '</div>';
    $output .= '</div>';
    if($value > 50){
    $output .= '<div class="vt-renut-section vt-renut-section-left" style="transform: rotate(0deg);">';
    $output .= '<div class="vt-renut-filler" style="background-color:'.$review_color.'; transform: rotate('.$left.'deg);">';
    $output .= '</div>';
    $output .= '</div>';
    }
    $output .= '</div>';
    $output .= '<div class="vt-renut-overlay">';
    $output .= '<div class="vt-renut-text">';
    $output .= '<div>';
    $output .= '<span>'.typecase_review_score($final_score, $rating_type, true).'</span>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';
}else{
    $output = '';
}

    if($echo == 'true') :
    print '<span class="vt_none"></span>'.$output;
    else :
    return $output;
    endif;
    }
}
if ( ! function_exists( 'typecase_foot_feed' ) ) {
function typecase_foot_feed() {?>
<div class="vt-insta-foot">
    <?php
        if(get_theme_mod('insta_label', esc_html__('Follow Me', 'typecase'))){?>
            <span class="i_foot_l">
                <?php if(get_theme_mod('insta_link')){?>
                <a target="_blank" href="<?php echo esc_url(get_theme_mod('insta_link')); ?>"><?php }?>
                    <i class="vti-instagram"></i>
                    <?php echo esc_html(get_theme_mod('insta_label', esc_html__('Follow Me', 'typecase'))); ?>
                <?php if(get_theme_mod('insta_link')){?></a><?php }?>
            </span>
        <?php } ?>
    <?php if ( function_exists( 'sb_instagram_feed_init' ) ) { echo do_shortcode('[instagram-feed num='.get_theme_mod('insta_col',6).' cols='.get_theme_mod('insta_col',6).' imagepadding=0 showheader=false showbutton=false showfollow=false disablemobile=true]'); }?>
</div>
<?php }}
if ( ! function_exists( 'typecase_head_share' ) ) {
function typecase_head_share() {
if(!get_theme_mod('disable_social_icons')==1){?>
                            <ul class="social_icon_header_top vt_socialcolor">
                                <?php if(get_theme_mod('facebook')){?>
                                <li><a class="facebook" href="<?php echo esc_url(get_theme_mod('facebook'));?>" target="_blank"><i class="vti-facebook"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('vk')){?>
                                <li><a class="vk" href="<?php echo esc_url(get_theme_mod('vk'));?>" target="_blank"><i class="vti-vk"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('telegram')){?>
                                <li><a class="telegram" href="<?php echo esc_url(get_theme_mod('telegram'));?>" target="_blank"><i class="vti-telegram"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('behance')){?>
                                <li><a class="behance" href="<?php echo esc_url(get_theme_mod('behance'));?>" target="_blank"><i class="vti-behance"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('vimeo')){?>
                                <li><a class="vimeo" href="<?php echo esc_url(get_theme_mod('vimeo'));?>" target="_blank"><i class="vti-vimeo"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('youtube')){?>
                                <li><a class="youtube" href="<?php echo esc_url(get_theme_mod('youtube'));?>" target="_blank"><i class="vti-youtube"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('instagram')){?>
                                <li><a class="instagram" href="<?php echo esc_url(get_theme_mod('instagram'));?>" target="_blank"><i class="vti-instagram"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('linkedin')){?>
                                <li><a class="linkedin" href="<?php echo esc_url(get_theme_mod('linkedin'));?>" target="_blank"><i class="vti-linkedin"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('pinterest')){?>
                                <li><a class="pinterest" href="<?php echo esc_url(get_theme_mod('pinterest'));?>" target="_blank"><i class="vti-pinterest"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('twitter')){?>
                                <li><a class="twitter" href="<?php echo esc_url(get_theme_mod('twitter'));?>" target="_blank"><i class="vti-twitter"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('deviantart')){?>
                                <li><a class="deviantart" href="<?php echo esc_url(get_theme_mod('deviantart'));?>" target="_blank"><i class="vti-deviantart"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('dribble')){?>
                                <li><a class="dribble" href="<?php echo esc_url(get_theme_mod('dribble'));?>" target="_blank"><i class="vti-dribbble"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('dropbox')){?>
                                <li><a class="dropbox" href="<?php echo esc_url(get_theme_mod('dropbox'));?>" target="_blank"><i class="fvti-dropbox"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('rss')){?>
                                <li><a class="rss" href="<?php echo esc_url(get_theme_mod('rss'));?>" target="_blank"><i class="vti-rss"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('skype')){?>
                                <li><a class="skype" href="<?php echo esc_url(get_theme_mod('skype'));?>" target="_blank"><i class="vti-skype"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('stumbleupon')){?>
                                <li><a class="stumbleupon" href="<?php echo esc_url(get_theme_mod('stumbleupon'));?>" target="_blank"><i class="vti-stumbleupon"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('wordpress')){?>
                                <li><a class="wordpress" href="<?php echo esc_url(get_theme_mod('wordpress'));?>" target="_blank"><i class="vti-wordpress"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('yahoo')){?>
                                <li><a class="yahoo" href="<?php echo esc_url(get_theme_mod('yahoo'));?>" target="_blank"><i class="vti-yahoo"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('sound_cloud')){?>
                                <li><a class="sound_cloud" href="<?php echo esc_url(get_theme_mod('sound_cloud'));?>" target="_blank"><i class="vti-soundcloud"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('spotify_i')){?>
                                <li><a class="spotify_i" href="<?php echo esc_url(get_theme_mod('spotify_i'));?>" target="_blank"><i class="vti-spotify"></i></a></li>
                                <?php }?>
                                <?php if(get_theme_mod('wechat')){?>
                                <li><a class="wechat" href="<?php echo esc_url(get_theme_mod('wechat'));?>" target="_blank"><i class="vti-wechat"></i></a></li>
                                <?php }?>
                            </ul>
                            <?php }
}
}
add_action( 'wp_ajax_nopriv_typecase_loadnavs', 'typecase_loadnavs' );
add_action( 'wp_ajax_typecase_loadnavs', 'typecase_loadnavs' );
if ( ! function_exists( 'typecase_loadnavs' ) ) {
    function typecase_loadnavs() {
        $module            = array();
        $response            = array();
        $response['content'] = '';
        $notice_class        = 'vt_end_wrp';

        if ( ! empty( $_POST['data'] ) ) {
            $module = typecase_module_opt( $_POST['data'] );
        }
        if ( empty( $module['page_next'] ) ) {
            $module['page_next'] = 2;
        }
        $query_data = typecase_query( $module, intval( $module['page_next'] ) );
        add_filter( 'wp_get_attachment_image_attributes', 'typecase_lsmall_img', 10, 3 );
        if ( $query_data->have_posts() ) {
            $response['page_max'] = $query_data->max_num_pages;

            if ( ! empty( $query_data->paged ) ) {
                $response['page_current'] = $query_data->paged;
            } else {
                $response['page_current'] = $module['page_next'];
            }
            if ( $response['page_current'] == $response['page_max'] ) {}

            $response['content'] = typecase_ajax_get_content( $module, $query_data );

            wp_reset_postdata();
        }

        wp_send_json( $response, null );
    }
}

if ( ! function_exists( 'typecase_menu_cat_opt' ) ) {
    add_action( 'wp_ajax_nopriv_typecase_menu_cat_opt', 'typecase_menu_cat_opt' );
    add_action( 'wp_ajax_typecase_menu_cat_opt', 'typecase_menu_cat_opt' );
    function typecase_menu_cat_opt() {
        $module                    = array();
        $data_response            = array();
        $data_response['content'] = '';
        if ( ! empty( $_POST['data'] ) ) {
            $module = typecase_module_opt( $_POST['data'] );
        }
        $data_query = typecase_query( $module );
        if ( ! empty( $data_query->max_num_pages ) ) {
            $data_response['page_max'] = $data_query->max_num_pages;
        }
        $data_response['content'] = typecase_ajax_get_content( $module, $data_query );
        wp_reset_postdata();
        die( json_encode( $data_response ) );
    }
}


if ( ! function_exists( 'typecase_module_opt' ) ) {
    function typecase_module_opt( $module ) {
        if ( is_array( $module ) ) {
            foreach ( $module as $key => $val ) {
                $key              = sanitize_text_field( $key );
                $module[ $key ] = sanitize_text_field( $val );
            }
        } elseif ( is_string( $module ) ) {
            $module = sanitize_text_field( $module );
        } else {
            $module = '';
        }
        return $module;
    }
}

if ( ! function_exists( 'typecase_ajax_get_content' ) ) :
    function typecase_ajax_get_content( $module = array(), $query_data = null ) {
        if ( empty( $module['section_style'] ) ) {
            $module['section_style'] = 'vt_mgrid';
        }
        ob_start();
        switch ( $module['section_style'] ) {
            case 'vt_lgrid' :
                typecase_lgrid_listing( $module, $query_data );
            break;
            case 'vt_mgrid' :
                typecase_mgrid_listing( $module, $query_data );
            break;
            case 'vt_g_number' :
                typecase_g_number_listing( $module, $query_data );
            break;
            case 'vt_li_number' :
                typecase_li_number_listing( $module, $query_data );
            break;
            case 'vt_m_list_mix' :
                typecase_m_list_mix_listing( $module, $query_data );
            break;
            case 'vt_magrid' :
                typecase_magrid_listing( $module, $query_data );
            break;
            case 'vt_mgrid_overlay' :
                typecase_mgrid_overlay_listing( $module, $query_data );
            break;
            case 'vt_m_list' :
                typecase_m_list_listing( $module, $query_data );
            break;
            case 'vt_sg' :
                typecase_sg_listing( $module, $query_data );
            break;
            case 'mega_grid' :
                typecase_menu_g_listing( $module, $query_data );
            break;
            case 'mega_grid_overlay' :
                typecase_ov_listing( $module, $query_data );
            break;
            case 'mega_small_list' :
                typecase_sm_listing( $module, $query_data );
            break;
            case 'vt_feature_15' :
                typecase_feature_15_listing( $module, $query_data );
            break;
            case 'vt_feature_16' :
                typecase_feature_16_listing( $module, $query_data );
            break;
            case 'vt_feature_17' :
                typecase_feature_17_listing( $module, $query_data );
            break;
            case 'large_layout1' :
                typecase_large_layout1( $module, $query_data );
            break;
            case 'large_layout2' :
                typecase_large_layout2( $module, $query_data );
            break;
            case 'large_layout3' :
                typecase_large_layout3( $module, $query_data );
            break;
            case 'large_layout4' :
                typecase_large_layout4( $module, $query_data );
            break;
            case 'large_layout5' :
                typecase_large_layout5( $module, $query_data );
            break;
        }
        return ob_get_clean();
    }
endif;

if ( ! function_exists( 'typecase_get_ajax_attributes' ) ) :
    function typecase_get_ajax_attributes( $module = array(), $query_data = null ) {
        if ( null == $query_data ) {
            return;
        }

        if ( empty( $module['blockid'] ) || ( empty( $module['pagination'] ) && empty( $module['tabs_link'] ) ) ) {
            return;
        }
        if ( ! empty( $query_data->max_num_pages ) && ! isset( $module['page_max'] ) ) {
            $module['page_max'] = $query_data->max_num_pages;
        }
        $module['page_current'] = 1;
        $defaults = array(
            'blockid'          => '',
            'section_style'    => '',            
            'post_type'        => '',
            'term_slugs'       => '',
            'post_type_tax'    => '',
            'page_max'         => '',
            'page_current'     => '',
            'category'         => '',
            'categories'       => '',
            'tags'             => '',
            'format'           => '',
            'author'           => '',
            'post_not_in'      => '',
            'post_in'          => '',
            'order'            => '',
            'posts_per_page'   => '',
            'offset'           => '',
            'text_style'       => '',
            'post_columns'     => '',
            'tabs_link'        => '',
            'tabs_link_ids'    => '',
            'show_excep'       => '',
            'sl_type'          => '',
        );
        foreach ( $defaults as $key => $val ) {
            if ( ! empty( $module[ $key ] ) ) {
                echo 'data-' . $key . '="' . esc_attr( $module[ $key ] ) . '" ';
            }
        }
    }
endif;

if ( ! function_exists( 'typecase_blocknav' ) ) :
    function typecase_blocknav( $module, $query_data = null ) {
        if ( empty( $module['pagination'] ) ) {
            return false;
        }
        switch ( $module['pagination'] ) {
            case 'loadmore' :
                typecase_blocknav_loadmore( $query_data );
                break;
            case 'next_prev' :
                typecase_blocknav_nextprev( $query_data );
                break;
            case 'autoload' :
                typecase_blocknav_autoload( $query_data );
            break;
            default:
                return false;
        }
    }
endif;

if ( ! function_exists( 'typecase_blocknav_autoload' ) ):
    function typecase_blocknav_autoload( $query_data = null ) {

        if ( empty( $query_data ) || ! is_object( $query_data ) ) {
            global $wp_query;
            $query_data = $wp_query;
        }
        if ( $query_data->max_num_pages < 2 ) {
            return false;
        } ?>
        <div class="vt_el_nav_w">
           <div class="vt_lmore_wrap">
               <div class="vt_autoload">
               <span class="vt-load-animation"><span></span></span>
               </div>
           </div>
        </div>
    <?php
    }
endif;

if ( ! function_exists( 'typecase_blocknav_loadmore' ) ) :
    function typecase_blocknav_loadmore( $query_data = null ) {

        if ( empty( $query_data ) || ! is_object( $query_data ) ) {
            global $wp_query;
            $query_data = $wp_query;
        }

        if ( $query_data->max_num_pages < 2 ) {
            return false;
        } ?>
        <div class="vt_el_nav_w">
           <div class="vt_lmore_wrap">
               <div class="vt_lmore_c">
               <a href="#" class="vt-load-link"><span><?php echo esc_html__( 'load more', 'typecase' ); ?></span></a>
               <span class="vt-load-animation"><span></span></span>
               </div>
           </div>
        </div>
    <?php
    }
endif;

if ( ! function_exists( 'typecase_blocknav_nextprev' ) ):
    function typecase_blocknav_nextprev( $query_data = null ) {

        if ( empty( $query_data ) || ! is_object( $query_data ) ) {
            global $wp_query;
            $query_data = $wp_query;
        }
        if ( $query_data->max_num_pages < 2 ) {
            return false;
        } ?>
        <div class="vt_el_nav_w vt_nxpre">
           <div class="pagination-wrap pagination-nextprev clearfix">
               <a href="#" class="vt-foot-nav vt-block-link vt-prev-nav vt_disable" data-type="prev"><i class="vti-left-chevron"></i></a>
               <a href="#" class="vt-foot-nav vt-block-link vt-next-nav" data-type="next"><i class="vti-right-chevron"></i></a>
           </div>
        </div>
    <?php
    }
endif;


if ( ! function_exists( 'typecase_query' ) ) {
    function typecase_query( $data = array(), $paged = null ) {

        $defaults = array(
            'categories'          => '',
            'category'            => '',
            'author'              => '',
            'format'              => '',
            'tags'                => '',
            'tag_in'              => '',
            'posts_per_page'      => '',
            'paged'               => '',
            'no_found_rows'       => false,
            'offset'              => '',
            'order'               => 'date_post',
            'post_type'           => 'post',
            'meta_key'            => '',
            'post_in'             => '',
            'post_not_in'         => '',
            'tax_query'           => array(),
            'ignore_sticky_posts' => 1
        );

        $data = wp_parse_args( $data, $defaults );

        $params = array();

        $params['post_status']         = 'publish';
        $params['ignore_sticky_posts'] = $data['ignore_sticky_posts'];
        $params['post_type']           = $data['post_type'];
        $params['no_found_rows']       = boolval( $data['no_found_rows'] );
        $params['tax_query']           = array();

        if ( ! empty( $data['posts_per_page'] ) ) {
            $params['posts_per_page'] = intval( $data['posts_per_page'] );
        }

        if ( ! empty( $data['post_in'] ) ) {
            if ( is_string( $data['post_in'] ) ) {
                $params['post__in'] = explode( ',', $data['post_in'] );
            } elseif ( is_array( $data['post_in'] ) ) {
                $params['post__in'] = $data['post_in'];
            }
        } elseif ( ! empty( $data['post_not_in'] ) ) {
            if ( is_array( $data['post_not_in'] ) ) {
                $params['post__not_in'] = $data['post_not_in'];
            } else {
                $params['post__not_in'] = explode( ',', $data['post_not_in'] );
            }
        }
        if ( ! empty( $data['categories'] ) && 'all' != $data['categories'] ) {
            if ( is_array( $data['categories'] ) ) {
                $params['cat'] = implode( ',', $data['categories'] );
            } elseif ( is_string( $data['categories'] ) ) {
                $params['cat'] = trim( $data['categories'] );
            }
        } elseif ( ! empty( $data['category'] ) && 'all' != $data['category'] ) {
            $params['cat'] = $data['category'];
        }

        if ( ! empty( $data['author'] ) ) {
            $params['author'] = $data['author'];
        }

        if ( ! empty( $data['format'] ) && 'post' == $data['post_type'] ) {
            if ( 'default' != $data['format'] ) {
                $params['tax_query'][] = array(
                    'taxonomy' => 'post_format',
                    'field'    => 'slug',
                    'terms'    => array( 'post-format-' . trim( $data['format'] ) ),
                );
            } else {
                $params['tax_query'][] = array(
                    'taxonomy' => 'post_format',
                    'field'    => 'slug',
                    'terms'    => array( 'post-format-gallery', 'post-format-video', 'post-format-audio' ),
                    'operator' => 'NOT IN',
                );
            }
        }

            // if ( ! empty( $data['tax_query'] ) ) {
            // $params['tax_query'][] = $data['tax_query'];            
            // }

            if ( ! empty( $data['term_slugs'] ) && is_string( $data['term_slugs'] ) ) {
                $data['term_slugs'] = explode( ',', $data['term_slugs'] );
                if ( is_array( $data['term_slugs'] ) ) {
                    $params['tax_query'] = array( 'relation' => 'OR' );
                    foreach ( $data['term_slugs'] as $val ) {
                        array_push( $params['tax_query'], array(
                            'taxonomy' => $data['post_type_tax'],
                            'field'    => 'slug',
                            'terms'    => trim( $val )
                        ) );
                    }
                }
            }        

        if ( ! empty( $paged ) ) {
            $params['paged'] = intval( $paged );
        } elseif ( ! empty( $data['paged'] ) ) {
            $params['paged'] = intval( $data['paged'] );
        }

        if ( ! empty( $data['offset'] ) ) {
            if ( $paged > 1 ) {
                $params['offset'] = intval( $data['offset'] ) + intval( ( $paged - 1 ) * intval( $data['posts_per_page'] ) );
            } else {
                $params['offset'] = intval( $data['offset'] );
            }

            unset( $params['paged'] );
        }

        if ( ! empty( $data['tags'] ) ) {
            $data['tags']  = preg_replace( '/\s+/', '', $data['tags'] );
            $params['tag'] = $data['tags'];
        }

        if ( ! empty( $data['tag_in'] ) && is_array( $data['tag_in'] ) ) {
            $params['tag__in'] = $data['tag_in'];
        }

        if ( ! empty( $data['meta_key'] ) ) {
            $params['meta_key'] = $data['meta_key'];
            $params['orderby']  = 'meta_value_num';
        }

        switch ( $data['order'] ) {

            case 'date_post' :
                $params['orderby'] = 'date';
                $params['order']   = 'DESC';
                break;

            case 'comment_count' :
                $params['orderby'] = 'comment_count';
                break;

            case 'post_type' :
                $params['orderby'] = 'type';
                break;

            case 'rand':
                $params['orderby'] = 'rand';
                break;

            case 'alphabetical_order_decs':
                $params['orderby'] = 'title';
                $params['order']   = 'DECS';
                break;

            case 'alphabetical_order_asc':
                $params['orderby'] = 'title';
                $params['order']   = 'ASC';
                break;

            default :
                $params['orderby'] = 'date';
                break;
        }

        $query_data = new WP_Query( $params );
        do_action( 'typecase_after_post_query', $query_data );

        return $query_data;
    }
}

if ( ! function_exists( 'typecase_add_settings_tabs_links' ) ) {
    function typecase_add_settings_tabs_links( $type = 'category', $custom_data = '' ) {

        $data = array();

        switch ( $type ) {

            case 'category' :
                $data_cat = get_categories( array(
                    'include'    => esc_attr( $custom_data ),
                    'number'     => 10,
                    'hide_empty' => 1,
                ) );
                if ( ! empty( $custom_data ) ) {
                    $custom_cat_ids = explode( ',', $custom_data );
                    foreach ( $custom_cat_ids as $custom_cat_id_el ) {
                        $custom_cat_id_el = trim( $custom_cat_id_el );
                        foreach ( $data_cat as $data_cat_el ) {
                            if ( $custom_cat_id_el == $data_cat_el->cat_ID ) {
                                $data[] = array(
                                    'id'   => $data_cat_el->cat_ID,
                                    'name' => $data_cat_el->name
                                );
                            }
                        }
                    }
                } else {
                    foreach ( $data_cat as $data_cat_el ) {
                        $data[] = array(
                            'id'   => $data_cat_el->cat_ID,
                            'name' => $data_cat_el->name
                        );
                    }
                }
                break;

            case 'tag' :
                $data_tag = get_tags( array(
                        'include'    => esc_attr( $custom_data ),
                        'number'     => 10,
                        'hide_empty' => 1
                    )
                );
                if ( ! empty( $custom_data ) ) {
                    $custom_tag_ids = explode( ',', $custom_data );
                    foreach ( $custom_tag_ids as $custom_tag_id_el ) {

                        $custom_tag_id_el = trim( $custom_tag_id_el );
                        foreach ( $data_tag as $data_tag_el ) {
                            if ( $custom_tag_id_el == $data_tag_el->name ) {
                                $data[] = array(
                                    'id'   => $data_tag_el->slug,
                                    'name' => $data_tag_el->name
                                );
                            }
                        }
                    }
                } else {
                    foreach ( $data_tag as $data_tag_el ) {
                        $data[] = array(
                            'id'   => $data_tag_el->slug,
                            'name' => $data_tag_el->name
                        );
                    }
                }
                break;

            case 'author' :
                $data_author = get_users( array(
                        'who'     => 'authors',
                        'include' => esc_attr( $custom_data ),
                    )
                );
                if ( ! empty( $data_author ) && is_array( $data_author ) ) {
                    foreach ( $data_author as $data_author_el ) {
                        $data[] = array(
                            'id'   => $data_author_el->ID,
                            'name' => $data_author_el->display_name
                        );
                    };
                }
                break;
        };

        return $data;
    }
}

add_action( 'wp_ajax_nopriv_typecase_block_link', 'typecase_block_link' );
add_action( 'wp_ajax_typecase_block_link', 'typecase_block_link' );
if ( ! function_exists( 'typecase_block_link' ) ) {
    function typecase_block_link() {

        $module = array();
        $response = array( 'page_max' => '', 'content' => '' );
        if ( ! empty( $_POST['data'] ) ) {
            $module = typecase_module_opt( $_POST['data'] );
        }

        $query_data = typecase_query( $module );
        if ( $query_data->have_posts() ) {
            $response['page_max'] = $query_data->max_num_pages;
            $response['content']  = typecase_ajax_get_content( $module, $query_data );

            wp_reset_postdata();
        }

        wp_send_json( $response, null );
    }
}

if ( ! function_exists( 'typecase_sp_rd' ) ){
    function typecase_sp_rd( $query_data = null ) {
		if ( get_theme_mod('enable_read_progress', 0) == 0 ) {
			return;
		}
        ?>
        <div class="vt_rd_wrap">
            <div class="vt_rd_read" data-key=<?php echo esc_attr(get_the_ID());?>></div>
        </div>
    <?php
    }
}

if ( function_exists( 'amp_init' ) ){
	add_filter( 'amp_customizer_is_enabled', '__return_false' );
    add_filter( 'amp_post_template_file', 'typecase_amp_template_parts', 10, 3 );
	add_filter( 'amp_post_article_footer_meta', 'typecase_amp_args' );
    add_filter( 'amp_post_article_header_meta', 'typecase_amp_meta' );
	add_action( 'amp_post_template_css', 'typecase_amp_extra_css' );	
}

function typecase_amp_template_parts( $file, $type, $post ) {
	if ( 'footer' === $type ) {
		$file = get_theme_file_path( 'inc/amp/footer.php' );
	} elseif ( 'article-footer' === $type ) {
		$file = get_theme_file_path( 'inc/amp/article-footer.php' );
	} elseif ( 'header-bar' === $type ) {
		$file = get_theme_file_path( 'inc/amp/header-bar.php' );
	}
	return $file;
}

function typecase_amp_args( $args ) {
	$args[] = 'article-footer';
	return $args;
}

function typecase_amp_meta( $meta_parts ) {
	if ( get_theme_mod( 'amp_author', 1 ) != 1 ) {
		foreach ( array_keys( $meta_parts, 'meta-author', true ) as $key ) {
			unset( $meta_parts[ $key ] );
		}
	}
	if ( get_theme_mod( 'amp_date', 1 ) != 1 ) {
		foreach ( array_keys( $meta_parts, 'meta-time', true ) as $key ) {
			unset( $meta_parts[ $key ] );
		}
	}
	return $meta_parts;
}

function typecase_amp_extra_css( $amp_template ) {
	?>
    .vt_logo_img{padding: 0px !important; max-width: <?php echo get_theme_mod( 'amp_head_logo_width', '100px' );?> !important; margin: 0px !important; display: flex;}
    .back-top{text-transform: uppercase; font-size: 11px; letter-spacing: 0.1em; color: <?php echo get_theme_mod( 'amp_footer_color', '#FFF' );?> !important; margin: 20px 0; right: 0; bottom: 0; position: relative;}
    .amp-sb-logo{color:<?php echo get_theme_mod( 'amp_sidebar_color', '#fff' );?>; font-weight: 700; margin-bottom: 20px;}
	amp-iframe { width: 100%; }
    .amp-wp-meta img{-o-object-fit: cover; object-fit: cover;}
	.amp-wp-comments-link {padding: 0 20px; }
	.cb-aff-button .cb-icon-wrap { display: none; }
	.amp-wp-comments-link a { background: #111; border-radius: 0px; border: 0; color: #fff; text-transform: uppercase; font-size: 12px; letter-spacing: 1px;  width: 100%; max-width: none; -webkit-box-sizing: border-box; box-sizing: border-box;}
	.amp-wp-comments-link a:hover, .amp-wp-comments-link a:visited, .amp-wp-comments-link a:focus { color: #fff; }
	.amp-wp-article-content amp-img.alignleft { width: 50%; }
	.amp-wp-tax-category a, .amp-wp-tax-tag a { border-radius: 20px; text-decoration: none; background: #111; color: #fff; padding: 5px 10px; text-transform: uppercase; font-weight: 700; letter-spacing: 1px; font-size: 9px; margin-left: 5px; margin-right: -5px;}
	body { background: <?php echo get_theme_mod( 'amp_content_bg', '#fff' );?>; color: <?php echo get_theme_mod( 'amp_content_color', '#000' );?>; }
	.amp-wp-article, .amp-wp-title { color: <?php echo get_theme_mod( 'amp_content_color', '#000' );?>; }
	a, a:visited{ color: <?php echo get_theme_mod( 'amp_content_link', '#f00' );?>; }
	.amp-wp-footer { border-top: 0px; text-align: center; background: <?php echo get_theme_mod( 'amp_footer_bg', '#000' );?>; color: <?php echo get_theme_mod( 'amp_footer_color', '#FFF' );?>;}
	.amp-wp-footer .logo_link{display: flex; justify-content: center;}
    .amp-wp-footer .logo_link .vt_logo_img{margin-bottom: 20px !important; margin-top: 10px !important; max-width: <?php echo get_theme_mod( 'amp_footer_logo_width', '150px' );?> !important;}
    .amp-wp-article-content > p:first-child {margin-top:30px;}
    .amp-wp-article-content > p.has-drop-cap:first-letter {margin-top:10px; font-size: 90px;}
	.amp-wp-article-content .alignnone:not(figure), .amp-wp-article-content .aligncenter:not(figure) {  margin-right: -16px;   margin-left: -16px;   max-width: none; }	
    .amp-wp-footer a { color: <?php echo get_theme_mod( 'amp_footer_link', '#f00' );?>; }
	header.amp-wp-header, header.amp-wp-header a{ color: <?php echo get_theme_mod( 'amp_head_color', '#fff' );?>; }
    amp-sidebar#amp-sb a { color: <?php echo get_theme_mod( 'amp_sidebar_link', '#fff' );?>; }
    header.amp-wp-header .amp-header-inner{ max-width: 840px; display: flex; justify-content: space-between; padding: 0px 15px; margin: 0px auto; align-items: center;}	
	.related_posts_wrap {margin: 40px 0; padding: 0 20px; }
    .related_posts_wrap h3{color: <?php echo get_theme_mod( 'amp_content_color', '#000' );?>;}
    .related_posts_wrap h3, .related_posts_wrap h4, .amp-wp-footer div, amp-sidebar li *{ font-family: -apple-system,BlinkMacSystemFont,"Segoe UI","Roboto","Oxygen-Sans","Ubuntu","Cantarell","Helvetica Neue",sans-serif; }
    .amp-wp-footer div{font-size: 14px;}
    .amp-wp-footer div div{padding: 10px 0px 0px 0px;}
    .related_post_items {margin-bottom: 20px; display: flex; align-items: center; gap: 15px;}
    .related_post_items a {text-decoration: none;display: flex; color: <?php echo get_theme_mod( 'amp_content_color', '#000' );?>;}
	.related_post_items .amp_img_w {line-height: 0; width: 75px; height: 75px; }	
	.related_post_items h4{margin: 0px;line-height: 1.2; font-size: 15px;}
    header.amp-wp-header {padding: 20px 0; position: sticky; top: 0; z-index: 2;}
	header.amp-wp-header { background: <?php echo get_theme_mod( 'amp_head_bg', '#000' );?>; }
    amp-sidebar { background: <?php echo get_theme_mod( 'amp_sidebar_bg', '#111' );?>; }
	header.amp-wp-header .logo {display: block; margin: 0 auto; padding: 0 20px; line-height: 0; }
	amp-sidebar {width: 80vw; padding: 30px 45px 30px 30px; -webkit-box-sizing: border-box; box-sizing: border-box; }
	amp-sidebar a {text-decoration: none; font-size: 15px;}
	amp-sidebar li {margin-bottom: 7px; list-style: none; }
    .amp-wp-header .amp-header-logo{margin: 0px; max-width: unset; padding: 0px; font-weight: 700;}
	.amp-wp-header .header-right, .amp-wp-header .header-left {margin: 0; width: 30px; padding: 0px; cursor: pointer;max-width: unset;}
	.amp-sb-open {width: 30px; height: 2px; position: relative; margin: 0 auto; display: block; background: <?php echo get_theme_mod( 'amp_head_color', '#fff' );?>;}	
	.amp-sb-open:before, .amp-sb-open:after {width: inherit; display: block; height: inherit; background: inherit; content: ''; position: absolute; }
	.amp-sb-logo .logo {margin-bottom: 30px; }
	.amp-sb-open:before {top: -7px; }
	.amp-sb-open:after {top: 7px; }
	.amp-sb-close {width: 20px; height: 20px; position: absolute; top: 25px; right: 30px; cursor: pointer;}
	.amp-sb-close:before, .amp-sb-close:after {position: absolute; left: 10px; content: ''; height: 20px; width: 2px; background: <?php echo get_theme_mod( 'amp_sidebar_color', '#fff' );?>; }
	.amp-sb-close:before {transform: rotate(45deg); }
	.amp-sb-close:after {transform: rotate(-45deg); }
	.share-button-fb {background: #3b5998; margin-right: 20px; }
    .typecase-share-buttons { display: flex; gap: 10px; justify-content: space-between; padding: 20px;}
	amp-social-share.button__share {align-items: center; display: flex; justify-content: center; height: 44px !important; padding: 0px !important; margin: 0px !important; text-align: center; color: #fff; -webkit-transition: .2s ease-out; transition: .2s ease-out; list-style: none; flex-grow: 1; flex-basis: 0;}
	amp-social-share.button__share svg{width: 15px; height: auto; fill: #fff;}
    amp-social-share.button__share.share-button-pin svg{width: 12px;}
    .share-button-pin {margin-right: 20px; background: #bd081c; }
	.share-button-tw { background: #1da1f2; }
	.share-button-wa { background: #00ec67; }	
	.header-right { margin-left: auto; }
	.amp-ad-wrap { text-align: center; margin: 30px 0; }
	<?php
}

add_theme_support( 'woocommerce', array(
            'gallery_thumbnail_image_width' => 120,
            'thumbnail_image_width'         => 380,
            'single_image_width'            => 1000,
        ) );
add_action( 'woocommerce_before_shop_loop_item_title', 'typecase_buttons_wrapper_open', 15 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 25 );
add_action( 'woocommerce_before_shop_loop_item_title', 'typecase_buttons_wrapper_close', 95 );
add_action( 'woocommerce_before_shop_loop_item_title', 'typecase_loop_product_thumbnail', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'typecase_loop_product_title', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 12 );
add_action( 'woocommerce_checkout_before_customer_details', 'typecase_checkout_customer_details_before' );
add_action( 'woocommerce_checkout_after_customer_details', 'typecase_checkout_customer_details_after' );
add_action( 'woocommerce_checkout_after_order_review', 'typecase_checkout_order_after' );
add_action( 'woocommerce_after_cart', 'typecase_cart_after', 20 );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display', 25 );
add_action( 'woocommerce_before_single_product', 'typecase_single_product_before', 5 );
add_action( 'woocommerce_after_single_product', 'typecase_single_product_after', 25 );
add_action( 'woocommerce_before_single_product_summary', 'typecase_single_product_image_before', 1 );
add_action( 'woocommerce_before_single_product_summary', 'typecase_single_product_summary_before', 100 );
add_action( 'woocommerce_after_single_product_summary', 'typecase_single_product_summary_after', 1 );
add_action( 'woocommerce_after_main_content', 'woocommerce_get_sidebar', 5 );
add_action( 'woocommerce_before_shop_loop', 'typecase_wc_before_shop_loop', 5 );
add_action( 'woocommerce_no_products_found', 'typecase_wc_before_shop_loop', 5 );
add_action( 'woocommerce_after_shop_loop', 'typecase_wc_after_shop_loop', 99 );
add_action( 'woocommerce_no_products_found', 'typecase_wc_after_shop_loop', 99 );
add_action( 'woocommerce_after_main_content', 'typecase_wc_after_main_content', 10 );
add_action( 'woocommerce_before_shop_loop', 'typecase_wc_before_result_count', 19 );
add_action( 'woocommerce_before_shop_loop', 'typecase_wc_after_catalog_ordering', 31 );
add_action( 'woocommerce_before_main_content', 'typecase_remove_single_breadcrumb', 1 );
add_action( 'woocommerce_after_quantity_input_field', 'typecase_wc_quantity_button' );
add_filter( 'woocommerce_add_to_cart_fragments', 'typecase_wc_add_to_cart', 10 );
add_filter( 'woocommerce_output_related_products_args', 'typecase_wc_related_posts_per_page' );
add_filter( 'woocommerce_product_additional_information_heading', 'typecase_additional_information_heading' );
add_filter( 'woocommerce_get_image_size_single', 'typecase_wc_image_size_single', 10 );
add_filter( 'loop_shop_per_page', 'typecase_wc_shop_products_per_page', 99 );
add_filter( 'woocommerce_cross_sells_columns', 'typecase_wc_cross_sells_columns' );
add_filter( 'woocommerce_sale_flash', 'typecase_wc_sale_percent', 10, 3 );
add_filter( 'loop_shop_columns', 'typecase_wc_shop_columns' );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating' );
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar' );

if ( ! function_exists( 'typecase_buttons_wrapper_open' ) ) :
    function typecase_buttons_wrapper_open() {
        echo '<div class="product-buttons  cart-tooltips">';
    }
endif;


if ( ! function_exists( 'typecase_buttons_wrapper_close' ) ) :
    function typecase_buttons_wrapper_close() {
        echo '</div>';
    }
endif;


if ( ! function_exists( 'typecase_loop_product_title' ) ) :
    function typecase_loop_product_title() {
        ?>
        <h2 class="woocommerce-loop-product__title h4">
            <a href="<?php echo get_the_permalink(); ?>" class="woocommerce-loop-product-link p-url"><?php the_title(); ?></a>
        </h2>
    <?php
    }
endif;

if ( ! function_exists( 'typecase_loop_product_thumbnail' ) ) :
    function typecase_loop_product_thumbnail() {
        ?>
        <a href="<?php echo get_the_permalink(); ?>" class="woocommerce-loop-product-link"> <?php echo woocommerce_get_product_thumbnail(); ?></a>
    <?php
    }
endif;


if ( ! function_exists( 'typecase_checkout_customer_details_before' ) ):
    function typecase_checkout_customer_details_before() {
        ?>
        <div class="checkout-col col-left">
    <?php
    }

endif;

if ( ! function_exists( 'typecase_checkout_customer_details_after' ) ):
    function typecase_checkout_customer_details_after() {
        ?>
        </div><div class="checkout-col col-right">
    <?php
    }

endif;


if ( ! function_exists( 'typecase_checkout_order_after' ) ):
    function typecase_checkout_order_after() {
        ?>
        </div>
    <?php
    }
endif;

if ( ! function_exists( 'typecase_cart_after' ) ):
    function typecase_cart_after() {
        ?>
        <div class="clearfix"></div>
    <?php
    }
endif;


if ( ! function_exists( 'typecase_single_product_before' ) ):
    function typecase_single_product_before() {
        ?>
        <div class="single-product-wrap clearfix">
    <?php
    }

endif;

if ( ! function_exists( 'typecase_single_product_after' ) ):
    function typecase_single_product_after() {
        ?>
        </div>
    <?php
    }
endif;

if ( ! function_exists( 'typecase_single_product_image_before' ) ):
    function typecase_single_product_image_before() {
        ?>
        <div class="vt-wc-wrap single-product-content"><div class="vt-wc-img"><div class="wc-single-featured">
    <?php
    }
endif;

if ( ! function_exists( 'typecase_single_product_summary_before' ) ):
function typecase_single_product_summary_before() {
    ?>
    </div></div>
    <div class="vt-wc-dec">
<?php
}
endif;

if ( ! function_exists( 'typecase_single_product_summary_after' ) ):
    function typecase_single_product_summary_after() {
        ?>
        </div></div>
    <?php
    }
endif;

if ( ! function_exists( 'typecase_additional_information_heading' ) ) :
    function typecase_additional_information_heading( $heading ) {
        return false;
    }
endif;


if ( ! function_exists( 'typecase_wc_image_size_single' ) ) :
    function typecase_wc_image_size_single( $size ) {

        if ( ! empty( $size['width'] ) ) {
            $size['height'] = intval( $size['width'] * 1.5 );
        }
        $size['crop'] = 1;

        return $size;
    }
endif;

if ( ! function_exists( 'typecase_wc_related_posts_per_page' ) ) :
    function typecase_wc_related_posts_per_page( $args ) {
        $total                  = 4;
        $args['posts_per_page'] = $total;
        $args['columns']        = 4;

        return $args;
    }

endif;

if ( ! function_exists( 'typecase_wc_cross_sells_columns' ) ) :
    function typecase_wc_cross_sells_columns( $columns ) {
        return 4;
    }

endif;

if ( ! function_exists( 'typecase_wc_before_shop_loop' ) ):
    function typecase_wc_before_shop_loop() {
        if ( is_shop() ):
            $typecase_wc_sidebar          = '';
            $typecase_wc_sidebar_position = '';
        elseif ( is_product_category() ) :
            $typecase_wc_sidebar          = '';
            $typecase_wc_sidebar_position = '';
        endif;
        if ( ! empty( $typecase_wc_sidebar ) && ! empty( $typecase_wc_sidebar_position ) ) : ?>
            <div class="page-content vt-content-section is-sidebar-<?php echo esc_attr( $typecase_wc_sidebar_position ) ?>">
            <div class="vt-container">
            <div class="vt-content">
            <div class="content-wrap">
        <?php else: ?>
            <div class="page-content vt-content-section none-sidebar">
            <div class="vt-container">
            <div class="vt-content">
            <div class="content-wrap">
        <?php endif;
    }
endif;

if ( ! function_exists( 'typecase_wc_after_shop_loop' ) ):
    function typecase_wc_after_shop_loop() {
        echo '</div></div>';
    }
endif;

if ( ! function_exists( 'typecase_wc_after_main_content' ) ) {
    function typecase_wc_after_main_content() {
        echo '</div></div>';
    }
}

if ( ! function_exists( 'typecase_wc_before_result_count' ) ) {
    function    typecase_wc_before_result_count() {
        echo '<aside class="result-wrap">';
    }
}

if ( ! function_exists( 'typecase_wc_after_catalog_ordering' ) ) {
    function typecase_wc_after_catalog_ordering() {
        echo '</aside>';
    }
}

if ( ! function_exists( 'typecase_wc_shop_columns' ) ) {
    function typecase_wc_shop_columns() {

        if ( is_shop() ):
            $typecase_wc_sidebar = '';
        elseif ( is_product_category() ) :
            $typecase_wc_sidebar = '';
        endif;
        if ( ! empty( $typecase_wc_sidebar ) ) {
            return 3;
        } else {
            return 4;
        }
    }
}

if ( ! function_exists( 'typecase_wc_sale_percent' ) ):
    function typecase_wc_sale_percent( $html, $post, $product ) {
        $sale_percent = '';
        if ( empty( $sale_percent ) || 0 == $product->get_regular_price() ) {
            return $html;
        } else {
            $attachment_ids = $product->get_gallery_image_ids();
            $atts_style     = 'onsale percent ';
            if ( empty( $attachment_ids ) ) {
                $atts_style = 'onsale percent without-gallery';
            }
            $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );

            return '<span class="' . esc_attr( $atts_style ) . '"><span class="onsale-inner"><strong>' . '-' . esc_html( $percentage ) . '</strong><i>&#37;' . '</i></span></span>';
        }
    }
endif;

if ( ! function_exists( 'typecase_wc_add_to_cart' ) ) {
    function typecase_wc_add_to_cart( $fragments ) {
        ob_start(); ?>
        <span class="cart-counter vt_count_cart"><?php echo sprintf( '%d', WC()->cart->cart_contents_count ); ?></span>
        <?php
        $fragments['.vt_i_cart .cart-counter'] = ob_get_clean();

        $mini_cart = $fragments['div.widget_shopping_cart_content'];
        unset( $fragments['div.widget_shopping_cart_content'] );
        $fragments['div.vt-cart-wrap'] = '<div class="vt-cart-wrap woocommerce">' . $mini_cart . '</div>';

        return $fragments;
    }
}

if ( ! function_exists( 'typecase_wc_shop_products_per_page' ) ) {
    function typecase_wc_shop_products_per_page( $total ) {
        $posts_per_page = 12;
        if ( ! empty( $posts_per_page ) ) {
            $total = $posts_per_page;
        }

        return $total;
    }
}

if ( ! function_exists( 'typecase_remove_single_breadcrumb' ) ) {
    function typecase_remove_single_breadcrumb() {
        if ( is_product() ) {
            remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
        }
    }
}

if ( ! function_exists( 'typecase_wc_quantity_button' ) ) {
    function typecase_wc_quantity_button() {
        ?>
        <span class="vtb-btn up"></span>
        <span class="vtb-btn down"></span>
    <?php
    }
}
