<?php
$max_content_width = get_theme_mod('max_content_width','1200px');
// Logo
$logo_width = get_theme_mod('logo_width','150px');
$m_logo_width = get_theme_mod('m_logo_width','120px');
$s_logo_width = get_theme_mod('s_logo_width','150px');
$foot_logo_width = get_theme_mod('foot_logo_width','150px');

// Header
$section_top_bar_height = get_theme_mod('section_top_bar_height','35px');
$section_logo_height = get_theme_mod('section_logo_height','120px');
$section_menu_height = get_theme_mod('section_menu_height','70px');

//Menu
$typecase_menu_font_family = get_theme_mod('typecase_menu_font_family', 'Inter Tight');
$typecase_menu_font_size = get_theme_mod('typecase_menu_font_size', '16px');
$typecase_menu_font_weight = get_theme_mod('typecase_menu_font_weight', '700');
$typecase_menu_transform = get_theme_mod('typecase_menu_transform', 'capitalize');
$letter_spacing_menu = get_theme_mod('letter_spacing_menu', '0em');
$spacing_menu = get_theme_mod('spacing_menu', '30px');

//Sub Menu
$typecase_sub_menu_font_size = get_theme_mod('typecase_sub_menu_font_size', '14px');
$typecase_sub_menu_font_weight = get_theme_mod('typecase_sub_menu_font_weight', '500');
$sub_menu_transform = get_theme_mod('sub_menu_transform', 'capitalize');
$sub_spacing_menu = get_theme_mod('sub_spacing_menu', '0em');

//Paragraph
$typecase_p_font_family = get_theme_mod('typecase_p_font_family', 'Inter');
$typecase_p_font_size = get_theme_mod('typecase_p_font_size', '16px');
$typecase_p_font_weight = get_theme_mod('typecase_p_font_weight', '400');
$p_line_height = get_theme_mod('p_line_height', '1.8');
$body_font_size = get_theme_mod('body_font_size', '15px');
$body_line_height = get_theme_mod('body_line_height', '1.5');

//Title
$typecase_title_font_family = get_theme_mod('typecase_title_font_family', 'Inter Tight');
$typecase_title_font_weight = get_theme_mod('typecase_title_font_weight', '800');
$typecase_title_transform = get_theme_mod('typecase_title_transform', 'none');
$letter_spacing_heading = get_theme_mod('letter_spacing_heading', '0em');
$line_height_heading = get_theme_mod('line_height_heading', '1.2');

//Catgory, Meta, Button
$typecase_cat_font_size    = get_theme_mod('typecase_cat_font_size', '15px');
$typecase_cat_font_weight = get_theme_mod('typecase_cat_font_weight', '700');
$typecase_cat_transform	= get_theme_mod('typecase_cat_transform', 'capitalize');
$letter_spacing_cat 	= get_theme_mod('letter_spacing_cat', '0em');
$typecase_meta_font_size 	= get_theme_mod('typecase_meta_font_size', '11px');
$typecase_meta_font_weight = get_theme_mod('typecase_meta_font_weight', '400');
$typecase_meta_a_font_weight = get_theme_mod('typecase_meta_a_font_weight', '600');
$typecase_meta_transform     = get_theme_mod('typecase_meta_transform', 'uppercase');
$letter_spacing_meta     = get_theme_mod('letter_spacing_meta', '.04em');

// Button setting
$typecase_button_font_size = get_theme_mod('typecase_button_font_size', '12px');
$typecase_button_font_weight = get_theme_mod('typecase_button_font_weight', '700');
$typecase_button_transform = get_theme_mod('typecase_button_transform', 'uppercase');
$letter_spacing_button = get_theme_mod('letter_spacing_button', '0.1em');
$button_radius = get_theme_mod('button_radius', '4px');

// Load more setting
$typecase_loadmore_font_size = get_theme_mod('typecase_loadmore_font_size', '12px');
$typecase_loadmore_font_weight = get_theme_mod('typecase_loadmore_font_weight', '700');
$typecase_loadmore_transform = get_theme_mod('typecase_loadmore_transform', 'uppercase');
$letter_spacing_loadmore = get_theme_mod('letter_spacing_loadmore', '0.1em');
$load_more_radius = get_theme_mod('load_more_radius', '4px');
$load_more_width = get_theme_mod('load_more_width', '290px');
$load_more_height = get_theme_mod('load_more_height', '48px');

// Other blog
$border_rounded = get_theme_mod('border_rounded', '0px');
$top_border_rounded = get_theme_mod('top_border_rounded', '60px');
$single_title_size = get_theme_mod('single_title_size', '40px');
$typecase_related_size = get_theme_mod('typecase_related_size', '20px');

//cookie
$vt_cookie_dec_size = get_theme_mod('vt_cookie_dec_size', '13px');
$vt_cookie_btn_size = get_theme_mod('vt_cookie_btn_size', '12px');
$vt_cookie_btn_space = get_theme_mod('vt_cookie_btn_space', '0em');
$vt_cookie_btn_tranform = get_theme_mod('vt_cookie_btn_tranform', 'capitalize');

//progress bar
$sp_progress_height = get_theme_mod('sp_progress_height','5px');
$sp_progress_pos = get_theme_mod('sp_progress_pos','top');
$sp_color1 = get_theme_mod('sp_color1','#ff0080');
$sp_color2 = get_theme_mod('sp_color2','#8100ff');

// Theme color
$theme_color = get_theme_mod('theme_color');
if(empty($theme_color)){$theme_color = '#ff184e';}

$theme_color_dark = get_theme_mod('theme_color_dark');
if(empty($theme_color_dark)){$theme_color_dark = '#ff184e';}

$theme_bg_color = get_theme_mod('theme_bg_color');
if(empty($theme_bg_color)){$theme_bg_color = '#FFF';}

$theme_bg_color_dark = get_theme_mod('theme_bg_color_dark');
if(empty($theme_bg_color_dark)){$theme_bg_color_dark = '#111';}

$theme_text_color = get_theme_mod('theme_text_color');
if(empty($theme_text_color)){$theme_text_color = '#000';}

$theme_text_color_dark = get_theme_mod('theme_text_color_dark');
if(empty($theme_text_color_dark)){$theme_text_color_dark = '#FFF';}

// Menu color
$menu_bg_color = get_theme_mod('menu_bg_color');
if(empty($menu_bg_color)){ $menu_bg_color = '#FFF';}

$menu_bg_color_dark = get_theme_mod('menu_bg_color_dark');
if(empty($menu_bg_color_dark)){ $menu_bg_color_dark = '#111';}

$menu_text_color = get_theme_mod('menu_text_color');
if(empty($menu_text_color)){ $menu_text_color = '#000';}

$menu_text_color_dark = get_theme_mod('menu_text_color_dark');
if(empty($menu_text_color_dark)){ $menu_text_color_dark = '#FFF';}

$submenu_back_color = get_theme_mod('submenu_back_color');
if(empty($submenu_back_color)){ $submenu_back_color = '#f7f7f6';}

$submenu_back_color_dark = get_theme_mod('submenu_back_color_dark');
if(empty($submenu_back_color_dark)){ $submenu_back_color_dark = '#222';}

$submenu_text_color = get_theme_mod('submenu_text_color');
if(empty($submenu_text_color)){ $submenu_text_color = '#000';}

$submenu_text_color_dark = get_theme_mod('submenu_text_color_dark');
if(empty($submenu_text_color_dark)){ $submenu_text_color_dark = '#FFF';}

$menu_line_color = get_theme_mod('menu_line_color');
if(empty($menu_line_color)){ $menu_line_color = '#eeedeb';}

$menu_line_color_dark = get_theme_mod('menu_line_color_dark');
if(empty($menu_line_color_dark)){ $menu_line_color_dark = '#ffffff26';}

$submenu_line_color = get_theme_mod('submenu_line_color');
if(empty($submenu_line_color)){ $submenu_line_color = '#ebebe3';}

$submenu_line_color_dark = get_theme_mod('submenu_line_color_dark');
if(empty($submenu_line_color_dark)){ $submenu_line_color_dark = '#464646';}

// Top menu color
$top_menu_bg_color = get_theme_mod('top_menu_bg_color');
if(empty($top_menu_bg_color)){ $top_menu_bg_color = '#000';}

$top_menu_text_color = get_theme_mod('top_menu_text_color');
if(empty($top_menu_text_color)){ $top_menu_text_color = '#FFF';}

$top_menu_bg_color_dark = get_theme_mod('top_menu_bg_color_dark');
if(empty($top_menu_bg_color_dark)){ $top_menu_bg_color_dark = '#000';}

$top_menu_text_color_dark = get_theme_mod('top_menu_text_color_dark');
if(empty($top_menu_text_color_dark)){ $top_menu_text_color_dark = '#FFF';}

$section_top_bar_height = get_theme_mod('section_top_bar_height','35px');
$section_top_bar_size = get_theme_mod('section_top_bar_size','15px');

// Logo section color
$head_logo_bg_color = get_theme_mod('head_logo_bg_color');
if(empty($head_logo_bg_color)){ $head_logo_bg_color = '#FFF';}

$head_logo_bg_color_dark = get_theme_mod('head_logo_bg_color_dark');
if(empty($head_logo_bg_color_dark)){ $head_logo_bg_color_dark = '#111';}

$head_logo_text_color = get_theme_mod('head_logo_text_color');
if(empty($head_logo_text_color)){ $head_logo_text_color = '#000';}

$head_logo_text_color_dark = get_theme_mod('head_logo_text_color_dark');
if(empty($head_logo_text_color_dark)){ $head_logo_text_color_dark = '#FFF';}

// Single color
$single_color = get_theme_mod('single_color');
if(empty($single_color)){$single_color = '#676767';}

$single_color_dark = get_theme_mod('single_color_dark');
if(empty($single_color_dark)){$single_color_dark = '#FFF';}

$single_link_color = get_theme_mod('single_link_color');
if(empty($single_link_color)){$single_link_color = '#ff184e';}

$single_link_color_dark = get_theme_mod('single_link_color_dark');
if(empty($single_link_color_dark)){$single_link_color_dark = '#ff184e';}

$single_link_hover_color = get_theme_mod('single_link_hover_color');
if(empty($single_link_hover_color)){$single_link_hover_color = '#ff184e';}

$single_link_hover_color_dark = get_theme_mod('single_link_hover_color_dark');
if(empty($single_link_hover_color_dark)){$single_link_hover_color_dark = '#ff184e';}

$post_meta_color = get_theme_mod('post_meta_color');
if(empty($post_meta_color)){$post_meta_color = '#0a0a0a';}

$post_meta_color_dark = get_theme_mod('post_meta_color_dark');
if(empty($post_meta_color_dark)){$post_meta_color_dark = '#bbb';}

$post_except_color = get_theme_mod('post_except_color');
if(empty($post_except_color)){$post_except_color = '#666';}

$post_except_color_dark = get_theme_mod('post_except_color_dark');
if(empty($post_except_color_dark)){$post_except_color_dark = '#ddd';}

$post_line_color = get_theme_mod('post_line_color');
if(empty($post_line_color)){$post_line_color = '#dbdbdb';}

$post_line_color_dark = get_theme_mod('post_line_color_dark');
if(empty($post_line_color_dark)){$post_line_color_dark = '#49494b';}

$category_label_padding = get_theme_mod('category_label_padding');
$category_label_radius = get_theme_mod('category_label_radius');

// Footer color
$footer_bg_color = get_theme_mod('footer_bg_color');
if(empty($footer_bg_color)){$footer_bg_color = '#111';}

$footer_bg_dark = get_theme_mod('footer_bg_dark');
if(empty($footer_bg_dark)){$footer_bg_dark = '#000';}

$footer_text_color = get_theme_mod('footer_text_color');
if(empty($footer_text_color)){$footer_text_color = '#a8a8aa';}

$footer_text_dark = get_theme_mod('footer_text_dark');
if(empty($footer_text_dark)){$footer_text_dark = '#a8a8aa';}

$footer_link_color = get_theme_mod('footer_link_color');
if(empty($footer_link_color)){$footer_link_color = '#dcdcdc';}

$footer_link_dark = get_theme_mod('footer_link_dark');
if(empty($footer_link_dark)){$footer_link_dark = '#dcdcdc';}

$footer_link_hcolor = get_theme_mod('footer_link_hcolor');
if(empty($footer_link_hcolor)){$footer_link_hcolor = '#ff184e';}

$footer_link_hdark = get_theme_mod('footer_link_hdark');
if(empty($footer_link_hdark)){$footer_link_hdark = '#ff184e';}

$footer_head_color = get_theme_mod('footer_head_color');
if(empty($footer_head_color)){$footer_head_color = '#FFF';}

$footer_head_color_dark = get_theme_mod('footer_head_color_dark');
if(empty($footer_head_color_dark)){$footer_head_color_dark = '#FFF';}

$footer_line_color = get_theme_mod('footer_line_color');
if(empty($footer_line_color)){$footer_line_color = '#49494b';}

$footer_line_color_dark = get_theme_mod('footer_line_color_dark');
if(empty($footer_line_color_dark)){$footer_line_color_dark = '#49494b';}

$footer_menu_col = get_theme_mod('footer_menu_col', '1');
$footer_title_size = get_theme_mod('footer_title_size', '18px');
$footer_font_size = get_theme_mod('footer_font_size', '15px');
$footer_copyright_size = get_theme_mod('footer_copyright_size', '14px');
$footer_menu_size = get_theme_mod('footer_menu_size', '14px');

// Widget
$typecase_widget_font_size = get_theme_mod('typecase_widget_font_size', '18px');
$typecase_widget_letter_spacing = get_theme_mod('typecase_widget_letter_spacing', '0em');
$typecase_widget_transform = get_theme_mod('typecase_widget_transform', 'uppercase');

?>
body.options_dark_skin{
    --vt-main-color: <?php echo esc_attr($theme_color_dark);?>;
    --vt-bg-color: <?php echo esc_attr($theme_bg_color_dark);?>;
    --vt-txt-color: <?php echo esc_attr($theme_text_color_dark);?>;
    --vt-btn-bg: #454545;
    --vt-comment-btn-link: #454545;
    --vt-comment-btn-linkc: #FFF;
    
    --vt-menu-bg: <?php echo esc_attr($menu_bg_color_dark);?>;
    --vt-menu-line-color: <?php echo esc_attr($menu_line_color_dark);?>;
    --vt-menu-color: <?php echo esc_attr($menu_text_color_dark);?>;
    --vt-sub-bg-color: <?php echo esc_attr($submenu_back_color_dark);?>;
    --vt-sub-menu-color: <?php echo esc_attr($submenu_text_color_dark);?>;
    --vt-sub-line-color: <?php echo esc_attr($submenu_line_color_dark);?>;
    --vt-topbar-bg: <?php echo esc_attr($top_menu_bg_color_dark);?>;
    --vt-topbar-color: <?php echo esc_attr($top_menu_text_color_dark);?>;
    --vt-logo-bg: <?php echo esc_attr($head_logo_bg_color_dark);?>;
    --vt-logo-color: <?php echo esc_attr($head_logo_text_color_dark);?>;

    --vt-single-color: <?php echo esc_attr($single_color_dark);?>;
    --vt-single-link-color: <?php echo esc_attr($single_link_color_dark);?>;
    --vt-single-link-hcolor: <?php echo esc_attr($single_link_hover_color_dark);?>;
    --vt-except-color: <?php echo esc_attr($post_except_color_dark);?>;
    --vt-meta-color: <?php echo esc_attr($post_except_color_dark);?>;
    --vt-post-line-color: <?php echo esc_attr($post_line_color_dark);?>;
    --vt-author-bg: #454545;

    --vt-foot-bg: <?php echo esc_attr($footer_bg_dark);?>;
    --vt-foot-color: <?php echo esc_attr($footer_text_dark);?>;
    --vt-foot-link: <?php echo esc_attr($footer_link_dark);?>;
    --vt-foot-hlink: <?php echo esc_attr($footer_link_hdark);?>;
    --vt-foot-head: <?php echo esc_attr($footer_head_color_dark);?>;
    --vt-foot-line: <?php echo esc_attr($footer_line_color_dark);?>;

}
body{
    --vt-main-width: <?php echo esc_attr($max_content_width);?>;
    --vt-main-color: <?php echo esc_attr($theme_color);?>;
    --vt-bg-color: <?php echo esc_attr($theme_bg_color);?>;
    --vt-txt-color: <?php echo esc_attr($theme_text_color);?>;
    --vt-txt-light: <?php echo esc_attr($theme_text_color_dark);?>;
    --vt-btn-bg: #393939;
    --vt-comment-btn-link: #F1F1F1;
    --vt-comment-btn-linkc: #000;
    --vt-desc-light: <?php echo esc_attr($post_except_color_dark);?>;
    --vt-meta-light: <?php echo esc_attr($post_meta_color_dark);?>;

    --vt-button-radius: <?php echo esc_attr($button_radius);?>;
    --vt-load-more-radius: <?php echo esc_attr($load_more_radius);?>;
    --vt-load-more-width: <?php echo esc_attr($load_more_width);?>;
    --vt-load-more-height: <?php echo esc_attr($load_more_height);?>;    

    --vt-menu-bg: <?php echo esc_attr($menu_bg_color);?>;
    --vt-menu-line-color: <?php echo esc_attr($menu_line_color);?>;
    --vt-menu-color: <?php echo esc_attr($menu_text_color);?>;
    --vt-sub-bg-color: <?php echo esc_attr($submenu_back_color);?>;
    --vt-sub-menu-color: <?php echo esc_attr($submenu_text_color);?>;
    --vt-sub-line-color: <?php echo esc_attr($submenu_line_color);?>;

    --vt-topbar-bg: <?php echo esc_attr($top_menu_bg_color);?>;
    --vt-topbar-color: <?php echo esc_attr($top_menu_text_color);?>;
    --vt-topbar-height: <?php echo esc_attr($section_top_bar_height);?>;
    --vt-topbar-size: <?php echo esc_attr($section_top_bar_size);?>;

    --vt-logo-bg: <?php echo esc_attr($head_logo_bg_color);?>;
    --vt-logo-color: <?php echo esc_attr($head_logo_text_color);?>;

    --vt-single-title-size: <?php echo esc_attr($single_title_size);?>;
    --vt-single-color: <?php echo esc_attr($single_color);?>;
    --vt-single-link-color: <?php echo esc_attr($single_link_color);?>;
    --vt-single-link-hcolor: <?php echo esc_attr($single_link_hover_color);?>;
    --vt-except-color: <?php echo esc_attr($post_except_color);?>;
    --vt-meta-color: <?php echo esc_attr($post_meta_color);?>;
    --vt-post-line-color: <?php echo esc_attr($post_line_color);?>;
    --vt-author-bg: #f8f7f5;
    --vt-post-related-size: <?php echo esc_attr($typecase_related_size);?>;

    --vt-foot-bg: <?php echo esc_attr($footer_bg_color);?>;
    --vt-foot-color: <?php echo esc_attr($footer_text_color);?>;
    --vt-foot-link: <?php echo esc_attr($footer_link_color);?>;
    --vt-foot-hlink: <?php echo esc_attr($footer_link_hcolor);?>;
    --vt-foot-head: <?php echo esc_attr($footer_head_color);?>;
    --vt-foot-line: <?php echo esc_attr($footer_line_color);?>;    
    --vt-foot-menu-col: <?php echo esc_attr($footer_menu_col);?>;    
    --vt-foot-title-size: <?php echo esc_attr($footer_title_size);?>;        
    --vt-foot-font-size: <?php echo esc_attr($footer_font_size);?>;        
    --vt-foot-copyright: <?php echo esc_attr($footer_copyright_size);?>;        
    --vt-foot-menu-size: <?php echo esc_attr($footer_menu_size);?>;        

    --vt-body-font: <?php echo esc_attr($typecase_p_font_family);?>;
    --vt-body-font-size: <?php echo esc_attr($body_font_size);?>;
    --vt-body-font-weight: <?php echo esc_attr($typecase_p_font_weight);?>;
    --vt-body-line-height: <?php echo esc_attr($body_line_height);?>;
    --vt-logo-width: <?php echo esc_attr($logo_width);?>;
    --vt-m-logo-width: <?php echo esc_attr($m_logo_width);?>;
    --vt-s-logo-width: <?php echo esc_attr($s_logo_width);?>;
    --vt-fot-logo-width: <?php echo esc_attr($foot_logo_width);?>;
    --vt-title-font: <?php echo esc_attr($typecase_title_font_family);?>;
    --vt-title-font-weight: <?php echo esc_attr($typecase_title_font_weight);?>;
    --vt-title-transform: <?php echo esc_attr($typecase_title_transform);?>;
    --vt-title-space: <?php echo esc_attr($letter_spacing_heading);?>;
    --vt-title-line-height: <?php echo esc_attr($line_height_heading);?>;
    --vt-content-font-size: <?php echo esc_attr($typecase_p_font_size);?>;
    --vt-content-line-height: <?php echo esc_attr($p_line_height);?>;
    --vt-sec-topbar-height: <?php echo esc_attr($section_top_bar_height);?>;
    --vt-sec-menu-height: <?php echo esc_attr($section_menu_height);?>;
    --vt-sec-logo-height: <?php echo esc_attr($section_logo_height);?>;
    --vt-menu-font: <?php echo esc_attr($typecase_menu_font_family);?>;
    --vt-menu-font-size: <?php echo esc_attr($typecase_menu_font_size);?>;
    --vt-menu-font-weight: <?php echo esc_attr($typecase_menu_font_weight);?>;
    --vt-menu-transform: <?php echo esc_attr($typecase_menu_transform);?>;
    --vt-menu-space: <?php echo esc_attr($letter_spacing_menu);?>;
    --vt-spacing-menu: <?php echo esc_attr($spacing_menu);?>;
    --vt-submenu-font-size: <?php echo esc_attr($typecase_sub_menu_font_size);?>;
    --vt-submenu-font-weight: <?php echo esc_attr($typecase_sub_menu_font_weight);?>;
    --vt-submenu-transform: <?php echo esc_attr($sub_menu_transform);?>;
    --vt-submenu-space: <?php echo esc_attr($sub_spacing_menu);?>;
    --vt-cat-font-size: <?php echo esc_attr($typecase_cat_font_size);?>;
    --vt-cat-font-weight: <?php echo esc_attr($typecase_cat_font_weight);?>;
    --vt-cat-font-space: <?php echo esc_attr($letter_spacing_cat);?>;
    --vt-cat-transform: <?php echo esc_attr($typecase_cat_transform);?>;
    --vt-meta-font-size: <?php echo esc_attr($typecase_meta_font_size);?>;
    --vt-meta-font-weight: <?php echo esc_attr($typecase_meta_font_weight);?>;
    --vt-meta-a-font-weight: <?php echo esc_attr($typecase_meta_a_font_weight);?>;
    --vt-meta-font-space: <?php echo esc_attr($letter_spacing_meta);?>;
    --vt-meta-transform: <?php echo esc_attr($typecase_meta_transform);?>;
    --vt-button-font-size: <?php echo esc_attr($typecase_button_font_size);?>;
    --vt-button-font-weight: <?php echo esc_attr($typecase_button_font_weight);?>;
    --vt-button-transform: <?php echo esc_attr($typecase_button_transform);?>;
    --vt-button-space: <?php echo esc_attr($letter_spacing_button);?>;
    --vt-loadmore-font-size: <?php echo esc_attr($typecase_loadmore_font_size);?>;
    --vt-loadmore-font-weight: <?php echo esc_attr($typecase_loadmore_font_weight);?>;
    --vt-loadmore-transform: <?php echo esc_attr($typecase_loadmore_transform);?>;
    --vt-loadmore-space: <?php echo esc_attr($letter_spacing_loadmore);?>;
    --vt-border-rounded: <?php echo esc_attr($border_rounded);?>;
    --vt-top-rounded: <?php echo esc_attr($top_border_rounded);?>;
    --vt-cookie-des-size: <?php echo esc_attr($vt_cookie_dec_size);?>;
    --vt-cookie-btn-size: <?php echo esc_attr($vt_cookie_btn_size);?>;
    --vt-cookie-btn-space: <?php echo esc_attr($vt_cookie_btn_space);?>;
    --vt-cookie-btn-transform: <?php echo esc_attr($vt_cookie_btn_tranform);?>;

    --vt-widget-fsize: <?php echo esc_attr($typecase_widget_font_size);?>;
    --vt-widget-space: <?php echo esc_attr($typecase_widget_letter_spacing);?>;
    --vt-widget-transform: <?php echo esc_attr($typecase_widget_transform);?>;    
}
<?php
if(function_exists('typecase_bac_PostViews')){
$vt_cus_font = $typecase_menu_font_family.','.$typecase_p_font_family.','.$typecase_title_font_family;
$vt_cus_font_arr = explode( ',', $vt_cus_font );
$vt_cus_font_unique = array_unique($vt_cus_font_arr);
    if (strpos($vt_cus_font, 'vt_c_') !== false) {
        $fonts = typecase_font_tax::typecase_get_fonts();
        foreach ( $fonts as $font => $values ){
            foreach ($vt_cus_font_unique as $font_text) {
                 if($font_text == 'vt_c_'.$font ){
                ?>
                @font-face {
                  font-family: '<?php echo esc_attr('vt_c_'.$font);?>';
                  <?php if(!empty($values['font_eot-0'])){?>
                  src: url('<?php echo esc_url($values['font_eot-0']);?>');
                  <?php }?>
                  src:<?php if(!empty($values['font_eot-0'])){?> url('<?php echo esc_url($values['font_eot-0']);?>?#iefix') format('embedded-opentype'),
                       <?php }
                       if(!empty($values['font_woff_2-0'])){?>
                       url('<?php echo esc_url($values['font_woff_2-0']);?>') format('woff2'),
                       <?php }
                       if(!empty($values['font_woff-0'])){?>
                       url('<?php echo esc_url($values['font_woff-0']);?>') format('woff'),
                       <?php }
                       if(!empty($values['font_ttf-0'])){?>
                       url('<?php echo esc_url($values['font_ttf-0']);?>')  format('truetype'),
                       <?php }
                       if(!empty($values['font_svg-0'])){?>
                       url('<?php echo esc_url($values['font_svg-0']);?>#<?php echo esc_attr('vt_c_'.$font);?>') format('svg');
                       <?php }?>
                }
                <?php
                }
            }
        }
    }
}?>
<?php if( !empty($category_label_padding) || !empty($category_label_radius) ){?>
.vt_lb3 .vt_cat_lbl, .vt_lb4 .vt_cat_lbl, .vt_lb5 .vt_cat_lbl, .vt_lb6 .vt_cat_lbl, .vt_lb7 .vt_cat_lbl{
    padding: <?php echo esc_attr($category_label_padding);?> !important;
    border-radius: <?php echo esc_attr($category_label_radius);?> !important;
}
<?php }?>
<?php if( !empty(get_theme_mod('ac_menu_line_height')) ){?>
.navigation_wrapper .vt_main_menu > .menu-item:hover > a .vt_mblt, .navigation_wrapper .vt_main_menu > .current-menu-ancestor > a .vt_mblt, .navigation_wrapper .vt_main_menu > .current-menu-item > a .vt_mblt, .navigation_wrapper .vt_main_menu > .is-current-sub > a .vt_mblt{
    background-size: 100% <?php echo esc_attr(get_theme_mod('ac_menu_line_height','1px'));?> !important;
}
<?php }?>
<?php if( !empty(get_theme_mod('ac_menu_line_color')) ){?>
.navigation_wrapper .vt_main_menu > .menu-item > a .vt_mblt{
    background-image: linear-gradient(90deg,<?php echo esc_attr(get_theme_mod('ac_menu_line_color'));?> 0,<?php echo esc_attr(get_theme_mod('ac_menu_line_color'));?> 94%);
    background-size: 0 <?php echo esc_attr(get_theme_mod('ac_menu_line_height','1px'));?>;
}
<?php }?>
<?php if( !empty($max_content_width) ){?>
.vtc-container{max-width: <?php echo esc_attr($max_content_width);?>;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_fb') ==1){?>
.vt_sli_in .vt_sli_fb{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_tw') ==1){?>
.vt_sli_in .vt_sli_tw{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_pin') ==1){?>
.vt_sli_in .vt_sli_pi{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_in') ==1){?>
.vt_sli_in .vt_sli_din{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_mail') ==1){?>
.vt_sli_in .vt_sli_mil{display: none !important;}
<?php }?>
.logo_small_wrapper_table .logo_small_wrapper a .vt_logo_w {
    position: absolute;top: 0px;left: 0px;opacity: 0;
}
.logo_small_wrapper_table .logo_small_wrapper .logo_link img{
    max-width: var(--vt-logo-width);
}
.vt_sleft_side .vt_smmain_side{
    order: 1;
    padding-left: 20px;
    padding-right: 30px;
}
.vt_sleft_side .vt_smmain_con{
    order: 2;
}
.vt_rd_wrap{
    <?php echo esc_attr($sp_progress_pos);?>: 0;    
}
.vt_rd_read{
    height: <?php echo esc_attr($sp_progress_height);?>;    
    background-color: <?php echo esc_attr($sp_color2);?>;
    background-image: linear-gradient(to right, <?php echo esc_attr($sp_color1);?> 0%, <?php echo esc_attr($sp_color2);?> 100%);
}
<?php
$vt_cat_color = get_terms('category');
    if ($vt_cat_color) {
        foreach( $vt_cat_color as $tag) {
            $tag_link = get_category_link($tag->term_id);
            $cat_color = get_term_meta($tag->term_id, "category_color_options", true);
            if( !empty($cat_color) ){
                echo '.cat-item-'.$tag->term_id.' span{background: '.esc_attr($cat_color).'}';
                echo '.vt_cat_cid_'.esc_attr($tag->term_id).' .vt_cm_count{background: '.esc_attr($cat_color).' !important;}';
                echo '.vt_cat_opt4 .vt_cat_opt_w.vt_cat_cid_'.esc_attr($tag->term_id).'{background: '.esc_attr($cat_color).' !important;}';
                echo '.vt_cat_txt.vt_cat'.esc_attr($tag->term_id).':before{background: '.esc_attr($cat_color).';}';
                echo '.vt_cat_lbl.vt_cat'.esc_attr($tag->term_id).'{background: '.esc_attr($cat_color).';}';
            }
        }
    }
?>