<?php
$post_id = get_the_ID();
$header_page_layout = get_theme_mod('header_layout','default');
$custom_header_layout = get_post_meta( $post_id, 'custom_header_layout', true );
$header_sticky = get_theme_mod('header_sticky','default');
$custom_header_sticky = get_post_meta( $post_id, 'custom_header_sticky', true );

$header_layout_opt= get_theme_mod('header_layout_design','header_1');
$logo_tag = (is_front_page() ? 'h1' : 'span');

if(empty($custom_header_layout)) {
    $header_layout = $header_layout_opt;
} else {
    $header_layout = $header_layout_opt;
}

if(empty($custom_header_layout)) {
    $header_cus_layout = $header_page_layout;
} else {
    $header_cus_layout = $custom_header_layout;
}
if(empty($custom_header_sticky)) {
    $header_sticky = $header_sticky;
} else {
    $header_sticky = $custom_header_sticky;
}

if( !empty($header_cus_layout) && $header_cus_layout != 'default'){?>
<header class="vtc-hmain-w vt_base_menu vt_md_main">
    <?php if ( defined( 'ELEMENTOR_VERSION' ) ){
        echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_cus_layout );            
    }?>
</header>
<header class="vtc-stick-main-w vt_cus_sihead vt_r_menu">
    <?php if ( defined( 'ELEMENTOR_VERSION' ) ){
        echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_sticky );            
    }?>
</header>
<?php }else{
switch ( $header_layout ) {   
case 'header_1' :
?>
<header class="vtc-hmain-w vtc-hop1 vt_base_menu vt_md_main">
    <div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">            
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                            </a>
                            </div>
                        </div>        
        <div class="vt_hd1_nav">
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>        
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
        </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop1 vt_cus_sihead vt_r_menu">
    <div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">    
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
        <div class="vt_hd1_nav">
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_2' :
?>
<header class="vtc-hmain-w vtc-hop2 vt_base_menu vt_md_main">
    <div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">            
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                            </a>
                            </div>
                        </div>        
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>        
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop2 vt_cus_sihead vt_r_menu">
    <div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">    
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_3' :
?>
<header class="vtc-hmain-w vtc-hop3 vt_base_menu vt_md_main">
<?php if(empty(get_theme_mod('hide_top_bar'))){?>
    <div class="vtc-top-w">
        <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_thc">
                        <div class="vt_htl">
                            <?php if(!empty(get_theme_mod('topl_text'))){?>
                            <div class="vt_hlc"><?php echo wp_kses_post(get_theme_mod('topl_text')); ?></div>
                            <?php }?>
                            <?php if(!empty(get_theme_mod('enable_topl_menu'))){?>
                                <div class="vt_hlnav">
                                    <div class="menu-primary-container navigation_wrapper">
                                    <?php $top_menu = array(
                                                    'theme_location' => 'top_menu',
                                                    'container' => '',
                                                    'menu_class' => 'vt_main_menu',
                                                    'menu_id' => 'vt_top_menu',
                                                    'fallback_cb' => false,
                                                    'link_before'=>'<span class="vt_mblt">',
                                                    'link_after'=>'</span>');
                                                    wp_nav_menu($top_menu);?>
                                    </div>  
                                </div>
                            <?php }?>
                        </div>
                        <div class="vt_htr">
                        <?php if(!empty(get_theme_mod('show_top_date' ))){
                            $date_format = get_theme_mod( 'topbar_date_format', 'l ,  j  F Y' ); ?>
                            <div class="vt_topbar_date">
                                <?php echo date_i18n( $date_format, current_time( 'timestamp' ) ); ?>
                            </div>
					    <?php } ?>
                            <?php if(!empty(get_theme_mod('topr_text'))){?>
                                <div class="vt_hrc"><?php echo wp_kses_post(get_theme_mod('topr_text')); ?></div>
                            <?php }?>
                            <?php if(empty(get_theme_mod('hide_top_social'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>                                                
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php }?>
    <div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                                            
                    <div class="menu-primary-container navigation_wrapper">
                        <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                        <?php $main_menu = array(
                                'walker' => new visionwp_walker(),
                                'theme_location' => 'main_menu',
                                'container' => '',
                                'menu_class' => 'vt_main_menu',
                                'fallback_cb' => false,
                                'link_before'=>'<span class="vt_mblt">',
                                'link_after'=>'</span>');
                               wp_nav_menu($main_menu);
                        ?>
                        <?php }else{ ?>
                        <?php if ( current_user_can( 'manage_options' ) ){ ?>
                        <ul class="vt_main_menu">
                            <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                            <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                        </ul>
                        <?php }}?>
                    </div>   
                    <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                            </a>
                            </div>
                        </div>     
                    <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop3 vt_cus_sihead vt_r_menu">
    <div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                            
                    <div class="menu-primary-container navigation_wrapper">
                        <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                        <?php $main_menu = array(
                                'walker' => new visionwp_walker(),
                                'theme_location' => 'main_menu',
                                'container' => '',
                                'menu_class' => 'vt_main_menu',
                                'fallback_cb' => false,
                                'link_before'=>'<span class="vt_mblt">',
                                'link_after'=>'</span>');
                               wp_nav_menu($main_menu);
                        ?>
                        <?php }else{ ?>
                        <?php if ( current_user_can( 'manage_options' ) ){ ?>
                        <ul class="vt_main_menu">
                            <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                            <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                        </ul>
                        <?php }}?>
                    </div>
                    <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
                    <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_4' :
?>
<header class="vtc-hmain-w vtc-hop4 vt_base_menu vt_md_main">
<?php if(empty(get_theme_mod('hide_top_bar'))){?>
    <div class="vtc-top-w">
        <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_thc">
                        <div class="vt_htl">
                            <?php if(!empty(get_theme_mod('topl_text'))){?>
                            <div class="vt_hlc"><?php echo wp_kses_post(get_theme_mod('topl_text')); ?></div>
                            <?php }?>
                            <?php if(!empty(get_theme_mod('enable_topl_menu'))){?>
                                <div class="vt_hlnav">
                                    <div class="menu-primary-container navigation_wrapper">
                                    <?php $top_menu = array(
                                                    'theme_location' => 'top_menu',
                                                    'container' => '',
                                                    'menu_class' => 'vt_main_menu',
                                                    'menu_id' => 'vt_top_menu',
                                                    'fallback_cb' => false,
                                                    'link_before'=>'<span class="vt_mblt">',
                                                    'link_after'=>'</span>');
                                                    wp_nav_menu($top_menu);?>
                                    </div>  
                                </div>
                            <?php }?>
                        </div>
                        <div class="vt_htr">
                        <?php if(!empty(get_theme_mod('show_top_date' ))){
                            $date_format = get_theme_mod( 'topbar_date_format', 'l ,  j  F Y' ); ?>
                            <div class="vt_topbar_date">
                                <?php echo date_i18n( $date_format, current_time( 'timestamp' ) ); ?>
                            </div>
					    <?php } ?>
                            <?php if(!empty(get_theme_mod('topr_text'))){?>
                                <div class="vt_hrc"><?php echo wp_kses_post(get_theme_mod('topr_text')); ?></div>
                            <?php }?>
                            <?php if(empty(get_theme_mod('hide_top_social'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>                                                
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php }?>
    <div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap"> 
                    <div class="vt_hleftwrap">                                                                  
                        <div class="logo_small_wrapper_table">
                                <div class="logo_small_wrapper">
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                                </a>
                                </div>
                        </div>     
                        <div class="menu-primary-container navigation_wrapper">
                            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                            <?php $main_menu = array(
                                    'walker' => new visionwp_walker(),
                                    'theme_location' => 'main_menu',
                                    'container' => '',
                                    'menu_class' => 'vt_main_menu',
                                    'fallback_cb' => false,
                                    'link_before'=>'<span class="vt_mblt">',
                                    'link_after'=>'</span>');
                                wp_nav_menu($main_menu);
                            ?>
                            <?php }else{ ?>
                            <?php if ( current_user_can( 'manage_options' ) ){ ?>
                            <ul class="vt_main_menu">
                                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                            </ul>
                            <?php }}?>
                        </div>
                    </div>
                    <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop4 vt_cus_sihead vt_r_menu">
    <div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">
                        <div class="vt_hleftwrap">
                        <div class="logo_small_wrapper_table">
                                <div class="logo_small_wrapper">
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                    <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                    <?php if (!empty($logo_n)): ?>
                                    <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                    <?php else: ?>
                                    <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                    <?php endif; ?>
                                    <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                    <?php if (!empty($logo_w)): ?>
                                    <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                    <?php else: ?>
                                    <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                    <?php endif; ?>
                                </a>
                                </div>
                        </div>
                        <div class="menu-primary-container navigation_wrapper">
                            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                            <?php $main_menu = array(
                                    'walker' => new visionwp_walker(),
                                    'theme_location' => 'main_menu',
                                    'container' => '',
                                    'menu_class' => 'vt_main_menu',
                                    'fallback_cb' => false,
                                    'link_before'=>'<span class="vt_mblt">',
                                    'link_after'=>'</span>');
                                wp_nav_menu($main_menu);
                            ?>
                            <?php }else{ ?>
                            <?php if ( current_user_can( 'manage_options' ) ){ ?>
                            <ul class="vt_main_menu">
                                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                            </ul>
                            <?php }}?>
                        </div>                        
                        </div>
                    <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_5' :
?>
<header class="vtc-hmain-w vtc-hop5 vt_base_menu vt_md_main">    
<?php if(empty(get_theme_mod('hide_top_bar'))){?>
    <div class="vtc-top-w">
        <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_thc">
                        <div class="vt_htl">
                            <?php if(!empty(get_theme_mod('topl_text'))){?>
                            <div class="vt_hlc"><?php echo wp_kses_post(get_theme_mod('topl_text')); ?></div>
                            <?php }?>
                            <?php if(!empty(get_theme_mod('enable_topl_menu'))){?>
                                <div class="vt_hlnav">
                                    <div class="menu-primary-container navigation_wrapper">
                                    <?php $top_menu = array(
                                                    'theme_location' => 'top_menu',
                                                    'container' => '',
                                                    'menu_class' => 'vt_main_menu',
                                                    'menu_id' => 'vt_top_menu',
                                                    'fallback_cb' => false,
                                                    'link_before'=>'<span class="vt_mblt">',
                                                    'link_after'=>'</span>');
                                                    wp_nav_menu($top_menu);?>
                                    </div>  
                                </div>
                            <?php }?>
                        </div>
                        <div class="vt_htr">
                        <?php if(!empty(get_theme_mod('show_top_date' ))){
                            $date_format = get_theme_mod( 'topbar_date_format', 'l ,  j  F Y' ); ?>
                            <div class="vt_topbar_date">
                                <?php echo date_i18n( $date_format, current_time( 'timestamp' ) ); ?>
                            </div>
					    <?php } ?>
                            <?php if(!empty(get_theme_mod('topr_text'))){?>
                                <div class="vt_hrc"><?php echo wp_kses_post(get_theme_mod('topr_text')); ?></div>
                            <?php }?>
                            <?php if(empty(get_theme_mod('hide_top_social'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>                                                
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php }?>
    <div class="vtc-hmain-logo">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap"> 
                        <div class="vt_head_sub">
                            <a href="<?php echo esc_url(get_theme_mod('vt_subcribe_link')); ?>" target="_blank"><span class="vt_btn_htxt"><?php echo esc_attr(get_theme_mod('vt_subcribe_txt','Subscribe')); ?></span><svg fill="none" stroke="currentColor" stroke-width="1.5px" xmlns="http://www.w3.org/2000/svg" width="23" viewBox="0 0 15.976 11.969"><path d="m9.469.527 5.447 5.516-5.447 5.392"></path><g><path d="M0 5.974h14.5"></path></g><g><path d="M0 5.974h14.5"></path></g></svg></a>
                        </div>
                        <div class="logo_small_wrapper_table">
                                <div class="logo_small_wrapper">
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                                </a>
                                </div>
                        </div>                           
                        <div class="vt_htr">                            
                            <?php if(empty(get_theme_mod('hide_head_share'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>     
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                        </div>                
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                     
                    <div class="search_header_menu vt_mb_nav_left vt_nav_mobile">                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
                    <div class="menu-primary-container navigation_wrapper">
                            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                            <?php $main_menu = array(
                                    'walker' => new visionwp_walker(),
                                    'theme_location' => 'main_menu',
                                    'container' => '',
                                    'menu_class' => 'vt_main_menu',
                                    'fallback_cb' => false,
                                    'link_before'=>'<span class="vt_mblt">',
                                    'link_after'=>'</span>');
                                wp_nav_menu($main_menu);
                            ?>
                            <?php }else{ ?>
                            <?php if ( current_user_can( 'manage_options' ) ){ ?>
                            <ul class="vt_main_menu">
                                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                            </ul>
                            <?php }}?>
                        </div>
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                    </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop5 vt_cus_sihead vt_r_menu">
<div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">    
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_6' :
?>
<header class="vtc-hmain-w vtc-hop6 vt_base_menu vt_md_main">  
<?php if(empty(get_theme_mod('hide_top_bar'))){?>  
    <div class="vtc-top-w">
        <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_thc">
                        <div class="vt_htl">
                            <?php if(!empty(get_theme_mod('topl_text'))){?>
                            <div class="vt_hlc"><?php echo wp_kses_post(get_theme_mod('topl_text')); ?></div>
                            <?php }?>
                            <?php if(!empty(get_theme_mod('enable_topl_menu'))){?>
                                <div class="vt_hlnav">
                                    <div class="menu-primary-container navigation_wrapper">
                                    <?php $top_menu = array(
                                                    'theme_location' => 'top_menu',
                                                    'container' => '',
                                                    'menu_class' => 'vt_main_menu',
                                                    'menu_id' => 'vt_top_menu',
                                                    'fallback_cb' => false,
                                                    'link_before'=>'<span class="vt_mblt">',
                                                    'link_after'=>'</span>');
                                                    wp_nav_menu($top_menu);?>
                                    </div>  
                                </div>
                            <?php }?>
                        </div>
                        <div class="vt_htr">
                        <?php if(!empty(get_theme_mod('show_top_date' ))){
                            $date_format = get_theme_mod( 'topbar_date_format', 'l ,  j  F Y' ); ?>
                            <div class="vt_topbar_date">
                                <?php echo date_i18n( $date_format, current_time( 'timestamp' ) ); ?>
                            </div>
					    <?php } ?>
                            <?php if(!empty(get_theme_mod('topr_text'))){?>
                                <div class="vt_hrc"><?php echo wp_kses_post(get_theme_mod('topr_text')); ?></div>
                            <?php }?>
                            <?php if(empty(get_theme_mod('hide_top_social'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>                                                
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php }?>
    <div class="vtc-hmain-logo">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap"> 
                    <div class="vt_htr">                            
                            <?php if(empty(get_theme_mod('hide_head_share'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>  
                        <div class="logo_small_wrapper_table">
                                <div class="logo_small_wrapper">
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                                </a>
                                </div>
                        </div>                                                      
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                        </div>                
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                                         
                    <div class="menu-primary-container navigation_wrapper">
                            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                            <?php $main_menu = array(
                                    'walker' => new visionwp_walker(),
                                    'theme_location' => 'main_menu',
                                    'container' => '',
                                    'menu_class' => 'vt_main_menu',
                                    'fallback_cb' => false,
                                    'link_before'=>'<span class="vt_mblt">',
                                    'link_after'=>'</span>');
                                wp_nav_menu($main_menu);
                            ?>
                            <?php }else{ ?>
                            <?php if ( current_user_can( 'manage_options' ) ){ ?>
                            <ul class="vt_main_menu">
                                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                            </ul>
                            <?php }}?>
                        </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop6 vt_cus_sihead vt_r_menu">
<div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">    
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_7' :
?>
<header class="vtc-hmain-w vtc-hop7 vt_base_menu vt_md_main">    
<?php if(empty(get_theme_mod('hide_top_bar'))){?>
    <div class="vtc-top-w">
        <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_thc">
                        <div class="vt_htl">
                            <?php if(!empty(get_theme_mod('topl_text'))){?>
                            <div class="vt_hlc"><?php echo wp_kses_post(get_theme_mod('topl_text')); ?></div>
                            <?php }?>
                            <?php if(!empty(get_theme_mod('enable_topl_menu'))){?>
                                <div class="vt_hlnav">
                                    <div class="menu-primary-container navigation_wrapper">
                                    <?php $top_menu = array(
                                                    'theme_location' => 'top_menu',
                                                    'container' => '',
                                                    'menu_class' => 'vt_main_menu',
                                                    'menu_id' => 'vt_top_menu',
                                                    'fallback_cb' => false,
                                                    'link_before'=>'<span class="vt_mblt">',
                                                    'link_after'=>'</span>');
                                                    wp_nav_menu($top_menu);?>
                                    </div>  
                                </div>
                            <?php }?>
                        </div>
                        <div class="vt_htr">
                        <?php if(!empty(get_theme_mod('show_top_date' ))){
                            $date_format = get_theme_mod( 'topbar_date_format', 'l ,  j  F Y' ); ?>
                            <div class="vt_topbar_date">
                                <?php echo date_i18n( $date_format, current_time( 'timestamp' ) ); ?>
                            </div>
					    <?php } ?>
                            <?php if(!empty(get_theme_mod('topr_text'))){?>
                                <div class="vt_hrc"><?php echo wp_kses_post(get_theme_mod('topr_text')); ?></div>
                            <?php }?>
                            <?php if(empty(get_theme_mod('hide_top_social'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>                                                
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php }?>
    <div class="vtc-hmain-logo">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                        
                        <div class="logo_small_wrapper_table">
                                <div class="logo_small_wrapper">
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                                </a>
                                </div>
                        </div>
                        <div class="vt_header_sb">
                        <?php if (is_active_sidebar('header-sidebar')) : dynamic_sidebar('header-sidebar'); endif; ?>
                        </div>                        
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                        </div>                
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                                         
                    <div class="menu-primary-container navigation_wrapper">
                            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                            <?php $main_menu = array(
                                    'walker' => new visionwp_walker(),
                                    'theme_location' => 'main_menu',
                                    'container' => '',
                                    'menu_class' => 'vt_main_menu',
                                    'fallback_cb' => false,
                                    'link_before'=>'<span class="vt_mblt">',
                                    'link_after'=>'</span>');
                                wp_nav_menu($main_menu);
                            ?>
                            <?php }else{ ?>
                            <?php if ( current_user_can( 'manage_options' ) ){ ?>
                            <ul class="vt_main_menu">
                                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                            </ul>
                            <?php }}?>
                        </div>
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop7 vt_cus_sihead vt_r_menu">
<div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">    
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_8' :
?>
<header class="vtc-hmain-w vtc-hop8 vt_base_menu vt_md_main">    
<?php if(empty(get_theme_mod('hide_top_bar'))){?>
    <div class="vtc-top-w">
        <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_thc">
                        <div class="vt_htl">
                            <?php if(!empty(get_theme_mod('topl_text'))){?>
                            <div class="vt_hlc"><?php echo wp_kses_post(get_theme_mod('topl_text')); ?></div>
                            <?php }?>
                            <?php if(!empty(get_theme_mod('enable_topl_menu'))){?>
                                <div class="vt_hlnav">
                                    <div class="menu-primary-container navigation_wrapper">
                                    <?php $top_menu = array(
                                                    'theme_location' => 'top_menu',
                                                    'container' => '',
                                                    'menu_class' => 'vt_main_menu',
                                                    'menu_id' => 'vt_top_menu',
                                                    'fallback_cb' => false,
                                                    'link_before'=>'<span class="vt_mblt">',
                                                    'link_after'=>'</span>');
                                                    wp_nav_menu($top_menu);?>
                                    </div>  
                                </div>
                            <?php }?>
                        </div>
                        <div class="vt_htr">
                        <?php if(!empty(get_theme_mod('show_top_date' ))){
                            $date_format = get_theme_mod( 'topbar_date_format', 'l ,  j  F Y' ); ?>
                            <div class="vt_topbar_date">
                                <?php echo date_i18n( $date_format, current_time( 'timestamp' ) ); ?>
                            </div>
					    <?php } ?>
                            <?php if(!empty(get_theme_mod('topr_text'))){?>
                                <div class="vt_hrc"><?php echo wp_kses_post(get_theme_mod('topr_text')); ?></div>
                            <?php }?>
                            <?php if(empty(get_theme_mod('hide_top_social'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>                                                
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php }?>
    <div class="vtc-hmain-logo">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                        
                        <div class="logo_small_wrapper_table">
                                <div class="logo_small_wrapper">
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                                </a>
                                </div>
                        </div>
                        <div class="vt_header_sb">
                        <?php if (is_active_sidebar('header-sidebar')) : dynamic_sidebar('header-sidebar'); endif; ?>
                        </div>                        
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                        </div>                
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                                         
                    <div class="menu-primary-container navigation_wrapper">
                            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                            <?php $main_menu = array(
                                    'walker' => new visionwp_walker(),
                                    'theme_location' => 'main_menu',
                                    'container' => '',
                                    'menu_class' => 'vt_main_menu',
                                    'fallback_cb' => false,
                                    'link_before'=>'<span class="vt_mblt">',
                                    'link_after'=>'</span>');
                                wp_nav_menu($main_menu);
                            ?>
                            <?php }else{ ?>
                            <?php if ( current_user_can( 'manage_options' ) ){ ?>
                            <ul class="vt_main_menu">
                                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                            </ul>
                            <?php }}?>
                        </div>
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop8 vt_cus_sihead vt_r_menu">
<div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">    
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
case 'header_9' :
?>
<header class="vtc-hmain-w vtc-hop9 vt_base_menu vt_md_main">    
<?php if(empty(get_theme_mod('hide_top_bar'))){?>
    <div class="vtc-top-w">
        <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_thc">
                        <div class="vt_htl">
                            <?php if(!empty(get_theme_mod('topl_text'))){?>
                            <div class="vt_hlc"><?php echo wp_kses_post(get_theme_mod('topl_text')); ?></div>
                            <?php }?>
                            <?php if(!empty(get_theme_mod('enable_topl_menu'))){?>
                                <div class="vt_hlnav">
                                    <div class="menu-primary-container navigation_wrapper">
                                    <?php $top_menu = array(
                                                    'theme_location' => 'top_menu',
                                                    'container' => '',
                                                    'menu_class' => 'vt_main_menu',
                                                    'menu_id' => 'vt_top_menu',
                                                    'fallback_cb' => false,
                                                    'link_before'=>'<span class="vt_mblt">',
                                                    'link_after'=>'</span>');
                                                    wp_nav_menu($top_menu);?>
                                    </div>  
                                </div>
                            <?php }?>
                        </div>
                        <div class="vt_htr">
                        <?php if(!empty(get_theme_mod('show_top_date' ))){
                            $date_format = get_theme_mod( 'topbar_date_format', 'l ,  j  F Y' ); ?>
                            <div class="vt_topbar_date">
                                <?php echo date_i18n( $date_format, current_time( 'timestamp' ) ); ?>
                            </div>
					    <?php } ?>
                            <?php if(!empty(get_theme_mod('topr_text'))){?>
                                <div class="vt_hrc"><?php echo wp_kses_post(get_theme_mod('topr_text')); ?></div>
                            <?php }?>
                            <?php if(empty(get_theme_mod('hide_top_social'))){?>
                            <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                            <?php }?>
                        </div>                                                
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php }?>
    <div class="vtc-hmain-logo">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                        
                        <div class="logo_small_wrapper_table">
                                <div class="logo_small_wrapper">
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                </<?php echo esc_html($logo_tag); ?>>
                                </a>
                                </div>
                        </div>
                        <div class="vt_logo_right">
                            <div class="vt_htr">
                                <?php if(empty(get_theme_mod('hide_head_share'))){?>
                                <div class="vt_hrsh"><?php get_template_part( 'inc/misc/section', 'social' );?></div>
                                <?php }?>                            
                            </div>     
                            <div class="vt_head_sub">
                                <a href="<?php echo esc_url(get_theme_mod('vt_subcribe_link')); ?>" target="_blank"><span class="vt_btn_htxt"><?php echo esc_attr(get_theme_mod('vt_subcribe_txt','Subscribe')); ?></span><svg fill="none" stroke="currentColor" stroke-width="1.5px" xmlns="http://www.w3.org/2000/svg" width="23" viewBox="0 0 15.976 11.969"><path d="m9.469.527 5.447 5.516-5.447 5.392"></path><g><path d="M0 5.974h14.5"></path></g><g><path d="M0 5.974h14.5"></path></g></svg></a>
                            </div>
                        </div>                        
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                        </div>                
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="vtc-hmain-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">                                         
                    <div class="menu-primary-container navigation_wrapper">
                            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
                            <?php $main_menu = array(
                                    'walker' => new visionwp_walker(),
                                    'theme_location' => 'main_menu',
                                    'container' => '',
                                    'menu_class' => 'vt_main_menu',
                                    'fallback_cb' => false,
                                    'link_before'=>'<span class="vt_mblt">',
                                    'link_after'=>'</span>');
                                wp_nav_menu($main_menu);
                            ?>
                            <?php }else{ ?>
                            <?php if ( current_user_can( 'manage_options' ) ){ ?>
                            <ul class="vt_main_menu">
                                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
                            </ul>
                            <?php }}?>
                        </div>
                        <div class="search_header_menu vt_nav_mobile">                        
                        <?php 
                        get_template_part( 'inc/misc/section', 'switch' );
                        get_template_part( 'inc/misc/section', 'basket' );                        
                        if(!get_theme_mod('disable_top_search')==1){?>
                            <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
                        <?php }?>                        
                        <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
                    </div>
    </div>
    </div>
</div>
</div>
</div>
</header>
<header class="vtc-stick-main-w vtc-hop9 vt_cus_sihead vt_r_menu">
<div class="vtc-stick-main-in">
    <div class="vtc-container">
            <div class="vtc-row">
                <div class="vtc-col-md-12">    
                    <div class="vt_hwrap">    
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                                <?php $logo_n = get_theme_mod('typecase_logo'); ?>
                                <?php if (!empty($logo_n)): ?>
                                <img class="vt_logo_n" src="<?php echo esc_url($logo_n); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_n" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_n.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                                <?php $logo_w = get_theme_mod('typecase_logow'); ?>
                                <?php if (!empty($logo_w)): ?>
                                <img class="vt_logo_w" src="<?php echo esc_url($logo_w); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php else: ?>
                                <img class="vt_logo_w" src="<?php echo esc_url(get_template_directory_uri().'/img/logo_w.png'); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php endif; ?>
                            </a>
                            </div>
                        </div>
        <div class="menu-primary-container navigation_wrapper">
            <?php if ( has_nav_menu( 'main_menu' ) ){ ?>
            <?php $main_menu = array(
                    'walker' => new visionwp_walker(),
                    'theme_location' => 'main_menu',
                    'container' => '',
                    'menu_class' => 'vt_main_menu',
                    'fallback_cb' => false,
                    'link_before'=>'<span class="vt_mblt">',
                    'link_after'=>'</span>');
                   wp_nav_menu($main_menu);
            ?>
            <?php }else{ ?>
            <?php if ( current_user_can( 'manage_options' ) ){ ?>
            <ul class="vt_main_menu">
                <li class="menu-item"><a href="<?php echo esc_url(admin_url( 'nav-menus.php' )); ?>">
                <?php esc_html_e( 'Click here to add navigation menu', 'typecase' ); ?></a></li>
            </ul>
            <?php }}?>
        </div>
        <div class="search_header_menu vt_nav_mobile">                        
            <?php 
            get_template_part( 'inc/misc/section', 'switch' );
            get_template_part( 'inc/misc/section', 'basket' );                        
            if(!get_theme_mod('disable_top_search')==1){?>
                <div class="search_header_wrapper search_form_menu_personal_click"><i class="vti-search"></i></div>
            <?php }?>                        
            <div class="menu_mobile_icons vt_tog_mob <?php if(!empty(get_theme_mod('show_mb_nav'))){echo 'vt_desk_show';}?>"><div class="vtm_w"><span class="vtma"></span><span class="vtmb"></span><span class="vtmc"></span></div></div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
</header>
<?php
break;
}
}