<?php
if ( ! function_exists( 'typecase_mcarousel' ) ) {
	function typecase_mcarousel( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            		=> '',
			'name'               		=> 'vt_mcarousel',
			'category'           		=> '',
			'categories'         		=> '',
			'format'             		=> '',
			'tags'               		=> '',
			'author'             		=> '',
			'post_not_in'        		=> '',
			'post_in'            		=> '',
			'order'              		=> '',
			'posts_per_page'     		=> '',
			'offset'             		=> '',
			'car_type' 			 		=> 'carousel1',
			'desktop_item' 				=> '',
			'tablet_item' 		 		=> '',
			'small_mobile_item' 		=> '',
			'large_mobile_item' 		=> '',
			'landscape_mobile_item' 	=> '',
			'slider_speed' 				=> '',
			'slider_spacebetween'		=> '',
			'slider_loop' 		 		=> '',
			'slider_autoplay' 			=> '',
			'slider_autoplay_delay' 	=> '',
			'slider_arrow' 				=> '',
			'slider_dots' 				=> '',
			'sl_center_mode' 	 		=> 'false',
			'sl_center_padding' 		=> '0',
			'pagination'        		=> false,
			'vt_hide_cat'       		=> '',
			'vt_hide_author'    		=> '',
			'vt_hide_date'      		=> '',
			'vt_hide_meta'      		=> '',
			'vt_hide_desc'       		=> '',
			'vt_hide_review'     		=> '',
			'vt_hide_line'       		=> '',
			'vt_cus_img'     => '',
		), $attrs );
		$module['classes']         = 'vt-main-block';
		$module['content_classes'] = 'vt-col-row';
		$total_posts = $module['posts_per_page'];
		$sltype = $module['car_type'];
		$query_data = typecase_query( $module );
		$module['posts_per_page'] = $total_posts;
		$module['car_type'] = $sltype;
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';
		$atts_style[] = $module['car_type'];
		if ( ! empty( $module['classes'] ) ) {
			$atts_style[] = $module['classes'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		$sl_center_mode = $module['sl_center_mode'];
		if($sl_center_mode == 'yes'){
			$sl_center_mode = "true";
		}else{
			$sl_center_mode = "false";
		}
		$sl_center_padding = $module['sl_center_padding'];
		$atts_style = implode( ' ', $atts_style );
		$items = [
                'desktop'           => $module['desktop_item'],
                'tablet'            => $module['tablet_item'],
                'small_mobile'      => $module['small_mobile_item'],
                'large_mobile'      => $module['large_mobile_item'],
                'landscape_mobile'  => $module['landscape_mobile_item'],
        ];
        $slider_settings = [
                'slideitem'    => $items,
                'speed'        => absint( $module['slider_speed'] ),
                'spacebetween' => absint( $module['slider_spacebetween'] ),
                'loop'         => ( 'yes' === $module['slider_loop'] ),
                'autoplay'     => ( 'yes' === $module['slider_autoplay'] ),
                'autoplay_delay'=> absint( $module['slider_autoplay_delay'] ),
                'effect'       => 'slide',
                'navigation'   => ( 'yes' === $module['slider_arrow'] ),
                'pagination'   => ( 'yes' === $module['slider_dots'] ),
                'uniqid'       => $module['blockid']
        ];
		?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="<?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php
		if ( empty( $module['car_type'] ) ) {
			$module['car_type'] = 'carousel1';
			$atts_style .= ' ' . $module['car_type'];
		}
		if ( $query_data->have_posts() ) :

			$atts_style = 'vt-roww content-inner vt_caropt_w';
		if ( ! empty( $module['content_classes'] ) ) {
			$atts_style .= ' ' . $module['content_classes'];
		}?>
			<div class="<?php echo esc_attr( $atts_style ); ?>">
				<div class="vt-eb-sl swiper-container" data-settings='<?php echo esc_attr(wp_json_encode( $slider_settings )); ?>'>
				<div class="swiper-wrapper">
	    	<?php
				switch ( $module['car_type'] ) {
					case 'carousel1' :
						typecase_mcarousel_a_listing( $module, $query_data );
					break;
					case 'carousel2' :
						typecase_mcarousel_b_listing( $module, $query_data );
					break;
					case 'carousel3' :
						typecase_mcarousel_c_listing( $module, $query_data );
					break;
					case 'carousel4' :
						typecase_mcarousel_d_listing( $module, $query_data );
					break;
				}
	    	?>
	    		</div>
	    		<?php if ( 'yes' === $module['slider_dots'] ) {?>
	    		<div class="vtc-pagination-<?php echo esc_attr( $module['blockid'] ); ?> vt_spw"><div class="swiper-pagination"></div></div>
	    		<?php }?>
	    		<?php if ( 'yes' === $module['slider_arrow'] ) {?>
	    		<div class="vtc-navigation-<?php echo esc_attr( $module['blockid'] ); ?>"><div class="vt-swiper-button-next"><div class="vt-spn-inner"><i class="vti-right-chevron-1"></i></div></div><div class="vt-swiper-button-prev"><div class="vt-spn-inner"><i class="vti-left-chevron-1"></i></div></div></div>
	    		<?php }?>
	    		</div>
			</div>
		</div>
			<?php
			wp_reset_postdata();
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_mcarousel_a_listing' ) ) :
	function typecase_mcarousel_a_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
			<div class="swiper-slide vt_gna">
          <div class="slide-inner">
          	<div class="vt_cgrid_layout">
			    	<?php if ( has_post_thumbnail()) {?>
			        <div class="vt_imgw">
			            <div class="vt_imgin">
								<?php 
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_list');
								}?>
			            </div>
			            <?php typecase_video_media(get_the_ID());?>
			            <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
						<?php typecase_post_tumb_cat(get_the_ID());?>
			        </div>
			    	<?php }?>
			    	<div class="vt_fe_text">
			        <?php typecase_post_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <?php typecase_post_meta(get_the_ID());?>
			    </div>
					</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;


if ( ! function_exists( 'typecase_mcarousel_b_listing' ) ) :
	function typecase_mcarousel_b_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
		  <div class="swiper-slide">
          <div class="slide-inner">
          	<div class="vt_ov_layout vt_ov_el">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw">
				            <div class="vt_imgin">
								<?php 
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_list');
								}?>
				            </div>
				            <?php typecase_video_media(get_the_ID());?>
			            	<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div>
			        </div>
			    <?php }?>
			    <div class="vt_fe_text">
			    	<div class="vt_fe_inner">
			    	<?php typecase_post_ov_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <?php typecase_post_meta(get_the_ID());?>
			        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
			        </div>
			    </div>
			</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;

if ( ! function_exists( 'typecase_mcarousel_c_listing' ) ) :
	function typecase_mcarousel_c_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
		  <div class="swiper-slide">
          <div class="slide-inner">
          	<div class="vt_ov_layout vt_ov_bg vt_ov_el">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw">
				            <div class="vt_imgin">
								<?php 
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_list');
								}?>
				            </div>
				            <?php typecase_video_media(get_the_ID());?>
			            	<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div>
			        </div>
			    <?php }?>
			    <div class="vt_fe_text">
			    	<div class="vt_fe_inner">
			    	<?php typecase_post_list_cat(get_the_ID());?>
			        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <?php typecase_post_meta(get_the_ID());?>
			        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
			        </div>
			    </div>
			</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;

if ( ! function_exists( 'typecase_mcarousel_d_listing' ) ) :
	function typecase_mcarousel_d_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
			<div class="swiper-slide vt_gbg">
          <div class="slide-inner">
          	<div class="vt_cgrid_layout">
			    	<?php if ( has_post_thumbnail()) {?>
			        <div class="vt_imgw">
			            <div class="vt_imgin">
								<?php 
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_list');
								}?>
			            </div>
			            <?php typecase_video_media(get_the_ID());?>
			            <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
						<?php typecase_post_tumb_cat(get_the_ID());?>
			        </div>
			    	<?php }?>
			    	<div class="vt_fe_text">
			        <?php typecase_post_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <?php typecase_post_meta(get_the_ID());?>
			    </div>
					</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;
