<?php
if ( ! function_exists( 'typecase_lgrid' ) ) {
	function typecase_lgrid( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'               => '',
			'section_style'      => 'large_layout1',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',
			'layout_style'       => 'large_layout1',
			'pagination'         => '',
			'vt_hide_cat'        => '',
			'vt_hide_author'     => '',
			'vt_hide_date'       => '',
			'vt_hide_meta'       => '',
			'vt_hide_desc'       => '',
			'vt_hide_line'       => '',
			'vt_hide_review'     => '',
			'vt_cus_img'     => '',
		), $attrs );		

		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';

		$total_posts = $module['posts_per_page'];		
		$query_data = typecase_query( $module );
		$module['posts_per_page'] = $total_posts;	
		$module['section_style'] = $module['layout_style'];

		ob_start();

		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}		
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		$atts_style = implode( ' ', $atts_style ); ?>		
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="vt_clear_at <?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>		
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww vt_contain vt_lg_opt';
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		}
		?>
		<div class="vt_l_wrap_f vt_wrap_eb vt_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">			
			<?php			
			switch ( $module['layout_style'] ) {			
				case 'large_layout1' :
					typecase_large_layout1( $module, $query_data );
				break;
				case 'large_layout2' :
					typecase_large_layout2( $module, $query_data );
				break;
				case 'large_layout3' :
					typecase_large_layout3( $module, $query_data );
				break;			
				case 'large_layout4' :
					typecase_large_layout4( $module, $query_data );
				break;			
				case 'large_layout5' :
					typecase_large_layout5( $module, $query_data );
				break;			
			}
			echo '</div>';
			typecase_blocknav( $module, $query_data );
			echo '</div></div>';
			wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_large_layout1' ) ) :
	function typecase_large_layout1( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="vt_lg_op vt_lg_l1 vt_lasep">			
					<div class="vt_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="vt_img_holder">
						<div class="vt_imgw vt_radus_e">
							<div class="vt_imgin">
								<?php
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_medium');
								}?>
							</div>
							<?php typecase_video_media(get_the_ID());?>
							<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="vt_imgl" href="<?php the_permalink();?>"></a>
							<?php typecase_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="vt_fe_text">
							<?php typecase_post_cat(get_the_ID());?>
							<h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php typecase_post_meta(get_the_ID());?>
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'typecase_large_layout2' ) ) :
	function typecase_large_layout2( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="vt_lg_op vt_lg_l2 vt_lasep">			
					<div class="vt_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="vt_img_holder">
						<div class="vt_imgw vt_radus_e">
							<div class="vt_imgin">
								<?php
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_medium');
								}?>
							</div>
							<?php typecase_video_media(get_the_ID());?>
							<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="vt_imgl" href="<?php the_permalink();?>"></a>
							<?php typecase_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="vt_fe_text">
							<?php typecase_post_cat(get_the_ID());?>
							<h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php typecase_post_meta(get_the_ID());?>
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'typecase_large_layout3' ) ) :
	function typecase_large_layout3( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="vt_lg_op vt_lg_l3 vt_lasep">			
					<div class="vt_lg_op_in">                    					
					<div class="vt_fe_text">
							<?php typecase_post_cat(get_the_ID());?>
							<h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<?php typecase_post_meta(get_the_ID());?>
						</div>
						<?php if ( has_post_thumbnail()) {?>
						<div class="vt_img_holder">
						<div class="vt_imgw vt_radus_e">
							<div class="vt_imgin">
								<?php
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_medium');
								}?>
							</div>
							<?php typecase_video_media(get_the_ID());?>
							<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="vt_imgl" href="<?php the_permalink();?>"></a>
							<?php typecase_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="vt_fe_text vt_fe_txt_bot">
							<p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 52, '...' );?> </p>							
							<?php typecase_button_txt();?>
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'typecase_large_layout4' ) ) :
	function typecase_large_layout4( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="vt_lg_op vt_lg_l4 vt_lasep">			
					<div class="vt_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="vt_img_holder">
						<div class="vt_imgw vt_radus_e">
							<div class="vt_imgin">
								<?php
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_medium');
								}?>
							</div>
							<?php typecase_video_media(get_the_ID());?>
							<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="vt_imgl" href="<?php the_permalink();?>"></a>
							<?php typecase_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="vt_fe_text">
							<?php typecase_post_cat(get_the_ID());?>
							<h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php typecase_post_meta(get_the_ID());?>
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'typecase_large_layout5' ) ) :
	function typecase_large_layout5( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="vt_lg_op vt_lg_l5 vt_lasep">			
					<div class="vt_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="vt_img_holder">
						<div class="vt_imgw vt_radus_e">
							<div class="vt_imgin">
								<?php
								if ($module['vt_cus_img'] != '' ) {
									the_post_thumbnail($module['vt_cus_img']);
								}else{
									the_post_thumbnail('typecase_medium');
								}?>
							</div>
							<?php typecase_video_media(get_the_ID());?>
							<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="vt_imgl" href="<?php the_permalink();?>"></a>
							<?php typecase_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="vt_fe_text">
							<?php typecase_post_cat(get_the_ID());?>
							<h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php typecase_post_meta(get_the_ID());?>
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;