<?php
if ( ! function_exists( 'typecase_feature_layout_10' ) ) {
	function typecase_feature_layout_10( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'vt_feature_10',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',
			'pagination'         => false,
			'vt_hide_cat'        => '',
			'vt_hide_author'     => '',
			'vt_hide_date'       => '',
			'vt_hide_meta'       => '',
			'vt_hide_desc'       => '',
			'vt_hide_review'     => '',
			'vt_hide_line'       => '',
			'vt_hide_col_line'   => '',
			'vt_light_mode'      => '',
		), $attrs );			       		
		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';		
		$query_data = typecase_query( $module );		
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		if ( 'yes' === $module['vt_hide_col_line'] ) {
			$atts_style[] = 'vt_hide_col_line';
		}
		if ( 'yes' === $module['vt_light_mode'] ) {
			$atts_style[] = 'vt_light_mode';
		}
		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="<?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww vt_contain';		
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		} ?>
		<div class="vt_mb_wrap_f vt_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">
				<div class="vt_fr10_wrap">
					<div class="vt_fr10_inner">
						<?php typecase_feature_10_listing( $module, $query_data ); ?>			
					</div>	
				</div>
			</div>
		</div>
	</div>		
			<?php
			wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_feature_10_listing' ) ) :
	function typecase_feature_10_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 0;
			$pnum = $query_data->post_count;
			while ( $query_data->have_posts() ) :				
				$query_data->the_post();								
				if($counter == 0){
					vt_layout_m_r_10( $module );
				}elseif ($counter == 1 || $counter == 2) {
					vt_layout_md_10( $module );
					if ($counter == 2) {
						echo '<div class="vt_fli_con vt_p_fr10"><div class="vt_fli_wrap">';
					}						
				}else{
					vt_layout_m_r_sm_10( $module );
				}				
				if(++$counter === $pnum) {
   					 echo "</div></div>";
  				}
				// $counter ++;
			endwhile;
		endif;
	}
endif;

if ( ! function_exists( 'vt_layout_m_r_10' ) ) :
	function vt_layout_m_r_10( $module = array() ) {?>
		<div class="vt_p_fr10 vt_m_fr10 vt_ov_el vt_radus_e">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw">
				            <div class="vt_imgin">
				                <?php the_post_thumbnail('typecase_medium');?>
				            </div>				
				            <?php typecase_video_media(get_the_ID());?>
			            	<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>            
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div> 
			        </div> 
			    <?php }?>                            
			    <div class="vt_fe_text">
			    	<div class="vt_fe_inner">
			    	<?php typecase_post_ov_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>			
			        <?php typecase_post_meta(get_the_ID());?>                
			        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
			        </div>
			    </div>
			</div>
	<?php }
endif;

if ( ! function_exists( 'vt_layout_md_10' ) ) :
	function vt_layout_md_10( $module = array() ) {?>
		<div class="vt_p_fr10 vt_ov_el vt_md_ov vt_radus_e">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw">
				            <div class="vt_imgin">
				                <?php the_post_thumbnail('typecase_layouts');?>
				            </div>				
				            <?php typecase_video_media(get_the_ID());?>
			            	<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>            
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div> 
			        </div> 
			    <?php }?>                            
			    <div class="vt_fe_text">
			    	<div class="vt_fe_inner">
			    	<?php typecase_post_ov_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>			
			        <?php typecase_post_meta(get_the_ID());?>                
			        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
			        </div>
			    </div>
			</div>
	<?php }
endif;

if ( ! function_exists( 'vt_layout_m_r_sm_10' ) ) :
	function vt_layout_m_r_sm_10( $module = array() ) {?>
			<div class="vt_mmlist_layout vt_lisep">
				<div class="vt_li_in">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw vt_radus_e">
				            <div class="vt_imgin">
				                <?php the_post_thumbnail('typecase_small');?>
				            </div>				            
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div> 
			        </div> 
			    <?php }?>                            
			    <div class="vt_fe_text">    
			        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>			
			        <?php typecase_post_meta_date(get_the_ID());?>                
			    </div>
			</div>
		</div>
	<?php }
endif;