<?php
if ( ! function_exists( 'typecase_feature_layout_7' ) ) {
	function typecase_feature_layout_7( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'vt_feature_7',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => 5,
			'offset'             => '',
			'pagination'         => false,
			'vt_hide_cat'        => '',
			'vt_hide_author'     => '',
			'vt_hide_date'       => '',
			'vt_hide_meta'       => '',
			'vt_hide_desc'       => '',
			'vt_hide_review'     => '',
			'vt_hide_line'       => '',
			'vt_hide_col_line'   => '',
			'vt_light_mode'      => '',
		), $attrs );			       		

		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';
		
		$query_data = typecase_query( $module );		
		ob_start();

		$atts_style   = array();
		$atts_style[] = 'block-section';		

		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		if ( 'yes' === $module['vt_hide_col_line'] ) {
			$atts_style[] = 'vt_hide_col_line';
		}
		if ( 'yes' === $module['vt_light_mode'] ) {
			$atts_style[] = 'vt_light_mode';
		}

		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="<?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww vt_contain';		
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		} ?>
		<div class="vt_mb_wrap_f vt_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">
			<?php typecase_feature_7_listing( $module, $query_data ); ?>			
			</div>
		</div>
	</div>		
			<?php
			wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_feature_7_listing' ) ) :
	function typecase_feature_7_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			echo '<div class="vt_fr7_wrap"><div class="vt_fr7_inner">';
			$counter = 1;
			$get_main_ft = TRUE;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
				if($get_main_ft){
				vt_layout_m_r_7( $module );
				$get_main_ft = FALSE;
				}else{
				vt_layout_m_r_sm_7( $module );
				}
			endwhile;
			echo '</div></div>';			
		endif;
	}
endif;

if ( ! function_exists( 'vt_layout_m_r_7' ) ) :
	function vt_layout_m_r_7( $module = array() ) {?>
		<div class="vt_p_fr7 vt_m_fr7">
			<div class="vt_m_fr7_inner">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_imgw vt_radus_e">
			            <div class="vt_imgin">
			                <?php the_post_thumbnail('typecase_medium');?>
			            </div>
			            <?php typecase_video_media(get_the_ID());?>
			            <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
						<?php typecase_post_tumb_cat(get_the_ID());?>
			        </div> 
			    <?php }?>                            
			    <div class="vt_fe_text">    
			        <?php typecase_post_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 30, '...' );?> </p>
			        <?php typecase_post_meta(get_the_ID());?>                
			    </div>
			 </div>
		</div>
	<?php }
endif;

if ( ! function_exists( 'vt_layout_m_r_sm_7' ) ) :
	function vt_layout_m_r_sm_7( $module = array() ) {?>
	<div class="vt_p_fr7 vt_cgrid_layout">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_imgw vt_radus_e">
			            <div class="vt_imgin">
			                <?php the_post_thumbnail('typecase_layouts');?>
			            </div>
			            <?php typecase_video_media(get_the_ID());?>
			            <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
						<?php typecase_post_tumb_cat(get_the_ID());?>
			        </div> 
			    <?php }?>                            
			    <div class="vt_fe_text">    
			        <?php typecase_post_cat(get_the_ID());?>
			        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <?php typecase_post_meta(get_the_ID());?>                
			    </div>
			</div>
	<?php }
endif;