<?php
if ( ! function_exists( 'typecase_feature_layout_9' ) ) {
	function typecase_feature_layout_9( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'vt_feature_9',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => 5,
			'offset'             => '',
			'pagination'         => false,
			'vt_hide_cat'        => '',
			'vt_hide_author'     => '',
			'vt_hide_date'       => '',
			'vt_hide_meta'       => '',
			'vt_hide_desc'       => '',
			'vt_hide_review'     => '',
			'vt_hide_line'       => '',
			'btn_txt'      		 => '',			
		), $attrs );			       		
		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';		
		$query_data = typecase_query( $module );		
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="<?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww vt_contain';		
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		} ?>
		<div class="vt_mb_wrap_f vt_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">
				<div class="vt_fr9_wrap">
					<div class="vt_fr9_inner">
						<?php typecase_feature_9_listing( $module, $query_data ); ?>			
					</div>	
				</div>
			</div>
		</div>
	</div>		
			<?php
			wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_feature_9_listing' ) ) :
	function typecase_feature_9_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 0;
			$pnum = $query_data->post_count;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();								
				if($counter == 0){
					vt_layout_img_9( $module );?>
					<div class="vt_fli_con">
					<?php vt_layout_m_r_9( $module );?>
					<div class="vt_fli_wrap">
				<?php }else{
					vt_layout_m_r_sm_9( $module );
				}
				if(++$counter === $pnum) {
   					 echo "</div></div>";
  				}
			endwhile;
		endif;
	}
endif;

if ( ! function_exists( 'vt_layout_img_9' ) ) :
	function vt_layout_img_9( $module = array() ) {?>
		<?php if ( has_post_thumbnail()) {?>
			        <div class="vt_imgm_holder">
				        <div class="vt_imgw vt_p_img">
				            <div class="vt_imgin">
				                <?php the_post_thumbnail('typecase_large');?>
				            </div>
				            <?php typecase_video_media(get_the_ID());?>
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div>		
			        </div>		
	<?php }}
endif;

if ( ! function_exists( 'vt_layout_m_r_9' ) ) :
	function vt_layout_m_r_9( $module = array() ) {?>
			    <div class="vt_fe_text vt_fe_main">    
					<?php typecase_post_ov_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 20, '...' );?> </p>
			        <?php typecase_post_meta(get_the_ID());?> 
					<?php typecase_button_txt(get_the_ID());?> 			        
			        <a class="vt_imgl" href="<?php the_permalink();?>"></a>
			    </div>			
	<?php }
endif;

if ( ! function_exists( 'vt_layout_m_r_sm_9' ) ) :
	function vt_layout_m_r_sm_9( $module = array() ) {?>
			<div class="vt_cslist_layout">
				<div class="vt_li_in">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw vt_radus_e">
				            <div class="vt_imgin"><?php the_post_thumbnail('typecase_small');?></div>
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div> 
			        </div> 
			    <?php }?>                            
			    <div class="vt_fe_text">    
			        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <?php typecase_post_meta_date(get_the_ID());?>                
			    </div>
			</div>
			</div>
	<?php }
endif;