<?php
if ( ! function_exists( 'typecase_grid_number' ) ) {
	function typecase_grid_number( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'vt_g_number',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',
			'pagination'         => '',
			'show_excep'         => '',
			'tabs_link'       	 => '',
			'tabs_link_ids'   	 => '',
			'tabs_link_label' 	 => '',
			'vt_hide_cat'        => '',
			'vt_hide_author'     => '',
			'vt_hide_date'       => '',
			'vt_hide_meta'       => '',
			'vt_hide_desc'       => '',
			'vt_hide_review'     => '',
			'vt_hide_line'       => '',
			'vt_hide_col_line'   => '',
		), $attrs );
		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';
		$total_posts = $module['posts_per_page'];
		$query_data = typecase_query( $module );
		$show_excep = $module['show_excep'];
		$module['posts_per_page'] = $total_posts;
		$module['show_excep'] = $show_excep;
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		if ( 'yes' === $module['vt_hide_col_line'] ) {
			$atts_style[] = 'vt_hide_col_line';
		}
		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="vt_clear_at <?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php typecase_block_tabs_link( $module ); ?>
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww vt_contain vt_cgrid_wrap vt_cgrid_num';
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		}
		?>
		<div class="vt_grid_wrap_f vt_wrap_eb vt_wrap_eb vt_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">
			<?php
			typecase_g_number_listing( $module, $query_data );
			echo '</div>';
			typecase_blocknav( $module, $query_data );
			echo '</div></div>';
			wp_reset_postdata();
		endif;
		return ob_get_clean();
	}
}
if ( ! function_exists( 'typecase_block_tabs_link' ) ) :
	function typecase_block_tabs_link( $module ) {
		if ( empty( $module['tabs_link'] ) || empty( $module['blockid'] ) ) {
			return;
		}
		if ( empty( $module['tabs_link_ids'] ) ) {
			$module['tabs_link_ids'] = '';
		}
		if ( empty( $module['tabs_link_label'] ) ) {
			$module['tabs_link_label'] = esc_html__('all', 'typecase');
		}
		$data = typecase_add_settings_tabs_links( $module['tabs_link'], $module['tabs_link_ids'] );
		if ( empty( $data ) || ! is_array( $data ) ) {
			return;
		} ?>
		<div id="<?php echo 'ajax_filter_' . $module['blockid']; ?>" class="vt_ajax_w vt_clear_at">
			<div class="vt_ajax_c vt_clear_at">
				<span class="ajax_nav_item"><a href="#" class="vt-block-link vt-tab-link vt-ac-m" data-ajax_filter_val="0"><?php echo esc_html( $module['tabs_link_label'] ); ?></a></span>
				<?php foreach ( $data as $item ) : ?>
					<span class="ajax_nav_item"><a href="#" class="vt-block-link vt-tab-link" data-ajax_filter_val="<?php echo esc_attr( $item['id'] ); ?>"><?php echo esc_html( $item['name'] ); ?></a></span>
				<?php endforeach; ?>
			</div>
		</div>
	<?php
	}
endif;

if ( ! function_exists( 'typecase_g_number_listing' ) ) :
	function typecase_g_number_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
				?>
				<div class="vt_cgrid_layout">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_imgw vt_radus_e">
			            <div class="vt_imgin">
			                <?php the_post_thumbnail('typecase_layouts');?>
			            </div>
			            <?php typecase_video_media(get_the_ID());?>
			            <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			            <div class="vt_sgnum"></div>
			            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
			        </div>
			    <?php }?>
			    <div class="vt_fe_text">
					<?php typecase_post_list_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>

			        <?php typecase_post_meta(get_the_ID());?>
			    </div>
			</div>
			<?php
			endwhile;
		endif;
	}
endif;
