<?php
if ( ! function_exists( 'typecase_hover_case' ) ) {
	function typecase_hover_case( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'               	=> '',
			'name'               		=> 'vt_hover_case',
			'category'           		=> '',
			'categories'         		=> '',
			'format'             		=> '',
			'tags'               		=> '',
			'author'             		=> '',
			'post_not_in'        		=> '',
			'post_in'            		=> '',
			'order'              		=> '',
			'posts_per_page'     		=> '',
			'offset'             		=> '',			
			'pagination'         		=> false,
		), $attrs );
		$module['classes']         	= 'vt-main-block';
		$module['content_classes'] 	= 'vt-col-row';
		$total_posts = $module['posts_per_page'];
		$query_data = typecase_query( $module );
		$module['posts_per_page'] = $total_posts;
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';
		if ( ! empty( $module['classes'] ) ) {
			$atts_style[] = $module['classes'];
		}
		$atts_style = implode( ' ', $atts_style );
		?>				
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="<?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php		
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww content-inner';		
		if ( ! empty( $module['content_classes'] ) ) {
			$atts_style .= ' ' . $module['content_classes'];
		} ?>
			<div class="<?php echo esc_attr( $atts_style ); ?>">				
		    	<div class="vt-showcase-container">
        			<div class="vt-showcase-wrapper">
		    			<?php typecase_hover_con_listing( $module, $query_data );?>		    		
		    		</div>
		    		<div class="vt-img-wrap">
		    			<?php typecase_hover_img_listing( $module, $query_data );?>		    		
		    		</div>
		    	</div>
			</div>			
		</div>
		<?php
		wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_hover_con_listing' ) ) :
	function typecase_hover_con_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 0;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();								
			?>
			<?php if($counter == 0){?>
				<div class="vt-showcase-content vt-showcase-active">
			<?php }else{?>
				<div class="vt-showcase-content">
			<?php }?>			    			 	  
          	  		<div class="vt-showcase-item-inner">
					    <div class="vt_fe_text">
					    	<div class="vt_fe_inner">
					    	<?php typecase_post_ov_cat(get_the_ID());?>
					        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>			
					        <?php typecase_post_meta(get_the_ID());?>                
					        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
					        </div>
					    </div>
					</div>
          </div>
      	<?php
      	$counter++;
			endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'typecase_hover_img_listing' ) ) :
	function typecase_hover_img_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 0;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();								
			?>
			<?php if($counter == 0){?>
				<div class="vt-img-inner vt-showcase-active">
			<?php }else{?>
				<div class="vt-img-inner">
			<?php }?>			    
				    <?php if ( has_post_thumbnail()) {?>
				        <div class="vt_img_holder">
					        <div class="vt_imgw">
					            <div class="vt_imgin">
					                <?php the_post_thumbnail('typecase_large');?>
					            </div>				
					            <?php typecase_video_media(get_the_ID());?>				            	
					            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
					        </div> 
				        </div> 
				    <?php }?>
				</div>
			<?php
			$counter++;
			endwhile;			
		endif;
	}
endif;