<?php
if ( ! function_exists( 'typecase_xsg' ) ) {
	function typecase_xsg( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'vt_sg',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',			
			'pagination'         => '',
			'vt_hide_cat'        => '',
			'vt_hide_author'     => '',
			'vt_hide_date'       => '',
			'vt_hide_meta'       => '',
			'vt_hide_desc'       => '',
			'vt_hide_review'     => '',			
			'vt_show_num'        => '',
			'vt_hide_line'       => '',
			'vt_hide_col_line'   => '',
			'vt_light_mode'      => '',
		), $attrs );		
		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';
		$total_posts = $module['posts_per_page'];		
		$query_data = typecase_query( $module );
		$module['posts_per_page'] = $total_posts;
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}		
		if ( 'yes' === $module['vt_show_num'] ) {
			$atts_style[] = 'vt_show_num';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		if ( 'yes' === $module['vt_hide_col_line'] ) {
			$atts_style[] = 'vt_hide_col_line';
		}
		if ( 'yes' === $module['vt_light_mode'] ) {
			$atts_style[] = 'vt_light_mode';
		}
		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="vt_clear_at <?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
			<?php
			if ( $query_data->have_posts() ) :
				$atts_style = 'vt-roww vt_contain';		
			if ( ! empty( $module['row_style_mian'] ) ) {
				$atts_style .= ' ' . $module['row_style_mian'];
			} ?>
			<div class="vt_grid_wrap_f vt_wrap_eb vt_xsgrid vt_clear_at">
				<div class="<?php echo esc_attr( $atts_style ); ?>">
					<div class="vt_fli_wrap">			
					<?php typecase_xsg_listing( $module, $query_data );?>	
					</div>				
					<?php typecase_blocknav( $module, $query_data );?>					
				</div>
			</div>
		</div>
		<?php	
		wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_xsg_listing' ) ) :
	function typecase_xsg_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
			<div class="vt_mmlist_layout vt_lisep vt_risep vt_li_num">
				<div class="vt_li_in">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw vt_radus_e">
				            <div class="vt_imgin">
				                <?php the_post_thumbnail('typecase_small');?>
				            </div>				            
				            <span class="vt_li_lbl"></span>
				            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div> 
			        </div>
			    <?php }?>                            
			    <div class="vt_fe_text">    
				<?php typecase_post_small_cat(get_the_ID());?>
			        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>			
			        <?php typecase_post_meta_date(get_the_ID());?>                
			    </div>
			</div>
			</div>
			<?php
			endwhile;			
		endif;
	}
endif;