<?php
if ( ! function_exists( 'typecase_mslider' ) ) {
	function typecase_mslider( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'               	=> '',
			'name'               		=> 'vt_mslider',
			'category'           		=> '',
			'categories'         		=> '',
			'format'             		=> '',
			'tags'               		=> '',
			'author'             		=> '',
			'post_not_in'        		=> '',
			'post_in'            		=> '',
			'order'              		=> '',
			'posts_per_page'     		=> '',
			'offset'             		=> '',
			'car_type' 	     				=> 'mslider1',
			'car_effect' 	     			=> 'fade',
			'slider_speed' 		 			=> '',
			'slider_loop' 		 			=> '',
			'slider_autoplay' 			=> '',
			'slider_autoplay_delay' => '',
			'slider_arrow' 		 			=> '',
			'slider_dots' 		 			=> '',
			'sl_center_mode' 	 			=> 'false',
			'sl_center_padding'  		=> '0',
			'pagination'         		=> false,
			'vt_hide_cat'        		=> '',
			'vt_hide_author'     		=> '',
			'vt_hide_date'       		=> '',
			'vt_hide_meta'       		=> '',
			'vt_hide_desc'       		=> '',
			'vt_hide_review'     		=> '',
			'vt_hide_line'       		=> '',
			'vt_cus_img'       		=> '',

		), $attrs );
		$module['classes']         	= 'vt-main-block';
		$module['content_classes'] 	= 'vt-col-row';
		$total_posts = $module['posts_per_page'];
		$sltype = $module['car_type'];
		$query_data = typecase_query( $module );
		$module['posts_per_page'] = $total_posts;
		$module['car_type'] = $sltype;
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';
		$atts_style[] = $module['car_type'];
		if ( ! empty( $module['classes'] ) ) {
			$atts_style[] = $module['classes'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		if ( $module['car_effect'] == 'parallax') {
			$effect   = "slide";
			$parallax = true;
			$atts_style[]= 'vt_slparallax';
		}else{
			$effect   = $module['car_effect'];
			$parallax = false;
		}
		$sl_center_mode = $module['sl_center_mode'];
		if($sl_center_mode == 'yes'){
			$sl_center_mode = "true";
		}else{
			$sl_center_mode = "false";
		}
		$sl_center_padding = $module['sl_center_padding'];
		$atts_style = implode( ' ', $atts_style );
		$items = [
                'desktop'           => 1,
                'tablet'            => 1,
                'small_mobile'      => 1,
                'large_mobile'      => 1,
                'landscape_mobile'  => 1,
        ];
        $slider_settings = [
                'slideitem'      	=> $items,
                'speed'          	=> absint( $module['slider_speed'] ),
                'spacebetween'   	=> 0,
                'loop'           	=> ( 'yes' === $module['slider_loop'] ),
                'autoplay'       	=> ( 'yes' === $module['slider_autoplay'] ),
                'autoplay_delay' 	=> absint( $module['slider_autoplay_delay'] ),
                'effect'         	=> $effect,
                'parallax'         	=> $parallax,
                'navigation'     	=> ( 'yes' === $module['slider_arrow'] ),
                'pagination'     	=> ( 'yes' === $module['slider_dots'] ),
                'uniqid'         	=> $module['blockid']
        ];
		?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="<?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php
		if ( empty( $module['car_type'] ) ) {
			$module['car_type'] = 'carousel1';
			$atts_style .= ' ' . $module['car_type'];
		}
		if ( $query_data->have_posts() ) :

			$atts_style = 'vt-roww content-inner';
		if ( ! empty( $module['content_classes'] ) ) {
			$atts_style .= ' ' . $module['content_classes'];
		} ?>
			<div class="<?php echo esc_attr( $atts_style ); ?>">
				<div class="vt-eb-sl vt-eb-msl swiper-container" data-settings='<?php echo esc_attr(wp_json_encode( $slider_settings )); ?>'>
				<div class="swiper-wrapper">
	    	<?php
				switch ( $module['car_type'] ) {
					case 'mslider1' :
						typecase_mslider_a_listing( $module, $query_data );
					break;
					case 'mslider2' :
						typecase_mslider_b_listing( $module, $query_data );
					break;
					case 'mslider3' :
						typecase_mslider_c_listing( $module, $query_data );
					break;
					case 'mslider4' :
						typecase_mslider_d_listing( $module, $query_data );
					break;
				}
	    	?>
	    		</div>
				<?php if ( 'yes' === $module['slider_dots'] ) {?>
	    		<div class="vtc-pagination-<?php echo esc_attr( $module['blockid'] ); ?> vt_spw"><div class="swiper-pagination"></div></div>
	    		<?php }?>
	    		<?php if ( 'yes' === $module['slider_arrow'] ) {?>
	    		<div class="vt_arpw vtc-navigation-<?php echo esc_attr( $module['blockid'] ); ?>"><div class="vt-swiper-button-next"><div class="vt-spn-inner"><i class="vti-right-chevron-1"></i></div></div><div class="vt-swiper-button-prev"><div class="vt-spn-inner"><i class="vti-left-chevron-1"></i></div></div></div>
	    		<?php }?>
				</div>
			</div>
		</div>
			<?php
			wp_reset_postdata();
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_mslider_a_listing' ) ) :
	function typecase_mslider_a_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
			<div class="swiper-slide vt_mslide">
          	  <div class="slide-inner vt_cs_overlay" <?php if ( $module['car_effect'] == 'parallax') {?>data-swiper-parallax="100%"<?php }?>>
	          	  <div class="vt_ov_layout vt_ov_el">
				    <?php if ( has_post_thumbnail()) {?>
				        <div class="vt_img_holder">
					        <div class="vt_imgw">
					            <div class="vt_imgin">
									<?php
									if ($module['vt_cus_img'] != '' ) {
										the_post_thumbnail($module['vt_cus_img']);
									}else{
										the_post_thumbnail('typecase_large');
									}?>
					            </div>
					            <?php typecase_video_media(get_the_ID());?>
					            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
					        </div>
				        </div>
				    <?php }?>
					    <div class="vt_fe_text">
					    	<div class="vt_fe_inner">
					    	<?php typecase_post_ov_cat(get_the_ID());?>
					        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
					        <?php typecase_post_meta(get_the_ID());?>
					        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
					        </div>
					    </div>
					</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;

if ( ! function_exists( 'typecase_mslider_b_listing' ) ) :
	function typecase_mslider_b_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
			<div class="swiper-slide vt_mslide">
          	  <div class="slide-inner vt_cs_overlay vt_sl_bt" <?php if ( $module['car_effect'] == 'parallax') {?>data-swiper-parallax="100%"<?php }?>>
	          	  <div class="vt_ov_layout vt_ov_el">
				    <?php if ( has_post_thumbnail()) {?>
				        <div class="vt_img_holder">
					        <div class="vt_imgw">
					            <div class="vt_imgin">
									<?php
									if ($module['vt_cus_img'] != '' ) {
										the_post_thumbnail($module['vt_cus_img']);
									}else{
										the_post_thumbnail('typecase_large');
									}?>
					            </div>
					            <?php typecase_video_media(get_the_ID());?>
								<a class="vt_imgl" href="<?php the_permalink();?>"></a>
					        </div>
				        </div>
				    <?php }?>
					    <div class="vt_fe_text">
					    	<div class="vt_fe_inner">
					    	<?php typecase_post_ov_cat(get_the_ID());?>
					        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
					        <?php typecase_post_meta(get_the_ID());?>
					        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
					        </div>
					    </div>
					</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;


if ( ! function_exists( 'typecase_mslider_c_listing' ) ) :
	function typecase_mslider_c_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
				<div class="swiper-slide vt_mslide">
          <div class="slide-inner vt_cs_background" <?php if ( $module['car_effect'] == 'parallax') {?>data-swiper-parallax="100%"<?php }?>>
          	<div class="vt_ov_layout vt_ov_bg vt_ov_el">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw">
				            <div class="vt_imgin">
									<?php
									if ($module['vt_cus_img'] != '' ) {
										the_post_thumbnail($module['vt_cus_img']);
									}else{
										the_post_thumbnail('typecase_large');
									}?>
				            </div>
				            <?php typecase_video_media(get_the_ID());?>
							<a class="vt_imgl" href="<?php the_permalink();?>"></a>
				        </div>
			        </div>
				 <?php }?>
				    <div class="vt_fe_text">
				    	<div class="vt_fe_inner">
				    	<?php typecase_post_ov_cat(get_the_ID());?>
				        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
				        <?php typecase_post_meta(get_the_ID());?>
				        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
				        </div>
				    </div>
				</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;


if ( ! function_exists( 'typecase_mslider_d_listing' ) ) :
	function typecase_mslider_d_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
			<div class="swiper-slide vt_mslide">
          	  <div class="slide-inner vt_cs_overlay vt_sl_ct" <?php if ( $module['car_effect'] == 'parallax') {?>data-swiper-parallax="100%"<?php }?>>
	          	  <div class="vt_ov_layout vt_ov_el">
				    <?php if ( has_post_thumbnail()) {?>
				        <div class="vt_img_holder">
					        <div class="vt_imgw">
					            <div class="vt_imgin">
									<?php
									if ($module['vt_cus_img'] != '' ) {
										the_post_thumbnail($module['vt_cus_img']);
									}else{
										the_post_thumbnail('typecase_large');
									}?>
					            </div>
					            <?php typecase_video_media(get_the_ID());?>
								<a class="vt_imgl" href="<?php the_permalink();?>"></a>
					        </div>
				        </div>
				    <?php }?>
					    <div class="vt_fe_text">
					    	<div class="vt_fe_inner">
					    	<?php typecase_post_ov_cat(get_the_ID());?>
					        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
					        <?php typecase_post_meta(get_the_ID());?>
					        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
					        </div>
					    </div>
					</div>
          </div>
      </div>
			<?php
			endwhile;
		endif;
	}
endif;
