<?php
if ( ! function_exists( 'typecase_feature_layout_17' ) ) {
	function typecase_feature_layout_17( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'vt_feature_17',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',
			'pagination'         => '',
			'show_excep'         => '',
			'tabs_link'       	 => '',
			'tabs_link_ids'   	 => '',
			'tabs_link_label' 	 => '',
			'vt_hide_cat'        => '',
			'vt_hide_author'     => '',
			'vt_hide_date'       => '',
			'vt_hide_meta'       => '',
			'vt_hide_desc'       => '',
			'vt_hide_review'     => '',
			'vt_hide_line'       => '',
			'vt_hide_col_line'   => '',
			'vt_light_mode'      => '',
		), $attrs );			       		
		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';		
		$total_posts = $module['posts_per_page'];		
		$query_data = typecase_query( $module );		
		$module['posts_per_page'] = $total_posts;		
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		if ( 'yes' === $module['vt_hide_desc'] ) {
			$atts_style[] = 'vt_hide_desc';
		}
		if ( 'yes' === $module['vt_hide_review'] ) {
			$atts_style[] = 'vt_hide_review';
		}
		if ( 'yes' === $module['vt_hide_line'] ) {
			$atts_style[] = 'vt_hide_line';
		}
		if ( 'yes' === $module['vt_hide_col_line'] ) {
			$atts_style[] = 'vt_hide_col_line';
		}
		if ( 'yes' === $module['vt_light_mode'] ) {
			$atts_style[] = 'vt_light_mode';
		}
		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="<?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php typecase_block_tabs_link( $module ); ?>
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww vt_contain vt_contain_mix';		
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		} ?>
		<div class="vt_mb_wrap_f vt_wrap_eb vt_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">				
				<?php typecase_feature_17_listing( $module, $query_data ); ?>								
			</div>
			<?php typecase_blocknav( $module, $query_data );?>
		</div>
	</div>		
			<?php
			wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_feature_17_listing' ) ) :
	function typecase_feature_17_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 0;
			$pnum = $query_data->post_count;
			echo '<div class="vt_fr17_wrap"> <div class="vt_fr17_inner">';
			while ( $query_data->have_posts() ) :
				$query_data->the_post();								
				if($counter == 0 || $counter == 1){
					vt_layout_m_r_17( $module );					
				}else{
					vt_layout_m_r_sm_17( $module );
				}
				if(++$counter === $pnum) {}
			endwhile;
			echo '</div></div>';
		endif;
	}
endif;

if ( ! function_exists( 'vt_layout_m_r_17' ) ) :
	function vt_layout_m_r_17( $module = array() ) {?>
		<div class="vt_cgrid_layout vt_lisep">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_imgw vt_radus_e">
			            <div class="vt_imgin">
			                <?php the_post_thumbnail('typecase_layouts');?>
			            </div>
			            <?php typecase_video_media(get_the_ID());?>
			            <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
						<?php typecase_post_tumb_cat(get_the_ID());?>
			        </div> 
			    <?php }?>                            
			    <div class="vt_fe_text">    
			        <?php typecase_post_cat(get_the_ID());?>
			        <h3 class="vt_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <p class="vt_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 23, '...' );?> </p>
			        <?php typecase_post_meta(get_the_ID());?>                
			    </div>
		</div>
	<?php }
endif;

if ( ! function_exists( 'vt_layout_m_r_sm_17' ) ) :
	function vt_layout_m_r_sm_17( $module = array() ) {?>
			<div class="vt_mmlistw vt_lisep">
				<div class="vt_mmlistc">
					<div class="vt_mmlist_layout">
						<div class="vt_li_in">
					    <?php if ( has_post_thumbnail()) {?>
					        <div class="vt_img_holder">
						        <div class="vt_imgw vt_radus_e">
						            <div class="vt_imgin">
						                <?php the_post_thumbnail('typecase_small');?>
						            </div>				            
						            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
						        </div> 
					        </div> 
					    <?php }?>                            
					    <div class="vt_fe_text">    
							<?php typecase_post_small_cat(get_the_ID());?>
					        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>	
					        <?php typecase_post_meta_date(get_the_ID());?>                
					    </div>
					</div>
				</div>
				</div>
			</div>
	<?php }
endif;